<?php
/**
 * @package linea21.core
 * @subpackage mail
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include("../class/system/class.phpmailer.php"); 

$mail = new phpmailer();

if(defined('MAIL_USE_SSL') && MAIL_USE_SSL== true) {
	$mail->Host = MAIL_HOST_SSL;
	$mail->Port = MAIL_PORT_SSL;
}
if (defined('MAIL_MAILER')) { 
	$mail->Mailer = MAIL_MAILER;
	if(MAIL_MAILER=='sendmail') {
		if(defined('MAIL_SENDMAIL')) $mail->Sendmail = MAIL_SENDMAIL;
		}
	if(MAIL_MAILER=='smtp') {
		if(defined('MAIL_HOST')) $mail->Host = MAIL_HOST;
	}
}

if (defined('MAIL_SMTP_AUTH') && MAIL_SMTP_AUTH == true) {
	$mail->SMTPAuth = MAIL_SMTP_AUTH;
	if (defined('MAIL_SMTP_USER')) $mail->Username = MAIL_SMTP_USER;
	if (defined('MAIL_SMTP_PASS')) $mail->Password = MAIL_SMTP_PASS;
}

/**
echo "destinataire : ".$email_dest."<br />";
echo "sujet : ".$email_subject."<br />";
echo "body : ".$email_html_body."<br />";
echo "methode : ".$email_method."<br />";
echo "host : ".$mail->Host."<br />";
echo "port : ".$mail->Port."<br />";
*/

for($i = 0;$i < count($newsletters); $i++) {
	$newsletter_id = $newsletters[$i]['newsletter_id'];
	$email_subject = formatText($newsletters[$i]['newsletter_title']);

	$newsletter_body_html = formatText($newsletters[$i]['newsletter_body'], '2HTML');
	$email_html_body=str_replace('##TITLE##', $email_subject, $template_html);
	$email_html_body=str_replace('##CHARSET##', CHARSET, $email_html_body);
	$email_html_body=str_replace('##CONTENTS##', $newsletter_body_html, $email_html_body);
	
	$newsletter_body_txt = formatText($newsletters[$i]['newsletter_body']);
	$email_text_body=str_replace('##CONTENTS##', strip_tags($newsletter_body_txt), $template_txt);
	
	$mail->CharSet = CHARSET;
	$mail->From = MAIL_FROM;
	$mail->FromName = MAIL_FROMNAME;
	$mail->Subject = $email_subject;
	$mail->WordWrap = 75;
	$mail->Body = $email_html_body;
	$mail->AltBody = $email_text_body; 
	$mail->AddReplyTo(MAIL_REPLY, MAIL_REPLYNAME);

	for($k = 0; $k < count($emails_batch); $k++) {
		$email_id = $emails_batch[$k]['emailcol_id'];
		$email_dest = $emails_batch[$k]['emailcol_email'];
		
		$mail->AddAddress($email_dest);
		
		$sending_result = (!$mail->Send()) ? 0 : 1;
		
		$current_date = date('[d-m-y H:i:s]');
		
		$tolog = $email_id. $log_sep. $email_dest . $log_sep . $newsletter_id . $log_sep . $sending_result . $log_sep . $current_date;
		LogMailing($tolog);
		
		$mail->ClearAddresses();
		$mail->ClearAttachments();
	}
	$newsletter_object->SetNewsletterPublished($newsletter_id, $sql_object);
}



?>