<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

$url = $_SERVER['REQUEST_URI'];


include_once('../config/define.php');
include_once('../lib/lib_common.php');
include_once('../config/server.php');
include_once('../lib/items.php');



/**
 * We identify the folder structure of
 * the application to remove it 
 * and perform URL rewriting
 * @sample : www.domain.tld/ [linea21/public/] part removed
 */
if(strpos(SITE_CITY_URL, '/', 7)) {
  $url = str_replace(substr(SITE_CITY_URL, strpos(SITE_CITY_URL, '/', 7) + 1), '', $url);
}

/**
 * Pattern: $_REQUEST['rub'] URI_SEPARATOR NAME @@$_REQUEST['filter'] URI_SEPARATOR $_REQUEST['id'] .html
 * OR
 * Pattern: $_REQUEST['rub'] URI_SEPARATOR NAME @@$_REQUEST['filter'] URI_SEPARATOR NAME , $_REQUEST['id'] .html
 * sample: directory/@@theme/environnement,3.html
 * sample: directory/@@alpha/P.html
 */
if(preg_match('#^/(.+)'.URI_SEPARATOR.'(@@)(.+)'.URI_SEPARATOR.'(.+)\.html$#', $url, $match)) {

  $_REQUEST['rub'] = $GLOBALS['links'][LANGUAGE][ActiveItemKey($match[1])]['linkvalue'];
  $_REQUEST['filter'] = $match[3];
  // check if the last captured contains a comma
  if(strpos($match[4], ',')) {
    list($name, $id) = explode(',', $match[4]);
    $_REQUEST['id'] = $id;
  } else {
    $_REQUEST['id'] = $match[4];
  }

  header("HTTP/1.1 200 OK"); // return 200 OK HTTP status
  include("index.php");
  exit();
}

/**
 * Pattern: $_REQUEST['rub'] URI_SEPARATOR [NAME , -optional] $_REQUEST['id'] URI_SEPARATOR $_REQUEST['parentid'] URI_SEPARATOR $_REQUEST['parentparentid'] .html
 * sample: message/industrial-ecology-initiation,5/1/4.html
 */
if(preg_match('#^/(.+)'.URI_SEPARATOR.'(.+)'.URI_SEPARATOR.'(.+)'.URI_SEPARATOR.'(.+)\.html$#', $url, $match)) {
  $_REQUEST['rub'] = $GLOBALS['links'][LANGUAGE][ActiveItemKey($match[1])]['linkvalue'];

  // check if the last captured contains a comma
  if(strpos($match[2], ',')) {
    list($name, $id) = explode(',', $match[2]);
    $_REQUEST['id'] = $id;
  }
  else $_REQUEST['id'] = $match[2];
  $_REQUEST['parentid'] = $match[3];
  
  // Check pagination
    if(preg_match('#^-(\d)-$#', $match[4], $submatch)) {
      $_REQUEST['debut'] = $submatch[1];
    }
    else $_REQUEST['parentparentid'] = $match[4];

  header("HTTP/1.1 200 OK"); // return 200 OK HTTP status
  include("index.php");
  exit();
}

/**
 * Pattern: $_REQUEST['rub'] URI_SEPARATOR [NAME , -optional] $_REQUEST['id'] URI_SEPARATOR [$_REQUEST['parentid'] OR $_REQUEST['debut']] .html
 * sample: publication-part/l-alcazar-deuxieme-partie,2/1.html
 */
if(preg_match('#^/(.+)'.URI_SEPARATOR.'(.+)'.URI_SEPARATOR.'(.+)\.html$#', $url, $match)) {
  $_REQUEST['rub'] = $GLOBALS['links'][LANGUAGE][ActiveItemKey($match[1])]['linkvalue'];

  // check if the last captured contains a comma
  if(strpos($match[2], ',')) {
    list($name, $id) = explode(',', $match[2]);
    $_REQUEST['id'] = $id;
  }
  else $_REQUEST['id'] = $match[2];
  
  // Check pagination
    if(preg_match('#^-(\d)-$#', $match[3], $submatch)) {
      $_REQUEST['debut'] = $submatch[1];
    }
    else $_REQUEST['parentid'] = $match[3];

  header("HTTP/1.1 200 OK"); // return 200 OK HTTP status
  include("index.php");
  exit();
}

/**
 * Handle Pagination
 * Pattern: $_REQUEST['rub'] URI_SEPARATOR [NAME , -optional] [$_REQUEST['id'] OR $_REQUEST['debut']] .html
 * sample: news/a-new-tool-for-the-city,2.html
 * sample: news/a-new-tool-for-the-city,2.html
 * sample: directory/-6-.html
 */
if(preg_match('#^/(.+)'.URI_SEPARATOR.'(.+)\.html$#', $url, $match))
{
  $_REQUEST['rub'] = $GLOBALS['links'][LANGUAGE][ActiveItemKey($match[1])]['linkvalue'];

  // check if the last captured contains a comma
  if(strpos($match[2], ',')) {
    list($name, $id) = explode(',', $match[2]);
    $_REQUEST['id'] = $id;
  } else {
    // Check pagination
    if(preg_match('#^-(\d)-$#', $match[2], $submatch)) {
      $_REQUEST['debut'] = $submatch[1];
    }
    else $_REQUEST['id'] = $match[2];
  }

  header("HTTP/1.1 200 OK"); // return 200 OK HTTP status
  include("index.php");
  exit();
}

/**
 * Simple format
 * Pattern: $_REQUEST['rub']  .html
 * sample: news.html
 */
if(preg_match('#^/(.+)\.html$#', $url, $match))
{
  $_REQUEST['rub'] = $GLOBALS['links'][LANGUAGE][ActiveItemKey($match[1])]['linkvalue'];

  header("HTTP/1.1 200 OK"); // return 200 OK HTTP status
  include("index.php");
  exit();
}

header("Location: error.php");
?>