<?php
/**
 * @package linea21.templates
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once('../user/'.SQL.'.inc.php');

function DisplayLastPublications($nb) {
	$data=$GLOBALS['sql_object']->DBSelect(SQL_Get_LastPublications($nb));

	$content ='<div id="home_publication">'.END_LINE;
	$content.='<h1>'._t('public','last_news_h1').'</h1>'.END_LINE;
	
	$link_publi= array('rub'=> $GLOBALS['links'][LANGUAGE]['publication']['linkvalue']);
		
	for($i=0; $i<count($data); $i++) {
		$publi_id=$data[$i]['publi_id'];
		$publi_title=formatText($data[$i]['publi_title'],'2HTML');
		$publi_resume=formatText($data[$i]['publi_resume'],'2HTML');
		$link_this= array('rub'=> $GLOBALS['links'][LANGUAGE]['publication']['linkvalue'], 'id'=>$publi_id, 'name'=> $data[$i]['publi_title']);
			
		$content.='<div>';
		$content.='<h2>'.$publi_title.'</h2>';
		$content.='<a href="'.HrefMaker($link_this).'" title="'.formatText($GLOBALS['links'][LANGUAGE]['publication']['desc'].' : '.$publi_title, '2ATT').'">';
		$content.=$publi_resume;
		$content.='</a>';
		$content.='</div><br />';
	}
	//$content.='<a href="'.HrefMaker($link_publi).'" title="'.$GLOBALS['links'][LANGUAGE]['publication']['desc'].'">';
	//$content.='accéder à la liste des dossiers';
	//$content.='</a>';
	$content.='</div>	'.END_LINE;
	
	echo $content;
}

function DisplayEdito() {
	$content ='<div id="home_edito">'.END_LINE;
	$content.='<h1>Edito</h1>'.END_LINE;
	$content.='<p>';
	$content.='
	<img src="'.THEME_PUBLIC_PATH.'images/edito.gif" alt="edito_habillage" />';
	$content.=_t('public','edito');
$content.='</p>'.END_LINE;
	$content.='</div>';
	echo $content;
}

function DisplayGDT() {
	$link_gdt= array('rub'=> $GLOBALS['links'][LANGUAGE]['workgroup']['linkvalue']);

	$content ='<div id="home_top"><div id="home_gdt">'.END_LINE;
	$content.='<h1>'._t('public','workgroup_h1').'</h1>'.END_LINE;
	$content.='<p>';
	$content.='<a href="'.HrefMaker($link_gdt).'" title="'.formatText($GLOBALS['links'][LANGUAGE]['workgroup']['desc'], '2ATT').'">';
	$content.=_t('public','workgroup_edito');
	$content.='</a>';
	$content.='</p>'.END_LINE;
	$content.='</div>';
	echo $content;
}

function DisplayIDD() {
	$link_idd= array('rub'=> $GLOBALS['links'][LANGUAGE]['dashboard']['linkvalue']);
	$content ='<div id="home_idd">'.END_LINE;
	$content.='<h1>'._t('public','dashboard_h1').'</h1>'.END_LINE;
	$content.='<p>';
	$content.='<a href="'.HrefMaker($link_idd).'" title="'.formatText($GLOBALS['links'][LANGUAGE]['dashboard']['desc'], '2ATT').'">';
	$content.=_t('public','dashboard_edito');
	$content.='</a>';
	$content.='</p>'.END_LINE;
	$content.='</div></div>';
	echo $content;
}

/**
 * DisplayMenu()
 * Affichage du menu
 *
 * @return void ( echo string )
 */
function DisplayMenu()
{
  $content = '<div id="menu">'.END_LINE;
  $content .= '<a href="#contenu" class="semnone" title="'._t('header','goto_contents').'" accesskey="2">'._t('header','goto_contents').'</a>'.END_LINE;
  $content .= '<ul>'.END_LINE;
  while (list($key, $value) = each ($GLOBALS['menuitems'])) {

    (ActiveItemAlias($GLOBALS['activeitem']) == $value) ? $classe = ' class="actif"' : $classe = '' ;
    $current_link = array('rub' => $GLOBALS['links'][LANGUAGE][$value]['linkvalue']);
    $content .= '<li id="menu_'.$value.'">';
    $content .= '<a href="' . HrefMaker($current_link) . '" title="' . $GLOBALS['links'][LANGUAGE][$value]['desc'] . '" accesskey="' . $GLOBALS['links'][LANGUAGE][$value]['accesskey'] . '" id="amenu_'.$value.'"'.$classe.'>' . $GLOBALS['links'][LANGUAGE][$value]['title'] . '</a>';
    $content .= '</li>' . END_LINE;
  }
  $content .= "</ul>";
  $content .= "</div>";
  echo $content;
}

/**
 * MyAccount()
 * Renvoie les liens de creation de compte ou de déconnexion
 * suivant le statut de l'utilisateur
 *
 * @return string content
 */
function MyAccount()
{
  $link_account = array('rub' => $GLOBALS['links'][LANGUAGE]['user-prefs']['linkvalue']);
  $content  = '<div id="myaccount">' . END_LINE;
  $content .= '<div id="tologin">' . END_LINE;
  $content .= '<a href="' . HrefMaker($link_account) . '" accesskey="u" title="'._t('header','myaccount_title').'"><img src="' .THEME_PUBLIC_PATH. 'images/' .LANGUAGE. '/menu_myaccount.png" alt="'._t('header','myaccount_title').'" /><span>' . _t('header','myaccount') . '</span></a>';
  $content .= '</div>' . END_LINE;
  $link_create = array('rub' => $GLOBALS['links'][LANGUAGE]['user-registration']['linkvalue']);
  $link_logout = array('rub' => $GLOBALS['links'][LANGUAGE]['logout']['linkvalue']);
  $content .= '<div id="logout">' . END_LINE;
  if (isset($_COOKIE['linea21']['whois'])) $content .= '<a href="' . HrefMaker($link_logout) . '" accesskey="l" title="'._t('header','deconnexion_title').'">' . _t('header','deconnexion') . '</a>';
  else $content .= '<a href="' . HrefMaker($link_create) . '" accesskey="c" title="'._t('divers','user_inscription_title').'">' . _t('divers','user_inscription') . '</a>';
  $content .= '</div>' . END_LINE;
  $content .= '</div>' . END_LINE;

  echo $content;
}

/**
 * AuthForm()
 * Formulaire d'authentification pour login ou inscription
 *
 * @param string $todo
 * @return void (echo string)
 */
function AuthForm($todo = 'LOGON', $back = 1 )
{
  if($back === 1) $back=$_SERVER['HTTP_REFERER'];

  if ($todo == 'LOGON') {
    $input_hidden = $GLOBALS['links'][LANGUAGE]['user-prefs']['linkvalue'];
    $div_id = 'logon';
  } else {
    $input_hidden = $GLOBALS['links'][LANGUAGE]['user-registration']['linkvalue'];
    $div_id = 'subscribe';
  }
  $form = '<form action="index.php" method="post">' . END_LINE;
  $form .= '<div id="' . $div_id . '">' . END_LINE;
  $form .= '<label for="login" class="labelised">' . _t('divers','login') . ' : </label>' . END_LINE;
  $form .= '<input type="text" maxlength="20" class="shorttextfield" name="login" id="login" />' . END_LINE;
  $form .= '<br />'.END_LINE;
  if ($todo == 'LOGON') {
    $form .= '<label for="password" class="labelised">' . _t('divers','password') . ' : </label>' . END_LINE;
    $form .= '<input type="password" maxlength="20" class="shorttextfield" name="password" id="password" />' . END_LINE;
  } else {
    $form .= '<label for="email" class="labelised">' . _t('divers','email') . ' : </label>' . END_LINE;
    $form .= '<input type="text" maxlength="100" class="shorttextfield" name="email" id="email" />' . END_LINE;
  }
  $form .= '<br />'.END_LINE;
  $form .= '<input type="hidden" name="rub" id="rub" value="' . $input_hidden . '" />' . END_LINE;
  $form .= '<input type="hidden" name="referer" id="referer" value="' . $back. '" />' . END_LINE;
  $form .= '<input type="image" src="' .THEME_PUBLIC_PATH. 'images/btn_go.gif" value="'._t('btn','valid').'" alt="'._t('btn','valid').'" title="'._t('btn','valid').'" size="15" name="valid" id="valid" style="margin-left:30em" />'.END_LINE;
  $form .= '</div>' . END_LINE;
  $form .= '</form>' . END_LINE;

  return $form;
}

?>