<?php
/**
 * @package linea21.modules
 * @subpackage workshoprep
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Workshoprep' (as Workshop Report) module is used by 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')) {
    include_once("../lib/lib_common.php");
    ReloadIndex('admin');
} 
////////////


if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

//////////// Check Droits utilisateur ////////////
if (!HaveRight('workshop')) ReloadIndex('admin');
if(!AuthUser4Workshop($id, $sql_object) && !IsSuperAdmin()) ReloadIndex('admin');
////////////


$req_det= SQL_getoneCompleteWorkshopRep($id);
$result=$sql_object->DBSelect($req_det);
if(count($result)>1) exit();

$workrep_title=formatText($result[0]['workrep_title'], '2HTML');
$workrep_workshop_name=formatText($result[0]['workshop_denomination'], '2HTML');
$workshop_title=' ('.$workrep_workshop_name.')';
$work_id=$result[0]['workrep_workshop_id'];


if(isset($_POST['valider'])) {
	$workshop_report_object = new workshop_report;
	$link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$work_id;
	$result=$workshop_report_object->DeleteWorkshopReport($id, $sql_object);
	if($result) header("Location: ".$link_confirm);
	else  system_error();
}


$rub_link="index.php?rub=workshop";
?>
<div id="chemin">
	<ul>
		<li>
			<a href="index.php" class="chemin_home"><? echo _t('way','home'); ?></a>
		</li>
		<li>
			   <a href="<?php echo $rub_link; ?>" id="chemin_<? echo $rub; ?>" class="chemin_rub"><? echo _t('menu','workshop'); ?></a>
		</li>
		<li>
			<span><? echo formatnavTitle(_t('workshoprep','sup')." : ". $workrep_title.$workshop_title); ?></span>
		</li>
	</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>
<div class="contentcontainer">
<?php
include_once($dir."/menurub.php");
?>
<div id="content">
<? echo "<h2>".formatTitleh2($workrep_title.$workshop_title)."</h2>"; ?>
<form id="supworkshoprep" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p class="info"><?php echo _t('divers','sup_confirm'); ?></p>
<div>
<input name="id" type="hidden" value="<?php echo $id; ?>" />
<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
<?php echo cancel_button('javascript:history.go(-1);'); ?>
<input name="valider" type="submit" value="<? echo _t('btn','valid') ?>" class="button" id="valider" />
</div>
</form>
</div>
<?php include_once($dir."/help.php"); ?>
</div>
