<?php
/**
 * @package linea21.core
 * @subpackage system
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Language Management
 */
include_once('afiles/class.afiles.php');

class language {
  /*
   * @parameters
   */
  var $a_file;
  var $languages=array();

  /**
   * config_file::__construct()
   * constructeur de classe
   * @access public
   * @return void
   */
  function __construct()
  {
    $this->a_file=new afiles;
    $this->getAllLang();
  }
  
  /**
   * PHP 4 compatibility
   * as __construct()
   * @return
   */
  
  function config_file()
  {
    $this->a_file=new afiles;
    $this->getAllLang();
  }
  /**
   * language::replace()
   * modifie l'ensemble des fichiers portant l'extension $extension dans le $path
   * de façon récursive
   * @access public
   * @param string $path
   * @param array $extension
   * @return void
   */
  function replace($path, $extension="php")
  {
    $files_path=$this->a_file->lsr(SITE_PATH.$path, $extension, array());
    foreach ($files_path as $key => $file_path)
    {
      $file=new afiles($file_path);
      $content_file=$file->read_file(false,false);
      $new_file=$this->_replace($content_file);
      if($new_file <> $content_file) $this->a_file->mkfile($new_file, $file_path);
    }
  }
/**
   * language::scan()
   * scan l'ensemble des fichiers portant l'extension $extension dans le $path
   * de façon récursive
   * @access public
   * @param string $path
   * @param array $extension
   * @return $ret
   */
  function scan ($path, $extension="php")
  {
    $ret="";
    if($this->a_file->type(SITE_PATH) <> false)
    { 
    $files_path=$this->a_file->lsr(SITE_PATH.$path, $extension, array());
    foreach ($files_path as $key => $file_path)
    {
      $file=new afiles($file_path);
      $content_file=$file->read_file(false,false);
      $ret.=$this->_parse($content_file, $file_path);
    }
    }
    else $ret=_t('tools','language_site_path');
    
    if($ret == "") $ret=_t('tools','language_scan_no_result');
    return $ret;
  }
  /**
   * language::_parse()
   * scan l'ensemble des fichiers de langue et compare avec un fichier donné
   * affiche une erreur si l'item n'est pas trouvé dans le fichier de langue
   * de façon récursive
   * @access public
   * @param string $content_file
   * @param array $file_path
   * @return $error
   */
  function _parse ($content_file, $file_path)
  {
    $file_path=str_replace(SITE_PATH,"",$file_path);
    $error=false;
    $pattern="_t("; 
    $pos_start = true;

    while($pos_start !== false)
    {
      //position du début de lang       
      $pos_start = strpos($content_file, $pattern);

      if($pos_start !== false)
      {
        //@TODO regex...
        $pos_start_scope=$pos_start+strlen($pattern);
        $pos_end_scope=strpos($content_file, ",", $pos_start_scope);
        $length_scope=$pos_end_scope-$pos_start_scope;
        $scope = substr($content_file,$pos_start_scope,$length_scope);
        $pos_start_item=strpos($content_file, ",", $pos_end_scope);
        $pos_end_item=strpos($content_file, ")", $pos_start_item);
        $length_item=$pos_end_item-$pos_start_item;
        $item=substr($content_file,$pos_start_item+1,$length_item-1);


        if(strpos($item, "$") === false && strpos($scope, "$") === false)
        {
          $scope=trim(trim($scope, " "), "'");  
          $item=trim(trim($item, " "), "'");
                  
          foreach ($this->languages as $code_lang => $lang)
          {
            if(!isset($lang[$scope][$item]))
            $error.="<p><em>lang</em> : ".$code_lang.", <em>file</em> : ".$file_path.", <em>scope</em> :".$scope.", <em>item</em> : ".$item."</p>";
          }
          
        }
        $length_pattern=$pos_end_item-$pos_start;
        $content_file=substr_replace($content_file, "foobar", $pos_start,$length_pattern+1);
      }
    }
    return $error;
  }
  /**
   * language::_replace()
   * remplace l'ensemble des item  correspondant à un pattern dans la chaine $content_file
   * de façon récursive
   * @access public
   * @param string $content_file
   * @return $content_file
   */
  function _replace ($content_file)
  {
    $pattern="GLOBALS['lang'][";
     
    $pos_start = true;
    while($pos_start !== false)
    {
      $pos_start = strpos($content_file, $pattern);
      if($pos_start !== false)
      {
        //@TODO regex...
        $pos_start_scope=$pos_start+strlen($pattern);
        $pos_end_scope=strpos($content_file, "]", $pos_start_scope);
        $length_scope=$pos_end_scope-$pos_start_scope;
        $scope = substr($content_file,$pos_start_scope,$length_scope);
        $pos_start_item=strpos($content_file, "[", $pos_end_scope+1);
        $pos_end_item=strpos($content_file, "]", $pos_start_item+1);
        $length_item=$pos_end_item-$pos_start_item;
        $item=substr($content_file,$pos_start_item+1,$length_item-1);

         
        $new_pattern="_t(".$scope.",".$item.")";
        //echo "new_pattern ".$new_pattern."<br />";
         
        $length_pattern=$pos_end_item-$pos_start;
        $content_file=substr_replace($content_file, $new_pattern, $pos_start-1,$length_pattern+2);
      }
    }
    return $content_file;
  }
 /**
   * language::GetAllLang()
   * Initialise tous les fichiers de langue dans l'attribut $languages
   * @access public
   * @return void
   */
  function GetAllLang()
  {
    $langs=array();
    $lang_files=$this->a_file->lsr(SITE_PATH."/languages", "php", array());
    //on récupère tous les fichiers de langue en rec
    foreach ($lang_files as $key => $lang_file)
    {
      $file=str_replace(SITE_PATH."/languages/","",$lang_file);
      $file_exp=explode("/", $file);
      if(!isset($arr_langs[$file_exp[0]])) $arr_langs[$file_exp[0]]=array();
      array_push($arr_langs[$file_exp[0]],$file_exp[1]);
    }
    
    foreach ($arr_langs as $language => $files)
    {
      if(!isset($this->languages[$language])) $this->languages[$language]=array();
    foreach ($files as $key => $file)
    {
      include('../languages/' . $language . '/'.$file);
      if(isset($lang)) $this->languages[$language]=$lang;
    }
    }
  }
}


?>