
$(function () { 
	$("#tree").tree({
		ui : {theme_name : "linea21", animation   : 400},
		callback : { onchange : function (NODE) {
    		document.location.href = $(NODE).children("a:eq(0)").attr("href");
    		}
    	},
		plugins : { 
			contextmenu : { 
				items : {
					remove : false,
					rename : false,
					create : false,
					mod : {
						label	: msg_mod, 
						icon	: "menu-mod",
						visible	: function (NODE, TREE_OBJ) { 
							// disable the action if the modify link is not listed !!! 
							if(typeof $(NODE).children("a:eq(1)").attr("href") == "undefined") return 0; 
							return 1; 
						}, 
						action	: function (NODE, TREE_OBJ) { 
							if(typeof $(NODE).children("a:eq(2)").attr("href") != "undefined") 
								document.location.href = $(NODE).children("a:eq(2)").attr("href");
							else
								document.location.href = $(NODE).children("a:eq(1)").attr("href");
						}
					},
					del : {
						label	: msg_del, 
						icon	: "menu-del", 
						visible	: function (NODE, TREE_OBJ) { 
							// disable the action if the delete link is not listed !!! 
							if(typeof $(NODE).children("a:eq(2)").attr("href") == "undefined") return 0; 
							// otherwise - OK
							return 1; 
						}, 
						action	: function (NODE, TREE_OBJ) { 
							if(typeof $(NODE).children("a:eq(1)").attr("href") != "undefined") {
								document.location.href = $(NODE).children("a:eq(1)").attr("href");
							}
						},
						separator_before : true
					}
				}
			}
		} // end plugins
	});
	if ($("#tree").length>0) $.tree.focused().open_all(); 
	$("#tree").after('<div style="clear:both"></div>'); // correcting a strange overflow
});
