<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>
<?php
themeInclude('../user/display.php');
themeInclude('../lib/input_helpers.php');

//////////////////////////////////////////
///// déconnexion utilisateur authentifié
//////////////////////////////////////////

if(ActiveItemKey($GLOBALS['activeitem']) == 'logout') {
  DestroyUserCookie();
  header("Location: ".$_SERVER['HTTP_REFERER']);
}


SetHTMLTitle(_t('user','section')); // set HTML title

//////////////////////////////////////////
/////affichage profil utilisateur
//////////////////////////////////////////

if(ActiveItemKey($GLOBALS['activeitem']) == 'user-profile') {

  /** préparation des variables
   * 	$id -> default -1
   **/
  if(isset($_REQUEST['id'])) $id=$_REQUEST['id']; else $id=-1;

  /** Détail d'un utilisateur
   */
  if(isset($_REQUEST['id'])) {
    // set HTML Title
    $result=$GLOBALS['sql_object']->DBSelect(SQL_getUserLogin($id));
    SetHTMLTitle(formatText($result[0]['user_login'], '2HTML'));
    DisplayInfoUser($id);
  }
}

//////////////////////////////////////////
/////affichage formulaire inscription utilisateur
//////////////////////////////////////////

if(ActiveItemKey($GLOBALS['activeitem']) == 'user-registration') {


  if(isset($_POST['valid'])) {
    include_once('../class/class.user.php');
    $user_object= new user;

    $data_table_user[0]=$_POST['login'];
    $data_table_user[1]=$_POST['email'];
    $data_table_user[2]='N'; // Affichage public de l'email ( par défaut Non 
    $data_table_user[3] = $user_object -> GetNewPassword();
    $data_table_right=$user_object->InitUserRight('SIMPLE_USER');
    $result=$user_object->CheckDataIntegrity($data_table_user, $GLOBALS['sql_object']);

    if($result===true) {
      /** include envoi de mail */
      $todo_mail='add_user';
      include_once('../user/mail_actions.php');
      include_once('../mail/template.php');
      /** end mail */

      $result=$user_object->AddUser($data_table_user, $data_table_right, $GLOBALS['sql_object']);
      if(is_numeric($result)) $msg='<p class="confirm">'._t('user','confirm_public').'</p>'.END_LINE;
    }

  }

  SetHTMLTitle(_t('divers','user_inscription'));
  echo '<h1>'._t('divers','user_inscription').'</h1>'.END_LINE;
  echo '<div class="h1_comment" id="h1_user_insc">';
  echo _t('user','h1_public_comment_insc');
  echo '</div>';
  if(isset($result) && !is_numeric($result)) {
    echo '<p class="error">'.END_LINE;
    echo $result.END_LINE;
    echo '</p>'.END_LINE;
  } else {
    if(isset($msg)) echo $msg;
  }

  echo AuthForm('SUBSCRIBE');
  DisplaySubscribeTextInfo();

}

//////////////////////////////////////////
/////affichage prefs utilisateurs
//////////////////////////////////////////

if(ActiveItemKey($GLOBALS['activeitem']) == 'user-prefs') {

  SetHTMLTitle(_t('divers','auth'). ' / '._t('user','p_mod'));

  if(isset($_REQUEST['login'])) {
    $auth_value=AuthenthificationProcess($_POST['login'], $_POST['password'], 'PUBLIC');
    if(!is_string($auth_value)) header("Location: ".$_POST['referer']);
  }

  if(isset($_COOKIE['linea21']['id'])) {
    $content ='<h1>'._t('user','p_mod'). ' - ' .$_COOKIE['linea21']['login']. '</h1>'.END_LINE;
    $content.='<div class="h1_comment" id="h1_user">';
    $content.=_t('user','h1_public_comment');
    $content.='</div>';

    echo $content;

    if(isset($_REQUEST['current_email'])) {
      ModifyProfile();
    } else {
      DisplayFormProfileUser($_COOKIE['linea21']['id']);
    }
  } else {
    echo '<h1>'._t('divers','auth').'</h1>'.END_LINE;
    echo '<div class="h1_comment" id="h1_user_auth">';
    echo _t('user','h1_public_comment_auth');
    echo '</div>';

    if(isset($auth_value)) {
      echo '<p class="error">'.END_LINE;
      echo $auth_value.END_LINE;
      echo '</p>'.END_LINE;
    }

    echo AuthForm('LOGON');
    DisplayAuthTextInfo();
  }


}
?>









