<?php
/**
 * @package linea21.modules
 * @subpackage publication
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')) {
    include_once("../lib/lib_common.php");
    ReloadIndex('admin');
} 
////////////

//////////// Check Droits utilisateur ////////////
if (!IsSuperAdmin()) ReloadIndex('admin');
////////////
?>
<div id="chemin">
	<ul>
		<li>
			<a href="index.php" class="chemin_home"><? echo _t('way','home'); ?></a>
		</li>
		<li>
			   <a href="<?php echo $rub_link; ?>" id="chemin_<? echo $rub; ?>" class="chemin_rub"><? echo _t('menu','publication'); ;?></a>
		</li>
		<li>
			<span><? echo formatNavTitle(_t('publication','add')); ?></span>
		</li>
	</ul>
</div>
<!--end barre haute -->
<?php
$form_title='';
$form_theme=-1;
$form_scale=-1;
$form_level=-1;
$form_resume='';
$form_comment='';
$form_author='';
$mask_statut_P='';
$mask_statut_D="checked=\"checked\"";


$publication_object= new publication;

if(isset($_POST['enregistrer'])) {
	$data_table=unserialize(urldecode($_POST['data_table']));
	$result=$publication_object->AddPublication($data_table, $sql_object);
	$link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
	if(is_numeric($result)) header("Location: ".$link_confirm);
	else  system_error();
}

if(isset($_POST['valider'])) {
	$table[0]=$_POST['publi_title'];
	$table[1]=$_POST['publi_resume'];
	$table[2]=$_POST['publi_theme'];
	$table[3]=$_POST['publi_scale'];
	$table[4]=$_POST['publi_level'];
	$table[5]=$_POST['publi_author'];
	$table[6]=$_POST['publi_comment'];
	$table[7]=$_POST['publi_statut'];

	$integrity=$publication_object->CheckDataIntegrity($table, $sql_object);

	if(is_string($integrity)) {
		$text_format='2FIELD';
	} else {
		$text_format='2HTML';
		$table[5]=$integrity['user_id'];
	}
	$form_title=formatText($_POST['publi_title'], $text_format);
	$form_resume=formatText($_POST['publi_resume'], $text_format);
	$form_theme=$_POST['publi_theme'];
	$form_scale=$_POST['publi_scale'];
	$form_level=$_POST['publi_level'];
	$form_author=formatText($_POST['publi_author'], $text_format);
	$form_comment=formatText($_POST['publi_comment'], $text_format);

	if($_POST['publi_statut']=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
	if($_POST['publi_statut']=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
	$table=urlencode(serialize($table));
}


if(!isset($integrity) || is_string($integrity)) {
include_once("../lib/input_helpers.php");

// select-box de thèmes
$data=$sql_object->DBSelect($req_list_theme);
$select_theme=ThemeSelectBox($data, "publi_theme", $form_theme);

// select-box des échelles
$data=$sql_object->DBSelect($req_list_scale);
$select_scale=ScaleSelectBox($data, "publi_scale", $form_scale);

// select-box des niveaux
$data=$sql_object->DBSelect($req_list_level);
$select_level=LevelSelectBox($data, "publi_level", $form_level);


}

include_once(THEME_ADMIN_PATH."quickicons.php");

?>

<?php
if(!isset($integrity) || is_string($integrity)) {
?>
<div class="contentcontainer">
		<?php
		include_once($dir."/menurub.php");
		?>
		<div id="content">
			<?php
			if(isset($integrity) && is_string($integrity)) display_errors($integrity);
			?>
			<h2><? echo formatTitleh2(_t('publication','add_title')); ?></h2>
			<form id="addpublication" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
				<p>
				<label for="publi_title"><? echo _t('publication','title'); ?> : *</label>
				<input name="publi_title" type="text" class="textfield" id="publi_title" maxlength="150" value="<?php echo $form_title; ?>" />
				</p>
				<p>
				<label for="publi_resume"><? echo _t('publication','resume'); ?> : *</label>
				<textarea id="publi_resume" name="publi_resume" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_resume; ?></textarea>
				</p>
				<p>
				<label for="publi_theme" ><? echo _t('publication','theme'); ?> : *</label>
				<?php echo $select_theme; ?>
				</p>
				<p>
				<label for="publi_scale" ><? echo _t('publication','scale'); ?> : *</label>
				<?php echo $select_scale; ?>
				</p>
				<p>
				<label for="publi_level" ><? echo _t('publication','level'); ?> : </label>
				<?php echo $select_level; ?>
				</p>
				<p>
				<label for="publi_author"><? echo _t('publication','author'); ?> : *</label>
				<input name="publi_author" type="text" class="textfield" id="publi_author" maxlength="150" value="<?php echo $form_author; ?>" />
				</p>
				<p>
				<label for="statut_D"><? echo _t('publication','statut'); ?> : *</label>
				<input name="publi_statut" type="radio" id="statut_P" value="P" <?php echo $mask_statut_P; ?> /><span class="radio"><?php echo _t('statut','public'); ?></span>
				<input name="publi_statut" type="radio" id="statut_D" value="D" <?php echo $mask_statut_D; ?> /><span class="radio"><?php echo _t('statut','draft'); ?></span>
				<br />
				</p>
				<p>
				<label for="publi_comment"><? echo _t('publication','comment'); ?> : </label>
				<textarea id="publi_comment" name="publi_comment" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_comment; ?></textarea>
				</p>
				<div>
				<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
				<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
				<?php echo cancel_button('javascript:history.go(-1);'); ?>
				<input name="valider" type="submit" value="<? echo _t('btn','valid') ?>" class="button" id="valider" />
				</div>
			</form>
		</div>
<?php include_once($dir."/help.php"); ?>
</div>
<?php
// Récapitulatif
} else	{

$requete=SQL_getonethemeName($form_theme);
$result=$sql_object->DBSelect($requete);
if($result==0 || count($result)!=1) exit;
else $theme_denomination=formatText($result[0]['theme_name'], '2HTML');

$requete=SQL_getonescaleDenomination($form_scale);
$result=$sql_object->DBSelect($requete);
if($result==0 || count($result)!=1) exit;
else $scale_denomination=formatText($result[0]['scale_denomination'], '2HTML');

if($form_level <> -1) {
$requete=SQL_getonelevelName($form_level);
$result=$sql_object->DBSelect($requete);
if($result==0 || count($result)!=1) exit;
else $level_denomination=formatText($result[0]['level_name'], '2HTML');
}
else $level_denomination=_t('divers','none');

$display_form_resume=empty_nc($form_resume);
$display_form_comment=empty_nc($form_comment);
?>
<div class="contentcontainer">
<?php
include_once($dir."/menurub.php");
?>
<div id="content">
			<h2><? echo _t('recap','title') ?></h2>
			<?php
			echo "<dl class=\"dl3\">\n";
			echo "<dt>"._t('publication','title')."</dt>\n";
			echo "<dd>". $form_title."</dd>\n";
			echo "<dt>". _t('publication','resume'). "</dt>\n";
			echo "<dd>".$display_form_resume."</dd>\n";
			echo "<dt>"._t('publication','theme')." :</dt>\n";
			echo "<dd>".$theme_denomination."</dd>\n";
			echo "<dt>"._t('publication','scale')." :</dt>\n";
			echo "<dd>".$scale_denomination."</dd>\n";
			echo "<dt>"._t('publication','level')." :</dt>\n";
			echo "<dd>".$level_denomination."</dd>\n";
			echo "<dt>"._t('publication','author')." :</dt>\n";
			echo "<dd>".$form_author."</dd>\n";
			echo "<dt>"._t('divers','statut') ."</dt>\n";
			echo "<dd>". display_statut($_POST['publi_statut']). "</dd>\n";
			echo "<dt>"._t('publication','comment') ."</dt>\n";
			echo "<dd>". $display_form_comment. "</dd>\n";
			echo "</dl>\n";
			?>
			<form id="addpublication" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
				<div>
				<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
				<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
				<input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
				<?php echo cancel_button('?rub=publication&amp;todo=list'); ?>
				<input name="retour" type="button" value="<? echo _t('btn','preview'); ?>" class="button" id="retour" onclick="history.go(-1);" />
				<input name="enregistrer" type="submit" value="<? echo _t('btn','save'); ?>" class="button" id="valider" />
				</div>
			</form>
		</div>
	<?php include_once($dir."/help.php"); ?>
</div>
<?php
}
?>
