<?php
/**
 * @package linea21.modules
 * @subpackage resources
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Resource' module is used by 'Publication' and 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')) {
    include_once("../lib/lib_common.php");
    ReloadIndex('admin');
} 
////////////

function GetAddedLink($parent_id, $type, $orderby, $limit= -1, $statut=-1) {

	if($statut==-1) $statut='Y';
	else {
		if($statut!='Y' && $statut!='N') $statut='Y';
	}
	if($orderby=='CREA') $orderfield='linkres_date_crea';
	if($orderby=='MODIFY') $orderfield='linkres_last_modify';
	$requete = 	"SELECT L.linkres_id, L.linkres_mask, L.linkres_text, to_char(L.linkres_date_crea, '".toStringSqlDate()."') AS linkres_date_crea_display, to_char(L.linkres_last_modify, '".toStringSqlDate('long')."') AS linkres_last_modify_display FROM " . T_LINK_RES . " AS L ".
				"LEFT OUTER JOIN ". J_LINK. " ON j_link_id=L.linkres_id ".
				"WHERE linkres_validity = '".$statut."' AND j_type='".$type."' AND j_root_id='".$parent_id."' ".
				"ORDER BY ".$orderfield." DESC";
	if($limit!=-1) $requete.= " OFFSET 0 LIMIT ".$limit;
	$requete.=';';
	return $requete;
}

function GetAddedBiblio($parent_id, $type, $orderby, $limit= -1, $statut=-1) {

	if($statut==-1) $statut='Y';
	else {
		if($statut!='Y' && $statut!='N') $statut='Y';
	}
	if($orderby=='CREA') $orderfield='bibliores_date_crea';
	if($orderby=='MODIFY') $orderfield='bibliores_last_modify';
	$requete = 	"SELECT B.bibliores_id, B.bibliores_author, B.bibliores_title, B.bibliores_sub_title, B.bibliores_editor, B.bibliores_date, to_char(B.bibliores_date_crea, '".toStringSqlDate()."') AS bibliores_date_crea_display, to_char(B.bibliores_last_modify, '".toStringSqlDate('long')."') AS bibliores_last_modify_display FROM " . T_BIBLIO_RES . " AS B ".
				"LEFT OUTER JOIN ". J_BIBLIO. " ON j_biblio_id=B.bibliores_id ".
				"WHERE bibliores_validity = '".$statut."' AND j_type='".$type."' AND j_root_id='".$parent_id."' ".
				"ORDER BY ".$orderfield." DESC";
	if($limit!=-1) $requete.= " OFFSET 0 LIMIT ".$limit;
	$requete.=';';
	return $requete;
}

function GetAddedMulti($parent_id, $type, $orderby, $limit= -1, $statut=-1) {

	if($statut==-1) $statut='Y';
	else {
		if($statut!='Y' && $statut!='N') $statut='Y';
	}
	if($orderby=='CREA') $orderfield='multires_date_crea';
	if($orderby=='MODIFY') $orderfield='multires_last_modify';
	$requete = 	"SELECT M.multires_id, M.multires_name, M.multires_description, M.multires_media_uri, to_char(M.multires_date_crea, '".toStringSqlDate()."') AS multires_date_crea_display, to_char(M.multires_last_modify, '".toStringSqlDate('long')."') AS multires_last_modify_display FROM " . T_MULTI_RES . " AS M ".
				"LEFT OUTER JOIN ". J_MULTI . " ON j_multi_id=M.multires_id ".
				"WHERE multires_validity = '".$statut."' AND j_type='".$type."' AND j_root_id='".$parent_id."' ".
				"ORDER BY ".$orderfield." DESC";
	if($limit!=-1) $requete.= " OFFSET 0 LIMIT ".$limit;
	$requete.=';';
	return $requete;
}

function SQL_getPublicationTitle($publi_id) {
	$requete =	"SELECT publi_title, publi_posted_by FROM " . T_PUBLI . " WHERE publi_id='".$publi_id."' LIMIT 1;";
	return $requete;
}

function SQL_getWorkshopRepTitleAndGroup($workrep_id) {
	$requete =	"SELECT workrep_title, workshop_denomination,workrep_workshop_id FROM " . T_WORK_REP . " ".
				"LEFT OUTER JOIN ".T_WORK." on workshop_id=workrep_workshop_id ".
				"WHERE workrep_id='".$workrep_id."' LIMIT 1;";
	return $requete;
}

function SQL_getLinkInfo($link_id) {
	$requete =	"SELECT linkres_mask, linkres_text FROM " . T_LINK_RES . " WHERE linkres_id ='".$link_id."' LIMIT 1;";
	return $requete;
}

function SQL_getMultiInfo($link_id) {
	$requete =	"SELECT multires_name, multires_media_uri, multires_description FROM " . T_MULTI_RES . " WHERE multires_id ='".$link_id."' LIMIT 1;";
	return $requete;
}

function SQL_getBiblioInfo($biblio_id) {
	$requete =	"SELECT bibliores_title, bibliores_sub_title, bibliores_author, bibliores_editor, bibliores_date FROM " . T_BIBLIO_RES . " WHERE bibliores_id ='".$biblio_id."' LIMIT 1;";
	return $requete;
}

?>
