<?php
/**
 * @package linea21.modules
 * @subpackage workshoprep
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Workshoprep' (as Workshop Report) module is used by 'Workshop' modules
 */

themeInclude('../workshoprep/'.SQL.'.inc.php');



function DisplayOneWorkshopRep($work_id) {
	$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getoneCompleteWorkshopRep($work_id, 'P'));
	$content = '';
	if(count($data)!=1) exit;
	else 
	{		
			$link_workshop= array('rub'=> $GLOBALS['links'][LANGUAGE]['workgroup']['linkvalue'],'id'=>$data[0]['workrep_workshop_id'], 'name' =>$data[0]['workshop_denomination']);
			$link_self= array('rub'=> $GLOBALS['links'][LANGUAGE]['report']['linkvalue'],'id' => $work_id);
			
			$workrep_title=formatText($data[0]['workrep_title'], '2HTML');
			$workrep_resume=formatText($data[0]['workrep_resume'], '2HTML');
			$workshop_denomination=formatText($data[0]['workshop_denomination'], '2HTML');
			
			$workrep_posted_on=formatText($data[0]['workrep_published_date_display'], '2HTML');
			$workrep_modify_on=formatText($data[0]['workrep_last_modify_display'], '2HTML');
			$workrep_statut=$data[0]['workrep_statut'];
			
			
			$content.='<h1 class="nobottommargin">'.$workrep_title.'</h1>'.END_LINE;
			$content.='<p class="published_by">'.END_LINE;
			$content.=_t('statut','published_on').' '.$workrep_posted_on.' - ';
			$content.=_t('workshoprep','workshop_product').' : <a href="'.HrefMaker($link_workshop).'" title="'.formatText($GLOBALS['links'][LANGUAGE]['workgroup']['desc']. ' ('.$workshop_denomination, '2ATT').')">'.$workshop_denomination.'</a>';
			if($workrep_statut=='PA')  {
				$content.=' ('._t('statut','archived_on').' '.$workrep_modify_on.')';
			}
			$content .= formatted_permalink($link_self, ' - ');
			$content.='</p>'.END_LINE;
			$content.='<p class="publi_resume">'.$workrep_resume.'</p>';
			$content.='<hr />';
			
	}	
	echo $content;
}

function DisplayWorkshopRepParts($work_id) {
	$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopParts($work_id));	
	$content ='<div id="parts">'.END_LINE;
	$content.='<h2>'._t('workshoprep','name2').'</h2>'.END_LINE;
	if($data!=0)
	{	
		$content.='<ul>'.END_LINE;
		for($i=0; $i<count($data); $i++) {
			$link_parts= array('rub'=> $GLOBALS['links'][LANGUAGE]['report-part']['linkvalue'],'id'=> $data[$i]['workrepcon_id'],'parentid'=>$work_id, 'name' =>$data[$i]['workrepcon_title']);
			$workrepcon_title=formatText($data[$i]['workrepcon_title'], '2HTML');
			$content.='<li>'.END_LINE;
			$content.='<span class="num">'.($i+1).' - </span>'.END_LINE;
			$content.='<a href="'. HrefMaker($link_parts).'">';
			$content.=$workrepcon_title;
			$content.='</a>';
			$content.='</li>'.END_LINE;
		}
		$content.='</ul>'.END_LINE;
	}
	else 
	{
	$content.='<p class="info">'._t('workshoprep','no_part').'</p>';
	}
	$content.='</div>'.END_LINE;
	//$content.='<hr />';
	
	echo $content;
}

function DisplayWorkshopRepLinks($work_id) {

	$data=SQL_GetResources($work_id, 'W', 'LINK', $GLOBALS['sql_object']);
	$content ='<div id="links">'.END_LINE;
	$content.='<h2>'._t('workshoprep','link_res').'</h2>'.END_LINE;
	if($data!=0) 
	{	
		$content.='<ul>'.END_LINE;
		for($i=0; $i<count($data); $i++) {
			$linkres_mask=formatText($data[$i]['linkres_mask'], '2HTML');
			$linkres_text=$data[$i]['linkres_text'];
			$content.='<li>'.END_LINE;
			$content.='<a href="'. $linkres_text.'" class="out">';
			$content.=$linkres_mask;
			$content.='</a>';
			$content.='</li>'.END_LINE;
		}
		$content.='</ul>'.END_LINE;
		
	}
	else 
	{
	$content.='<p class="info">'._t('workshoprep','no_link').'</p>';
	}
	$content.='</div>'.END_LINE;
	//$content.='<hr />';
	
	echo $content;
}

function DisplayWorkshopRepBiblio($work_id) {
	
	$data=SQL_GetResources($work_id, 'W', 'BIBLIO', $GLOBALS['sql_object']);
	$content ='<div id="biblio">'.END_LINE;
	$content.='<h2>'._t('workshoprep','biblio_res').'</h2>'.END_LINE;
	if($data!=0) 
	{	
		$content.='<ul>'.END_LINE;
		for($i=0; $i<count($data); $i++) {
			$bibliores_author=formatText($data[$i]['bibliores_author'], '2HTML');
			$bibliores_title=formatText($data[$i]['bibliores_title'], '2HTML');
			$bibliores_sub_title=empty($data[$i]['bibliores_sub_title']) ? '' : ', '.formatText($data[$i]['bibliores_sub_title'], '2HTML');
			$bibliores_editor=empty($data[$i]['bibliores_editor']) ? '' : ' - '.formatText($data[$i]['bibliores_editor'], '2HTML');
			$bibliores_date=empty($data[$i]['bibliores_date']) ? '' : ', '.formatText($data[$i]['bibliores_date'], '2HTML');
			
			$content.='<li>'.END_LINE;
			$content.=$bibliores_author.' - <span class="biblio_title">'.$bibliores_title;
			$content.=$bibliores_sub_title.'</span>'. $bibliores_editor. $bibliores_date;
			$content.='</li>'.END_LINE;
		}
		$content.='</ul>'.END_LINE;
		
	}
	else 
	{
		$content.='<p class="info">'._t('workshoprep','no_biblio').'</p>';
	}
	$content.='</div>'.END_LINE;
	//$content.='<hr />';
	
	echo $content;
}
?>