<?php
/**
 * @package linea21.modules
 * @subpackage yellowpages
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

themeInclude('../yellowpages/'.SQL.'.inc.php');

/**
 * DisplayUrlAddYellowpages()
 * @return
 * affichage d'ajout d'un organisation
 **/
function DisplayUrlAddYellowpages() {

  $link_table= array('rub'=> $GLOBALS['links'][LANGUAGE]['directory-add']['linkvalue']);
  $content='<div class="nb_sujet_yp"> <a href="'.HrefMaker($link_table).'" title="'._t('yp','add_public').'">'._t('yp','add_public').'</a></div>'.END_LINE;
  echo $content;
}

/**
 * DisplayListYellowPages()
 * affichage de l'annuaire
 * @param $debut
 * @param unknown $limite
 * @param integer $filter
 * @param integer $search
 * @return
 **/
function DisplayListYellowPages($debut, $limite = SELECT_LIMIT, $filter= -1, $search= -1){

  $result_yp = $GLOBALS['sql_object'] -> DBSelect(SQL_get_Display_ypList($debut, $limite, $filter, $search));
  $result_nb_yp = $GLOBALS['sql_object'] -> DBSelect(SQL_get_Display_CountypList($filter, $search));

  $bdd_nb_yp=$result_nb_yp[0]['num_rows'];


  if ($filter==-1) $table_link=array('rub' => $GLOBALS['links'][LANGUAGE]['directory']['linkvalue']);
  else $table_link=array('rub' => $GLOBALS['links'][LANGUAGE]['directory']['linkvalue'],'id' => $search, 'filter' => $filter);


  $bdd_nb_yp_display = $bdd_nb_yp;

  echo DisplayUrlAddYellowpages();
  echo '<h1>'._t('yp','list').'</h1>'.END_LINE;
  echo '<div class="h1_comment" id="h1_yellowpages">'._t('yp','h1_public_comment').'</div>';

  DisplayAlphaBeta($filter,$search);
  echo Display_linkin_page($table_link, $bdd_nb_yp, $debut);

  $content='<hr />'.END_LINE;
  if($result_yp!=0)
  {

    for($i=0; $i<count($result_yp); $i++) {
      $link_table= array('rub'=> $GLOBALS['links'][LANGUAGE]['directory-detail']['linkvalue'],'id'=>$result_yp[$i]['yellowp_id'], 'name'=>$result_yp[$i]['yellowp_name']);
      $link_table2= array('rub'=> $GLOBALS['links'][LANGUAGE]['directory']['linkvalue'],'filter'=> $GLOBALS['filters'][LANGUAGE]['theme']['linkvalue'],'id'=>$result_yp[$i]['sdtheme_id'], 'name'=>$result_yp[$i]['sdtheme_name']);
      $yp_name=formatText($result_yp[$i]['yellowp_name'], '2HTML');
      $yp_activity=formatText(cutText($result_yp[$i]['yellowp_activity'],150), '2HTML');
      $yp_sdtheme=formatText($result_yp[$i]['sdtheme_name'], '2HTML');
      $yp_theme=formatText($result_yp[$i]['theme_name'], '2HTML');
      $content.='<h2><a href="'.HrefMaker($link_table).'" title="'.formatText($yp_name, '2ATT').'">'.$yp_name.'</a>'.END_LINE;
      $content.='</h2>'.END_LINE;
      $content.='<p> '._t('yp','activity').' : '.$yp_activity.'</p>'.END_LINE;
       
      if ($yp_sdtheme<>""){
        $content.='<p class="filter_info"> '._t('divers','themeref').' : <a href="'.HrefMaker($link_table2).'" title="'.formatText($yp_sdtheme, '2ATT').'" class="filter_info_theme">'.$yp_sdtheme.'</a>
			'._t('divers','sousthemeref').': <span class="filter_info_scale">'.$yp_theme.'</span>
			</p>'.END_LINE;
      }
      else {
        $content.='<p class="filter_info"> '._t('divers','themeref').' : '.empty_nc($yp_sdtheme).' <span>'._t('divers','sousthemeref').': '.empty_nc($yp_sdtheme).'</span> </p>'.END_LINE;
      }
      $content.='<hr />'.END_LINE;
    }
  }
  else
  {
    $content.='<p class="info"> '._t('yp','noresult').'</p>';
  }
  echo $content;
  echo Display_linkin_page($table_link, $bdd_nb_yp, $debut)."<br />";

}

/**
 * DisplayAlphaBeta()
 * affichage de la liste alphabétique
 * @param $filter
 * @param $filter_id
 * @return
 **/
function DisplayAlphaBeta($filter,$filter_id){

  $result_alphabetical = $GLOBALS['sql_object'] -> DBSelect(SQL_get_req_alphabetical());

  $content='<div class="lienliste">'.END_LINE;
  $content.=_t('divers','trialpha').' :';
  for($i=0; $i<count($result_alphabetical); $i++)  {
    $link_aff_classic= HrefMaker(array('rub'=>$GLOBALS['links'][LANGUAGE]['directory']['linkvalue'], 'filter'=>"alpha", 'id'=>$result_alphabetical[$i]['first_letter']));
    if ($i==0) $separator="";
    else $separator="-";
    if ($result_alphabetical[$i]['first_letter']==strtoupper($filter_id))
    $content.=$separator.' <span>'.$result_alphabetical[$i]['first_letter'].'</span> '.END_LINE;
    else $content.=$separator.' <a href="'.$link_aff_classic.'" title="'.$result_alphabetical[$i]['first_letter'].'" >'.$result_alphabetical[$i]['first_letter'].'</a> '.END_LINE;
  }
  $content.='</div>'.END_LINE;
  echo  $content;
}

/**
 * DisplayOneYellowPages()
 * affichage d'une organisation
 * @param $yp_id
 * @return
 **/
function DisplayOneYellowPages($yp_id){

  $data= $GLOBALS['sql_object'] -> DBSelect(SQL_getdetyp($yp_id));
  if($data!=0)
  {

    $content= '';
    for($i=0; $i<count($data); $i++) {
      $link_table2= array('rub'=> $GLOBALS['links'][LANGUAGE]['directory']['linkvalue'],'filter'=> $GLOBALS['filters'][LANGUAGE]['theme']['linkvalue'],'id'=>$data[0]['sdtheme_id'], 'name'=>$data[0]['sdtheme_name']);
      $link_self= array('rub'=> $GLOBALS['links'][LANGUAGE]['directory']['linkvalue'],'id'=> $yp_id);

      $yp_name=formatText($data[$i]['yellowp_name'], '2HTML');
      $yp_activity=formatText(cutText($data[0]['yellowp_activity'],150), '2HTML');
      $yp_sdtheme=formatText($data[0]['sdtheme_name'], '2HTML');
      $yp_theme=formatText($data[0]['theme_name'], '2HTML');
      $yp_street=formatText($data[0]['yellowp_street'], '2HTML');
      $yp_postal_code=formatText($data[0]['yellowp_postal_code'], '2HTML');
      $yp_city=formatText($data[0]['yellowp_city'], '2HTML');
      $yp_phone=formatText($data[0]['yellowp_phone'], '2HTML');
      $yp_fax=formatText($data[0]['yellowp_fax'], '2HTML');
      $yp_email=formatText($data[0]['yellowp_email'], '2HTML');
      $yp_website=formatText($data[0]['yellowp_website'], '2HTML');
       
      $content.='<h1 class="nobottommargin">'.$yp_name.'</h1>'.END_LINE;
      $content.='<p class="permalink">'.END_LINE;
      $content.= formatted_permalink($link_self);
      $content.='</p>'.END_LINE;
      $content.='<dl id="det_yp"><dt> '._t('yp','adresse').' : </dt><dd>'.$yp_street.' '.$yp_postal_code.' '.$yp_city.'</dd>'.END_LINE;
      $content.='<dt> '._t('yp','phone').' : </dt><dd>'.empty_nc($yp_phone).'</dd>'.END_LINE;
      $content.='<dt> '._t('yp','fax').': </dt><dd>'.empty_nc($yp_fax).'</dd>'.END_LINE;
      $content.='<dt> '._t('yp','email').' : </dt><dd><a href="mailto:'.$yp_email.'" title="'.formatText($yp_email, '2ATT').'">'.$yp_email.'</a></dd>'.END_LINE;
      if ($data[0]['yellowp_website']<>"") $content.='<dt> '._t('yp','website').' : </dt><dd><a href="'.$data[0]['yellowp_website'].'" title="'.formatText($yp_website, '2ATT').'">'.$yp_website.'</a></dd>'.END_LINE;
      else $content.='<dt> '._t('yp','website').' : </dt><dd>'.empty_nc($yp_website).'</dd>'.END_LINE;
      $content.='<dt> '._t('yp','activity').' : </dt><dd>'.$yp_activity.'</dd>'.END_LINE;
      if ($yp_sdtheme<>""){
        $content.='<dt> '._t('divers','themeref').' : </dt><dd><a href="'.HrefMaker($link_table2).'" title="'.formatText($yp_sdtheme, '2ATT').'">'.$yp_sdtheme.'</a>
			</dd><dt> '._t('divers','sousthemeref').': </dt><dd>'.$yp_theme.'
			</dd>'.END_LINE;
      }
      else {
        $content.='<dt> '._t('divers','themeref').' : </dt><dd>'.empty_nc($yp_sdtheme).' </dd><dt>'._t('divers','sousthemeref').': </dt><dd>'.empty_nc($yp_sdtheme).'</span> </dd>'.END_LINE;
      }
      $content.='</dl>'.END_LINE;
    }
  }
  else
  {
    $content.='<p class="info">'._t('yp','noresult').'</p>';
  }
  echo $content;

}


/**
 * DisplayConfirmAdd()
 * affichage confirmation de l'ajout
 * @return
 **/
function DisplayConfirmAdd() {
  $link_table= array('rub'=> $GLOBALS['links'][LANGUAGE]['directory']['linkvalue']);
  $content='<p class="confirm">'._t('yp','confirm_pub').' <a href="'.HrefMaker($link_table).'" title="'.formatText(_t('yp','confirm_pub2'), '2ATT').'" >'._t('yp','confirm_pub2').'</a>'.END_LINE;
  $content.='</p>'.END_LINE;
  echo $content;
}

/**
 * DisplayAddYellowPages()
 * affichage formulaire d'ajout
 * @param integer $btn
 * @param $table
 * @return
 **/
function DisplayAddYellowPages() {
  include_once('../lib/input_helpers.php');
  include_once('../class/class.yellowpages.php');
  $form_name='';
  $form_activity='';
  $form_theme='';
  $form_street='';
  $form_postal_code='';
  $form_city='';
  $form_phone='';
  $form_fax='';
  $form_email='';
  $form_website='';
  $data= $GLOBALS['sql_object'] -> DBSelect(SQL_get_req_list_theme());
  $select_theme=ThemeSelectBox($data, "yp_theme", $form_theme);
  //  testing $_POST['yp_name'] and not $_POST['valider'] because of OPERA bug
  if(isset($_POST['yp_name'])) {
    $table[0]=$_POST['yp_name'];
    $table[1]=$_POST['yp_activity'];
    $table[2]=$_POST['yp_theme'];
    $table[3]=$_POST['yp_street'];
    $table[4]=$_POST['yp_postal_code'];
    $table[5]=$_POST['yp_city'];
    $table[6]='';
    $table[7]=$_POST['yp_phone'];
    $table[8]=$_POST['yp_fax'];
    $table[9]=$_POST['yp_email'];
    $table[10]=$_POST['yp_website'];
    $table[11]="D";
    $yp_object= new yellowpages;

    // prevent spam
    if($_SESSION['securityaction']!=md5($_POST['securitycode'])) {
      $integrity=_t('security','message');
    }
    if(!isset($integrity)) $integrity=$yp_object->CheckDataIntegrity($table);

    if (is_string($integrity)) {
      echo "<p class=\"error\">".$integrity."</p>";
      $form_name=formatText($_POST['yp_name'], '2FIELD');
      $form_activity=formatText($_POST['yp_activity'], '2FIELD');
      $form_theme=$_POST['yp_theme'];
      $form_street=formatText($_POST['yp_street'], '2FIELD');
      $form_postal_code=$_POST['yp_postal_code'];
      $form_city=formatText($_POST['yp_city'], '2FIELD');
      $form_phone=$_POST['yp_phone'];
      $form_fax=$_POST['yp_fax'];
      $form_email=formatText($_POST['yp_email'], '2FIELD');
      $form_website=formatText($_POST['yp_website'], '2FIELD');
    } else {
      $result=$yp_object->AddYellowPages($table, $GLOBALS['sql_object']);
      $link_confirm=HrefMaker(array('rub'=> $GLOBALS['links'][LANGUAGE]['directory']['linkvalue']));
      if(is_numeric($result)) DisplayConfirmAdd();
      else  echo "<p class=\"error\">".system_error()."</p>";
    }
  }
  if (!isset($integrity) || is_string($integrity)) {
    $form='<h1>'._t('yp','add_public').'</h1>'.END_LINE;
    $form.='<div class="h1_comment" id="h1_yellowpages">'._t('yp','h1_public_add').'</div>';
    $form.='<form action="index.php" method="post">'.END_LINE;
    $form.='<div id="ajout">'.END_LINE;
    $form.='<p><label for="yp_name">'._t('yp','name2').'* : </label>'.END_LINE;
    $form.='<input type="text" maxlength="150"  name="yp_name" id="yp_name" value="'.$form_name.'" class="textfield" /></p>'.END_LINE;
    $form.='<p><label for="yp_activity">'._t('yp','activity').' * : </label>'.END_LINE;
    $form.='<input type="text" maxlength="255"  name="yp_activity" id="yp_activity" value="'.$form_activity.'" class="textfield" /></p>'.END_LINE;
    $form.='<p><label for="yp_theme">'._t('yp','theme').' : </label>'.END_LINE;
    $form.=$select_theme.'</p>'.END_LINE;
    $form.='<p><label for="yp_street">'._t('yp','street').' * : </label>'.END_LINE;
    $form.='<input type="text" maxlength="200" class="textfield" name="yp_street" id="yp_street"  value="'.$form_street.'" /></p>'.END_LINE;
    $form.='<p><label for="yp_postal_code">'._t('yp','postal_code').' * : </label>'.END_LINE;
    $form.='<input type="text" maxlength="6" class="textfield" name="yp_postal_code" id="yp_postal_code" value="'.$form_postal_code.'" /></p>'.END_LINE;
    $form.='<p><label for="yp_city">'._t('yp','city').' * : </label>'.END_LINE;
    $form.='<input type="text" maxlength="100" class="textfield" name="yp_city" id="yp_city" value="'.$form_city.'" /></p>'.END_LINE;
    $form.='<p><label for="yp_phone">'._t('yp','phone').' : </label>'.END_LINE;
    $form.='<input type="text" maxlength="12" class="textfield" name="yp_phone" id="yp_phone" value="'.$form_phone.'" /></p>'.END_LINE;
    $form.='<p><label for="yp_fax">'._t('yp','fax').' : </label>'.END_LINE;
    $form.='<input type="text" maxlength="12" class="textfield" name="yp_fax" id="yp_fax" value="'.$form_fax.'" /></p>'.END_LINE;
    $form.='<p><label for="yp_email">'._t('yp','email').' * : </label>'.END_LINE;
    $form.='<input type="text" maxlength="150" class="textfield" name="yp_email" id="yp_email" value="'.$form_email.'" /></p>'.END_LINE;
    $form.='<p><label for="yp_website">'._t('yp','website').' : </label>'.END_LINE;
    $form.='<input type="text" maxlength="150" class="textfield" name="yp_website" id="yp_website" value="'.$form_website.'" /></p>'.END_LINE;
    $form.='<p>'.END_LINE;
    $form.='<span class="info">' . _t('security','info2') . ' : </span>'.END_LINE;
    $form.='<img src="../lib/securitycode.php" alt="' . _t('security','info2') .'" id="securityimg"  />';
    $form.='</p">'.END_LINE;
    $form.='<p><label for="securitycode" >' . _t('antispam','info') . ' : </label>'.END_LINE;
    $form.='<input type="text" class="shorttextfield" id="securitycode" maxlength="5" name="securitycode" /></p> ';
    $form.='<input type="hidden" id="rub_yp" value="'.$GLOBALS['links'][LANGUAGE]['directory-add']['linkvalue'].'" name="rub" /> ';
    $form.='<input type="submit" value="'._t('btn','valid').'" size="15" name="valider" id="valider" />'.END_LINE;
    $form.='</div>'.END_LINE;
    $form.='</form>'.END_LINE;

    echo $form;
  }
}
?>