<?php
/**
 * @package linea21.modules
 * @subpackage sdi
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * SDI (Sustainable Development Indicators) Management
 */

class sdi {
  /* @param
   * */
  // nom des tables utilisées dans l'objet.
  var $TDB_SDI_INFO = T_SDI_INFO ;
  var $TDB_SDI_EVAL = T_SDI_EVAL ;
  var $TDB_SDI_PROVIDER = T_SDI_PROVIDER ;
  var $TDB_SDI_RULES = T_SDI_RULES ;
  var $TDB_SDI_VALUE = T_SDI_VALUE ;
  var $TDB_SD_THEME = T_SD_THEME ;
  // variables utilisées pour caractéristiques principales d'un IDD
  var $I_ID;
  var $I_NAME;
  var $I_DESCRIPTION;
  var $I_COMMENT;
  var $I_THEME;
  var $I_RANGE;
  var $I_GOAL;
  var $I_CONSULTING;
  var $I_UNIT;
  var $I_MAX_VALUE;
  var $I_MIN_VALUE;
  var $I_THRESHOLD;
  var $I_THRESHOLD_RELATIVE;
  var $I_FREQUENCY;
  var $I_PROVIDER;
  var $I_EVALUATION;
  var $I_REGLEMENTATION;
  var $I_DATE_CREA;
  var $I_LAST_MODIFY;
  var $I_STATUT;
  // variables utilisées pour critères d'évaluation d'un ID
  var $E_ID;
  var $E_SCALE;
  var $E_FIABILITY;
  var $E_ACCESSIBILITY;
  var $E_LISIBILITY;
  var $E_RELEVANCE;
  var $E_GLOBAL_PERFORMANCE;
  var $E_DATE_CREA;
  var $E_LAST_MODIFY;
  // variables utilisées pour organisme fournisseur d'un IDD
  var $P_ID;
  var $P_NAME;
  var $P_SERVICE;
  var $P_DESCRIPTION;
  var $P_INCHARGE;
  var $P_ADDRESS;
  var $P_PHONE;
  var $P_FAX;
  var $P_EMAIL;
  var $P_DATE_CREA;
  var $P_LAST_MODIFY;
  // variables utilisées pour réglementation d'un IDD
  var $R_ID;
  var $R_TITLE;
  var $R_BODY;
  var $R_REFERER_URI;
  var $R_MASK_URI;
  var $R_DATE_CREA;
  var $R_LAST_MODIFY;
  // variables utilisées pour valeur d'un IDD
  var $V_ID;
  var $V_VALUE;
  var $V_SDI_ID;
  var $V_SCALE;
  var $V_DATE_PUBLISHED;
  var $V_DATE_CREA;
  var $V_LAST_MODIFY;
  var $V_STATUT;

  /**
   * sdi::CheckDataIntegrity_value()
   * Vérification d'une valeur d'un indicateur
   *
   * @access public
   * @param array $table contient les composants d'un indicateur
   * @return boolean si vrai renvoie true sinon message d'erreurs (string)
   */
  function CheckDataIntegrity_value($table, $sql_object)
  {

    $notvalue = _t('dashboard','object_notvalue');
    $notgoodvalue = _t('dashboard','object_notgoodvalue');

    if (!is_numeric($table[0])) return $notvalue;

    $result = $this->_GetInfoSdi($table[1], $sql_object);

    if($result[0]['sdii_max_value'] < $result[0]['sdii_min_value']) {
      if ($table[0] > $result[0]['sdii_min_value'] ||  $table[0] < $result[0]['sdii_max_value']) return $notgoodvalue;
    } else {
      if($table[0] < $result[0]['sdii_min_value'] || $table[0] > $result[0]['sdii_max_value']) return $notgoodvalue;
    }
    return checkdate_validity($table[3]);

  }

  /**
   * sdi::CheckDataIntegrity_info()
   * Vérification des données générales d'un indicateur
   *
   * @access public
   * @param array $table contient les composants d'un indicateur
   * @return boolean si vrai renvoie true sinon message d'erreurs (string)
   */

  function CheckDataIntegrity_info($table)
  {

    $notname = _t('sdi','object_notname');
    $notdescription = _t('sdi','object_notdescription');
    $nottheme = _t('sdi','object_nottheme');
    //$notrange = _t('sdi','object_notrange');
    $notunit = _t('sdi','object_notunit');
    $notmax_value = _t('sdi','object_notmax_value');
    $notmin_value = _t('sdi','object_notmin_value');
    $notthreshold_value = _t('sdi','object_notthreshold_value');
    $notfrequency = _t('sdi','object_notfrequency');

    if (strlen($table[0]) < 2) return $notname;
    if (strlen($table[1]) < 2) return $notdescription;
    if ($table[3] <= 0 || !is_numeric($table[3])) return $nottheme;

    $table[7]=trim($table[7]);
    if (empty($table[7])) return $notunit;
    if (!is_numeric($table[8])) return $notmax_value;
    if (!is_numeric($table[9])) return $notmin_value;
    if (!is_numeric($table[10])) return $notthreshold_value;
    if (!is_numeric($table[11])) return $notfrequency;

    return true;
  }

  /**
   * sdi::CheckDataIntegrity_eval()
   * Vérification des données d'évaluation d'un indicateur
   *
   * @access public
   * @param array $table contient les composants évaluation d'un indicateur
   * @return boolean si vrai renvoie true sinon message d'erreurs (string)
   */

  function CheckDataIntegrity_eval($table)
  {

    $note_scale_compare = _t('sdi','object_note_scale_compare');
    $note_fiability = _t('sdi','object_note_fiability');
    $note_accessibility = _t('sdi','object_note_accessibility');
    $note_lisibility = _t('sdi','object_note_lisibility');
    $note_relevance = _t('sdi','object_note_relevance');
    $note_global_performance = _t('sdi','object_note_global_performance');

    if (!is_numeric($table[13])) return $note_scale_compare;
    if (!is_numeric($table[14])) return $note_fiability;
    if (!is_numeric($table[15])) return $note_accessibility;
    if (!is_numeric($table[16])) return $note_lisibility;
    if (!is_numeric($table[17])) return $note_relevance;
    if (!is_numeric($table[18])) return $note_global_performance;

    return true;
  }

  /**
   * sdi::CheckDataIntegrity_provider()
   * Vérification des données d'un fournisseur d'un indicateur
   *
   * @access public
   * @param array $table contient les composants évaluation d'un indicateur
   * @return boolean si vrai renvoie true sinon message d'erreurs (string)
   */
  function CheckDataIntegrity_provider($table)
  {

    $notp_name = _t('sdi','object_notp_name');
    $notp_address = _t('sdi','object_notp_address');
    $notp_phone = _t('sdi','object_notp_phone');
    $notp_fax = _t('sdi','object_notp_fax');
    $notp_mail = _t('sdi','object_notp_mail');

    if (strlen($table[19]) < 2) return $notp_name;
    if (strlen($table[23]) < 2) return $notp_address;

    if (trim($table[24]) != '' && !is_numeric($table[24])) return $notp_phone;
    if (trim($table[25]) != '' && !is_numeric($table[25])) return $notp_fax;

    $testmail = $this->_checkEmailValidity($table[26]);
    if ($testmail != 1) return $notp_mail;

    return true;
  }

  /**
   * sdi::_checkEmailValidity()
   * Vérification du mail
   *
   * @access private
   * @param string $email contient les composants d'un mail
   * @return boolean si vrai renvoie true sinon message d'erreurs (string)
   */
  function _checkEmailValidity($email)
  {
    $email = strtolower($email);
    if (strlen($email) < 6 || !ereg("@", $email) || preg_match_all("/([^a-zA-Z0-9_\@\.\-])/i", $email, $trouve) || !preg_match("/^([a-z0-9_]|\\-|\\.)+@(([a-z0-9_]|\\-)+\\.)+[a-z]{2,4}\$/i", $email)) {
      return 0;
    }
    return 1;
  }

  /**
   * sdi::CheckDataIntegrity_reglementation()
   * Vérification des données de réglementation d'un indicateur
   *
   * @access public
   * @param array $table contient les composants réglementation d'un indicateur
   * @return boolean si vrai renvoie true sinon message d'erreurs (string)
   */
  function CheckDataIntegrity_reglementation($table)
  {

    $notr_title = _t('sdi','object_notr_title');
    $notr_body = _t('sdi','object_notr_body');

    if (strlen($table[27]) < 2) return $notr_title;
    if (strlen($table[28]) < 2) return $notr_body;

    if(CHECK_LINK==true && !empty($table[29])) {
      if (!$this->CheckOnlineFile($table[29])) return _t('sdi','server_noresponse');
    }

    return true;
  }

  /**
   * resources::CheckOnlineFile()
   * vérifie l'existence d'un fichier en ligne
   *
   * @access public
   * @param  $path
   * @return boolean
   */
  function CheckOnlineFile($path)
  {
    $file_pt = @fopen($path, 'r');
    if (!$file_pt) return false;
    else {
      fclose($file_pt);
      return true;
    }
  }

  /**
   * sdi::_AddProvider()
   * Ajout d'un nouveau fournisseur d'un IDD
   *
   * @access private
   * @param object $sql_object
   * @return integer $last_id
   */
  function _AddProvider($sql_object)
  {
    $requete = "INSERT INTO " . $this->TDB_SDI_PROVIDER . " (sdip_name, sdip_service, sdip_description, sdip_incharge, sdip_address, sdip_phone, sdip_fax, sdip_email, sdip_date_crea) VALUES ('','','', '', '', '', '', '',NOW());";
    $last_id = $sql_object->DBInsert ($requete, 1);
    return $last_id;
  }

  /**
   * sdi::_AddEvaluation()
   * Ajout de critères d'évaluation d'un IDD
   *
   * @access private
   * @param object $sql_object
   * @return integer $last_id
   */
  function _AddEvaluation ($sql_object)
  {
    $requete = "INSERT INTO " . $this->TDB_SDI_EVAL . " (sdie_scale_compare, sdie_fiability, sdie_accessibility, sdie_lisibility, sdie_relevance, sdie_global_performance, sdie_date_crea)VALUES (DEFAULT, DEFAULT, DEFAULT, DEFAULT, DEFAULT, DEFAULT,NOW());";
    $last_id = $sql_object->DBInsert ($requete, 1);
    return $last_id;
  }


  /**
   * sdi::_AddRules()
   * Ajout d'une réglementation d'un IDD
   *
   * @access private
   * @param object $sql_object
   * @return integer $last_id
   */
  function _AddRules($sql_object)
  {
    $requete = "INSERT INTO " . $this->TDB_SDI_RULES . " (sdir_title, sdir_body, sdir_referer_uri, sdir_mask_uri, sdir_date_crea) VALUES ('', '', '', '', NOW());";
    $last_id = $sql_object->DBInsert ($requete, 1);
    return $last_id;
  }


  /**
   * sdi::AddSdi()
   * Ajout d'un IDD
   *
   * @access public
   * @param array $table_sdi_info contient les infos detaillees d'un IDD
   * @param object $sql_object
   * @return integer $last_id
   */
  function AddSdi($table_sdi_info, $sql_object)
  {
    $table_sdi_info=$sql_object->DBescape($table_sdi_info);

    $this->I_NAME = strip_input($table_sdi_info[0]);
    $this->I_DESCRIPTION = strip_input($table_sdi_info[1], true);
    $this->I_COMMENT = strip_input($table_sdi_info[2], true);
    $this->I_THEME = $table_sdi_info[3];
    $this->I_RANGE = $table_sdi_info[4];
    $this->I_GOAL = strip_input($table_sdi_info[5], true);
    $this->I_CONSULTING = strip_input($table_sdi_info[6], true);
    $this->I_UNIT = strip_input($table_sdi_info[7]);
    $this->I_MAX_VALUE = $table_sdi_info[8];
    $this->I_MIN_VALUE = $table_sdi_info[9];
    $this->I_THRESHOLD = $table_sdi_info[10];
    $this->I_FREQUENCY = $table_sdi_info[11];

    $this->I_PROVIDER = $this->_AddProvider($sql_object);
    $this->I_EVALUATION = $this->_AddEvaluation($sql_object);
    $this->I_REGLEMENTATION = $this->_AddRules($sql_object);
    $this->I_STATUT = $table_sdi_info[12];
    $this->I_THRESHOLD_RELATIVE = $table_sdi_info[14];



    $requete = "INSERT INTO " . $this->TDB_SDI_INFO . " (sdii_name, sdii_description, sdii_comment, sdii_theme, sdii_range, sdii_goal,
		sdii_consulting, sdii_unit, sdii_max_value, sdii_min_value, sdii_threshold_value, sdii_threshold_relative, sdii_frequency, sdii_provider, sdii_evaluation,
		sdii_reglementation, sdii_statut, sdii_date_crea) VALUES ('" . $this->I_NAME . "', '" . $this->I_DESCRIPTION . "', '"
		. $this->I_COMMENT . "', " . $this->I_THEME . ", " . $this->I_RANGE . ", '" . $this->I_GOAL . "', '"
		. $this->I_CONSULTING . "' , '" . $this->I_UNIT . "' , " . $this->I_MAX_VALUE . " , " . $this->I_MIN_VALUE . " , "
		. $this->I_THRESHOLD . " , '" . $this->I_THRESHOLD_RELATIVE . "' , " . $this->I_FREQUENCY . " , " . $this->I_PROVIDER . " , " . $this->I_EVALUATION . " , "
		. $this->I_REGLEMENTATION . " ,'" . $this->I_STATUT . "' , NOW());";

		$result = $sql_object->DBInsert ($requete, 1);
		return $result;
  }

  /**
   * sdi::AddValue()
   * Ajout d'une valeur IDD
   *
   * @access public
   * @param array $table_sdi_value contient les composants d'une valeur d'un IDD
   * @param object $sql_object
   * @return integer $last_id
   */
  function AddValue($table_sdi_value, $sql_object)
  {
    $table_sdi_value=$sql_object->DBescape($table_sdi_value);

    $this->V_VALUE = $table_sdi_value[0];
    $this->V_SDI_ID = $table_sdi_value[1];
    $this->V_SCALE = $table_sdi_value[2];
    $this->V_DATE_PUBLISHED = formatDate($table_sdi_value[3], true);
    $this->V_STATUT = $table_sdi_value[4];

    $requete = "INSERT INTO " . $this->TDB_SDI_VALUE . " (sdiv_value, sdiv_sdi_info, sdiv_scale, sdiv_date_published, sdiv_statut, sdiv_date_crea)
		VALUES (" . $this->V_VALUE . ", " . $this->V_SDI_ID . ", "
		. $this->V_SCALE . ", '" . $this->V_DATE_PUBLISHED . "', '" . $this->V_STATUT . "', NOW());";

		$last_id = $sql_object->DBInsert ($requete, 1);
		return $last_id;
  }

  /**
   * sdi::ModifySdi()
   * modification d'un IDD
   *
   * @access public
   * @param int $ID identifiant de l'IDD
   * @param object $sql_object
   * @param array $table_sdi_info contient les composants d'un IDD
   * @return bool $result
   */
  function ModifySdi($ID, $table_sdi_info, $sql_object)
  {
    $table_sdi_info=$sql_object->DBescape($table_sdi_info);

    if (is_numeric($ID)) {
      $this->I_ID = $ID;
    } else return false;

    $this->I_NAME = strip_input($table_sdi_info[0]);
    $this->I_DESCRIPTION = strip_input($table_sdi_info[1], true);
    $this->I_COMMENT = strip_input($table_sdi_info[2], true);
    $this->I_THEME = $table_sdi_info[3];
    $this->I_RANGE = $table_sdi_info[4];
    $this->I_GOAL = strip_input($table_sdi_info[5], true);
    $this->I_CONSULTING = strip_input($table_sdi_info[6], true);
    $this->I_UNIT = strip_input($table_sdi_info[7]);
    $this->I_MAX_VALUE = $table_sdi_info[8];
    $this->I_MIN_VALUE = $table_sdi_info[9];
    $this->I_THRESHOLD = $table_sdi_info[10];
    $this->I_FREQUENCY = $table_sdi_info[11];
    $this->I_STATUT = $table_sdi_info[12];
    $this->I_THRESHOLD_RELATIVE = $table_sdi_info[13];

    $requete = "UPDATE " . $this->TDB_SDI_INFO . " SET sdii_name='" . $this->I_NAME . "', sdii_description='"
    . $this->I_DESCRIPTION . "', sdii_comment='" . $this->I_COMMENT . "', sdii_theme="
    . $this->I_THEME . ", sdii_range=" . $this->I_RANGE . ", sdii_goal='"
    . $this->I_GOAL . "', sdii_consulting='" . $this->I_CONSULTING . "', sdii_unit='"
    . $this->I_UNIT . "', sdii_max_value=" . $this->I_MAX_VALUE . ", sdii_min_value="
    . $this->I_MIN_VALUE . ", sdii_threshold_value=" . $this->I_THRESHOLD . ", sdii_threshold_relative='" . $this->I_THRESHOLD_RELATIVE . "', sdii_frequency="
    . $this->I_FREQUENCY . ", sdii_statut='"
    . $this->I_STATUT . "', sdii_last_modify= NOW()
		WHERE sdii_id=" . $this->I_ID . ";";
    $result = $sql_object->DBQuery ($requete);
    return $result;
  }

  /**
   * sdi::_GetKeysSdi()
   * récupération des clés d'un ID
   *
   * @access private
   * @param int $id_id identifiant de l'IDD
   * @param object $sql_object
   * @return array $table_key
   */
  function _GetKeysSdi($sdi_id, $sql_object)
  {
    if (is_numeric($sdi_id)) {
      $this->I_ID = $sdi_id;
    }
    $requete = "SELECT sdii_provider, sdii_evaluation, sdii_reglementation
		FROM " . $this->TDB_SDI_INFO . "
		WHERE sdii_id=" . $this->I_ID . ";";
    $result = $sql_object->DBSelect($requete);

    return $result;

  }

  /**
   * sdi::ModifyParam()
   * modification des paramètres d'un IDD en fonction de son sdii_id
   *
   * @access public
   * @param int $ID identifiant de l'IDD
   * @param array $tableparam contient les composants d'un IDD
   * @param string $param paramètre passé :
   * E -> evaluation
   * P -> provider
   * R -> reglementation
   * @param object $sql_object
   * @return bool $result
   */
  function ModifyParam($ID, $tableparam, $param, $sql_object)
  {
    $param = strtoupper($param);
    switch ($param) {
      case 'E':
        $data = $this->_GetKeysSdi($ID, $sql_object);
        $id_e = $data[0]['sdii_evaluation'];
        $result = $this->_ModifyEvaluation($id_e, $tableparam, $sql_object);
        break;
      case 'P':
        $data = $this->_GetKeysSdi($ID, $sql_object);
        $id_p = $data[0]['sdii_provider'];
        $result = $this->_ModifyProvider($id_p, $tableparam, $sql_object);
        break;
      case 'R':
        $data = $this->_GetKeysSdi($ID, $sql_object);
        $id_r = $data[0]['sdii_reglementation'];
        $result = $this->_ModifyRules($id_r, $tableparam, $sql_object);
        break;
    }
    return $result;
  }
  /**
   * sdi::DeleteSdi()
   * suppression d'un IDD
   *
   * @access public
   * @param int $id identifiant de l'IDD a supprimer
   * @param object $sql_object
   * @return bool $result
   */
  function DeleteSdi($ID, $sql_object)
  {
    $state = "E";
    $result = $this->StateSdi($ID, $state, $sql_object);
    $requete = "UPDATE " . $this->TDB_SDI_VALUE . " SET sdiv_statut='" . $state . "' WHERE sdiv_sdi_info=" . $ID . ";";
    $result2 = $sql_object->DBQuery ($requete);
    return $result;
  }

  /**
   * sdi::_ModifyEvaluation()
   * modification d'une évaluation IDD
   *
   * @access private
   * @param int $ID identifiant de l'évaluation
   * @param object $sql_object
   * @param array $table_sdi_eval contient les composants d'un IDD
   * @return bool $result
   */
  function _ModifyEvaluation($ID, $table_sdi_eval, $sql_object)
  {
    $table_sdi_eval=$sql_object->DBescape($table_sdi_eval);

    if (is_numeric($ID)) {
      $this->E_ID = $ID;
    } else return false;

    $this->E_SCALE = empty_numeric($table_sdi_eval[0]);
    $this->E_FIABILITY = empty_numeric($table_sdi_eval[1]);
    $this->E_ACCESSIBILITY = empty_numeric($table_sdi_eval[2]);
    $this->E_LISIBILITY = empty_numeric($table_sdi_eval[3]);
    $this->E_RELEVANCE = empty_numeric($table_sdi_eval[4]);
    $this->E_GLOBAL_PERFORMANCE = empty_numeric($table_sdi_eval[5]);


    $requete = "UPDATE " . $this->TDB_SDI_EVAL . " SET sdie_scale_compare='" . $this->E_SCALE . "', sdie_fiability='"
    . $this->E_FIABILITY . "', sdie_accessibility='" . $this->E_ACCESSIBILITY . "', sdie_lisibility='"
    . $this->E_LISIBILITY . "', sdie_relevance='" . $this->E_RELEVANCE . "', sdie_global_performance='"
    . $this->E_GLOBAL_PERFORMANCE . "', sdie_last_modify = NOW()
		WHERE sdie_id=" . $this->E_ID . ";";
    $result = $sql_object->DBQuery ($requete);
    return $result;
  }

  /**
   * sdi::_ModifyProvider()
   * modification d'un fournisseur IDD
   *
   * @access private
   * @param int $ID identifiant du fournisseur
   * @param object $sql_object
   * @param array $table_sdi_provider contient les composants d'un fournisseur
   * @return bool $result
   */
  function _ModifyProvider ($ID, $table_sdi_provider, $sql_object)
  {
    $table_sdi_provider=$sql_object->DBescape($table_sdi_provider);

    if (is_numeric($ID)) {
      $this->P_ID = $ID;
    } else return false;

    $this->P_NAME = strip_input($table_sdi_provider[0]);
    $this->P_SERVICE = strip_input($table_sdi_provider[1]);
    $this->P_DESCRIPTION = strip_input($table_sdi_provider[2], true);
    $this->P_INCHARGE = strip_input($table_sdi_provider[3]);
    $this->P_ADDRESS = strip_input($table_sdi_provider[4], true);
    $this->P_PHONE = strip_input($table_sdi_provider[5]);
    $this->P_FAX = strip_input($table_sdi_provider[6]);
    $this->P_EMAIL = strip_input($table_sdi_provider[7]);

    $requete = "UPDATE " . $this->TDB_SDI_PROVIDER . " SET sdip_name= '" . $this->P_NAME . "', sdip_service='"
    . $this->P_SERVICE . "', sdip_description='" . $this->P_DESCRIPTION . "', sdip_incharge='"
    . $this->P_INCHARGE . "', sdip_address='" . $this->P_ADDRESS . "', sdip_phone='"
    . $this->P_PHONE . "', sdip_fax='" . $this->P_FAX . "', sdip_email='"
    . $this->P_EMAIL . "', sdip_last_modify = NOW()
		WHERE sdip_id='" . $this->P_ID . "';";
    $result = $sql_object->DBQuery ($requete);
    return $result;
  }

  /**
   * sdi::_ModifyRules()
   * modification d'une réglementation
   *
   * @access private
   * @param int $ID identifiant d'une réglementation
   * @param object $sql_object
   * @param array $table_sdi_rules contient les composants d'une réglementation
   * @return bool $result
   */
  function _ModifyRules ($ID, $table_sdi_rules, $sql_object)
  {
    $table_sdi_rules=$sql_object->DBescape($table_sdi_rules);

    if (is_numeric($ID)) {
      $this->R_ID = $ID;
    } else return false;

    $this->R_TITLE = strip_input($table_sdi_rules[0]);
    $this->R_BODY = strip_input($table_sdi_rules[1], true);
    $this->R_REFERER_URI = strip_input($table_sdi_rules[2]);
    $this->R_MASK_URI = strip_input($table_sdi_rules[3]);

    $requete = "UPDATE " . $this->TDB_SDI_RULES . " SET sdir_title= '" . $this->R_TITLE . "', sdir_body='"
    . $this->R_BODY . "', sdir_referer_uri='" . $this->R_REFERER_URI . "', sdir_mask_uri='"
    . $this->R_MASK_URI . "',  sdir_last_modify = NOW()
		WHERE sdir_id='" . $this->R_ID . "';";
    $result = $sql_object->DBQuery ($requete);
    return $result;
  }

  /**
   * sdi::ModifyValue()
   * modification d'une valeur
   *
   * @access public
   * @param int $ID identifiant d'une valeur
   * @param object $sql_object
   * @param array $table_sdi_value contient les composants d'une valeur
   * @return bool $result
   */
  function ModifyValue ($ID, $table_sdi_value, $sql_object)
  {
    $table_sdi_value=$sql_object->DBescape($table_sdi_value);

    if (is_numeric($ID)) {
      $this->V_ID = $ID;
    } else return false;

    $this->V_VALUE = $table_sdi_value[0];
    $this->V_SDI_ID = $table_sdi_value[1];
    $this->V_SCALE = $table_sdi_value[2];
    $this->V_DATE_PUBLISHED = formatDate($table_sdi_value[3], true);
    $this->V_STATUT = $table_sdi_value[4];

    $requete = "UPDATE " . $this->TDB_SDI_VALUE . " SET sdiv_value=" . $this->V_VALUE . ", sdiv_sdi_info="
    . $this->V_SDI_ID . ", sdiv_scale=" . $this->V_SCALE . ",sdiv_date_published='" . $this->V_DATE_PUBLISHED . "',sdiv_statut='" . $this->V_STATUT . "', sdiv_last_modify = NOW()
		WHERE sdiv_id=" . $this->V_ID . ";";
    $result = $sql_object->DBQuery ($requete);
    return $result;
  }

  /**
   * sdi::ModifyRange()
   * modification simple du rang d'un IDD
   *
   * @access public
   * @param int $ID identifiant de l'IDD
   * @param object $sql_object
   * @param int $range contient la valeur du rang à modifier
   * @return bool $result
   */
  function ModifyRange ($ID, $range, $sql_object)
  {
    if (is_numeric($ID)) {
      $this->I_ID = $ID;
    } else return false;

    if (is_numeric($range)) {
      $this->I_RANGE = $range;
    } else return false;

    $requete = "UPDATE " . $this->TDB_SDI_INFO . " SET sdii_range=" . $this->I_RANGE . ",
		sdii_last_modify= NOW()
		WHERE sdii_id='" . $this->I_ID . "';";
    $result = $sql_object->DBQuery ($requete);
    return $result;
  }

  /**
   * sdi::StateSdi()
   * modification simple du statut d'un IDD
   *
   * @access public
   * @param int $ID identifiant de l'IDD
   * @param object $sql_object
   * @param string $state contient la valeur du statut à modifier
   * @return bool $result
   */
  function StateSdi ($ID, $state, $sql_object)
  {
    if (is_numeric($ID)) {
      $this->ID = $ID;
    } else return false;

    $requete = "UPDATE " . $this->TDB_SDI_INFO . " SET sdii_statut='" . $state . "' WHERE sdii_id=" . $this->ID . ";";
    $result = $sql_object->DBQuery ($requete);
    return $result;
  }



  /**
   * sdi::StateValue()
   * modification simple du statut d'une valeur d'un IDD
   *
   * @access public
   * @param int $id identifiant de l'IDD
   * @param object $sql_object
   * @param string $state contient la valeur du statut à modifier
   * @return bool $result
   */
  function StateValue ($ID, $state, $sql_object)
  {
    if (is_numeric($ID)) {
      $this->ID = $ID;
    } else return false;
    $requete = "UPDATE " . $this->TDB_SDI_VALUE . " SET sdiv_statut='" . $state . "' WHERE sdiv_id=" . $this->ID . ";";
    $result = $sql_object->DBQuery ($requete);
    return $result;
  }

  /**
   * sdi::DeleteValue()
   * suppression  d'une valeur d'un IDD
   *
   * @access public
   * @param int $id identifiant de la valeur a supprimer
   * @param object $sql_object
   * @return bool $result
   */
  function DeleteValue ($ID, $sql_object)
  {
    $state = "E";
    $result = $this->StateValue($ID, $state, $sql_object);
    return $result;
  }


  function _GetInfoSdi($id, $sql_object)
  {
    if(SQL=='mysql') $datefunction="DATE_FORMAT";
    if(SQL=='pgsql') $datefunction="to_char";
    $requete = "SELECT II.sdii_id, II.sdii_name, II.sdii_description, II.sdii_comment, T.theme_name, II.sdii_theme,
		II.sdii_range, II.sdii_goal, II.sdii_consulting, II.sdii_unit, II.sdii_max_value, II.sdii_min_value,
		II.sdii_threshold_value, II.sdii_threshold_relative, II.sdii_frequency, II.sdii_provider, IP.sdip_name, II.sdii_evaluation, II.sdii_reglementation,
		" . $datefunction . "(II.sdii_date_crea, '" . toStringSqlDate() . "' ) AS date_c, II.sdii_statut			
		FROM " . $this->TDB_SDI_INFO . " AS II LEFT OUTER JOIN theme as T on II.sdii_theme=T.theme_id 
		LEFT OUTER JOIN sdi_provider as IP on II.sdii_provider=IP.sdip_id";
    $requete .= " WHERE II.sdii_id=" . $id . ";";
    
    $result = $sql_object->DBSelect ($requete);

    return $result;
  }


}

?>