<?php
/**
 * @package linea21.modules
 * @subpackage content
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Content' module is used by 'Publication' and 'Workshop' modules
 */

themeInclude('../contents/'.SQL.'.inc.php');

function DisplayOneWorkshopPart($work_id) {
  $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getOneWorkshopParts($work_id));
  $content = '';
  if(count($data)!=1) exit;
  else
  {
    $workrepcon_title=formatText($data[0]['workrepcon_title'], '2HTML');
    $workrepcon_body=linkin_content(formatText($data[0]['workrepcon_body'], '2HTML'));
    $workrepcon_date_crea_display=formatText($data[0]['workrepcon_date_crea_display'], '2HTML');
    $link_self = array('rub' => $GLOBALS['links'][LANGUAGE]['report-part']['linkvalue'], 'id' => $work_id, 'parentid' => $_REQUEST['parentid']);
     
    $content.='<h1 class="nobottommargin">'.$workrepcon_title.'</h1>'.END_LINE;
    $content.='<p class="permalink">'.END_LINE;
    $content.= formatted_permalink($link_self);
    $content.='</p>'.END_LINE;
    $content.='<p class="textcontent">'.$workrepcon_body.'</p>';
     
  }
  echo $content;
}

function DisplayOnePublicationPart($publi_id) {
  $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getOnePublicationParts($publi_id));
  $content = '';

  $link_self = array('rub' => $GLOBALS['links'][LANGUAGE]['publication-part']['linkvalue'], 'id' => $publi_id, 'parentid' => $_REQUEST['parentid']);

  if(count($data)!=1) exit;
  else
  {
    $title=formatText($data[0]['publicon_title'], '2HTML');
    $body=linkin_content(formatText($data[0]['publicon_body'], '2HTML'));
    $photouri=$data[0]['publicon_photos_uri'];
    $template=$data[0]['publicon_template'];
    $publicon_date_crea_display=formatText($data[0]['publicon_date_crea_display'], '2HTML');
     
    $formatted_content=TemplateFormat($title, $body, $template, $photouri);
     
    $content.='<h1 class="nobottommargin">'.$title.'</h1>'.END_LINE;
    $content.='<p class="permalink">'.END_LINE;
    $content.= formatted_permalink($link_self);
    $content.='</p>'.END_LINE;
    $content.=$formatted_content;
    $content.='<hr />';
     
  }
  echo $content;
}

function TemplateFormat($title, $body, $template, $photouri) {

  // Pas de Template avec 2 photos
  if($template==1 || $template==2) list($photo1_src)=GetAllPhotoUri($photouri);
  if($template==1) $style=' class="tplimgleft"';
  if($template==2) $style=' class="tplimgright"';

  $content='<div>';
  if($template!=3) $content.=EnlargeImage('../'.$photo1_src, $style,  'visuel '.$title);
  $content.='<p class="textcontent">'.$body.'</p>'.END_LINE;
  $content.='</div>';
  $content.='<br style="clear:both" />';

  return $content;
}

function DisplayWorkshopNameAndGroup($work_id) {
  $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopRepTitleAndGroup($work_id));
  $content = '';
  if(count($data)!=1) exit;
  else
  {
    $link_workshop= array('rub'=> $GLOBALS['links'][LANGUAGE]['workgroup']['linkvalue'],'id'=>$data[0]['workshop_id'], 'name' => $data[0]['workshop_denomination']);
    $link_workshoprep= array('rub'=> $GLOBALS['links'][LANGUAGE]['report']['linkvalue'],'id'=>$data[0]['workrep_id'], 'name' => $data[0]['workrep_title']);
     
    $workrep_title=formatText($data[0]['workrep_title'], '2HTML');
    $workshop_denomination=formatText($data[0]['workshop_denomination'], '2HTML');
     
    $content.='<p>'.END_LINE;
    $content.=_t('workshoprep','name').' : ';
    $content.='<a href="'.HrefMaker($link_workshoprep).'" title="'.$GLOBALS['links'][LANGUAGE]['report']['desc']. ' ('.$workrep_title.')">'.$workrep_title.'</a>';
    $content.=' | ';
    $content.='<span class="workshopname">';
    $content.='<a href="'.HrefMaker($link_workshop).'" title="'._t('workshoprep','workshop_product'). ' : '.formatText($workshop_denomination, '2ATT').'">'.$workshop_denomination.'</a>';
    $content.='</span>';
    $content.='</p>'.END_LINE;
    $content.='<hr />'.END_LINE;
     
  }
  echo $content;
}

function DisplayPublicationTitle($publi_id) {
  $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getPublicationTitle($publi_id));
  $content = '';
  if(count($data)!=1) exit;
  else
  {
    $link_publi= array('rub'=> $GLOBALS['links'][LANGUAGE]['publication']['linkvalue'],'id'=>$data[0]['publi_id'], 'name'=> $data[0]['publi_title']);
    $publi_title=formatText($data[0]['publi_title'], '2HTML');

    $content.='<p>'.END_LINE;
    $content.=''._t('publication','name').' : ';
    $content.='<a href="'.HrefMaker($link_publi).'" title="'.$GLOBALS['links'][LANGUAGE]['publication']['desc']. ' ('.formatText($publi_title, '2ATT').')">'.$publi_title.'</a>';
    $content.='</p>'.END_LINE;
    $content.='<hr />'.END_LINE;
     
  }
  echo $content;
}

function DisplayWorkshopRepLinkinPart($id, $parentid, $format='TEXT') {
  /**
   * $id -> partie courante
   * $parentid -> id du dossier
   * $format 'NUM' || 'TEXT'
   */
  $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopParts($parentid));
  $content = '';
  $nb_parts=count($data)-1;
  if($data!=0)
  {
    $content.='<div id="linkinparts">';
    //$content.=_t('publication','goto').' : '.END_LINE;

    if($format=='TEXT') {
      $content.='<ul>'.END_LINE;
      for($i=$nb_parts; $i>=0; $i--)
      {
        $link_parts= array('rub'=> $GLOBALS['links'][LANGUAGE]['report-part']['linkvalue'],'id'=> $data[$i]['workrepcon_id'],'parentid'=>$parentid, 'name'=> $data[$i]['workrepcon_title']);
        $workrepcon_title=formatText($data[$i]['workrepcon_title'], '2HTML');
        $content.='<li>'.END_LINE;
        $content.='<span class="num">'.($nb_parts - $i +1).' - </span>'.END_LINE;
        if($id!=$data[$i]['workrepcon_id']) {
          $content.='<a href="'. HrefMaker($link_parts).'" title="'.formatText($workrepcon_title, '2ATT').'">';
          $content.=$workrepcon_title;
          $content.='</a>';
        } else {
          $content.=$workrepcon_title;
        }
        $content.='</li>'.END_LINE;
      }
      $content.='</ul>'.END_LINE;
    } else {
      $content.= _t('contents','name').' : '.END_LINE;
      $sep='';
      for($i=$nb_parts; $i>=0; $i--)
      {
        $link_parts= array('rub'=> $GLOBALS['links'][LANGUAGE]['report-part']['linkvalue'],'id'=> $data[$i]['workrepcon_id'],'parentid'=>$parentid, 'name'=> $data[$i]['workrepcon_title']);
        $workrepcon_title=formatText($data[$i]['workrepcon_title'], '2HTML');
        $content.=$sep;
        if($id!=$data[$i]['workrepcon_id']) {
          $content.='<a href="'. HrefMaker($link_parts).'" title="'.formatText($workrepcon_title, '2ATT').'">';
          $content.=($nb_parts-$i +1);
          $content.='</a>';
        } else {
          $content.=($nb_parts-$i +1);
        }
        $sep=' - ';
      }
    }
    $content.='</div>'.END_LINE;
    $content.='<hr />'.END_LINE;
  }
  echo $content;
}



function DisplayPublicationLinkinPart($id, $parentid, $format='TEXT') {
  /**
   * $id -> partie courante
   * $parentid -> id du dossier
   * $format 'NUM' || 'TEXT'
   */

  $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getPublicationParts($parentid));
  $content = '';
  $nb_parts=count($data)-1;
  if($data!=0)
  {
    $content.='<div id="linkinparts">'.END_LINE;
    if($format=='TEXT') {
      $content.='<ul>'.END_LINE;
      for($i=$nb_parts; $i>=0; $i--)
      {
        $link_parts= array('rub'=> $GLOBALS['links'][LANGUAGE]['publication-part']['linkvalue'],'id'=> $data[$i]['publicon_id'],'parentid'=>$parentid, 'name'=> $data[$i]['publicon_title']);
        $publicon_title=formatText($data[$i]['publicon_title'], '2HTML');
        $content.='<li>'.END_LINE;
        $content.='<span class="num">'.($nb_parts - $i +1).' - </span>'.END_LINE;
        if($id!=$data[$i]['publicon_id']) {
          $content.='<a href="'. HrefMaker($link_parts).'" title="'.formatText($publicon_title, '2ATT').'">';
          $content.=$publicon_title;
          $content.='</a>';
        } else {
          $content.=$publicon_title;
        }
        $content.='</li>'.END_LINE;
      }
      $content.='</ul>'.END_LINE;
    } else {
      $content.=''._t('publication','part_number2').' : '.END_LINE;
      $sep='';
      for($i=$nb_parts; $i>=0; $i--)
      {
        $link_parts= array('rub'=> $GLOBALS['links'][LANGUAGE]['publication-part']['linkvalue'],'id'=> $data[$i]['$publicon_id'],'parentid'=>$parentid, 'name'=> $data[$i]['publicon_title']);
        $publicon_title=formatText($data[$i]['$publicon_title'], '2HTML');
        $content.=$sep;
        if($id!=$data[$i]['workrepcon_id']) {
          $content.='<a href="'. HrefMaker($link_parts).'" title="'.formatText($publicon_title, '2ATT').'">';
          $content.=($nb_parts-$i +1);
          $content.='</a>';
        } else {
          $content.=($nb_parts-$i +1);
        }
        $sep=' - ';
      }
    }
    $content.='</div>'.END_LINE;
     
  }
  echo $content;
}

function DisplayLinkParts($current_part, $parentid, $direction, $type) {

  if($type=='W') $link_rub=$GLOBALS['links'][LANGUAGE]['report-part']['linkvalue'];
  if($type=='P') $link_rub=$GLOBALS['links'][LANGUAGE]['publication-part']['linkvalue'];

  if($direction=='NEXT') {
    if($type=='W') $requete=SQL_getNextWorkshopRepParts($current_part, $parentid);
    if($type=='P') $requete=SQL_getNextPublicationParts($current_part, $parentid);
    $class='next';
    $prefix='&gt; &gt; ';
    $suffix='';
    $title=_t('publication','next_part');

  }
  if($direction=='PREVIOUS') {
    if($type=='W') $requete=SQL_getPreviousWorkshopRepParts($current_part, $parentid);
    if($type=='P') $requete=SQL_getPreviousPublicationParts($current_part, $parentid);
    $class='previous';
    $prefix='';
    $suffix=' &lt; &lt;';
    $title=_t('publication','prev_part');
  }
  $data=$GLOBALS['sql_object'] -> DBSelect($requete);

  if($data==false || count($data)!=1) $content = '';
  else
  {
    $link_part= array('rub'=> $link_rub,'id'=>$data[0]['part_id'], 'parentid' =>$parentid, 'name'=> $data[0]['part_title']);
    $part_title=formatText(cutText($data[0]['part_title'], 45), '2HTML');
    $part_complete_title=formatText($data[0]['part_title'], '2HTML');

    $content ='<div class="'.$class.'">'.END_LINE;
    $content.=$prefix;
    $content.='<a href="'.HrefMaker($link_part).'" title="'.formatText($title.' : '.$part_complete_title, '2ATT').'">'.$part_title.'</a>';
    $content.=$suffix;
    $content.='</div>'.END_LINE;
     
  }
  echo $content;
}

?>