<?php
/**
 * @package linea21.utils
 * @subpackage lib
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

/**
* getLang()
* offers the ability to force lang into url then session
* (used for demo)
* 
* @return void
*/
function getLang() {
  if(isset($_GET['flang']))
  {
    in_array($_GET['flang'], availableLanguages()) ? $_SESSION['flang'] = $_GET['flang'] : die('no way!');
    return $_GET['flang'];
  }
  if(isset($_SESSION['flang'])) {
    in_array($_SESSION['flang'], availableLanguages()) ? 1 : die('no way!');
    return $_SESSION['flang'];
  }
  return LANGUAGE;
}
/**
* IncludeLang()
* Fait les includes de fichiers de langue en fonction de la rubrique active ( partie publique )
* 
* @return void (include)
*/
function IncludeLang()
{
    $language = getLang();
    include_once('../languages/' . $language . '/lang_common.' . CHARSET . '.php');

    if (ActiveItemAlias($GLOBALS['activeitem']) == 'directory') {
		include_once('../languages/' . $language . '/lang_yellowpages.' . CHARSET . '.php');
    }
    if (ActiveItemAlias($GLOBALS['activeitem']) == 'dashboard') {
		include_once('../languages/' . $language . '/lang_sdi.' . CHARSET . '.php');
		include_once('../languages/' . $language . '/lang_dashboard.' . CHARSET . '.php');
    }
	if (ActiveItemAlias($GLOBALS['activeitem']) == 'workgroup') {
		include_once('../languages/' . $language . '/lang_workshop.' . CHARSET . '.php');
		include_once('../languages/' . $language . '/lang_workshoprep.' . CHARSET . '.php');
		include_once('../languages/' . $language . '/lang_publication.' . CHARSET . '.php');
    }
    if (ActiveItemAlias($GLOBALS['activeitem']) == 'project') {
		include_once('../languages/' . $language . '/lang_project.' . CHARSET . '.php');
    }
	if (ActiveItemAlias($GLOBALS['activeitem']) == 'publication') {
		include_once('../languages/' . $language . '/lang_publication.' . CHARSET . '.php');
    }
	if (ActiveItemAlias($GLOBALS['activeitem']) == 'user-prefs') {
		include_once('../languages/' . $language . '/lang_user.' . CHARSET . '.php');
    }
    if (ActiveItemAlias($GLOBALS['activeitem']) == 'news') {
		include_once('../languages/' . $language . '/lang_news.' . CHARSET . '.php');
    }
	if (ActiveItemAlias($GLOBALS['activeitem']) == 'subscribe-newsletter') {
		include_once('../languages/' . $language . '/lang_newsletter.' . CHARSET . '.php');
    }
	if (ActiveItemAlias($GLOBALS['activeitem']) == 'search') {
		include_once('../languages/' . $language . '/lang_search.' . CHARSET . '.php');
    }

    $GLOBALS['lang'] = $lang;
} 

/**
* IncludeAdminLang()
* Fait les includes de fichiers de langue en fonction de la rubrique active ( partie admin )
* 
* @return void (include)
*/
function IncludeAdminLang($rubrique)
{
    $language = getLang();
    include_once('../languages/' . $language . '/lang_common.' . CHARSET . '.php');
    include_once('../languages/' . $language . '/lang_' . $rubrique . '.' . CHARSET . '.php');

    if ($rubrique === 'dashboard') {
        include_once('../languages/' . $language . '/lang_sdi.' . CHARSET . '.php');
    } 
    if ($rubrique === 'sdi') {
        include_once('../languages/' . $language . '/lang_dashboard.' . CHARSET . '.php');
    } 

    $GLOBALS['lang'] = $lang;
} 

/**
 * _t()
 * Translate item
 * @param string $item
 * @return string
 **/
function _t($scope, $item)
{ 
  if(isset($GLOBALS['lang'][$scope][$item])) return $GLOBALS['lang'][$scope][$item];
  else return $scope." ".$item;
}
?>