<?php
/**
 * @package linea21.modules
 * @subpackage news
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')) {
    include_once("../lib/lib_common.php");
    ReloadIndex('admin');
} 
////////////

//////////// Check Droits utilisateur ////////////
if (!HaveRight('news')) ReloadIndex('admin');
////////////
?>

<div id="chemin">
	<ul>
		<li>
			<a href="index.php" class="chemin_home"><? echo _t('way','home'); ?></a>
		</li>
		<li>
			   <a href="<?php echo $rub_link; ?>" id="chemin_<? echo $rub; ?>" class="chemin_rub"><? echo _t('menu','news'); ?></a>
		</li>
		<li>
			<span><? echo formatNavTitle(_t('news','add')); ?></span>
		</li>
	</ul>
</div>
<!--end barre haute -->
<?php
$form_title='';
$form_header='';
$form_body='';
$mask_template_1='';
$mask_template_2='';
$mask_template_3='';
$mask_template_4='';
$form_theme=-1;
$form_scale=-1;
$form_level=-1;
$layer_tpl_1_2 = "style=\"display:block;\"";
$layer_tpl_3 = "style=\"display:none;\"";
$mask_statut_P="checked=\"checked\"";
$mask_statut_D='';


$news_object = new news;

if(isset($_POST['enregistrer'])) {
	$data_table=unserialize(urldecode($_POST['data_table']));
	$result=$news_object->AddNews($data_table, $sql_object);
	$link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
	if(is_numeric($result)) header("Location: ".$link_confirm);
	else  system_error();
}

if(isset($_POST['valider'])) {
	$table[0]=$_POST['news_title'];
	$table[1]=$_POST['news_header'];
	$table[2]=$_POST['news_body'];
	$table[3]=$_POST['news_theme'];
	$table[4]=$_POST['news_scale'];
	$table[5]=$_POST['news_level'];
	$table[6]=$_POST['news_template'];
	$table[8]=0; //range
	$table[9]=GetSessionElement('id'); // ID posteur
	$table[10]=''; // date de péremption
	$table[11]='N'; // is_national
	$table[12]=$_POST['news_statut'];
	
	$news_object= new news;
	$integrity=$news_object->CheckDataIntegrity($table);

	if((!isset($_FILES['news_visuel1']) || $_FILES['news_visuel1']['name']=='') && ($_POST['news_template']==1 || $_POST['news_template']==2)) $files_integrity=_t('news','no_visu1');
	if(((!isset($_FILES['news_visuel1']) || $_FILES['news_visuel1']['name']=='') || (!isset($_FILES['news_visuel2']) || $_FILES['news_visuel2']['name']=='')) && $_POST['news_template']==3) $files_integrity=_t('news','no_visu2');
	if(isset($files_integrity) && !is_string($integrity))  $integrity=$files_integrity;

	if(!is_string($integrity)) {
		if ($_POST['news_template'] != 4) {
			include_once('../class/system/class.upload.php');
			include_once('../class/system/class.image.php');
			$image_object = new image;
            $upload_object = new upload;
            $upload1 = $_FILES['news_visuel1'];
			$size_integrity=$upload_object->CheckMaxFile($upload1['size'], $news_object->UPLOAD_MAX_MO);
			if(is_string($size_integrity)) $integrity=$size_integrity;
			$format_integrity=$upload_object->CheckExtImage($upload1['name']);
			if(is_string($format_integrity)) $integrity=$format_integrity;
			
			if($_POST['news_template'] == 3) {
				$upload2 = $_FILES['news_visuel2'];
				$size_integrity=$upload_object->CheckMaxFile($upload2['size'], $news_object->UPLOAD_MAX_MO);
				if(is_string($size_integrity)) $integrity=$size_integrity;
				$format_integrity=$upload_object->CheckExtImage($upload2['name']);
				if(is_string($format_integrity)) $integrity=$format_integrity;
			}
			if(!is_string($integrity)) {
	            $result=$sql_object->DBSelect($req_max_news_id, 'OBJECT');
				$dir_name=($result[0]->maxid+1).'/';
				$destination="../".$news_object->URI_INPUT.$dir_name;
				
				$final_name="1.".$upload_object->GetExtension($upload1['name']);
				$visual_link1=$destination.$final_name;
				$table[7]=$news_object->URI_INPUT.$dir_name.$final_name;
				$result_upload=$upload_object->UploadFile($upload1, $final_name, $destination);
				$upload_object->CheckMimeImageType($visual_link1);
								
				// création des thumbs
				$min_name=get_min_name($destination.$final_name);
				$image_object->ThumbCreate($destination.$final_name, $min_name , $news_object->MAX_PHOTO_MIN_WIDTH);
				
				// on retaille l'original au besoin.
				if(PHOTO_RESIZE==true && ExcedMaxSize($destination.$final_name, $news_object->MAX_PHOTO_MAX_WIDTH)) {
					$image_object->ThumbCreate($destination.$final_name, $destination.$final_name , $news_object->MAX_PHOTO_MAX_WIDTH);
				}
				
				// préparation de l'affichage de la miniature
				$visual_link1=EnlargeImage($visual_link1);
				
				if($_POST['news_template'] == 3) {
					$final_name="2.".$upload_object->GetExtension($upload2['name']);
					$visual_link2=$destination.$final_name;
					$table[7] .= '|'.$news_object->URI_INPUT.$dir_name.$final_name;
					$result_upload=$upload_object->UploadFile($upload2, $final_name, $destination);
					$upload_object->CheckMimeImageType($visual_link2);
										
					// création des thumbs
					$min_name=get_min_name($destination.$final_name);
					$image_object->ThumbCreate($destination.$final_name, $min_name , $news_object->MAX_PHOTO_MIN_WIDTH);
					
					// on retaille l'original au besoin.
					if(PHOTO_RESIZE==true && ExcedMaxSize($destination.$final_name, $news_object->MAX_PHOTO_MAX_WIDTH)) {
						$image_object->ThumbCreate($destination.$final_name, $destination.$final_name , $news_object->MAX_PHOTO_MAX_WIDTH);
					}
					
					// préparation de l'affichage de la miniature
					$visual_link2=EnlargeImage($visual_link2);

				}
			}
        }
	}
	if(is_string($integrity)) {
		$text_format='2FIELD';
	} else {
		$text_format='2HTML';
	}
	$form_title=formatText($_POST['news_title'], $text_format);
	$form_header=formatText($_POST['news_header'], $text_format);
	$form_body=formatText($_POST['news_body'], $text_format);
	$form_theme=$_POST['news_theme'];
	$form_scale=$_POST['news_scale'];
	$form_level=$_POST['news_level'];
	$form_template=$_POST['news_template'];
	if($_POST['news_template']==1) $mask_template_1=" selected=\"selected\"";
	if($_POST['news_template']==2) $mask_template_2=" selected=\"selected\"";
	if($_POST['news_template']==3) {
		$mask_template_3=" selected=\"selected\"";
		$layer_tpl_3 = "style=\"display:block;\"";
	}
	if($_POST['news_template']==4) {
		$mask_template_4=" selected=\"selected\"";
		$layer_tpl_1_2 = "style=\"display:none;\"";
	}

	if($_POST['news_statut']=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
	if($_POST['news_statut']=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
	$table=urlencode(serialize($table));
}


if(!isset($integrity) || is_string($integrity)) {
include_once("../lib/input_helpers.php");

// select-box de thèmes
$data=$sql_object->DBSelect($req_list_theme);
$select_theme=ThemeSelectBox($data, "news_theme", $form_theme);

// select-box des échelles
$data=$sql_object->DBSelect($req_list_scale);
$select_scale=ScaleSelectBox($data, "news_scale", $form_scale);

// select-box des niveaux
$data=$sql_object->DBSelect($req_list_level);
$select_level=LevelSelectBox($data, "news_level", $form_level);

// select-box Templates
$select_template="<select name=\"news_template\" id=\"news_template\" onchange=\"ShowFilesLayer(this.value, 'news')\">\n";
$select_template.="<option value=\"1\"".$mask_template_1.">".$news_object->GetTemplateName(1)."</option>\n";
$select_template.="<option value=\"2\"".$mask_template_2.">".$news_object->GetTemplateName(2)."</option>\n";
$select_template.="<option value=\"3\"".$mask_template_3.">".$news_object->GetTemplateName(3)."</option>\n";
$select_template.="<option value=\"4\"".$mask_template_4.">".$news_object->GetTemplateName(4)."</option>\n";
$select_template.="</select>\n";
}

include_once(THEME_ADMIN_PATH."quickicons.php");

?>

<?php
if(!isset($integrity) || is_string($integrity)) {
?>
<div class="contentcontainer">
		<?php
		include_once($dir."/menurub.php");
		?>
		<div id="content">
			<?php
			if(isset($integrity) && is_string($integrity)) display_errors($integrity);
			?>
			<h2><? echo formatTitleh2(_t('news','add_title')); ?></h2>
			<form id="addnews" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post" enctype="multipart/form-data">
				<p>
				<label for="news_title"><? echo _t('news','title'); ?> : *</label>
				<input name="news_title" type="text" maxlength="200" id="news_title" class="textfield" value="<?php echo $form_title; ?>" />
				</p>
				<p>
				<label for="news_header"><? echo _t('news','header'); ?> : *</label>
				<textarea id="news_header" name="news_header" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_header; ?></textarea>
				</p>
				<p>
				<label for="news_body"><? echo _t('news','body'); ?> : *</label>
				<textarea id="news_body" name="news_body" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_body; ?></textarea>
				</p>
				<p>
				<label for="news_theme" ><? echo _t('news','theme'); ?> : *</label>
				<?php echo $select_theme; ?>
				</p>
				<p>
				<label for="news_scale" ><? echo _t('news','scale'); ?> : *</label>
				<?php echo $select_scale; ?>
				</p>
				<p>
				<label for="news_level" ><? echo _t('news','level'); ?> : </label>
				<?php echo $select_level; ?>
				</p>
				<p>
				<label for="news_template" ><? echo _t('news','template'); ?> : </label>
				<?php echo $select_template; ?>
				</p>
				<p id="layervisuel1" <?php echo $layer_tpl_1_2; ?>>
					<label for="news_visuel1"><?php echo _t('news','visu1'); ?></label>
					<input name="news_visuel1" type="file" size="47" id="news_visuel1"  class="file" /><br /><br />
				</p>
				<p id="layervisuel2" <?php echo $layer_tpl_3; ?>>
					<label for="news_visuel2"><?php echo _t('news','visu2'); ?></label>
					<input name="news_visuel2" type="file" size="47" id="news_visuel2"  class="file" /><br /><br />
				</p>
				<p style="clear:both">
				<label for="statut_P"><? echo _t('news','statut'); ?> : </label>
				<input name="news_statut" type="radio" id="statut_P" value="P" <?php echo $mask_statut_P; ?> /><span class="radio"><?php echo _t('statut','public'); ?></span>
				<input name="news_statut" type="radio" id="statut_D" value="D" <?php echo $mask_statut_D; ?> /><span class="radio"><?php echo _t('statut','draft'); ?></span>
				<br />
				</p>
				<div>
				<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
				<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
				<?php echo cancel_button('javascript:history.go(-1);'); ?>
				<input name="valider" type="submit" value="<? echo _t('btn','valid') ?>" class="button" id="valider" />
				</div>
			</form>
		</div>
<?php include_once($dir."/help.php"); ?>
</div>
<?php
// Récapitulatif
} else	{

$requete=SQL_getonethemeName($form_theme);
$result=$sql_object->DBSelect($requete);
if($result==0 || count($result)!=1) exit;
else $theme_denomination=formatText($result[0]['theme_name'], '2HTML');

$requete=SQL_getonescaleDenomination($form_scale);
$result=$sql_object->DBSelect($requete);
if($result==0 || count($result)!=1) exit;
else $scale_denomination=formatText($result[0]['scale_denomination'], '2HTML');

if($form_level <> -1) {
$requete=SQL_getonelevelName($form_level);
$result=$sql_object->DBSelect($requete);
if($result==0 || count($result)!=1) exit;
else $level_denomination=formatText($result[0]['level_name'], '2HTML');
}else $level_denomination=_t('divers','none');

$reca_visual="<dt>"._t('news','photouri')."</dt>\n";
if(isset($visual_link1)) {
	$reca_visual.="<dd>&nbsp;</dd>\n";
	$reca_visual.="<dt>"._t('news','visu1')." :</dt>\n";
	$reca_visual.="<dd>".$visual_link1."</dd>\n";
	if(isset($visual_link2)) {
		$reca_visual.="<dt>"._t('news','visu2')." :</dt>\n";
		$reca_visual.="<dd>".$visual_link2."</dd>\n";
	}
} else {
	$reca_visual.="<dd>"._t('divers','none')."</dd>\n";
}

?>
<div class="contentcontainer">
<?php
include_once($dir."/menurub.php");
?>
<div id="content">
			<h2><? echo formatTitleh2(_t('recap','title')); ?></h2>
			<?php
			echo "<dl class=\"dl3\">\n";
			echo "<dt>"._t('news','title')."</dt>\n";
			echo "<dd>". $form_title."</dd>\n";
			echo "<dt>". _t('news','header'). "</dt>\n";
			echo "<dd>".empty_nc(linkin_content($form_header))."</dd>\n";
			echo "<dt>"._t('news','body')." :</dt>\n";
			echo "<dd>".linkin_content($form_body)."</dd>\n";
			echo "<dt>"._t('news','theme')." :</dt>\n";
			echo "<dd>".$theme_denomination."</dd>\n";
			echo "<dt>"._t('news','scale')." :</dt>\n";
			echo "<dd>".$scale_denomination."</dd>\n";
			echo "<dt>"._t('news','level')." :</dt>\n";
			echo "<dd>".$level_denomination."</dd>\n";
			echo "<dt>"._t('news','template')." :</dt>\n";
			echo "<dd>".$news_object->GetTemplateName($form_template)."</dd>\n";
			echo $reca_visual;
			echo "<dt>"._t('divers','statut')."</dt>\n";
			echo "<dd>". display_statut($_POST['news_statut']). "</dd>\n";
			echo "</dl>\n";
			?>
			<form id="addscale" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
				<div>
				<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
				<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
				<input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
				<?php echo cancel_button('?rub=news&amp;todo=list'); ?>
				<input name="retour" type="button" value="<? echo _t('btn','preview'); ?>" class="button" id="retour" onclick="history.go(-1);" />
				<input name="enregistrer" type="submit" value="<? echo _t('btn','save'); ?>" class="button" id="valider" />
				</div>
			</form>
		</div>
	<?php include_once($dir."/help.php"); ?>
</div>
<?php
}
?>
