<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>

<?php
//////////////////////////////////////////
/////affichage partie dossier
//////////////////////////////////////////

if(ActiveItemKey($GLOBALS['activeitem']) == 'publication' || ActiveItemKey($GLOBALS['activeitem']) == 'publication-archives') {

  SetHTMLTitle(_t('publication','section')); // set HTML title

  if(ActiveItemKey($GLOBALS['activeitem']) == 'publication') {
    $GLOBALS['filters'][LANGUAGE]['theme']['active'] = 1; // filter activation
    $GLOBALS['filters'][LANGUAGE]['level']['active'] = 1; // filter activation
    $GLOBALS['filters'][LANGUAGE]['scale']['active'] = 1; // filter activation
  }
  themeInclude('../publication/display.php');
  /** préparation des variables
   * 	$statut
   * 	$debut default 0
   * 	$id -> default -1
   * 	$filter default -1
   **/
  if(ActiveItemKey($GLOBALS['activeitem'])=='publication') $statut='public';
  if(ActiveItemKey($GLOBALS['activeitem'])=='publication-archives') $statut='archives_p';
  if(isset($_REQUEST['id'])) $id=$_REQUEST['id']; else $id=-1;
  if(isset($_REQUEST['debut'])) $debut=$_REQUEST['debut']; else $debut=0;
  if(isset($_REQUEST['filter'])) {
    if($_REQUEST['filter']==$GLOBALS['filters'][LANGUAGE]['scale']['linkvalue']) $filter='SCALE';
    if($_REQUEST['filter']==$GLOBALS['filters'][LANGUAGE]['theme']['linkvalue']) $filter='THEME';
    if($_REQUEST['filter']==$GLOBALS['filters'][LANGUAGE]['level']['linkvalue']) $filter='LEVEL';
  } else $filter=-1;


  /** Affichage du lien de consultation d'archives ( si nécessaire 
   */
  if(ActiveItemKey($GLOBALS['activeitem']) != 'publication-archives')  {

    $link_archive= array('rub'=> $GLOBALS['links'][LANGUAGE]['publication-archives']['linkvalue']);
    echo '<div class="switchnav">';
    echo '<a href="'.HrefMaker($link_archive).'" title="'._t('divers','goto_archives').'">'._t('divers','goto_archives').'</a>'.END_LINE;
    echo '</div>';
  }

  /** Affichage du lien de consultation de la liste courante ( si nécessaire 
   */
  if(ActiveItemKey($GLOBALS['activeitem']) == 'publication-archives')  {

    $link_archive= array('rub'=> $GLOBALS['links'][LANGUAGE]['publication']['linkvalue']);
    echo '<div class="switchnav">';
    echo '<a href="'.HrefMaker($link_archive).'" title="'._t('divers','goto_currentlist').'">'._t('divers','goto_currentlist').'</a>'.END_LINE;
    echo '</div>';
  }

  /** Affichage du Listing Des Dossiers et Dossiers archivés
   */
  if((isset($_REQUEST['id']) && isset($_REQUEST['filter'])) || (!isset($_REQUEST['id']) && !isset($_REQUEST['filter'])))
  {
    DisplayListPublication($statut, $filter, $id, $debut);
  }


  /** Détail d'un dossier
   */
  if(isset($_REQUEST['id']) && !isset($_REQUEST['filter'])) {
    // set HTML Title
    $result=$GLOBALS['sql_object']->DBSelect(SQL_getPublicationTitle($id));
    SetHTMLTitle(formatText($result[0]['publi_title'], '2HTML'));
    DisplayOnePublication($id);
    DisplayPublicationParts($id);
    echo '<div id="ressources">'.END_LINE;
    DisplayPublicationLinks($id);
    DisplayPublicationMulti($id);
    DisplayPublicationBiblio($id);
    echo '</div>'.END_LINE;
  }
}


//////////////////////////////////////////
/////affichage rapport de groupe de travail
//////////////////////////////////////////

if(ActiveItemKey($GLOBALS['activeitem']) == 'report') {
  themeInclude('../workshoprep/display.php');

  SetHTMLTitle(_t('workshoprep','section')); // set HTML title

  /** préparation des variables
   * 	$id -> default -1
   **/
  if(isset($_REQUEST['id'])) $id=$_REQUEST['id']; else $id=-1;

  /** Détail d'un rapport
   */
  if(isset($_REQUEST['id'])) {
    $result=$GLOBALS['sql_object']->DBSelect(SQL_getoneCompleteWorkshopRep($id));
    SetHTMLTitle(formatText($result[0]['workrep_title']. ' ('.$result[0]['workshop_denomination'].')', '2HTML'));

    DisplayOneWorkshopRep($id, 'P');
    DisplayWorkshopRepParts($id);
    echo '<div id="ressources">'.END_LINE;
    DisplayWorkshopRepLinks($id);
    DisplayWorkshopRepBiblio($id);
    echo '</div>'.END_LINE;
  }

}


//////////////////////////////////////////
/////	affichage Parties par parties
/////	Rapports de groupe de travail et Dossiers
//////////////////////////////////////////

if(ActiveItemKey($GLOBALS['activeitem']) =='report-part' || ActiveItemKey($GLOBALS['activeitem']) == 'publication-part') {
  themeInclude('../contents/display.php');

  /** préparation des variables
   * 	$id -> default -1
   *   $parentid -> default -1
   **/

  if(isset($_REQUEST['id'])) $id=$_REQUEST['id']; else $id=-1;
  if(isset($_REQUEST['parentid'])) $parentid=$_REQUEST['parentid']; else $parentid=-1;

  /** Détail d'une partie
   */
  if(ActiveItemKey($GLOBALS['activeitem']) =='report-part')
  {
    themeInclude('../workshoprep/display.php');

    SetHTMLTitle(_t('workshoprep','section')); // set HTML title
    $result=$GLOBALS['sql_object']->DBSelect(SQL_getoneCompleteWorkshopRep($parentid));
    SetHTMLTitle(formatText($result[0]['workrep_title']. ' ('.$result[0]['workshop_denomination'].')', '2HTML'));
    $result=$GLOBALS['sql_object']->DBSelect(SQL_getOneWorkshopParts($id));

    SetHTMLTitle(formatText($result[0]['workrepcon_title'], '2HTML'));

    DisplayWorkshopNameAndGroup($parentid);
    DisplayWorkshopRepLinkinPart($id, $parentid, 'TEXT');
    DisplayOneWorkshopPart($id);
    echo '<div class="nextprev">'.END_LINE;
    DisplayLinkParts($id, $parentid, 'PREVIOUS', 'W');
    DisplayLinkParts($id, $parentid, 'NEXT', 'W');
    echo '</div>'.END_LINE;
    echo '<div id="ressources">'.END_LINE;
    DisplayWorkshopRepLinks($parentid);
    DisplayWorkshopRepBiblio($parentid);
    echo '</div>'.END_LINE;

  }
  if(ActiveItemKey($GLOBALS['activeitem']) == 'publication-part')
  {
    themeInclude('../publication/display.php');

    SetHTMLTitle(_t('publication','section')); // set HTML title
    $result=$GLOBALS['sql_object']->DBSelect(SQL_getPublicationTitle($parentid));
    SetHTMLTitle(formatText($result[0]['publi_title'], '2HTML'));
    $result=$GLOBALS['sql_object']->DBSelect(SQL_getOnePublicationParts($id));
    SetHTMLTitle(formatText($result[0]['publicon_title'], '2HTML'));

    DisplayPublicationTitle($parentid);
    DisplayPublicationLinkinPart($id, $parentid, 'TEXT');
    DisplayOnePublicationPart($id);
    echo '<div class="nextprev">'.END_LINE;
    DisplayLinkParts($id, $parentid, 'PREVIOUS', 'P');
    DisplayLinkParts($id, $parentid, 'NEXT', 'P');
    echo '</div>'.END_LINE;
    echo '<div id="ressources">'.END_LINE;
    DisplayPublicationLinks($parentid);
    DisplayPublicationMulti($parentid);
    DisplayPublicationBiblio($parentid);
    echo '</div>'.END_LINE;
  }



}


//////////////////////////////////////////
/////affichage partie news
//////////////////////////////////////////

if(ActiveItemAlias($GLOBALS['activeitem'])=='news') {

  SetHTMLTitle(_t('news','section')); // set HTML title

  if(ActiveItemKey($GLOBALS['activeitem'])=='news') {
    $GLOBALS['filters'][LANGUAGE]['theme']['active'] = 1; // filter activation
    $GLOBALS['filters'][LANGUAGE]['level']['active'] = 1; // filter activation
    $GLOBALS['filters'][LANGUAGE]['scale']['active'] = 1; // filter activation
  }
  themeInclude('../news/display.php');
  /** préparation des variables
   * 	$statut
   * 	$debut default 0
   * 	$id -> default -1
   * 	$filter default -1
   **/
  if(ActiveItemKey($GLOBALS['activeitem'])=='news') $statut='public';
  if(ActiveItemKey($GLOBALS['activeitem'])=='news-archives') $statut='archives_p';
  if(isset($_REQUEST['id'])) $id=$_REQUEST['id']; else $id=-1;
  if(isset($_REQUEST['debut'])) $debut=$_REQUEST['debut']; else $debut=0;
  if(isset($_REQUEST['filter'])) {
    if($_REQUEST['filter']==$GLOBALS['filters'][LANGUAGE]['scale']['linkvalue']) $filter='SCALE';
    if($_REQUEST['filter']==$GLOBALS['filters'][LANGUAGE]['theme']['linkvalue']) $filter='THEME';
    if($_REQUEST['filter']==$GLOBALS['filters'][LANGUAGE]['level']['linkvalue']) $filter='LEVEL';
  } else $filter=-1;

  /** Affichage du lien de consultation d'archives ( si nécessaire 
   */

  if(ActiveItemKey($GLOBALS['activeitem']) != 'news-archives')  {

    $link_archive= array('rub'=> $GLOBALS['links'][LANGUAGE]['news-archives']['linkvalue']);

    echo '<div class="switchnav">';
    echo '<a href="'.HrefMaker($link_archive).'" title="'._t('divers','goto_archives').'">'._t('divers','goto_archives').'</a>'.END_LINE;
    echo '</div>';

  }


  /** Affichage du lien de consultation liste principale ( si nécessaire 
   */
  if(ActiveItemKey($GLOBALS['activeitem']) == 'news-archives')  {

    $link_archive= array('rub'=> $GLOBALS['links'][LANGUAGE]['news']['linkvalue']);

    echo '<div class="switchnav">';
    echo '<a href="'.HrefMaker($link_archive).'" title="'._t('divers','goto_currentlist').'">'._t('divers','goto_currentlist').'</a>'.END_LINE;
    echo '</div>';

  }

  /** Affichage du Listing Actualité + Archives
   */

  if((isset($_REQUEST['id']) && isset($_REQUEST['filter'])) || (!isset($_REQUEST['id']) && !isset($_REQUEST['filter'])))
  {
    DisplayListNews($statut, $filter, $id, $debut);
  }


  /** Détail d'une actualité
   */
  if(isset($_REQUEST['id']) && !isset($_REQUEST['filter'])) {

    // set HTML Title
    $result=$GLOBALS['sql_object']->DBSelect(SQL_getNewsTitle($id));
    SetHTMLTitle(formatText($result[0]['news_title'], '2HTML'));

    $news_statut=DisplayOneNews($id);
    echo '<hr />'.END_LINE;
    echo '<div class="nextprev">'.END_LINE;
    DisplayLinkNews($id, 'PREVIOUS', $news_statut);
    DisplayLinkNews($id, 'NEXT', $news_statut);
    echo '</div>'.END_LINE;
  }


}

//////////////////////////////////////////
/////affichage partie projet
//////////////////////////////////////////

if(ActiveItemAlias($GLOBALS['activeitem'])=='project') {
  
  themeInclude('../project/display.php');
  SetHTMLTitle(_t('project','section')); // set HTML title
  $GLOBALS['filters'][LANGUAGE]['priority']['active'] = 1; // filter activation
  /** préparation des variables
  * 	$statut
  * 	$debut default 0
  * 	$id -> default -1
  * 	$filter default -1
  **/
  if(ActiveItemKey($GLOBALS['activeitem'])=='project') $statut='public';
  if(ActiveItemKey($GLOBALS['activeitem'])=='project-archives') $statut='archives_p';
  if(isset($_REQUEST['id'])) $id=$_REQUEST['id']; else $id=-1;
  if(isset($_REQUEST['debut'])) $debut=$_REQUEST['debut']; else $debut=0;
  if(isset($_REQUEST['filter'])) {
    if($_REQUEST['filter']==$GLOBALS['filters'][LANGUAGE]['scale']['linkvalue']) $filter='SCALE';
    if($_REQUEST['filter']==$GLOBALS['filters'][LANGUAGE]['priority']['linkvalue']) $filter='PRIORITY';
    if($_REQUEST['filter']==$GLOBALS['filters'][LANGUAGE]['theme']['linkvalue']) $filter='THEME';

  } else $filter=-1;

  /** Affichage du lien de consultation d'archives ( si nécessaire 
   */

  	if(ActiveItemKey($GLOBALS['activeitem']) != 'project-archives')  {
  
  		$link_archive= array('rub'=> $GLOBALS['links'][LANGUAGE]['project-archives']['linkvalue']);
  
  		echo '<div class="switchnav">';
  		echo '<a href="'.HrefMaker($link_archive).'" title="'._t('divers','goto_archives').'">'._t('divers','goto_archives').'</a>'.END_LINE;
  		echo '</div>';
  
  	}


  /** Affichage du lien de consultation liste principale ( si nécessaire 
   */
  //	if(ActiveItemKey($GLOBALS['activeitem']) == 'project-archives')  {
  //
  //		$link_archive= array('rub'=> $GLOBALS['links'][LANGUAGE]['news']['linkvalue']);
  //
  //		echo '<div class="switchnav">';
  //		echo '<a href="'.HrefMaker($link_archive).'" title="'._t('divers','goto_currentlist').'">'._t('divers','goto_currentlist').'</a>'.END_LINE;
  //		echo '</div>';
  //
  //	}

  /** Affichage du Listing Projets + Archives
   */

  if((isset($_REQUEST['id']) && isset($_REQUEST['filter'])) || (!isset($_REQUEST['id']) && !isset($_REQUEST['filter'])))
  {
    DisplayListProject($statut, $filter, $id, $debut);
  }


  /** Détail d'un projet
   */
  if(isset($_REQUEST['id']) && !isset($_REQUEST['filter'])) {

    // set HTML Title
    $result=$GLOBALS['sql_object']->DBSelect(SQL_getProjectName($id));
    SetHTMLTitle(formatText($result[0]['project_name'], '2HTML'));

    $project_statut=DisplayOneProject($id);
  }


}
?>









