<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>

<?php
themeInclude('../search/display.php');

SetHTMLTitle(_t('search','section')); // set HTML title

if(ActiveItemKey($GLOBALS['activeitem'])=='search-result') {
  SetHTMLTitle(_t('search','result')); // set HTML title
  echo '<h1>'._t('search','result').'</h1>';

  if(!isset($_REQUEST['search']) || strlen($_REQUEST['search'])<=3) {
    echo '<div class="info">';
    echo _t('search','min_length');
    echo '</div>';
  } else {
    $str=strip_tags($_REQUEST['search']);
    $searchtype=isset($_REQUEST['searchtype']) ? $_REQUEST['searchtype'] : 'one';
    echo '<h2>'._t('search','keywords') .'\''.formatText($str,'2HTML').'\'</h2>'.END_LINE;

    $start_time = getmicrotime();
    DisplayPublicResults($str, $searchtype);
    $end_time = getmicrotime();
    DisplayQueryTime($start_time, $end_time);
    LogKeywordsSearch($str, 'PUBLIC', $searchtype);
  }
}

if(ActiveItemKey($GLOBALS['activeitem'])=='search') {
  SetHTMLTitle(_t('menu','advancedsearch')); // set HTML title 
  echo '<h1>'._t('menu','advancedsearch').'</h1>';

  DisplayAdvancedSearchForm();
}
?>





