<?php
/**
 * @package linea21.core
 * @subpackage system
 * @author fablezouave modified by linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * @link http://classes.scriptsphp.org/doc.bench
 * Bench Tool
 */

class bench {

  var $start;
  var $decimals;
  var $Result;

  /*
   Constructeur de la classe
   (initialisation des variables)
   */

  function bench() {

    $this->start = 0;
    // Nombre de chiffres après la virgule
    // pour l' affichage des résultats
    $this->decimals = 10;
    $this->Result = array();
  }

  /*
   Cette méthode marque le début du benchmark
   */

  function start_bench() {
    $this->start = bench::get_microtime();
  }

  /*
   Cette méthode marque la fin du benchmark
   */

  function end_bench() {
    $end = bench::get_microtime() - $this->start;
    $this->Result['End'] = $end;
  }


  /*
   Cette méthode sert à récupérer
   des temps intermèdiaires
   */

  function add_flag($txt) {
    $flag = bench::get_microtime() - $this->start;
    $this->Result[$txt] = $flag;
  }

  /*
   Cette méthode retourne un temps exploitable.
   */

  function get_microtime(){
    $T = explode(' ', microtime());
    $time = $T[1].substr($T[0], 1);
    return (float)$time;
  }

  /*
   Cette méthode retourne le nombre $value
   formaté avec n chiffres après la virgule
   */

  function format($value, $n=0) {
    $dec = $n==0 ? $this->decimals : $n;
    return number_format((float)$value, $dec);
  }

  /*
   Cette méthode retourne le résultat des benchs
   sous la forme d' un tableau HTML.
   */

  function return_result() {
    $prec  = 0;
    $inter = 0;

    $ret  = '<table style="border:1px solid #666;">';
    $ret .= '<tr style="background-color:#cccccc;color:#333">';
    $ret .= '<td>Event</td>';
    $ret .= '<td>Time from the beginning</td>';
    $ret .= '<td>Time from last flag</td>';
    $ret .= '<td> - Percentage -</td>';
    $ret .= '</tr>';

    foreach($this->Result as $key => $val) {
      $inter = $val - $prec;
      $prec = $val;
      $percent = ($inter/$this->Result['End'])*100;

      $ret .= '<tr>';
      $ret .= '<td>'.$key.'</td>';
      $ret .= '<td>'.bench::format($val).' s</td>';
      $ret .= '<td>'.bench::format($inter).' s</td>';
      $ret .= '<td>'.bench::format($percent, 2).' % </td>';
      $ret .= '</tr>';
    }

    $ret .= '</table>';

    return $ret;
  }

  /*
   Cette méthode retourne un simple résultat
   correspondant au temps passé entre
   start_bench() et end_bench()
   */

  function return_simple_result() {
    $r = bench::format($this->Result['End']) ;
    $ret = "Page générée en $r secondes. / Generated in $r seconds";
    return $ret;
  }


} // end class

?>
