<?php
/**
 * @package linea21.core
 * @subpackage home
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Home' module is used into the back-office 
 */

$req_yp = "SELECT yellowp_name, yellowp_id FROM " . T_YELLOWPAGES . " WHERE yellowp_statut='D';";

$req_sdi = 	"SELECT DISTINCT V.sdiv_sdi_info, MAX(V.sdiv_date_published) as date_pub, " .
			"MAX(V.sdiv_date_published) + I.sdii_frequency * interval '1 day' AS datep, " .
			"I.sdii_name, I.sdii_id, S.scale_denomination, S.scale_id 
			FROM " . T_SDI_VALUE . " AS V
			LEFT OUTER JOIN " . T_SDI_INFO . " AS I ON V.sdiv_sdi_info = I.sdii_id
			LEFT OUTER JOIN " . T_SCALE . " AS S ON V.sdiv_scale = S.scale_id
			WHERE sdiv_statut <> 'E' AND sdii_statut <> 'E' 
			AND I.sdii_frequency <> 0 AND S.scale_statut <> 'E' 
			GROUP BY V.sdiv_sdi_info, I.sdii_frequency, I.sdii_name, I.sdii_id, S.scale_denomination, S.scale_id 
			HAVING (MAX(V.sdiv_date_published) + I.sdii_frequency * interval '1 day') < NOW() 
			ORDER BY S.scale_id;";

$req_news = "SELECT N.news_title, news_id FROM " . T_NEWS . " AS  N WHERE news_statut='P' ORDER BY news_published_date DESC OFFSET 0 LIMIT 3;";

$req_publi = "SELECT publi_title, publi_resume, publi_id FROM " . T_PUBLI . " WHERE publi_statut='P' ORDER BY publi_published_date DESC OFFSET 0 LIMIT 1;";

$req_rep = "SELECT  workrep_title , workrep_resume,   workrep_id FROM " . T_WORK_REP . " AS  N WHERE workrep_statut='P' ORDER BY workrep_published_date DESC OFFSET 0 LIMIT 1;";

function SQL_getUser($date)
{
    $req_user = "SELECT user_login, user_id , user_date_crea FROM " . T_USER . " WHERE user_date_crea > '" . $date . "' AND user_validity='Y'";
    return $req_user;
} 

function SQL_getProjects()
{
    $q =  "SELECT project_name, project_id, to_char(project_estimated_date, '".
          toStringSqlDate()."') AS project_estimated_date_display FROM "  . T_PROJECT . 
          " WHERE project_statut='P' AND project_estimated_date <> '0001-01-01'".
          " ORDER BY project_estimated_date ASC OFFSET 0 LIMIT 1;";
    return $q;
} 

?>
