<?php
/**
 * @package linea21.modules
 * @subpackage content
 * @see workshop, publication
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Content Management
 */

class contents {
  /* @param
   * */
  var $TDB_LIAISON = J_PARTS;
  var $ACTIVE_TABLE;
  var $ACTIVE_TYPE; // valeur 'P' || 'W'
  var $WR_ID;
  var $WR_TITLE;
  var $WR_BODY;
  var $WR_DATE_CREA;
  var $WR_LAST_MODIFY;
  var $WR_TABLE = T_WORK_REP_CONT;

  var $P_ID;
  var $P_TITLE;
  var $P_BODY;
  var $P_TEMPLATE;
  var $P_PHOTOS_URI;
  var $P_DATE_CREA;
  var $P_LAST_MODIFY;
  var $P_TABLE = T_PUBLI_CONT;
  var $P_MAX_PHOTO_MAX_WIDTH = MAX_PHOTO_MAX_WIDTH;
  var $P_MAX_PHOTO_MIN_WIDTH = MAX_PHOTO_MIN_WIDTH;
  var $P_UPLOAD_MAX_MO = UPLOAD_MAX_MO; // taille maximale d'upload des fichiers en octets
  var $P_URI_INPUT = "publication/contents/"; // dossier racine de stockage des elements multimedias
  var $P_URI_OUTPUT = "publication/contents/"; // dossier racine de diffusion des elements multimedias
  protected $dispatcher = null;

  public function __construct()
  {
    $this->dispatcher = $GLOBALS['dispatcher'];
  }

  public function __call($method, $arguments)
  {
    $event = $this->dispatcher->notifyUntil(new sfEvent($this, 'contents.extensible_function', array(
      'method'    => $method,
      'arguments' => $arguments
    )));
    if (!$event->isProcessed())
    {
      throw new Exception(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
    }

    return $event->getReturnValue();
  }
  /**
   * contents::CheckDataIntegrity()
   * vérifie l'integrité d'un partie avant Insertion
   *
   * @access public
   * @param array $table contient les composants d'une partie
   * @param string $type 'P', 'W'
   * @param string $type_test 'LIGHT', 'ROCK'
   * @return boolean true
   * si verifié, sinon string 'message d'erreur'
   */
  function CheckDataIntegrity($table, $type, $type_test = 'LIGHT')
  {
    if (strlen($table[0]) < 2) return _t('contents','no_title');
    if (strlen($table[1]) < 10) return _t('contents','no_body');
    if ($type == 'P' && $type_test == 'ROCK') {
      if ($table[2] != 3 && $table[3] == '')return _t('contents','no_visu1');
    }

    return true;
  }

  /**
   * contents::GetTemplateName()
   * Retourne la forme textuelle du template
   *
   * @access public
   * @param integrer $num
   * @return void
   */
  function GetTemplateName($num)
  {
    if ($num == 1) return _t('contents','template_1');
    if ($num == 2) return _t('contents','template_2');
    if ($num == 3) return _t('contents','template_3');
  }

  /**
   * contents::_wichType()
   * initialisation des tables SQL
   *
   * @access private
   * @param string $type : type du CONTENU 'WORKSHOP' ou 'PUBLICATION'
   * @return string -void
   */
  function _wichType($type)
  {
    switch ($type) {
      case 'WORKSHOP':
        $this->ACTIVE_TABLE = $this->WR_TABLE;
        $this->ACTIVE_TYPE = 'W';
        break;
      case 'PUBLICATION':
        $this->ACTIVE_TABLE = $this->P_TABLE;
        $this->ACTIVE_TYPE = 'P';
        break;
      default:
        return "error";
    }
  }

  /**
   * contents::AddContents()
   * ajout d'une partie de contenu
   *
   * @access public
   * @param integer $ID identifiant du père (rattachement)
   * @param array $contents_table tableau contenant les infos ressources
   * @param string $type 'WORKSHOP' ou 'PUBLICATION'
   * @param object $
   * @return integer $last_id
   */
  function AddContents($ID, $contents_table, $type, $sql_object)
  {
    $contents_table=$sql_object->DBescape($contents_table);
    if ($this->_wichType($type) == "error") exit;
    $requete = "INSERT INTO " . $this->ACTIVE_TABLE ;
    if ($type == "WORKSHOP") {
      $this->WR_TITLE = strip_input($contents_table[0]);
      $this->WR_BODY = strip_input($contents_table[1], true);
      $requete.= " (workrepcon_title, workrepcon_body, workrepcon_date_crea, workrepcon_last_modify, workrepcon_validity)";
      $requete .= " VALUES('" . $this->WR_TITLE . "', '" . $this->WR_BODY . "', NOW(),NOW(), 'Y');";
    }
    if ($type == "PUBLICATION") {
      $this->P_TITLE = strip_input($contents_table[0]);
      $this->P_BODY = strip_input($contents_table[1], true);
      $this->P_TEMPLATE = $contents_table[2];
      $this->P_PHOTOS_URI = strip_input($contents_table[3]);
      $requete.= " (publicon_title, publicon_body, publicon_template, publicon_photos_uri, publicon_date_crea, publicon_last_modify, publicon_validity)";
      $requete .= " VALUES('" . $this->P_TITLE . "', '" . $this->P_BODY . "', " . $this->P_TEMPLATE . ", '" . $this->P_PHOTOS_URI . "', NOW(),NOW(), 'Y');";
    }
    $last_id = $sql_object->DBInsert ($requete, 1);

    if (is_numeric($last_id)) {
      $requete = "INSERT INTO " . $this->TDB_LIAISON . " VALUES(" . $ID . "," . $last_id . ", '" . $this->ACTIVE_TYPE . "');";
      $result = $sql_object->DBInsert ($requete);
    }
    return $result;
  }

  /**
   * contents::ModifyContents()
   * modification d'une partie de contenu
   *
   * @access public
   * @param integer $ID : identifiant de la partie à modifier
   * @param array $contents_table : tableau contenant les infos ressources
   * @param string $type 'WORKSHOP' ou 'PUBLICATION'
   * @param object $sql_object
   * @return boolean $result
   */
  function ModifyContents($ID, $contents_table, $type, $sql_object)
  {
    $contents_table=$sql_object->DBescape($contents_table);
    if ($this->_wichType($type) == "error") exit;
    if (!is_numeric($ID)) return false;
    if ($type == "WORKSHOP") $this->WR_ID = $ID;
    if ($type == "PUBLICATION") $this->P_ID = $ID;

    $requete = "UPDATE " . $this->ACTIVE_TABLE . " SET ";
    if ($type == "WORKSHOP") {
      $this->WR_TITLE = strip_input($contents_table[0]);
      $this->WR_BODY = strip_input($contents_table[1], true);
      $requete .= "workrepcon_title='" . $this->WR_TITLE . "', workrepcon_body='" . $this->WR_BODY . "', workrepcon_last_modify=NOW() WHERE workrepcon_id='" . $this->WR_ID . "';";
    }
    if ($type == "PUBLICATION") {
      $this->P_TITLE = strip_input($contents_table[0]);
      $this->P_BODY = strip_input($contents_table[1], true);
      $this->P_TEMPLATE = strip_input($contents_table[2]);
      $this->P_PHOTOS_URI = strip_input($contents_table[3]);
      $requete .= "publicon_title='" . $this->P_TITLE . "', publicon_body='" . $this->P_BODY . "', publicon_template='" . $this->P_TEMPLATE . "',  publicon_photos_uri='" . $this->P_PHOTOS_URI . "', publicon_last_modify=NOW() WHERE publicon_id='" . $this->P_ID . "';";
    }
    $result = $sql_object->DBQuery($requete);

    return $result;
  }

  /**
   * contents::DeleteContents()
   * suppression d'une partie
   *
   * @access public
   * @param integer $ID : identifiant du contents a supprimer
   * @param string $type :  'WORKSHOP' ou 'PUBLICATION'
   * @param object $sql_object
   * @return boolean $result
   */
  function DeleteContents($ID, $type, $sql_object)
  {
    if (is_numeric($ID)) {
      if ($type == "WORKSHOP") {
        $champ1 = "workrepcon_id";
        $champ2 = "jwp_contents_id";
        $champ3 = "workrepcon_validity";
        $champ4 = "workrepcon_last_modify";
      }
      if ($type == "PUBLICATION") {
        $champ1 = "publicon_id";
        $champ2 = "jpp_contents_id";
        $champ3 = "publicon_validity";
        $champ4 = "publicon_last_modify";
      }
    } else return false;
    if ($this->_wichType($type) == "error") return false;
    $requete = "UPDATE " . $this->ACTIVE_TABLE . " SET " . $champ3 . "='N', ".$champ4."=NOW()  WHERE " . $champ1 . "='" . $ID . "';";
    $result = $sql_object->DBQuery($requete);

    return $result;
  }
}

?>
