<?php
/**
 * @package linea21.modules
 * @subpackage plugin
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Plugin Management
 */

class plugin {

  private $info = array();

  public function __construct($name) {

    $a = array();

    try{
      if(!@$flow=simplexml_load_file(SITE_PATH.'plugins/'.$name.'/plugin.xml')){
        throw new Exception($name.' plugin : xml file was not found');
      }
      $this->info['name'] = $name;
      $this->info['shortname'] = str_replace('l21_', '', $name);
      $this->info['description'] = $flow->description;
      $this->info['version'] = $flow->version;
      $this->info['date'] = $flow->date;
      $this->info['compatibility'] = $flow->compatibility;
      $this->info['author'] = $flow->author;
      $this->info['homepage'] = $flow->homepage;
      $this->info['settings'] = (integer) $flow->settings;
      $this->info['default_language'] = $flow->default_language;
      $this->info['image'] = $flow->image;
      $this->info['active_path'] = SITE_PATH.'plugins/'.$this->info['name'].'/.active';

      /** TODO - Définir la portée du plugin sur les applications 'admin' | 'public'
       * afin d'optimiser le chargement des fichiers depuis __init__.php
       * **/
      foreach($flow->apps->app as $el) {
        $this->info['apps'][]=(string) $el;
      }
    }
    catch(Exception $e){
      return $e->getMessage();
    }

  }

  public function __toString() {
    return $this->getVar('name');
  }

  public function hasImage() {

    if(!empty($this->info['image'])) return true;
    else return false;

  }

  public function hasAdvancedSettings() {

    if($this->info['settings'] == true) return true;
    else return false;

  }

  public function imagePath() {

    return '../plugins/'.$this->info['name'].'/'.$this->info['image'];

  }

  public function getPluginInfo() {

    return $this->info;

  }

  public function getVar($varname) {

    return $this->info[$varname];
  }

  public function getAvailablePlugins() {

    return availablePlugins();

  }

  public function loadPlugin() {
    // we check if the current app is concerned by the module
    if(!in_array(CURRENT_APP, $this->getVar('apps'))) return false;
    IncludeLanguagesPluginfiles($this);
    if(file_exists(SITE_PATH.'plugins/'.$this->info['name'].'/__init__.php')) {
      include_once(SITE_PATH.'plugins/'.$this->info['name'].'/__init__.php');
    }
    return true;
  }

  public function enable() {

    $fp = fopen($this->getVar('active_path'), "x");
    fclose($fp);

    if(file_exists(SITE_PATH.'plugins/'.$this->info['name'].'/__install__.php')) {
      include_once(SITE_PATH.'plugins/'.$this->info['name'].'/__install__.php');
    }

  }

  public function disable() {

    return unlink($this->getVar('active_path'));

  }

  public function is_active() {

    return file_exists($this->getVar('active_path'));

  }


}

?>