<?php
/**
 * @package linea21.modules
 * @subpackage project
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Project Management
 */

class project {
  /* @param
   * */
  var $TDB_PROJECT = T_PROJECT; // nom de la table.
  var $ID;
  var $PARENT_ID;
  var $SCALE_ID;
  var $PRIORITY_ID;
  var $THEME_ID;
  var $WORKSHOP_ID;
  var $NAME;
  var $DESCRIPTION;
  var $BODY;
  var $BEGIN_DATE;
  var $ESTIMATED_DATE;
  var $END_DATE;
  var $SDI;
  var $PUBLISHED_DATE;
  var $POSTED_BY;
  var $DATE_CREA;
  var $STATUT;
  var $LAST_MODIFY;
  protected $dispatcher = null;

  public function __construct()
  {
    $this->dispatcher = $GLOBALS['dispatcher'];
  }

  public function __call($method, $arguments)
  {
    $event = $this->dispatcher->notifyUntil(new sfEvent($this, 'project.extensible_function', array(
      'method'    => $method,
      'arguments' => $arguments
    )));
    if (!$event->isProcessed())
    {
      throw new Exception(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
    }

    return $event->getReturnValue();
  }

  /**
   * project::_getDate()
   * date courante et ajout
   *
   * @access private
   * @param int $m chiffre des mois
   * @param int $d chiffre des jours
   * @param int $y chiffre des années
   * @return string $format_date
   * @return
   */
  function _getDate($m = 0, $d = 0, $y = 0)
  {
    $format_date = mktime(date("H"), date("i"), date("s"), date("m") + $m, date("d") , date("Y"), -1);
    $format_date = strftime('%Y-%m-%d %H:%M:%S', $format_date);

    return $format_date;
  }

  /**
   * project::CheckDataIntegrity()
   * Vérification intégrité des données
   *
   * @access public
   * @param array $table : contient les composants Nécessaires d'un projet
   * @return boolean true
   * si verifié, sinon string 'message d'erreur'
   */

  function CheckDataIntegrity($table)
  {
    if (strlen($table[0]) < 3) return _t('project','no_name');
    if (strlen($table[1]) < 3) return _t('project','no_description');
    if (strlen($table[2]) < 3) return _t('project','no_body');
    if ($table[5] <= 0 || !is_numeric($table[5])) return _t('project','no_priority');
    if ($table[4] <= 0 || !is_numeric($table[4])) return _t('project','no_scale');
    if(!empty($table[6])) return checkdate_validity($table[6], _t('project','begin_date_err'));
    if(!empty($table[7])) return checkdate_validity($table[7], _t('project','estimated_date_err'));
    if(!empty($table[8])) return checkdate_validity($table[8], _t('project','end_date_err'));

    return true;
  }

  /**
   * project::AddProject()
   * Ajout d'un projet
   *
   * @access public
   * @param array $table_project : contient les composants d'un projet
   * @param object $sql_object
   * @return integer $last_id
   */
  function AddProject($table_project, $sql_object)
  {
    $table_project=$sql_object->DBescape($table_project);

    if ($table_project[0] != '') {
      $this->NAME = strip_input(trim($table_project[0]), true);
    }
    if ($table_project[1] != '') {
      $this->DESCRIPTION = strip_input(trim($table_project[1]), true);
    }
    if ($table_project[2] != '') {
      $this->BODY = strip_input(trim($table_project[2]), true);
    }
    if (is_numeric($table_project[3]) && $table_project[3] != -1) {
      $this->PARENT_ID = $table_project[3];
    } else {
      $this->PARENT_ID = 0;
    }
    if (is_numeric($table_project[4])) {
      $this->SCALE_ID = $table_project[4];
    }
    if (is_numeric($table_project[5])) {
      $this->PRIORITY_ID = $table_project[5];
    }
    if ($table_project[6] != '') {
      $this->BEGIN_DATE = formatDate($table_project[6], true);
    } else {
      $this->BEGIN_DATE = '0001-01-01';
    }
    if ($table_project[7] != '') {
      $this->ESTIMATED_DATE = formatDate($table_project[7], true);
    } else {
      $this->ESTIMATED_DATE = '0001-01-01';
    }
    if ($table_project[8] != '') {
      $this->END_DATE = formatDate($table_project[8], true);
    } else {
      $this->END_DATE = '0001-01-01';
    }
    if (is_numeric($table_project[9])) {
      $this->POSTED_BY = $table_project[9];
    }
    if ($table_project[10] != '') {
      $this->STATUT = strtoupper($table_project[10]);
    }
    if (is_numeric($table_project[11]) && $table_project[11] != -1) {
      $this->THEME_ID = $table_project[11];
    } else {
      $this->THEME_ID = 0;
    }
    if (is_numeric($table_project[12]) && $table_project[12] != -1) {
      $this->WORKSHOP_ID = $table_project[12];
    } else {
      $this->WORKSHOP_ID = 0;
    }
    $this->SDI = $table_project[13];
    if ($this->STATUT == 'P') {
      $this->PUBLISHED_DATE = $this->_getDate();
    } else {
      $this->PUBLISHED_DATE = '0001-01-01';
    }

    $query = "INSERT INTO " . $this->TDB_PROJECT . " (project_name, project_description, project_body, ".
    "project_parent_id, project_priority_id, project_scale_id, " .
    "project_begin_date, project_estimated_date, project_end_date, ".
    "project_theme_id, project_workshop_id, ".
    "project_posted_by, project_published_date, " .
    "project_statut, project_date_crea) " .
    "VALUES('" . $this->NAME . "', '" . $this->DESCRIPTION . "', '" . $this->BODY .
    "', " . $this->PARENT_ID . ", " . $this->PRIORITY_ID . ", " . $this->SCALE_ID .
    ", '" . $this->BEGIN_DATE . "', '" . $this->ESTIMATED_DATE . "', '" . $this->END_DATE .
    "', " . $this->THEME_ID . ", " . $this->WORKSHOP_ID .
    ", " . $this->POSTED_BY . ", '" . $this->PUBLISHED_DATE . "' , '" . $this->STATUT .
    "', now());";
     
    $this->ID = $sql_object->DBInsert ($query, 1);
    $this->_addSDI($sql_object);

    return $this->ID;
  }

  /**
   * project::DeleteProject()
   * suppression d'un projet
   *
   * @access public
   * @param int $ID : identifiant du projet
   * @param object $sql_object
   * @return bool $result
   */

  function DeleteProject($ID, $sql_object)
  {
    $this->ID = $ID;


    $query = "UPDATE " . $this->TDB_PROJECT . " set project_statut='E', project_last_modify=NOW() WHERE project_id='" . $this->ID . "';";
    $result = $sql_object->DBQuery($query);
    if($result) {
      $query = "DELETE FROM " . J_PROJECT_SDI . " WHERE jps_project_id='".$this->ID."';";
      $res = $sql_object->DBQuery($query);
    }
    if($result) {
      $query = "UPDATE " . $this->TDB_PROJECT . " set project_parent_id=0 WHERE project_parent_id='" . $this->ID . "';";
      $result = $sql_object->DBQuery($query);
    }
    return $result;
  }

  /**
   * project::ModifyProject()
   * modification d'un projet
   *
   * @access public
   * @param integer $ID : identifiant du projet
   * @param object $sql_object
   * @param array $table_project : contient les composants d'un projet
   * @return boolean $result
   */
  function ModifyProject($ID, $table_project, $sql_object)
  {

    $table_project=$sql_object->DBescape($table_project);

    if (is_numeric($ID)) {
      $this->ID = $ID;
    }

    if ($table_project[0] != '') {
      $this->NAME = strip_input(trim($table_project[0]), true);
    }
    if ($table_project[1] != '') {
      $this->DESCRIPTION = strip_input(trim($table_project[1]), true);
    }
    if ($table_project[2] != '') {
      $this->BODY = strip_input(trim($table_project[2]), true);
    }
    if (is_numeric($table_project[3]) && $table_project[3] != -1) {
      $this->PARENT_ID = $table_project[3];
    } else {
      $this->PARENT_ID = 0;
    }
    if (is_numeric($table_project[4])) {
      $this->SCALE_ID = $table_project[4];
    }
    if (is_numeric($table_project[5])) {
      $this->PRIORITY_ID = $table_project[5];
    }
    if ($table_project[6] != '') {
      $this->BEGIN_DATE = formatDate($table_project[6], true);
    } else {
      $this->BEGIN_DATE = '0001-01-01';
    }
    if ($table_project[7] != '') {
      $this->ESTIMATED_DATE = formatDate($table_project[7], true);
    } else {
      $this->ESTIMATED_DATE = '0001-01-01';
    }
    if ($table_project[8] != '') {
      $this->END_DATE = formatDate($table_project[8], true);
    } else {
      $this->END_DATE = '0001-01-01';
    }
    if ($table_project[9] != '') {
      $this->STATUT = strtoupper($table_project[9]);
    }
    if (is_numeric($table_project[11]) && $table_project[11] != -1) {
      $this->THEME_ID = $table_project[11];
    } else {
      $this->THEME_ID = 0;
    }
    if (is_numeric($table_project[12]) && $table_project[12] != -1) {
      $this->WORKSHOP_ID = $table_project[12];
    } else {
      $this->WORKSHOP_ID = 0;
    }
    $this->SDI = $table_project[13];
    if ($this->STATUT == 'P') {
      $this->PUBLISHED_DATE = $this->_getDate();
    } else {
      $this->PUBLISHED_DATE = '0001-01-01';
    }

    $mask = $this->_HavePublishedDate($table_project[10]);

    $query = "UPDATE  " . $this->TDB_PROJECT . " SET project_name='" . $this->NAME . "', project_description='" . $this->DESCRIPTION. "', project_body='" . $this->BODY . "' , project_parent_id='" . $this->PARENT_ID . "', project_scale_id='" . $this->SCALE_ID . "', project_theme_id='" . $this->THEME_ID ."', project_workshop_id='" . $this->WORKSHOP_ID ."', project_priority_id='" . $this->PRIORITY_ID . "', project_begin_date='" . $this->BEGIN_DATE . "', project_estimated_date='" . $this->ESTIMATED_DATE . "', project_end_date='".$this->END_DATE."', project_statut='" . $this->STATUT . "', project_last_modify=NOW() " . $mask . " WHERE project_id='" . $this->ID . "';";
    $result = $sql_object->DBQuery($query);
    $result = $this->_modifySDI($sql_object);

    return $result;
  }

  /**
   * project::_addSDI()
   * associate indicators to project
   *
   * @access private
   */
  function _addSDI($sql_object) {
    foreach ($this->SDI as &$value) {
      $query = "INSERT INTO ". J_PROJECT_SDI . " VALUES(".$this->ID.", ".$value.");";
      $result = $sql_object->DBQuery($query);
    }
    return $result;
  }

  /**
   * project::_modifySDI()
   * associate indicators to project
   *
   * @access private
   */
  function _modifySDI($sql_object) {
    $query = "DELETE FROM " . J_PROJECT_SDI . " WHERE jps_project_id='".$this->ID."';";
    $result = $sql_object->DBQuery($query);
    if(count($this->SDI)>0) {
      $result = $this->_addSDI($sql_object);
    }

    return $result;
  }

  /**
   * project::_HavePublishedDate()
   * Détermine la date de publication a inserer dans la bdd
   *
   * @access private
   * @param string $current_status : statut actuel de l'actualité
   * @return string $sql_mask
   */
  function _HavePublishedDate($current_status)
  {
    switch ($this->STATUT) {
      case 'P':
        if ($current_status == 'D') $sql_mask = ", project_published_date= NOW()";
        else $sql_mask = '';
        break;
      case 'D':
        $sql_mask = ", project_published_date= '0001-01-01'";
        break;
      default:
        $sql_mask = '';
    }
    return $sql_mask;
  }
}

?>
