<?php
/**
 * @package linea21.modules
 * @subpackage workshop
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Work group Management
 */

class workshop {
  /* @param
   * */
  var $TDB_WORKSHOP = T_WORK; // nom de la table.
  var $ID;
  var $DENOMINATION;
  var $RESUME;
  var $THEME;
  var $COMMENT;
  var $LEVEL;
  var $DATE_CREA;
  var $LAST_MODIFY;
  var $STATUT;
  protected $dispatcher = null;

  public function __construct()
  {
    $this->dispatcher = $GLOBALS['dispatcher'];
  }

  public function __call($method, $arguments)
  {
    $event = $this->dispatcher->notifyUntil(new sfEvent($this, 'workshop.extensible_function', array(
      'method'    => $method,
      'arguments' => $arguments
    )));
    if (!$event->isProcessed())
    {
      throw new Exception(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
    }

    return $event->getReturnValue();
  }

  /**
   * workshop::CheckDataIntegrity()
   * Vérification intégrité des données
   *
   * @access public
   * @param array $table contient les composants d'un groupe de travail
   * @return boolean true
   * si verifié, sinon string 'message d'erreur'
   */
  function CheckDataIntegrity($table, $sql_object)
  {
    if (strlen($table[0]) < 3) return _t('workshop','no_title');
    if (strlen($table[1]) < 3) return _t('workshop','no_resume');
    if ($table[2] == -1) return _t('workshop','no_theme');

    if (substr($table[6], -1) == ',') {
      $table[6] = substr($table[6], 0, -1);
    }
    $table_organizer = @explode(',', $table[6]);
    for ($i = 0;$i < count($table_organizer);$i++) {
      $table_organizer[$i] = trim($table_organizer[$i]);
      if (strlen(trim($table_organizer[$i])) < 2) $return = _t('workshop','no_author');
      $result = $this->_CheckUserValidity($table_organizer[$i], $sql_object);
      if (!is_numeric($result)) $return = _t('workshop','author_not_valid') . " : " . $table_organizer[$i];
      else $return = $result;
      $result_admin = $this->_CheckAdmin($sql_object, -1, $table_organizer[$i]);
      if ($result_admin == false) $return = _t('workshop','author_not_admin') . " : " . $table_organizer[$i];
      if (!is_numeric($return)) return $return;
    }
    return $return;
  }

  /**
   * workshop::_CheckAdmin()
   * Vérification droits d'utilisation avancé Admin ou Animateur
   *
   * @access private
   * @param object $sql_object
   * @return integer $user_id (option)
   * @param string $user_login (option)
   * @return integer id de l'utilisateur si verifié, sinon false
   */
  function _CheckAdmin($sql_object, $user_id = -1, $user_login = -1)
  {
    if ($user_id <> -1) {
      $requete = "SELECT rights_workshop, U.user_id FROM " . T_USER . " AS U LEFT OUTER JOIN " . T_RIGHT . " AS R on U.user_rights=R.rights_id  WHERE user_id='" . $user_id . "' AND user_validity='Y';";
    }
    if ($user_login <> -1) {
      $requete = "SELECT rights_workshop, U.user_id FROM " . T_USER . " AS U LEFT OUTER JOIN " . T_RIGHT . " AS R on U.user_rights=R.rights_id  WHERE lower(user_login)= '" . strtolower($user_login) . "' AND user_validity='Y';";
    }
    $result = $sql_object->DBSelect($requete);
    if ($result[0]['rights_workshop'] == 'A' || $result[0]['rights_workshop'] == 'O') return $result[0]['user_id'];
    else return false;
  }

  /**
   * workshop::_CheckUserValidity()
   * Vérification validité de l'utilisateur
   *
   * @access private
   * @param string $login
   * @param object $sql_object
   * @return integer si $login existe
   * sinon renvoie false
   */
  function _CheckUserValidity($login, $sql_object)
  {
    $requete = "SELECT user_id FROM " . T_USER . " WHERE lower(user_login)= '" . strtolower($login) . "' AND user_validity='Y';";
    $result = $sql_object->DBSelect($requete);
    if ($result == 0) return false;
    if (count($result) > 1) exit();
    else return (int)$result[0]['user_id'];
  }

  /**
   * workshop::CheckUsersIntegrity()
   * Vérification pour ajout d'utilisateurs
   *
   * @access public
   * @param string $logins
   * @param integer $id
   * @param object $sql_object
   * @param string $statut
   * @return string $result
   */
  function CheckUsersIntegrity($logins, $id, $sql_object, $statut)
  {

    if (strlen(trim($logins)) < 2) return _t('workshop','no_author');

    if (substr($logins, -1) == ',') {
      $logins = substr($logins, 0, -1);
    }
    $users = @explode(',', $logins);

    foreach ($users as $user) {
      $user = trim($user);
      // check if user exists
      $result = $this->_CheckUserValidity($user, $sql_object);
      if ($result== false) return _t('workshop','author_not_valid') . " : " . $user;
      // check if user has rights enough
      if ($statut == 'O') {
        $result = $this->_CheckAdmin($sql_object, -1, $user);
        if ($result == false) return _t('workshop','author_not_admin') . " : " . $user;
      }
      // check if user is already member of the workgroup
      $q = "SELECT user_id FROM " . T_USER . " WHERE lower(user_login)= '" . strtolower($user) . "' AND user_validity='Y';";
      $data = $sql_object->DBSelect($q);

      $q = "SELECT COUNT(jwu_id) AS nb FROM " . J_WORK_USERS . " WHERE jwu_user_id=" . $data[0]['user_id'] . " AND jwu_workshop_id=" . $id . ";";
      $data = $sql_object->DBSelect($q, 'OBJECT');
      if ($data[0]->nb != 0) return _t('workshop','yet_author') . " : " . $user;
    }

    return true;
  }

  /**
   * workshop::AddWorkshop()
   * Ajout d'un groupe de travail
   *
   * @access public
   * @param array $table_workshop contient les composants d'un workshop
   * @param object $sql_object
   * @return integer $last_id
   */
  function AddWorkshop($table_workshop, $sql_object)
  {
    $table_workshop=$sql_object->DBescape($table_workshop);

    if($table_workshop[4] == -1) $table_workshop[4]=0;

    $this->DENOMINATION = strip_input(trim($table_workshop[0]));
    $this->RESUME = strip_input(trim($table_workshop[1]), true);
    $this->THEME = $table_workshop[2];
    $this->COMMENT = strip_input(trim($table_workshop[3]), true);
    $this->LEVEL = $table_workshop[4];
    $this->STATUT = $table_workshop[5];

    $requete = "INSERT INTO " . $this->TDB_WORKSHOP . " (workshop_denomination, workshop_resume, workshop_theme, workshop_comment, workshop_level, workshop_statut, workshop_date_crea) VALUES('" . $this->DENOMINATION . "', '" . $this->RESUME . "', " . $this->THEME . ", '" . $this->COMMENT . "', " . $this->LEVEL . ", '" . $this->STATUT . "', NOW());";
    $last_id = $sql_object->DBInsert ($requete, 1);
    return $last_id;
  }

  /**
   * workshop::ModifyWorkshop()
   * modification d'un workshop
   *
   * @access public
   * @param int $ID identifiant d'un workshop
   * @param array $table_workshop contient les composants d'un workshop
   * @param object $sql_object
   * @return bool $result
   */
  function ModifyWorkshop($ID, $table_workshop, $sql_object)
  {
    $table_workshop=$sql_object->DBescape($table_workshop);

    if($table_workshop[4] == -1) $table_workshop[4]=0;

    if (is_numeric($ID)) {
      $this->ID = $ID;
    }

    $this->DENOMINATION = strip_input(trim($table_workshop[0]));
    $this->RESUME = strip_input(trim($table_workshop[1], true));
    $this->THEME = $table_workshop[2];
    $this->COMMENT = strip_input(trim($table_workshop[3], true));
    $this->LEVEL = $table_workshop[4];

    $requete = "UPDATE  " . $this->TDB_WORKSHOP . " set workshop_denomination='" . $this->DENOMINATION . "', workshop_resume='" . $this->RESUME . "' , workshop_theme=" . $this->THEME . ", workshop_level=" . $this->LEVEL . ", workshop_comment='" . $this->COMMENT . "' WHERE workshop_id=" . $this->ID . ";";
    $result = $sql_object->DBQuery($requete);
    return $result;
  }

  /**
   * modification du statut d'un workshop
   *
   * @access public
   * @param int $id identifiant du workshop
   * @param string $state (facultatif) 'P' Public/'D' Draft/'AA' AdminArchive/'PA' PublicArchive/'E' Erase
   * @param object $sql_object
   * @return bool $result
   */

  function StateWorkshop($ID, $state, $sql_object)
  {
    if (is_numeric($ID)) {
      $this->ID = $ID;
    }
    if ($state != '') {
      strtoupper($state);
      switch ($state) {
        case 'P':
          $this->STATUT = $state;
          break;
        case 'D':
          $this->STATUT = $state;
          break;
        case 'AA':
          $this->STATUT = $state;
          break;
        case 'PA':
          $this->STATUT = $state;
          break;
        case 'E':
          $this->STATUT = $state;
          break;
        default:
          $this->STATUT = 'D';
          break;
      }
    } else $this->STATUT = 'D';
    $requete = "UPDATE  " . $this->TDB_WORKSHOP . " set workshop_statut='" . $this->STATUT . "' WHERE workshop_id=" . $this->ID . ";";
    $result = $sql_object->DBQuery($requete);
    return $result;
  }

  /**
   * suppression d'un workshop
   *
   * @access public
   * @param int $id identifiant du workshop a supprimer
   * @param object $sql_object
   * @return bool $result
   */

  function DeleteWorkshop($ID, $sql_object)
  {
    if (is_numeric($ID)) {
      $this->ID = $ID;
    }
    $result = $this->StateWorkshop($this->ID, 'E', $sql_object);

    return $result;
  }

  /**
   * workshop::AddUserWorkshop()
   * Ajout d'un ou plusieurs utilisateurs au workshop
   *
   * @access public
   * @param int $work_id identifiant du workshop
   * @param string $user_login login(s) utilisateur(s)
   * @param array $user_right droit confié a l'utilisateur sur le workshop
   * @param object $sql_object
   * @return integer $last_id
   */
  function AddUserWorkshop($work_id, $user_login, $user_right , $sql_object)
  {
    if (is_numeric($work_id)) {
      $this->ID = $work_id;
    } else return false;
    if (substr($user_login, -1) == ',') {
      $user_login = substr($user_login, 0, -1);
    }
    $user_login = @explode(',', $user_login);
    for ($i = 0;$i < count($user_login);$i++) {
      $requete = "SELECT user_id FROM " . T_USER . " WHERE lower(user_login) = '" . strtolower($user_login[$i]) . "' AND user_validity='Y';";
      $data = $sql_object->DBSelect($requete);
      $user_id = $data[0]['user_id'];
      $requete = "INSERT INTO " . J_WORK_USERS . " (jwu_workshop_id, jwu_user_id, jwu_user_right) VALUES(" . $this->ID . ", " . $user_id . ",'" . $user_right . "');";
      $last_id = $sql_object->DBInsert ($requete, 1);
    }

    return $last_id;
  }

  /**
   * workshop::DeleteUserWorkshop()
   * suppression d'un utilisateur au workshop
   *
   * @access public
   * @param int $user_id identifiant du workshop
   * @param string $work_id login de l'utilisateur
   * @param object $sql_object
   * @return bool $result
   */
  function DeleteUserWorkshop($user_id, $work_id, $sql_object)
  {
    if (is_numeric($work_id) && is_numeric($user_id)) {
      $requete = "DELETE FROM " . J_WORK_USERS . " WHERE jwu_workshop_id=" . $work_id . " AND jwu_user_id=" . $user_id . ";";
      $result = $sql_object->DBQuery($requete);
      return $result;
    } else return false;
  }

  /**
   * workshop::ModifyUserWorkshop()
   * NOT USED
   * modification d'un utilisateur au workshop
   *
   * @access public
   * @param int $work_id identifiant du workshop
   * @param string $user_login login de l'utilisateur
   * @param object $sql_object
   * @return bool $result
   */
  function ModifyUserWorkshop($work_id, $user_login, $sql_object)
  {
    if (is_numeric($work_id)) {
      $user_id = $this->_CheckUserValidity($user_login, $sql_object);
      $requete = "UPDATE " . J_WORK_USERS . " SET jwu_user_id=" . $user_id . " WHERE jwu_user_right='O'  AND jwu_workshop_id=" . $work_id . " ;";
      $result = $sql_object->DBQuery($requete);
      return $result;
    } else return false;
  }

  /**
   * workshop::ModifyOrganizerWorkshop()
   * modification des organisateurs d'un workshop
   *
   * @access public
   * @param int $work_id identifiant du workshop
   * @param string $table_login string des organisateurs séparés par ','
   * @param object $sql_object
   * @return int $last_id
   */
  function ModifyOrganizerWorkshop($work_id, $table_login, $sql_object)
  {
    if (substr($table_login, -1) == ',') {
      $table_login = substr($table_login, 0, -1);
    }
    $table_login = @explode(',', $table_login);
    $requete = "DELETE FROM " . J_WORK_USERS . " WHERE jwu_workshop_id=" . $work_id . " AND jwu_user_right='O';";
    $result = $sql_object->DBQuery($requete);
    for ($i = 0;$i < count($table_login);$i++) {
      $user_id = $this->_CheckUserValidity(trim($table_login[$i]), $sql_object);
      $requete2 = "DELETE FROM " . J_WORK_USERS . " WHERE jwu_workshop_id=" . $work_id . " AND jwu_user_id=" . $user_id . ";";
      $result2 = $sql_object->DBQuery($requete2);
      $requete3 = "INSERT INTO " . J_WORK_USERS . " (jwu_workshop_id, jwu_user_id, jwu_user_right) VALUES(" . $work_id . ", " . $user_id . ",'O');";
      $last_id = $sql_object->DBInsert ($requete3, 1);
    }
    return $last_id;
  }

}

?>