<?php
/**
 * @package linea21.modules
 * @subpackage workshop
 * @see workshop
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Workgroup Forum Management
 */

class workshop_com {
  /* @param
   * */

  var $TDB_COM = T_WORK_COM; // nom de la table.
  var $ID;
  var $SUBJECT;
  var $BODY;
  var $PARENT;
  var $USER_ID;
  var $WORKSHOP_ID;
  var $DATE_CREA;
  var $LAST_MODIFY;
  var $STATUT;
  protected $dispatcher = null;

  public function __construct()
  {
    $this->dispatcher = $GLOBALS['dispatcher'];
  }

  public function __call($method, $arguments)
  {
    $event = $this->dispatcher->notifyUntil(new sfEvent($this, 'workshop_com.extensible_function', array(
      'method'    => $method,
      'arguments' => $arguments
    )));
    if (!$event->isProcessed())
    {
      throw new Exception(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
    }

    return $event->getReturnValue();
  }

  /**
   * workshop_com::CheckDataIntegrity()
   * Vérification intégrité des données
   *
   * @access public
   * @param array $table contient les composants d'une discussion
   * @return boolean true
   * si verifié, sinon string 'message d'erreur'
   */
  function CheckDataIntegrity($table, $sql_object)
  {
    if (strlen($table[0]) < 3) return _t('workshop','com_no_subject');
    if (strlen($table[1]) < 3) return _t('workshop','com_no_body');
    return true;
  }

  /**
   * workshop_com::AddCom()
   * Ajout d'une nouvelle discussion dans le calendrier
   *
   * @access public
   * @param array $table_com : contient les composants d'une discussion
   * @param object $sql_object
   * @return integer $last_id
   */
  function AddCom($table_com, $sql_object)
  {
    $table_com=$sql_object->DBescape($table_com);

    $this->SUBJECT = strip_input(trim($table_com[0]));
    $this->BODY = strip_input(trim($table_com[1], true));
    if ($table_com[2] != '') {
      $this->PARENT_ID = $table_com[2];
    } else $this->PARENT_ID = 0;
    $this->USER_ID = $table_com[3];
    $this->WORKSHOP_ID = $table_com[4];
    $this->STATUT = "P";

    if ($this->PARENT_ID == 0) {
      $requete = "INSERT INTO " . $this->TDB_COM . " (workcom_subject, workcom_body, workcom_parent, workcom_user_id, workcom_workshop_id, workcom_statut, workcom_date_crea, workcom_last_modify ) " . "VALUES('" . $this->SUBJECT . "', '" . $this->BODY . "', " . $this->PARENT_ID . ", " . $this->USER_ID . ", " . $this->WORKSHOP_ID . ", '" . $this->STATUT . "', NOW(), NOW());";
      $last_id = $sql_object->DBInsert ($requete, 1);
    } else {
      $requete_root = "UPDATE  " . $this->TDB_COM . " SET workcom_last_modify=NOW() WHERE workcom_id=" . $this->PARENT_ID . ";";
      $result_root = $sql_object->DBQuery($requete_root);
      $requete = "INSERT INTO " . $this->TDB_COM . " (workcom_subject, workcom_body, workcom_parent, workcom_user_id, workcom_workshop_id, workcom_statut, workcom_date_crea, workcom_last_modify ) " . "VALUES('" . $this->SUBJECT . "', '" . $this->BODY . "', " . $this->PARENT_ID . ", " . $this->USER_ID . ", " . $this->WORKSHOP_ID . ", '" . $this->STATUT . "', NOW(), NOW());";
      $last_id = $sql_object->DBInsert ($requete, 1);
    }
    return $last_id;
  }

  /**
   * workshop_com::DeleteCom()
   * suppression d'un message
   *
   * @access public
   * @param int $com_id identifiant du message
   * @param int $parent_id identifiant du parent
   * @param object $sql_object
   * @return bool $result
   */
  function DeleteCom($ID, $com_id, $parent_id, $sql_object)
  {
    if (is_numeric($ID)) {
      $this->ID = $ID;
    } else return false;

    if ($parent_id == 0) {
      $requete_son = "SELECT workcom_id FROM " . $this->TDB_COM . " WHERE workcom_statut <> 'E' AND workcom_parent=$com_id  AND workcom_workshop_id=$ID";
      echo $requete_son;
      $result_son = $sql_object->DBSelect($requete_son);

      if ($result_son <> 0) {
        $requete = "UPDATE " . $this->TDB_COM . " SET workcom_statut='E' WHERE workcom_id=$com_id;";
        $result = $sql_object->DBQuery ($requete);
        for($i = 0; $i < count($result_son); $i++) {
          $requete_son_e = "UPDATE " . $this->TDB_COM . " SET workcom_statut='E' WHERE workcom_id=" . $result_son[$i]['workcom_id'] . ";";
          $result_son_e = $sql_object->DBQuery ($requete_son_e);
        }
        return $result;
      } else {
        $requete = "UPDATE " . $this->TDB_COM . " SET workcom_statut='E' WHERE workcom_id=$com_id;";
        $result = $sql_object->DBQuery ($requete);
        return $result;
      }
    } else {
      $requete = "UPDATE " . $this->TDB_COM . " SET workcom_statut='E' WHERE workcom_id=$com_id;";
      $result = $sql_object->DBQuery ($requete);
      return $result;
    }
  }

  /**
   * workshop_com::LockCom()
   * vérouillage d'un message
   *
   * @access public
   * @param int $ID identifiant du workshop
   * @param int $com_id identifiant du message
   * @param int $parent_id identifiant du message parent
   * @param int $lock
   * @param object $sql_object
   * @return bool $result
   */
  function LockCom($ID, $com_id, $parent_id, $lock, $sql_object)
  {
    if ($lock == 0) $statut = 'C';
    else $statut = 'P';

    if (is_numeric($ID)) {
      $this->ID = $ID;
    } else return false;

    if ($parent_id == 0) {
      $requete_son = "SELECT workcom_id FROM " . $this->TDB_COM . " WHERE workcom_statut <> 'E' AND workcom_parent=$com_id  AND workcom_workshop_id=$ID";
      $result_son = $sql_object->DBSelect($requete_son);

      if ($result_son <> 0) {
        $requete = "UPDATE " . $this->TDB_COM . " SET workcom_statut='" . $statut . "' WHERE workcom_id=$com_id;";
        $result = $sql_object->DBQuery ($requete);
        for($i = 0; $i < count($result_son); $i++) {
          $requete_son_e = "UPDATE " . $this->TDB_COM . " SET workcom_statut='" . $statut . "' WHERE workcom_id=" . $result_son[$i]['workcom_id'] . ";";
          $result_son_e = $sql_object->DBQuery ($requete_son_e);
        }
        return $result;
      } else {
        $requete = "UPDATE " . $this->TDB_COM . " SET workcom_statut='" . $statut . "' WHERE workcom_id=$com_id;";
        $result = $sql_object->DBQuery ($requete);
        return $result;
      }
    } else {
      $requete = "UPDATE " . $this->TDB_COM . " SET workcom_statut='" . $statut . "' WHERE workcom_id=$com_id;";
      $result = $sql_object->DBQuery ($requete);
      return $result;
    }
  }

  /**
   * workshop_com::ModifyCom()
   * modification d'un message
   *
   * @access public
   * @param int $ID identifiant du message
   * @param array $table_com contient les composants d'un message
   * @param object $sql_object
   * @return bool $result
   */
  function ModifyCom($ID, $table_com, $sql_object)
  {
    $table_com=$sql_object->DBescape($table_com);

    if ($table_com[0] != '') {
      $this->SUBJECT = strip_input(trim($table_com[0]));
    }
    if ($table_com[1] != '') {
      $this->BODY = strip_input(trim($table_com[1], true));
    }

    $requete = "UPDATE  " . $this->TDB_COM . " SET workcom_subject='" . $this->SUBJECT . "', workcom_body='" . $this->BODY . "' , workcom_last_modify=NOW() WHERE workcom_id=" . $ID . ";";
    $result = $sql_object->DBQuery($requete);
    return $result;
  }

  /**
   * workshop_com::ModifyComUser()
   * modification d'un message utilisateur authentifié
   *
   * @access public
   * @param int $ID identifiant du message
   * @param array $table_com contient les composants d'un message
   * @param int $user_id identifiant de l'utilisateur
   * @param object $sql_object
   * @return bool $result
   */
  function ModifyComUser($ID, $table_com, $user_id, $sql_object)
  {
    $table_com=$sql_object->DBescape($table_com);

    if ($table_com[0] != '') {
      $this->SUBJECT = strip_input(trim($table_com[0]));
    }
    if ($table_com[1] != '') {
      $this->BODY = strip_input(trim($table_com[1], true));
    }
    $result_user = $this->_CheckUser($sql_object, $ID);
    if ($result_user <> $user_id) {
      $result = _t('workshop','not_author');
    } else {
      $requete = "UPDATE  " . $this->TDB_COM . " SET workcom_subject='" . $this->SUBJECT . "', workcom_body='" . $this->BODY . "' , workcom_last_modify=NOW() WHERE workcom_id=" . $ID . ";";
      $result = $sql_object->DBQuery($requete);
    }
    return $result;
  }

  /**
   * workshop_com::_CheckUser()
   * obtention de l'id d'un auteur de message
   *
   * @param object $sql_object
   * @param integer $mes_id
   * @return id_utilisateur $result[0]['workcom_user_id']
   */
  function _CheckUser($sql_object, $mes_id = -1)
  {
    if ($mes_id <> -1) {
      $requete = "SELECT  workcom_user_id FROM " . $this->TDB_COM . " WHERE workcom_id=" . $mes_id . ";";
    }
    $result = $sql_object->DBSelect($requete);
    return $result[0]['workcom_user_id'];
  }
}

?>
