<?php
/**
 * @package linea21.modules
 * @subpackage workshoprep
 * @see workshop
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Work group report Management
 */
class workshop_report {
  /* @param
   * */
  var $TDB_WORKREP = T_WORK_REP; // nom de la table.
  var $ID;
  var $TITLE;
  var $RESUME;
  var $WORKSHOP_ID;
  var $PUBLISHED_DATE;
  var $COMMENT;
  var $DATE_CREA;
  var $LAST_MODIFY;
  var $STATUT;
  protected $dispatcher = null;

  public function __construct()
  {
    $this->dispatcher = $GLOBALS['dispatcher'];
  }

  public function __call($method, $arguments)
  {
    $event = $this->dispatcher->notifyUntil(new sfEvent($this, 'workshop_report.extensible_function', array(
      'method'    => $method,
      'arguments' => $arguments
    )));
    if (!$event->isProcessed())
    {
      throw new Exception(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
    }

    return $event->getReturnValue();
  }

  /**
   * workshop_report::CheckDataIntegrity()
   * Vérification intégrité des données
   *
   * @access public
   * @param array $table : contient les composants d'un compte rendu
   * @return boolean true
   * si verifié, sinon string 'message d'erreur'
   */
  function CheckDataIntegrity($table, $sql_object)
  {
    if (strlen($table[0]) < 3) return _t('workshoprep','no_title');
    if (strlen($table[1]) < 3) return _t('workshoprep','no_resume');

    return true;
  }


  /**
   * workshop_report::AddWorkshopReport()
   * Ajout d'un un rapport de groupe de travail
   *
   * @access public
   * @param array $table_workrep contient les composants du rapport
   * @param object $sql_object
   * @return integer $last_id
   */
  function AddWorkshopReport($table_workrep, $sql_object)
  {
    $table_workrep=$sql_object->DBescape($table_workrep);

    $this->TITLE = strip_input(trim($table_workrep[0]));
    $this->RESUME = strip_input(trim($table_workrep[1], true));
    $this->COMMENT = strip_input(trim($table_workrep[2], true));
    $this->STATUT = strtoupper($table_workrep[3]);
    $this->WORKSHOP_ID = $table_workrep[4];
    $this->PUBLISHED_DATE = "NOW()";

    if ($this->STATUT == 'P') {
      $this->PUBLISHED_DATE = "NOW()";
    } else {
      $this->PUBLISHED_DATE = "'0001-01-01'";
    }

    $requete = "INSERT INTO " . $this->TDB_WORKREP . " (workrep_title, workrep_resume, workrep_workshop_id, workrep_published_date, workrep_comment, workrep_statut, workrep_date_crea) VALUES('" . $this->TITLE . "', '" . $this->RESUME . "', " . $this->WORKSHOP_ID . ", " . $this->PUBLISHED_DATE . ", '" . $this->COMMENT . "', '" . $this->STATUT . "', NOW());";
    $last_id = $sql_object->DBInsert ($requete, 1);
    return $last_id;
  }


  /**
   * workshop_report::ModifyWorkshopReport()
   * modification d'un rapport de groupe de travail
   *
   * @access public
   * @param int $ID identifiant du rapport de workshop
   * @param array $table_workrep contient les composants du rapport
   * @param object $sql_object
   * @return bool $result
   */
  function ModifyWorkshopReport($ID, $table_workrep, $sql_object)
  {
    $table_workrep=$sql_object->DBescape($table_workrep);

    $this->ID = $ID;
    $this->TITLE = strip_input(trim($table_workrep[0]));
    $this->RESUME = strip_input(trim($table_workrep[1], true));
    $this->COMMENT = strip_input(trim($table_workrep[2], true));
    $this->STATUT = $table_workrep[3];

    $mask = $this->_HavePublishedDate($table_workrep[4]);

    $requete = "UPDATE  " . $this->TDB_WORKREP . " SET workrep_title='" . $this->TITLE . "', workrep_resume='" . $this->RESUME . "', workrep_comment='" . $this->COMMENT . "', workrep_statut='" . $this->STATUT . "', workrep_last_modify=NOW() " . $mask . " WHERE workrep_id='" . $this->ID . "';";
    $result = $sql_object->DBQuery($requete);
    return $result;
  }


  /**
   * workshop_report::_HavePublishedDate()
   * Détermine la date de publication a inserer dans la bdd
   *
   * @access private
   * @param string $current_status : statut actuel de la publication
   * @return string $sql_mask
   */
  function _HavePublishedDate($current_status)
  {
    switch ($this->STATUT) {
      case 'P':
        if ($current_status == 'D') $sql_mask = ", workrep_published_date= NOW()";
        else $sql_mask = '';
        break;
      case 'D':
        $sql_mask = ", workrep_published_date= '0001-01-01'";
        break;
      default:
        $sql_mask = '';
    }
    return $sql_mask;
  }


  /**
   * workshop_report::DeleteWorkshopReport()
   * suppression d'un rapport de groupe de travail
   *
   * @access public
   * @param int $ID id du rapport de groupe de travail
   * @param object $sql_object
   * @return bool $result
   */
  function DeleteWorkshopReport($ID, $sql_object)
  {
    $this->ID = $ID;
    $requete = "UPDATE  " . $this->TDB_WORKREP . " set workrep_statut='E', workrep_last_modify=NOW() WHERE workrep_id='" . $this->ID . "';";
    $result = $sql_object->DBQuery($requete);

    return $result;
  }

}

?>
