<?php
/**
 * @package linea21.core
 * @subpackage system
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Generate code-image
 */

class codimage {
  /* @parameters
   * */
  var $CURRENT_IMG;
  var $IMG_SRC="../templates/admin/default/images/security_fili.png";
  var $FONT_SIZE=16; // taille de la police
  var $FONT="../class/system/artichow/font/Vera.ttf"; // repertoire Police
  var $ANGLE=0;
  var $PADDING_X=10;
  var $PADDING_Y=10;
  var $TEXT_LENGTH=5;
  var $TEXT=5;
  var $BACKGROUND_COLOR;
  var $FONT_COLOR;

  function codimage() {
    $this->GetRandomText();
    $size = imagettfbbox($this->FONT_SIZE,$this->ANGLE,$this->FONT,$this->TEXT);
    $dx = abs($size[2]-$size[0]);
    $dy = abs($size[5]-$size[3]);
    $this->CURRENT_IMG = imagecreate($dx+$this->PADDING_X,$dy+$this->PADDING_Y);
    $picsrc = imagecreatefrompng($this->IMG_SRC);
    Imagecopymerge ( $this->CURRENT_IMG  ,  $picsrc , 0  , 0  , 0  , 0  , imagesx($this->CURRENT_IMG)  , imagesy($this->CURRENT_IMG),100);
    $this->GetFontColor();
    ImageTTFText($this->CURRENT_IMG, $this->FONT_SIZE, $this->ANGLE, (int)($this->PADDING_X/2)+1, $dy+(int)($this->PADDING_Y/2), $this->FONT_COLOR, $this->FONT, $this->TEXT);
  }

  function Output() {
    Header("Content-type: image/png");
    ImagePng($this->CURRENT_IMG);
    ImageDestroy($this->CURRENT_IMG);
  }

  function GetBackgroundColor() {
    if(empty($this->BACKGROUND_COLOR))	$this->SetBackgroundColor();
    return true;
  }

  function SetBackgroundColor($r=200, $v=200, $b=200) {
    $this->BACKGROUND_COLOR= ImageColorAllocate($this->CURRENT_IMG, $r, $v, $b);
    return true;
  }

  function GetRandomText()
  {
    $str = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    $text = '';
    for ($i = 0; $i < $this->TEXT_LENGTH; $i++) {
      $text .= substr($str, rand(0, strlen($str) - 1), 1);
    }
    $this->TEXT=$text;
  }

  function SetFontSize($size)
  {
    $this->FONT_SIZE=$size;
    return true;
  }

  function SetPaddingX($pad)
  {
    $this->PADDING_X=$pad;
    return true;
  }

  function SetPaddingY($pad)
  {
    $this->PADDING_Y=$pad;
    return true;
  }

  function GetFontColor() {
    if(empty($this->FONT_COLOR))	$this->SetFontColor();
    return true;
  }

  function SetFontColor($r=0, $v=0, $b=0)
  {
    $this->FONT_COLOR= ImageColorAllocate($this->CURRENT_IMG, $r,$v, $b);
    return true;
  }

}

?>