<?php
/**
 * @package linea21.core
 * @subpackage config_files
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//BE CAREFULL THIS FILE IS A SYSTEM FILE : use define_release.ini and define_db.ini for settings

/////////////////////////////////////
//	GLOBALS
/////////////////////////////////////

// Defining CURRENT_APP
if(strpos($_SERVER["SCRIPT_FILENAME"], 'admin') !== false) define('CURRENT_APP', 'admin');
else define('CURRENT_APP', 'public');

// Defining APPS
// $GLOBALS['APPS'] = array('admin', 'public');


define('END_LINE',		"\n");
define('TAB_LINE',		"\t");

$GLOBALS['authorized_theme_sections'] = array ('THEME_SETTINGS');
$GLOBALS['authorized_db_sections'] = array ('DATABASE');
$GLOBALS['authorized_release_sections'] = array ('LANGUAGE_SETTINGS','NOTIFICATION_SETTINGS','LOCALES_SETTINGS','MODULES_SETTINGS','DEBUG_SETTINGS', 'SYSTEM_SETTINGS', 'SERVER_SETTINGS','MAIL_SETTINGS','MAIL_INFORMATIONS', 'SUPPORT_SETTINGS','LOGS_SETTINGS');

$GLOBALS['current_title'] = array(); // HTML <title> tag

$GLOBALS['links'] = array(); // Localized variables
$GLOBALS['filters'] = array(); // Localized (filters) variables

$GLOBALS['menuitems'] = array (
                        'home',
    					'news',
                        'project',
						'dashboard',
    					'workgroup',
						'workgroup-subscription',
						'publication',
    					'directory',
						'contact'
                       );



// INI file to PHP Constants
include_once ("../class/class.config_file.php");
if(!isset($CONFIG))
{
  $CONFIG = new config_file;
  $CONFIG->initializeIniParams();
}
define('CURRENT_APP_URL', SITE_ROOT_URL. CURRENT_APP. '/');
define('THEME_ADMIN_PATH',		"../".THEME_DIRECTORY."/admin/".THEME_ADMIN."/");
define('THEME_PUBLIC_PATH',		"../".THEME_DIRECTORY."/public/".THEME_PUBLIC."/");


// Debuger Init
if(defined('MOD_DEBUG') && MOD_DEBUG == true) {
  require_once('../class/system/PHP_Debug/dbg.conf.php');
  require_once('../class/system/PHP_Debug/PHP/Debug.php');
  $Dbg = new PHP_Debug($options);
  $renderer = 'HTML_Div';
  $Dbg->addSetting($renderer, 'app_renderer_mode');
  $Dbg->addSettings($options, 'app_settings');

  $Dbg->add('Admin theme : <b>'.THEME_ADMIN.'</b> | Public theme : <b>'.THEME_PUBLIC .'</b>');
  $debug_line = $Dbg->add('Pre-execute and includes');
}

// Bootstrap (common includes)
include_once("../config/server.php");
include_once("../lib/items.php");
include_once("../lib/lib_common.php");


// Culture Init
include_once('../lib/lang.php');
include_once('../class/class.culture.php');
culture::getInstance();
define('U_L', culture::getInstance()->getVar('current'));

// Include ONLY the desired language PRODUCTION mode
include(themePath('../languages/' .U_L. '/define.php'));
$GLOBALS['links'] = array_merge($GLOBALS['links'], $l10n_links);
$GLOBALS['filters'] = array_merge($GLOBALS['filters'], $l10n_filters);

// Plugins Init - Dispatcher + installed plugins
include_once("../lib/vendor/sfEventDispatcher/sfEventDispatcher.php");
$dispatcher = new sfEventDispatcher();

include_once('../class/class.plugin.php');
foreach(availablePlugins() as $plugin) {
  $plug = new plugin($plugin);
  if($plug->is_active()) $plug->loadPlugin();
}


/**
 * These globals have to be declared after $GLOBALS['links'] array.
 */
$GLOBALS['datePicker_includes'] = array('project|add', 'project|mod',
  			 'dashboard|add', 'dashboard|mod',
  			 'workshop|add_cal', 'workshop|mod_cal',
  			 'prefs-utilisateur|');

$GLOBALS['multiSelect_includes'] = array('project|add', 'project|mod');

$GLOBALS['textboxList_includes'] = array('workshop|add', 'workshop|mod',
             'workshop|add_u');

$GLOBALS['fancyUpload_includes'] = array('files');

// finally, we include user configuration file if exists
if(CURRENT_APP == 'admin') {
  $user_conf = THEME_ADMIN_PATH.'/override/config/define.php';
} else {
  $user_conf = THEME_PUBLIC_PATH.'/override/config/define.php';
}
if(file_exists($user_conf)) include_once($user_conf);
?>