var tl;
$(document).ready(function (){

	    var eventSource = new Timeline.DefaultEventSource(0);
            var theme = Timeline.ClassicTheme.create();  
	    theme.event.label.width = 450; // px
	    theme.event.bubble.width = 320;
	    theme.event.bubble.height = 160;
	    theme.event.track.height = 0;
	    theme.event.track.gap = 0;
 
            var bandInfos = [
	        Timeline.createBandInfo({
                    width:          "70%",
		    intervalUnit:   Timeline.DateTime.MONTH, 
                    intervalPixels: 100,
		    eventSource:    eventSource,
                    date:           Date(),
                    theme:          theme
                }),
		Timeline.createBandInfo({
		    showEventText:  false,
                    width:          "30%", 
		    intervalUnit:   Timeline.DateTime.YEAR, 
		    intervalPixels: 200,
		    eventSource:  eventSource,
                    date:           Date(),
		    layout: 		'overview'
                })
            ];
            bandInfos[1].syncWith = 0;
	    bandInfos[1].highlight = true;

            
            tl = Timeline.create(document.getElementById("my-timeline"), bandInfos, Timeline.HORIZONTAL);
            tl.loadXML("../project/timeline-xml.php?i=a", function(xml, url) {
                eventSource.loadXML(xml, url);
            });

});