<?php
/**
 * @package linea21.utils
 * @subpackage lib
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

/**
 * IncludeLang()
 * Fait les includes de fichiers de langue en fonction de la rubrique active ( partie publique )
 *
 * @return void (include)
 */
function IncludeLang()
{
  $language = U_L;
  include_once('../languages/' . $language . '/lang_common.' . CHARSET . '.php');

  if (ActiveItemAlias($GLOBALS['activeitem']) == 'directory') {
    include_once('../languages/' . $language . '/lang_yellowpages.' . CHARSET . '.php');
  }
  if (ActiveItemAlias($GLOBALS['activeitem']) == 'dashboard') {
    include_once('../languages/' . $language . '/lang_sdi.' . CHARSET . '.php');
    include_once('../languages/' . $language . '/lang_dashboard.' . CHARSET . '.php');
  }
  if (ActiveItemAlias($GLOBALS['activeitem']) == 'workgroup') {
    include_once('../languages/' . $language . '/lang_workshop.' . CHARSET . '.php');
    include_once('../languages/' . $language . '/lang_workshoprep.' . CHARSET . '.php');
    include_once('../languages/' . $language . '/lang_publication.' . CHARSET . '.php');
    include_once('../languages/' . $language . '/lang_system.' . CHARSET . '.php');
  }
  if (ActiveItemAlias($GLOBALS['activeitem']) == 'project') {
    include_once('../languages/' . $language . '/lang_project.' . CHARSET . '.php');
  }
  if (ActiveItemAlias($GLOBALS['activeitem']) == 'publication') {
    include_once('../languages/' . $language . '/lang_publication.' . CHARSET . '.php');
  }
  if (ActiveItemAlias($GLOBALS['activeitem']) == 'user-prefs') {
    include_once('../languages/' . $language . '/lang_user.' . CHARSET . '.php');
  }
  if (ActiveItemAlias($GLOBALS['activeitem']) == 'news') {
    include_once('../languages/' . $language . '/lang_news.' . CHARSET . '.php');
  }
  if (ActiveItemAlias($GLOBALS['activeitem']) == 'subscribe-newsletter') {
    include_once('../languages/' . $language . '/lang_newsletter.' . CHARSET . '.php');
  }
  if (ActiveItemAlias($GLOBALS['activeitem']) == 'search') {
    include_once('../languages/' . $language . '/lang_search.' . CHARSET . '.php');
  }
  if (ActiveItemAlias($GLOBALS['activeitem']) == 'workgroup-subscription') {
    include_once('../languages/' . $language . '/lang_workshop.' . CHARSET . '.php');
    include_once('../languages/' . $language . '/lang_user.' . CHARSET . '.php');
  }

  $GLOBALS['lang'] = $lang;
  IncludeUserfiles();
}

/**
 * IncludeAdminLang()
 * Fait les includes de fichiers de langue en fonction de la rubrique active ( partie admin )
 *
 * @return void (include)
 */
function IncludeAdminLang($rubrique)
{
  $language = U_L;
  include_once('../languages/' . $language . '/lang_common.' . CHARSET . '.php');
  include_once('../languages/' . $language . '/lang_' . $rubrique . '.' . CHARSET . '.php');

  if ($rubrique === 'dashboard') {
    include_once('../languages/' . $language . '/lang_sdi.' . CHARSET . '.php');
  }
  if ($rubrique === 'sdi') {
    include_once('../languages/' . $language . '/lang_dashboard.' . CHARSET . '.php');
  }

  $GLOBALS['lang'] = $lang;
  IncludeUserfiles();

}

/**
 * _t()
 * Translate item
 * @param string $scope
 * @param string $item
 * @return string
 **/
function _t($scope, $item)
{
  if(isset($GLOBALS['lang'][$scope][$item])) {
    return $GLOBALS['lang'][$scope][$item];
  }
  else {
    if(MOD_DEBUG == 1) {
      return '<span class="debug_alert">_t(\''.$scope."', '".$item.'\') does not exist</span>';
    } else {
      return $scope." ".$item;
    }
  }
}

/**
 * _def()
 * Define a user language variable
 * override previous value if already defined
 * @param string $scope
 * @param string $item
 * @param string $str
 * @return string
 **/
function _def($scope, $item, $str)
{
  if(isset($GLOBALS['lang'][$scope][$item])) unset($GLOBALS['lang'][$scope][$item]);

  $GLOBALS['lang'][$scope][$item] = $str;
}

/**
 * IncludeUserfiles()
 * Include user files prefixed by '_' from languages folders
 *
 * @return void (include)
 */
function IncludeUserfiles() {
  $language = U_L;
  $paths = glob('../languages/' . $language . '/_*.php');
  if(CURRENT_APP == 'admin') {
    $pattern = THEME_ADMIN_PATH.'override/languages/' . $language . '/_*.php';
  } else {
    $pattern = THEME_PUBLIC_PATH.'override/languages/' . $language . '/_*.php';
  }
  $paths = array_merge($paths, glob($pattern));
  if($paths != false) {
    foreach ($paths as $filename) {
      _debug('Including user defined language files : '. $filename);
      include_once($filename);
    }
  }
}

/**
 * IncludeLanguagesPluginfiles()
 * Include plugin files from specific plugin languages folders
 * @param object $plugin
 * @return void (include)
 */
function IncludeLanguagesPluginfiles($plugin) {

  // we try to include the current culture
  $paths = glob('../plugins/'.$plugin->getVar('name').'/languages/' . U_L . '/*.php');
  // if current culture not found, we include default language files
  if(count($paths)==0) $paths = glob('../plugins/'.$plugin->getVar('name').'/languages/' . $plugin->getVar('default_language') . '/*.php');

  if($paths != false) {
    foreach ($paths as $filename) {
      _debug('Including <em>'.$plugin.'</em> plugin language files : '. $filename);
      include_once($filename);
    }
  }
  return true;
}
?>