<?php
/**
 * @package linea21.utils
 * @subpackage lib
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */


/**
 * implode_with_keys()
 * implode avec clefs associées renvoyées
 * sous forme de chaîne de caractères
 * @param string $glue
 * @param string $array
 * @return string
 */
function implode_with_keys($glue, $array) {
  $output = array();
  foreach( $array as $key => $item )
  $output[] = $key . "=" . $item;

  return implode($glue, $output);
}

/**
 * getHttpParameters()
 * Renvoie les paramètres HTTP
 * sous forme de chaîne de caractères
 * @return string
 */
function getHttpParameters($prefix = '?') {

  return $prefix. (string) implode_with_keys('&', $_REQUEST);
}

/**
 * strip_input()
 * Remove PHP and HTML code
 * @param string $str
 * @param string $exceptions
 * @return string
 */
function strip_input($str, $exceptions = false) {

  if(defined('RICH_TEXT_EDITOR') && RICH_TEXT_EDITOR != (string) 0) {
    return $str;
  }
  else {
    if($exceptions)  {
      return strip_tags($str, ALLOWABLE_TAGS);
    }
    else {
      return strip_tags($str);
    }
  }

}

/**
 * IncludeTimeline()
 * Include SIMILE Timeline JS code
 * if needed
 * @return void
 */
function IncludeTimeline() {
  if(defined('TIMELINE_DISPLAY') && TIMELINE_DISPLAY == 1) {
    if(isset($_REQUEST['rub']) && $_REQUEST['rub']=="project" && (!isset($_REQUEST['todo']) || $_REQUEST['todo'] == 'list')) {
      echo '<script src="' .SITE_ROOT_URL. 'lib/js/timeline/timeline_ajax/simile-ajax-api.js" type="text/javascript"></script>'.END_LINE;
      echo '<script type="text/javascript">
             Timeline_urlPrefix=\'' .SITE_ROOT_URL. 'lib/js/timeline/timeline_js/\';
             Timeline_parameters=\'bundle=true\';
             $(function() {
             $("#content").prepend(\'<div id="my-timeline" style="height: 250px; border-bottom: 1px solid #aaa"></div>\');
             });
             
          </script>';
      echo '<script src="' .SITE_ROOT_URL. 'lib/js/timeline/timeline_js/timeline-api.js" type="text/javascript"></script>'.END_LINE;
      echo '<script type="text/javascript" src="../lib/js/timeline.js"></script>'. END_LINE;
    }
  }
}

/**
 * IncludeTextResizerJs()
 * Include jQuery text-resizer plugin
 * if no js wysiwyg are enabled
 * @return void
 */
function IncludeTextResizerJs() {

  if(!defined('RICH_TEXT_EDITOR') || RICH_TEXT_EDITOR == (string) 0 )
  {
    echo '<script type="text/javascript" src="../lib/js/jquery.textarearesizer.compressed.js"></script>';
    echo '<script type="text/javascript">
	  		$(document).ready(function() {
    			$(\'textarea.largetextfield:not(.processed)\').TextAreaResizer();
    		})
	  		</script>'.END_LINE;
  }
}

/**
 * IncludePHPDebug()
 * Include Js & css for PHP_DEBUG
 * @return void
 */
function IncludePHPDebug() {
  if(defined('MOD_DEBUG') && MOD_DEBUG == true) {
    echo '<script type="text/javascript" src="../lib/vendor/PHP_Debug/js/html_div.js"></script>'.END_LINE;
    echo '<link type="text/css" rel="stylesheet" href="../lib/vendor/PHP_Debug/css/html_div.css" />'.END_LINE;
  }
}
/**
 * IncludeTooltipJs()
 * Include jQuery tooltip plugin
 * @param string $selector
 * @return void
 */
function IncludeTooltipJs($selector) {
  $str='';
  if(is_string($selector)) {
    $str .= '$("'.$selector.'").tooltip({ effect: "slide", opacity: 0.8});';
  } else {
    foreach($selector as $sel) {
      $str .= '$("'.$sel.'").tooltip({ effect: "slide", opacity: 0.8});';
    }
  }
  echo '<script type="text/javascript" src="../lib/js/jquery.tools.min.js"></script>'.END_LINE;
  echo '<script type="text/javascript">
  		$(document).ready(function() {
	  			'.$str.'
	  		})
	  		</script>'.END_LINE;
}

/**
 * extRegex()
 * Transform a list given in the form "jpg,png,gif"
 * into "(jpg)|(png)|(gif)" format
 * @return string
 */
function extRegex($list) {
  $a = explode(',', $list);
  $b = array();
  foreach($a as $el) {
    array_push($b, '('.$el.')');
  }
  return implode('|', $b);
}

/**
 * IncludeFancyUploadJs()
 * Include jQuery Fancy Upload
 * @return void
 */
function IncludeFancyUploadJs() {
  $rub = isset($_REQUEST['rub']) ? $_REQUEST['rub'] : '';
  if(ActiveItemKey($rub)) $rub = ActiveItemKey($rub);

  $a = $GLOBALS['fancyUpload_includes'];

  // security check here because uploadify is not able to handle cookie
  if(in_array($rub, $a) && CookieWorkshopid($_REQUEST['id'])) {

    $fileDesc = str_replace(',', ', ', MEDIA_ALLOWED_EXT);
    echo '<script type="text/javascript">
          	var rooturl = "' . SITE_ROOT_URL. '";
          	var upbutton = "' . _t('divers', 'up').'";
          	var delbutton = "'. _t('divers', 'delqueue').'";
          	var addfiles = "' . _t('upload', 'addfiles').'";
          	var succeed = "' . _t('upload', 'confirmed').'";
          	var error = "' . _t('upload', 'error').'";
          	var notallowed_msg = "'.sprintf(_t('upload', 'wrong_ext'), $fileDesc).'";
          	var size_msg = "'.sprintf(_t('upload','upload_size'), formatBytes(MEDIA_ALLOWED_SIZE)).'";
          	var maxsize = "' . MEDIA_ALLOWED_SIZE.'";
          	var regexpattern = "' . extRegex(MEDIA_ALLOWED_EXT).'";
          	var fileReplace = "' . _t('divers', 'replace_file').'";
          	var cbText = "'._t('workshop', 'share_files').'";
          </script>
 	      <link type="text/css" rel="stylesheet" href="http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.10/themes/base/jquery-ui.css" id="theme" />
 	      <link type="text/css" rel="stylesheet" href="../lib/vendor/jQuery-File-Upload/jquery.fileupload-ui-l21.css" media="screen" />
 	      <script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.10/jquery-ui.min.js"></script>
    	  <script type="text/javascript" src="../lib/vendor/jQuery-File-Upload/jquery.fileupload.js"></script>
          <script type="text/javascript" src="../lib/vendor/jQuery-File-Upload/jquery.fileupload-ui.js"></script>
          <script type="text/javascript" src="../lib/vendor/jQuery-File-Upload/public-settings.js"></script>'.END_LINE;
  }
}

/**
 * IncludeTextCornerJs()
 * Include jQuery text-corner plugin
 * @return void
 */
function IncludeTextCornerJs() {
  echo '<script type="text/javascript" src="../lib/js/jquery.corner.js"></script>'.END_LINE;
  echo '<script type="text/javascript" src="../lib/js/jquery.corner.config.js"></script>'.END_LINE;
}

/**
 * IncludeTreeJs()
 * Include jQuery tree plugin
 * @return void
 */
function IncludeTreeJs() {
  $str = '<ul id="cMenu" class="contextMenu"><li class="edit"><a href="#edit">'. _t('divers','modify').'<\/a><\/li><li class="delete separator"><a href="#delete">'. _t('divers','delete').'<\/a><\/li><\/ul>';
  echo '<script type="text/javascript" src="../lib/js/jquery.contextMenu/jquery.contextMenu.js"></script>'.END_LINE;
  echo '<link type="text/css" rel="stylesheet" href="../lib/js/jquery.contextMenu/jquery.contextMenu-l21.css" media="screen" />'.END_LINE;
  echo '<script type="text/javascript" src="../lib/js/jquery.treeview/jquery.treeview.js"></script>'.END_LINE;
  echo '<link type="text/css" rel="stylesheet" href="../lib/js/jquery.treeview/jquery.treeview.css" media="screen" />'.END_LINE;
  echo '<script type="text/javascript">
  		$(document).ready(function(){
  			$("#tree").after(\''.$str.'\');
			$("#tree").treeview({
				animated: "fast",
        		collapsed: false,
        		unique: false
        	});
        	
        	$("#tree ul li").contextMenu({
					menu: "cMenu"
				}, function(action, el, pos) {
					if(action=="edit") {
						if(typeof $(el).children("a.ico_mod").attr("href") == "undefined") {
    						return 0;
    					} else {
							document.location.href = $(el).children("a.ico_mod").attr("href");
						}
					}
					if(action=="delete") {
    					if(typeof $(el).children("a.ico_sup").attr("href") == "undefined") {
    						//$("cMenu").disableContextMenuItems("delete");
    						//$("ul.contextMenu li.delete").attr("disabled", true);
    						return 0;
    					} else {
							document.location.href = $(el).children("a.ico_sup").attr("href");
						}
					}

				});
			$("#tree li a.ico_mod, #tree li a.ico_sup").css("display", "none");
				
        });
	  	</script>'.END_LINE;
}

/**
 * IncludeRichTextEditor()
 * Include RichTextEditor if enabled
 * @return void
 */
function IncludeRichTextEditor() {

  if(defined('RICH_TEXT_EDITOR') && RICH_TEXT_EDITOR != (string) 0 )  {
    if(strtolower(RICH_TEXT_EDITOR) == 'tinymce')
    {
      echo '<script type="text/javascript" src="'.themePath('../lib/js/tinymce/jscripts/tiny_mce/tiny_mce.js', THEME_ADMIN_PATH).'"></script>'.END_LINE;
      echo '<script type="text/javascript" src="'.themePath('../lib/js/tinymce/jscripts/tiny_mce/config.js', THEME_ADMIN_PATH).'"></script>'.END_LINE;
    }
    if(strtolower(RICH_TEXT_EDITOR) == 'cke')
    {
      include('../lib/js/ckeditor/ckeditor.php');
      $CKEditor = new CKEditor();
      $CKEditor->basePath = SITE_ROOT_URL.'lib/js/ckeditor/';
      $CKEditor->config['customConfig'] = 'l21_config.js';


      if(defined('CKFINDER_ENABLED') && CKFINDER_ENABLED == true) {
        require_once '../lib/vendor/ckfinder/ckfinder.php';
        CKFinder::SetupCKEditor( $CKEditor, '../lib/vendor/ckfinder/' ) ;
      } else {
        $CKEditor->config['filebrowserBrowseUrl'] = '../library/access.php';
        $CKEditor->config['filebrowserImageBrowseUrl'] = '../library/access.php?type=images';
        $CKEditor->config['filebrowserUploadUrl'] = '../library/access.php';
        $CKEditor->config['filebrowserImageUploadUrl'] = '../library/access.php?type=images';
        $CKEditor->config['filebrowserWindowWidth'] = '100%';
        $CKEditor->config['filebrowserWindowHeight'] = '100%';
      }

      $CKEditor->replaceAll('largetextfield');
    }
  }

}


/**
 * IncludeLightboxJs()
 * Include Lightbox jQuery plugin
 * @param string £selector
 * @return void
 */
function IncludeLightboxJs($selector) {
  $str='';
  if(is_string($selector)) {
    $str .= '$("'.$selector.'").lightBox();'.END_LINE;
  } else {
    foreach($selector as $sel) {
      $str .= '$("'.$sel.'").lightBox();'.END_LINE;
    }
  }
  echo '<script type="text/javascript" src="../lib/js/jquery.lightbox-0.5.pack.js"></script>'.END_LINE;
  echo '<link type="text/css" rel="stylesheet" href="'.THEME_ADMIN_PATH.'css/jquery.lightbox-0.5.css" />'.END_LINE;
  echo '
        <script type="text/javascript">
        $(document).ready(function() {
	  			'.$str.'
	  	})
    	</script>'. END_LINE;

}

/**
 * IncludeTextBoxListJs()
 * Include jQuery TextBoxList plugin
 * if needed
 * @return void
 */
function IncludeTextBoxListJs() {

  $rub = isset($_REQUEST['rub']) ? $_REQUEST['rub'] : '';
  $todo = isset($_REQUEST['todo']) ? $_REQUEST['todo'] : '';

  if(ActiveItemKey($rub)) $rub = ActiveItemKey($rub);
  $s = $rub . '|' . $todo;
  $a = $GLOBALS['textboxList_includes'];

  if(in_array($s, $a)) {
    echo '<link type="text/css" rel="stylesheet" href="'.THEME_ADMIN_PATH.'css/TextboxList.css" media="screen" />'.END_LINE;
    echo '<link type="text/css" rel="stylesheet" href="'.THEME_ADMIN_PATH.'css/TextboxList.Autocomplete.css" media="screen" />'.END_LINE;
    echo '<script type="text/javascript" src="../lib/js/jquery.textboxList/GrowingInput.js"></script>'.END_LINE;
    echo '<script type="text/javascript" src="../lib/js/jquery.textboxList/TextboxList.js"></script>'.END_LINE;
    echo '<script type="text/javascript" src="../lib/js/jquery.textboxList/TextboxList.Autocomplete.js"></script>'.END_LINE;
  }
}

/**
 * IncludeMultiSelectJs()
 * Include jQuery multiSelect plugin
 * if needed
 * @return void
 */
function IncludeMultiSelectJs() {

  $rub = isset($_REQUEST['rub']) ? $_REQUEST['rub'] : '';
  $todo = isset($_REQUEST['todo']) ? $_REQUEST['todo'] : '';

  if(ActiveItemKey($rub)) $rub = ActiveItemKey($rub);
  $s = $rub . '|' . $todo;
  $a = $GLOBALS['multiSelect_includes'];

  if(in_array($s, $a)) {
    echo '<script type="text/javascript" src="../lib/js/jquery.multiSelect/jquery.multiSelect.js"></script>'.END_LINE;
    echo '<script type="text/javascript" src="../lib/js/jquery.multiSelect/jquery.bgiframe.min.js"></script>'.END_LINE;
    echo '<link type="text/css" rel="stylesheet" href="'.THEME_ADMIN_PATH.'css/jquery.multiSelect.css" />'.END_LINE;
  }
}

/**
 * IncludedatePickerJs()
 * Include jQuery date Picker
 * if needed
 * @return void
 */
function IncludedatePickerJs() {

  $rub = isset($_REQUEST['rub']) ? $_REQUEST['rub'] : '';
  $todo = isset($_REQUEST['todo']) ? $_REQUEST['todo'] : '';

  if(ActiveItemKey($rub)) $rub = ActiveItemKey($rub);
  $s = $rub . '|' . $todo;
  $a = $GLOBALS['datePicker_includes'];

  if(in_array($s, $a)) {
    echo '<script type="text/javascript" src="../lib/js/jquery.datePicker.js"></script>'.END_LINE;
    echo '<link type="text/css" rel="stylesheet" href="'.THEME_ADMIN_PATH.'css/datePicker.css" />'.END_LINE;
    echo '<script type="text/javascript" src="../lib/js/date.js"></script>'.END_LINE;
    if(U_L != 'en') {
      echo '<script type="text/javascript" src="'.themePath('../lib/js/date_'. strtolower(U_L).'.js', THEME_ADMIN_PATH).'"></script>'. END_LINE;
    }
  }
}

/**
 * SureCreateDir()
 * Créer un dossier s'il n'existe pas.
 * @param string $pathname
 * @param integer $perms
 * @return integer $ver_num
 */
function SureCreateDir($pathname, $perms) {
  if(!file_exists($pathname)) {
    return mkdir ($pathname, $perms, true);
  } else {
    return true;
  }
}


/**
 * SureRemoveDir()
 * Supprime le contenu d'un dossier et le dossier lui-même si précisé.
 *
 * @return integer $ver_num
 */
function SureRemoveDir($dir, $DeleteMe) {
  if(!$dh = @opendir($dir)) return;
  while (($obj = readdir($dh))) {
    if($obj=='.' || $obj=='..') continue;
    if (!@unlink($dir.'/'.$obj)) SureRemoveDir($dir.'/'.$obj, true);
  }
  if ($DeleteMe){
    closedir($dh);
    @rmdir($dir);
  }
}

/**
 * num_phpversion()
 * Retourne un entier comme numéro de version PHP
 *
 * @return integer $ver_num
 */
function num_phpversion() {
  $ver = explode( '.', phpversion() );
  $ver_num = $ver[0] . $ver[1] . $ver[2];

  return $ver_num;
}

/**
 * cutText()
 * Découpe un texte à une longeur donnée.
 *
 * @param string $content
 * @param integer $length
 * @param integer $abbr
 * @param string $end
 * @return
 */
function cutText($content, $length, $abbr = 0, $end = '...')
{
  // fix bug #16
  if(function_exists('mb_substr')) $substr = mb_substr($content, 0, $length, CHARSET);
  else  $substr = substr($content, 0, $length);
  if (strlen($content) > $length) {
    if ($abbr == 1) $content_light = "<abbr title=\"" . $content . "\">" . $substr . $end . "</abbr>\n";
    else $content_light = $substr . $end;
  } else $content_light = $content;
  return $content_light;
}

/**
 * cutBody()
 * Renvoie un texte en 2 parties dans un tableau
 *
 * @param string $text
 * @return array $body
 */
function cutBody($text)
{
  $middle = (strlen($text) / 2);
  $end = strlen($text);
  $body[0] = substr($text, 0, $middle);
  $body[1] = substr($text, $middle, $end);
  $chaine = preg_split("/(\.(<br \/>| ))/", $body[1], 2);

  $body[0] .= $chaine[0] . ".";
  $body[1] = @trim($chaine[1]);

  return $body;
}

/**
 * EnlargeImage()
 * Miniatures; agrandissement onclick
 *
 * @param string $uri
 * @param string $style
 * @param string $alt_desc
 * @return string $img_link
 */
function EnlargeImage($uri, $style = '', $alt_desc = '')
{
  list($width, $height, $type, $attr) = getimagesize($uri);

  $img_link = '<a href="' . $uri . '" title="' . _t('divers','enlarge_photo') . '">' . END_LINE;
  $img_link .= '<img src="' . get_min_name($uri) . '" alt="' . _t('divers','enlarge_photo') . ' ' . $alt_desc . '"' . $style . ' />' . END_LINE;
  $img_link .= '</a>' . END_LINE;

  return $img_link;
}

/**
 * formatNavTitle()
 * Formatage des titres ( interface admin )
 *
 * @param string $content
 * @return string $content
 */
function formatNavTitle($content)
{
  $content = formatText($content, '2HTML');
  $content = cutText($content, 70, 1);

  return $content;
}

/**
 * formatTextli()
 * Formatage des listes ( interface admin )
 *
 * @param string $content
 * @return string $content
 */
function formatTextli($content)
{
  $content = formatText($content, '2HTML');
  $content = cutText($content, 65, 1);
  return $content;
}

/**
 * formatTitleh2()
 * Formatage des titres h2 ( interface admin )
 *
 * @param string $content
 * @return string $content
 */
function formatTitleh2($content)
{
  $content = formatText($content, '2HTML');
  return $content;
}

/**
 * isRawText()
 * check if raw text or html text
 *
 * @param string $t
 * @return bool
 */
function isRawText($t) {
  if(preg_match('/<[a-z0-9]>/i', $t) == 0) {
    return true;
  } else {
    return false;
  }
}

/**
 * formatText()
 * Formatage de texte pour affichage
 *
 * @param  $content
 * @param string $format
 * @return string $content
 */
function formatText($content, $format = -1)
{
  $content = stripslashes(trim($content));
  switch ($format) {
    case '2HTML':
      if(RICH_TEXT_EDITOR === 0 || isRawText($content)) $content = nl2br($content);
      break;
    case '2FIELD':
      $content = htmlentities($content, ENT_QUOTES, 'utf-8');
      break;
    case '2ATT':
      $content = htmlentities($content, ENT_QUOTES, 'utf-8');
      break;
    case '2XML':
      $content = strip_tags($content);
      break;
    case '2FILE':
      //$content = addslashes(trim($content));
      $content = htmlspecialchars($content, ENT_QUOTES, 'utf-8');
      break;
    default:
  }
  return $content;
}

/**
 * ReplaceInvalidChars()
 * Remplacement des caractères invalides  par leurs entités HTML
 *
 * @param string $str
 * @return string $valid_string
 */
function ReplaceInvalidChars($str)
{
  $htmlentities_chars = array('å' => '&#338;', 'ú' => '&#339;',
        'ä' => '&#352;', 'ö' => '&#353;',
        'ü' => '&#376;', 'à' => '&#710;',
        'ò' => '&#732;', 'ñ' => '&#8211;',
        'ó' => '&#8212;', 'ë' => '&#8216;',
        'í' => '&#8217;', 'Ç' => '&#8218;',
        'ì' => '&#8220;', 'î' => '&#8221;',
        'Ñ' => '&#8222;', 'Ü' => '&#8224;',
        'á' => '&#8225;', 'Ö' => '&#8230;',
        'â' => '&#8240;', 'É' => '&#402;',
        'ã' => '&#8249;', 'õ' => '&#8250;',
        'Ä' => '&#8364;', 'ô' => '&#8482;',
        'ï' => '&#8226;', 'ò' => '&#732;',
        'ô' => '&#8482;');

  //$valid_string = str_replace(array_keys($htmlentities_chars), array_values($htmlentities_chars), $str);
  //return $valid_string;
  return $str;
}

function stripAccents($string) {

  $search = explode(",","ç,æ,œ,á,é,í,ó,ú,à,è,ì,ò,ù,ä,ë,ï,ö,ü,ÿ,â,ê,î,ô,û,å,e,i,ø,u");
  $replace = explode(",","c,ae,oe,a,e,i,o,u,a,e,i,o,u,a,e,i,o,u,y,a,e,i,o,u,a,e,i,o,u");

  return str_replace($search, $replace, $string);


}

function stripText($text) {

  $text = strtolower($text);

  // strip all non word chars
  $text = preg_replace('/\W/', ' ', $text);
  // replace all white space sections with a dash
  $text = preg_replace('/\ +/', '-', $text);
  // trim dashes
  $text = preg_replace('/\-$/', '', $text);
  $text = preg_replace('/^\-/', '', $text);

  return $text;
}

/**
 * toStringSqlDate()
 * Renvoie la date au format SQL
 *
 * @param string $format
 * @return string $s
 */
function toStringSqlDate($format = 'short')
{
  $date_format =   array(
                   'dd-mm-yyyy' => array(
                      	'mysql' => array('short'=> '%d-%m-%Y', 'long'=>
  array('12' => '%d-%m-%Y  %r', '24' => '%d-%m-%Y  %T')),
                    	'pgsql' => array('short'=> 'DD-MM-YYYY', 'long'=>
  array('12' => 'DD-MM-YYYY HH12:MI:SS', '24' => 'DD-MM-YYYY HH24:MI:SS'))),
                    'yyyy-mm-dd' => array(
                      	'mysql' => array('short'=> '%Y-%m-%d', 'long'=>
  array('12' => '%Y-%m-%d  %r', '24' => '%Y-%m-%d  %T')),
                    	'pgsql' => array('short'=> 'YYYY-MM-DD', 'long'=>
  array('12' => 'YYYY-MM-DD HH12:MI:SS', '24' => 'YYYY-MM-DD HH24:MI:SS'))),

  );
   
  if($format == 'long') $s = $date_format[DATE_FORMAT][SQL][$format][TIME_FORMAT];
  else $s = $date_format[DATE_FORMAT][SQL][$format];

  return $s;
}


/**
 * date_compare()
 * Compare 2 dates with a given operator.
 * @param  $date1
 * @param  $date2
 * @param  $op
 * @return boolean
 */
function date_compare($date1, $date2, $op) {

  $date1= strtotime(formatDate($date1, true));
  $date2= strtotime(formatDate($date2, true));

  switch($op) {
    case '>':
      if($date1 > $date2) return true;
      else return false;
      break;
    case '<':
      if($date1 < $date2) return true;
      else return false;
    case '>=':
      if($date1 >= $date2) return true;
      else return false;
      break;
    case '<=':
      if($date1 <= $date2) return true;
      else return false;
    case '==':
      if($date1 == $date2) return true;
      else return false;
    default:
      return false;
  }
}

/**
 * ln10filename()
 * Build a localized filename
 * according to the cuurent language
 *
 * @param string $file
 * @return string
 */
function ln10filename($file)
{

  $tmp=@explode(".", $file);
  $total = count($tmp) - 1;
  $ext = $tmp[$total];
  unset($tmp[$total]);

  return @implode(".", $tmp). '.' . U_L. '.' .$ext;
}


/**
 * distInclude()
 * Include the required file
 * if no user file is found,
 * includes the dist/ version file.
 * Localized files have the priority
 *
 * @param string $file
 * @return void
 */
function distInclude($file, $default_dist)
{
  $l10n_file = ln10filename($file);
  $l10n_file_dist =  dirname($l10n_file).'/dist/'.basename($l10n_file);

  $file_dist_default =  $default_dist.'dist/'.basename($file);
  $l10n_file_dist_default = $default_dist.'dist/'.basename($l10n_file);

  if(file_exists($l10n_file)) {
    _debug('distInclude() file Inclusion : '.$l10n_file);
    include_once($l10n_file);

  } elseif(file_exists($l10n_file_dist))  {
    _debug('distInclude() file Inclusion : '.$l10n_file_dist);
    include_once($l10n_file_dist);
  }
  elseif(file_exists($file)) {
    _debug('distInclude() file Inclusion : '.$file);
    include_once($file);
  }
  elseif(file_exists($l10n_file_dist_default)) {
    _debug('distInclude() file Inclusion : '.$l10n_file_dist_default);
    include_once($l10n_file_dist_default);
  }
  elseif(file_exists($file_dist_default)) {
    _debug('distInclude() file Inclusion : '.$file_dist_default);
    include_once($file_dist_default);
  }
  else {
    _debug('distInclude() file Inclusion : '.dirname($file).'/dist/'.basename($file));
    include_once(dirname($file).'/dist/'.basename($file));
  }

}

/**
 * themePath()
 * check if a template file version exists or not
 * if no user file is found in theme,
 * return the default module version file.
 *
 * @param string $file
 * @param string $path
 * @return string
 */
function themePath($file, $path= 0)
{
  if($path == 0) $path = THEME_PUBLIC_PATH;
  $theme_file = $path.'override/'.str_replace('../', '', $file);
  if(file_exists($theme_file)) {
    _debug('themePath() returned value : '.$theme_file);
    return $theme_file;

  } else {
    _debug('themePath() returned value : '.$file);
    return $file;
  }

}

/**
 * formatDate()
 * Renvoie la date aux formats yyyy-mm-dd ou dd-mm-yyyy suivant le cas de départ
 * Si $db == true renvoie toujours la date au format yyyy-mm-dd
 *
 * @param string $date
 * @param boolean $db
 * @return string $new_date
 */
function formatDate($date, $db = false)
{
  @list($part1, $part2, $part3) = explode('-', $date);
  if(strlen($part1) == 2) {
    $new_date = $part3 . '-' . $part2 . '-' . $part1;
  } else {
    $new_date = $part1 . '-' . $part2 . '-' . $part3;
  }
  if($db == true) {
    // always return yyyy-mm-dd format
    if(strlen($part1) == 2) {
      $new_date = $part3 . '-' . $part2 . '-' . $part1;
    } else {
      $new_date = $part1 . '-' . $part2 . '-' . $part3;
    }
  }

  return $new_date;
}


/**
 * date_rfc2822()
 * Format date to RFC 2822 date format
 * @param string $date
 * @return string (exemple : Thu, 21 Dec 2000 16:01:07 +0200)
 */
function date_rfc2822($date) {
  if(!isNullDate($date)) {
    $tmp_date = formatDate($date, true);
    @list($y, $m, $d) = explode('-', $tmp_date);
    return date("r", mktime(3, 0, 0, $m, $d, $y));
  } else {
    return false;
  }
}


function isNullDate($date)
{
  if($date == '0001-01-01' || $date == '01-01-0001') {
    return true;
  } else return false;

}

/**
 * empty_nc()
 * retourne le contenu ou N.C
 *
 * @param string $content
 * @return string $content
 */
function empty_nc($content)
{
  $content = trim($content);
  if (empty($content) || isNullDate($content)) $content = _t('divers','nc');

  return $content;
}

/**
 * empty_none()
 * retourne le contenu ou 'aucun'
 *
 * @param string $content
 * @return string $content
 */
function empty_none($content)
{
  $content = trim($content);
  if (empty($content)) $content = _t('divers','none');

  return $content;
}

/**
 * empty_none()
 * retourne le contenu ou 0
 *
 * @param string $content
 * @return string $content
 */
function empty_numeric($content)
{
  $content = trim($content);
  if (empty($content)) $content = 0;

  return $content;
}

/**
 * checkdate_validity()
 * Vérifie la validité d'une date
 *
 * @param string $date
 * @param string $msg (optionnal)
 * @return boolean true or error message (string)
 */
function checkdate_validity($date, $msg= '')
{

  $date=formatDate($date, true);
  @list($year, $month, $day) = explode('-', $date);

  if(!preg_match('/^\d{4}-\d\d-\d\d$/', $date)) {
    $msg .= _t('date','not_valid');
    return $msg;
  }

  if (!@checkdate($month , $day , $year)) return $msg . _t('date','date_do_not_exist');
  return true;
}

/**
 * display_errors()
 * Affichage d'un message d'erreur utilisateur
 *
 * @param string $msg
 * @return void (echo)
 */
function display_errors($msg)
{
  $display_it = "<div class=\"error\">\n";
  $display_it .= $msg;
  $display_it .= "</div>\n";
  echo $display_it;
}

/**
 * system_error()
 * Affichage d'un message d'erreur syst�me
 *
 * @param string $msg
 * @return void (echo)
 */
function system_error($msg = ERROR_SYSTEM)
{
  $display_it = "<div class=\"systemerror\">\n";
  $display_it .= $msg;
  $display_it .= "</div>\n";
  echo $display_it;
  exit;
}

/**
 * get_temp_name()
 * obtenir le nom temporaire d'un fichier
 *
 * @param string $path
 * @return string $temp_path
 */
function get_temp_name($path)
{
  $short_path = dirname($path);
  $filename = basename($path);
  $temp_path = $short_path . "/temp_" . $filename;
  return $temp_path;
}

/**
 * get_min_name()
 * obtenir le nom de la miniature d'un fichier
 *
 * @param string $path
 * @return string $min_path
 */
function get_min_name($path)
{
  $short_path = dirname($path);
  $filename = basename($path);
  $min_path = $short_path . "/min_" . $filename;
  return $min_path;
}

/**
 * ExcedMaxSize()
 * Teste si une image dépasse ou non la taille autorisée (en pixels)
 *
 * @param string $path
 * @param integer $width_max
 * @return boolean
 */
function ExcedMaxSize($path, $width_max)
{
  list($width, $height, $type, $attr) = getimagesize($path);
  if ($width > $width_max || $height > $width_max) return true;
  else return false;
}

/**
 * GetAllPhotoUri()
 * renvoie les paths des photos dans un tableau
 *
 * @param string $path
 * @param string $opt
 * @return array $tab
 */
function GetAllPhotoUri($path, $opt = -1)
{
  if (empty($path)) return false;
  else {
    $tab = explode('|', $path);
    if ($opt == 'min') array_walk($tab, 'get_min_name');
    return $tab;
  }
}

/**
 * cancel_button()
 * génére un bouton de retour
 *
 * @param  $back_uri
 * @return string
 */
function cancel_button($back_uri)
{
  return '<input name="annuler" type="button" value="' . _t('btn','annul') . '" class="button" id="annuler" onclick="window.location=\'' . $back_uri . '\';" />';
}

/**
 * GetDisplayUserRight()
 * renvoie les droits d'un utilisateur
 *
 * @param string $indice
 * @param string $module
 * @return string
 */
function GetDisplayUserRight($indice, $module = -1)
{
  $indice = strtoupper($indice);
  if ($indice == 'U') return _t('user','norights');
  if ($indice == 'A') return _t('user','adminrights');
  if ($indice == 'O' && $module == 'dashboard') return _t('user','managerrights');
  if ($indice == 'O' && $module == 'workshop') return _t('user','animatorrights');
  if ($indice == 'O' && ($module != 'workshop' && $module != 'dashboard')) return _t('user','redactorrights');
}

/**
 * Display_linkin_page()
 *
 * @param array $table_link
 * @param integer $total
 * @param integer $debut
 * @param integer $pas
 * @return void
 **/
function Display_linkin_page($table_link, $total, $debut, $pas = SELECT_LIMIT)
{
  $result = ceil($total / $pas);
  if ($result <= 1) return '&nbsp;';
  else {
    $link = '<div class="lienliste">'.END_LINE;
    $link .= '« ';
    $sep='';
    for($i = 0; $i < $result; $i++) {
      $current_pos = ($pas * $i);
      if ($debut == $current_pos) $link .= $sep."<span>" . ($i + 1) . "</span> \n";
      else {
        $array_pos = array ('debut' => $current_pos);
        $new_table_link = array_merge ($table_link, $array_pos);
        $link .= $sep.'<a href="'. HrefMaker($new_table_link) . '">' . ($i + 1) . '</a>'.END_LINE;
      }
      $sep=' | ';
    }
    $link .= ' »';
    $link .= '</div>'.END_LINE;
    echo $link;
  }
}

/**
 * linkin_page()
 * création d'un navigateur de pages numérotées
 *
 * @param string $string_uri
 * @param integer $total
 * @param integer $debut
 * @param integer $pas
 * @return string $link
 */
function linkin_page($string_uri, $total, $debut, $pas = SELECT_LIMIT)
{
  $result = ceil($total / $pas);
  if ($result <= 1) return '&nbsp;';
  else {
    if (strpos($string_uri, '?') === false) $string_uri .= '?';
    else $string_uri .= '&amp;';
    $link = '<div class="lienliste">';
    for($i = 0; $i < $result; $i++) {
      $current_pos = ($pas * $i);
      if ($debut == $current_pos) $link .= "<span>" . ($i + 1) . "</span> \n";
      else $link .= "<a href=\"" . $string_uri . "debut=" . $current_pos . "\">" . ($i + 1) . "</a> \n";
    }
    $link .= '</div>';
    return $link;
  }
}

/**
 * display_statut()
 * renvoie le statut en pleines lettres
 *
 * @param string $statut
 * @return string $result
 */
function display_statut($statut)
{
  switch ($statut) {
    case 'P':
      $result = _t('statut','public');
      break;
    case 'D':
      $result = _t('statut','draft');
      break;
    case 'E':
      $result = _t('statut','E');
      break;
    case 'AA':
      $result = _t('statut','AA');
      break;
    case 'PA':
      $result = _t('statut','PA');
      break;
    case 'C':
      $result = _t('statut','C');
      break;
    case 'U':
      $result = _t('statut','U');
      break;
    case 'O':
      $result = _t('statut','O');
      break;
    case 'A':
      $result = _t('statut','A');
      break;
    case 'W':
      $result = _t('statut','W');
      break;
    default:
      $result = _t('statut','public');
  }
  return $result;
}

/**
 * linkin_content()
 * Cherche les liens et emails dans du contenu -> linkage
 *
 * @param string $content
 * @param string $option
 * @return string $content
 */
function linkin_content($content, $option = 'ALL')
{
  if(defined('AUTO_LINK') && AUTO_LINK == 1)
  {
    if(defined('RICH_TEXT_EDITOR') && RICH_TEXT_EDITOR == (string) 0) {
      if ($option == 'ALL' || $option == 'MAIL') {
        $content = eregi_replace("( |<br />)+([_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)+)", '\\1<a href="mailto:\\2">\\2</a>', $content);
      }
      if ($option == 'ALL' || $option == 'LINK') {
        $content = eregi_replace("(http|https|ftp|ftps)://([-a-z0-9#?/&=:,_;@%.{}]*)([a-z0-9=]{2,4})", '<a href="\\1://\\2\\3" class="out">\\1://\\2\\3</a>', $content);
      }
    }
  }

  return $content;
}

/**
 * QuickBoxNow()
 * Génération de la quickbox
 *
 * @param string $module
 * @param string $h1
 * @param string $liste
 * @param string $suffixclass
 * @return string $quickbox
 */
function QuickBoxNow($module, $h1, $liste, $suffixclass = '')
{
  $quickbox = "<div class=\"entete\">\n<div class=\"qb_ico\" id=\"qbico" . $suffixclass . "\" title=\"" . $module . "\"></div>\n";
  $quickbox .= "<div class=\"quickbox\" id=\"qbbg" . $suffixclass . "\">\n";
  $quickbox .= "<h1>" . $h1 . "</h1>\n";
  $quickbox .= "<ul>";
  $quickbox .= $liste;
  $quickbox .= "</ul>";
  $quickbox .= "</div>";
  $quickbox .= "</div>";

  return $quickbox;
}

/**
 * ReloadIndex()
 * Chargement de l'index après destruction de sessions
 *
 * @param string $item
 * @return void
 */
function ReloadIndex($item)
{
  switch ($item) {
    case 'public':
      return header("Location: ../public/index.php");
      break;
    case 'admin':
      return header("Location: ../admin/logout.php");
      break;
  }
}

/**
 * getmicrotime()
 * renvoie le temps en microsecondes
 *
 * @return float
 */
function getmicrotime()
{
  list($usec, $sec) = explode(" ", microtime());
  return ((float)$usec + (float)$sec);
}


/**
 * availablePlugins()
 * Return available plugins
 * @return array
 **/
function availablePlugins() {
  $a = array();
  if ($handle = opendir('../plugins/')) {
    while (false !== ($file = readdir($handle))) {
      if (substr($file, 0, 4) == 'l21_' ) {
        array_push($a, $file);
      }
    }
    closedir($handle);
  }

  return $a;
}



/**
 * sql_dump2array()
 * @param $url
 * @param $a
 * @return array
 * @link http://fr2.php.net/manual/fr/function.mysql-query.php
 */
function sql_dump2array($url, $a = -1) {
   
  $handle = @fopen($url, "r");
  $query = "";
  if($a == -1) $a = array();

  while(!feof($handle)) {
    $sql_line = fgets($handle);
    if (trim($sql_line) != "" && strpos($sql_line, "--") === false && strpos($sql_line, "#") === false) {
      array_push($a, $sql_line);
    }
  }
  return $a;
}

/**
 * placeholderReplace()
 * format '{$key}'
 * @param $array
 * @param $input
 * @return array
 */
function placeholderReplace($array, $input) {
  foreach ($input as $key => $value)
  {
    $array = preg_replace("/{{$key}}/i", $value, $array);
  }
  return $array;
}

/**
 * GenerateXhtmlPage()
 *
 * @param $string
 * @param integer $time
 * @param unknown $redirect
 * @return
 **/
function GenerateXhtmlPage($string, $time = 2, $redirect = CURRENT_APP_URL)
{


  $page  = '<?xml version="1.0" encoding="' . CHARSET . '" xml:lang="' . U_L . '"?>' . END_LINE;
  $page .= '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">' . END_LINE;
  $page .= '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="' . U_L . '">' . END_LINE;
  $page .= '<head>' . END_LINE;
  $page .= '<meta http-equiv="content-type" content="text/html;charset=' . CHARSET . '" />' . END_LINE;
  $page .= '<meta http-equiv="content-langage" content="' . CHARSET . '" />' . END_LINE;
  $page .= '<meta http-equiv="refresh" content="' . $time . ';url=' . $redirect . '">' . END_LINE;
  $page .= '<link rel="icon" type="image/gif" href="' .THEME_ADMIN_PATH. 'images/favicon.gif" />' . END_LINE;
  $page .= '<title>'.SITE_NAME.'</title>' . END_LINE;
  $page .= '</head>' . END_LINE;
  $page .= '<body>' . END_LINE;
  $page .= '<div class="info" style="margin-top:10em">'.$string.END_LINE;
  $page .= '<br />';
  $page .= sprintf( _t('divers','redirect_string'), $redirect, $time);
  $page .= '</div>'. END_LINE;
  $page .= '</body>' . END_LINE;
  $page .= '</html>' . END_LINE;

  return $page;
}

/**
 * _debug()
 * Display a debug message
 * @param string
 * @return void
 **/
function _debug($string)
{
  if(isset($GLOBALS['Dbg']))
  {
    global $Dbg;

    $Dbg->add($string);
    $Dbg->stopTimer();
  }
}

/**
 * headerAddCSS()
 * Add CSS into header
 * @param string
 * @param string
 * @return boolean
 **/
function headerAddCSS($path, $pos = 'default')
{
  if(!file_exists('../'.$path)) return false;

  $str = '<link type="text/css" rel="stylesheet" href="../'.$path.'" />'.END_LINE;

  if(isset($GLOBALS['CSSheader']))
  {
    if($pos == 'first') {
      $GLOBALS['CSSheader'] = $str . $GLOBALS['CSSheader'];
    } else {
      $GLOBALS['CSSheader'] .= $str . END_LINE ;
    }
  } else {
    $GLOBALS['CSSheader'] = $str;
  }
  _debug('Loading <b>CSS file</b> : '.$path . ' (position: '.$pos.')');

  return true;
}

/**
 * headerAddJS()
 * Add JS into header
 * @param string
 * @param string
 * @return boolean
 **/
function headerAddJS($path, $pos = 'default')
{
  if(!file_exists('../'.$path)) {
    _debug('<b>Problem loading JS file</b> : '.$path . ' (position: '.$pos.')');
    return false;
  }

  $str= '<script type="text/javascript" src="../'.$path .'"></script>'.END_LINE;

  if(isset($GLOBALS['JSheader']))
  {
    if($pos == 'first') {
      $GLOBALS['JSheader'] = $str . $GLOBALS['JSheader'];
    }
    else {
      $GLOBALS['JSheader'] .= $str . END_LINE ;
    }
  } else {
    $GLOBALS['JSheader'] = $str;
  }
  _debug('Loading <b>JS file</b> : '.$path . ' (position: '.$pos.')');

  return true;
}

/**
 * footerAddJS()
 * Add JS into footer
 * @param string
 * @param string
 * @return boolean
 **/
function footerAddJS($path, $pos = 'default')
{
  if(!file_exists('../'.$path)) {
    _debug('<b>Problem loading JS file</b> : '.$path . ' (position: '.$pos.')');
    return false;
  }

  $str= '<script type="text/javascript" src="../'.$path .'"></script>'.END_LINE;

  if(isset($GLOBALS['JSfooter']))
  {
    if($pos == 'first') {
      $GLOBALS['JSfooter'] = $str . $GLOBALS['JSheader'];
    }
    else {
      $GLOBALS['JSfooter'] .= $str . END_LINE ;
    }
  } else {
    $GLOBALS['JSfooter'] = $str;
  }
  _debug('Loading <b>JS file</b> : '.$path . ' (position: '.$pos.')');

  return true;
}

/**
 * AddDynamicHeader()
 * Display JS and CSS header
 * @return void
 **/
function AddDynamicHeader() {
  if(isset($GLOBALS['JSheader'])) echo $GLOBALS['JSheader'];
  if(isset($GLOBALS['CSSheader']))  echo $GLOBALS['CSSheader'];
}

/**
 * AddDynamicFooter()
 * Display JS footer
 * @return void
 **/
function AddDynamicFooter() {
  if(isset($GLOBALS['JSfooter'])) echo $GLOBALS['JSfooter'];
}

/**
 * check4newVersion()
 * Display a link to download new version if available
 * @return string
 **/
function check4newVersion() {
  try{
    if(!@$rss=simplexml_load_file(SITE_LINEA_URL.'/linea_version.xml')){
      throw new Exception('Version : xml file was not found');
    }
    $current_version = preg_replace("/([a-z])/i",'', LINEA_VERSION); // remove letter (if dev version)

    $latest_version = str_pad(str_replace('.', '', $rss->num), 4, '0');
    $current_version = str_pad(str_replace('.', '', $current_version), 4, '0');

    if((integer)$latest_version > (integer)$current_version) {
      $update = '<div id="version-check">'._t('check_update','search').' : <a href="'.(string)$rss->link.'">'.sprintf(_t('check_update','dl'), $rss->num).'</a></div>';
    } else {
      $update = '<div id="version-check">'._t('check_update','search').' : '._t('check_update','ok').'</div>';
    }
  }
  catch(Exception $e){
    $update = $e->getMessage();
  }

  return $update;
}

/**
 * loadThemeInfo()
 * Load theme info
 * @param string
 * @param string
 * @return string
 **/
function loadThemeInfo($type, $name) {
  $a = array();
  try{
    if(!@$flow=simplexml_load_file(SITE_PATH.'templates/'.$type.'/'.$name.'/theme.xml')){
      throw new Exception($name.' plugin : xml file was not found');
    }
    $a['name'] = $flow->themename;
    $a['description'] = $flow->description;
    $a['version'] = $flow->version;
    $a['date'] = $flow->date;
    $a['compatibility'] = $flow->compatibility;
    $a['author'] = $flow->author;
    $a['homepage'] = $flow->homepage;

    return $a;
  }
  catch(Exception $e){
    return $e->getMessage();
  }
}
/**
 * For compatibility with PHP < 5.2
 * json_decode
 */
if ( !function_exists('json_decode') ){
  function json_decode($content, $assoc=false){
    require_once __DIR__ .'/vendor/JSON/JSON.php';
    if ( $assoc ){
      $json = new Services_JSON(SERVICES_JSON_LOOSE_TYPE);
    } else {
      $json = new Services_JSON;
    }
    return $json->decode($content);
  }
}

/**
 * For compatibility with PHP < 5.2
 * json_encode
 */
if ( !function_exists('json_encode') ){
  function json_encode($content){
    require_once __DIR__ .'/vendor/JSON/JSON.php';
    $json = new Services_JSON;
     
    return $json->encode($content);
  }
}

/**
 Validate an email address.
 Provide email address (raw input)
 Returns true if the email address has the email
 address format and the domain exists.
 @link http://www.linuxjournal.com/article/9585
 */
function validEmail($email)
{
  $isValid = true;
  $atIndex = strrpos($email, "@");
  if (is_bool($atIndex) && !$atIndex)
  {
    $isValid = false;
  }
  else
  {
    $domain = substr($email, $atIndex+1);
    $local = substr($email, 0, $atIndex);
    $localLen = strlen($local);
    $domainLen = strlen($domain);
    if ($localLen < 1 || $localLen > 64)
    {
      // local part length exceeded
      $isValid = false;
    }
    else if ($domainLen < 1 || $domainLen > 255)
    {
      // domain part length exceeded
      $isValid = false;
    }
    else if ($local[0] == '.' || $local[$localLen-1] == '.')
    {
      // local part starts or ends with '.'
      $isValid = false;
    }
    else if (preg_match('/\\.\\./', $local))
    {
      // local part has two consecutive dots
      $isValid = false;
    }
    else if (!preg_match('/^[A-Za-z0-9\\-\\.]+$/', $domain))
    {
      // character not valid in domain part
      $isValid = false;
    }
    else if (preg_match('/\\.\\./', $domain))
    {
      // domain part has two consecutive dots
      $isValid = false;
    }
    else if
    (!preg_match('/^(\\\\.|[A-Za-z0-9!#%&`_=\\/$\'*+?^{}|~.-])+$/',
    str_replace("\\\\","",$local)))
    {
      // character not valid in local part unless
      // local part is quoted
      if (!preg_match('/^"(\\\\"|[^"])+"$/',
      str_replace("\\\\","",$local)))
      {
        $isValid = false;
      }
    }
    if(CHECK_LINK == 1) {
      if ($isValid && !(checkdnsrr($domain,"MX") || checkdnsrr($domain,"A")))
      {
        // domain not found in DNS
        $isValid = false;
      }
    }
  }
  return $isValid;
}

/**
 * setBreadcrumb()
 * Set breadcrumb content
 * @param array
 * @return void
 **/
function setBreadcrumb($array)
{
  if(!isset($GLOBALS['breadcrumb'])) $GLOBALS['breadcrumb']= array();
  $GLOBALS['breadcrumb'] = array_merge($GLOBALS['breadcrumb'], $array);
}

/**
 * getBreadcrumb()
 * get the Breadcrumb for displaying
 * @param string (optional)
 * @return string
 **/
function getBreadcrumb($sep = '»')
{
  $str = '<div id="breadcrumb">'.END_LINE;
  $str.= '<ul>'.END_LINE;
  $str.= '<li>'.$sep.' <a href="'.SITE_ROOT_URL.'public/">Accueil</a></li>'.END_LINE;
  foreach($GLOBALS['breadcrumb'] as $key => $value) {
    // echo "$key => $value";
    if($value!=false) $str.= '<li>'.$sep.' <a href="'.$value.'">'.$key.'</a></li>'.END_LINE;
    else $str.= '<li>'.$sep.' '.$key.'</li>'.END_LINE;
  }
  $str.= '</ul>'.END_LINE;
  $str.= '</div>'.END_LINE;

  return $str;
}

/**
 * ListDir()
 * Return an HTML list for a given folder
 * @param int
 * @param string
 * @param string
 * @return string
 **/
function ListDir($dir_handle,$path, $url) {
  //global $listing;
  $i= 0;
  echo "<ul>";
  while (false !== ($file = readdir($dir_handle))) {
    $dir =$path . $file;
    if(is_dir($dir) && $file != '.' && $file !='..' ) {
      $handle = @opendir($dir) or die("Unable to open file $file");
      ListDir($handle, $dir.'/', $url);
    } elseif($file != '.' && $file !='..' && $file !='.htaccess') {
      $size= formatBytes(filesize($dir), 2);
      $class = ($i++ & 1) ? '' : 'class="odd"';
      $dir = str_replace('../', '', $dir);
      $dir = str_replace('//', '/', $dir);
      $dir = dirname($dir).'/'. rawurlencode(basename($dir));
      echo '<li '.$class.'><a href="'. $url . $dir .'">'.$file.'</a> <em>('.$size.')</em> <a  class="dlfile" href="'. $url .'library/dl.php?file='. $dir .'" title="'._t('divers','dl'). ' ' . $file.'"><span>' ._t('divers','dl'). '</span></a></li>';
    }
  }
  if($i==0) echo '<li>'._t('divers','no_files').'</li>';
  echo "</ul>";
  closedir($dir_handle);
}

/**
 * formatBytes()
 * Make File size readable
 * @param int
 * @param int (optional)
 * @return string
 **/
function formatBytes($bytes, $precision = 2) {
  $units = array('o', 'Ko', 'Mo', 'Go', 'To');

  $bytes = max($bytes, 0);
  $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
  $pow = min($pow, count($units) - 1);

  $bytes /= pow(1024, $pow);

  return round($bytes, $precision) . ' ' . $units[$pow];
}

/**
 * logfile()
 * Log into file
 * @param string
 * @param array
 * @return void
 **/
function logfile($src, $a) {

  $sep = '##';
  $fp = @fopen($src, 'a');

  foreach($a as $value) {
    @fwrite($fp, $value . $sep);
  }

  @fwrite($fp, date('[d-m-y H:i:s]' . $sep. END_LINE));
  @fclose($fp);

  return true;
}

/**
 * getThemes()
 * Return installed themes
 * into an array
 * @param string
 * @return array
 **/
function getThemes($f) {

  $a = array();

  if ($handle = opendir('../templates/'.$f)) {
    $sep='';
    while (false !== ($file = readdir($handle))) {
      if ($file != "." && $file != ".." && $file != ".svn") {
        array_push($a, $file);
      }
    }
    closedir($handle);
  }

  return $a;
}

/**
 * cleanString()
 * Remove exotic characters form string
 * same as used in filemanager
 * @param string
 * @param array
 * @return string
 **/
function cleanString($string, $allowed = array()) {
  $allow = null;

  if (!empty($allowed)) {
    foreach ($allowed as $value) {
      $allow .= "\\$value";
    }
  }

  $mapping = array(
        'Š'=>'S', 'š'=>'s', 'Đ'=>'Dj', 'đ'=>'dj', 'Ž'=>'Z', 'ž'=>'z', 'Č'=>'C', 'č'=>'c', 'Ć'=>'C', 'ć'=>'c',
        'À'=>'A', 'Á'=>'A', 'Â'=>'A', 'Ã'=>'A', 'Ä'=>'A', 'Å'=>'A', 'Æ'=>'A', 'Ç'=>'C', 'È'=>'E', 'É'=>'E',
        'Ê'=>'E', 'Ë'=>'E', 'Ì'=>'I', 'Í'=>'I', 'Î'=>'I', 'Ï'=>'I', 'Ñ'=>'N', 'Ò'=>'O', 'Ó'=>'O', 'Ô'=>'O',
        'Õ'=>'O', 'Ö'=>'O', 'Ő'=>'O', 'Ø'=>'O', 'Ù'=>'U', 'Ú'=>'U', 'Û'=>'U', 'Ü'=>'U', 'Ű'=>'U', 'Ý'=>'Y',
        'Þ'=>'B', 'ß'=>'Ss','à'=>'a', 'á'=>'a', 'â'=>'a', 'ã'=>'a', 'ä'=>'a', 'å'=>'a', 'æ'=>'a', 'ç'=>'c',
        'è'=>'e', 'é'=>'e', 'ê'=>'e', 'ë'=>'e', 'ì'=>'i', 'í'=>'i', 'î'=>'i', 'ï'=>'i', 'ð'=>'o', 'ñ'=>'n',
        'ò'=>'o', 'ó'=>'o', 'ô'=>'o', 'õ'=>'o', 'ö'=>'o', 'ő'=>'o', 'ø'=>'o', 'ù'=>'u', 'ú'=>'u', 'ű'=>'u',
        'û'=>'u', 'ý'=>'y', 'ý'=>'y', 'þ'=>'b', 'ÿ'=>'y', 'Ŕ'=>'R', 'ŕ'=>'r', ' '=>'_', "'"=>'_', '/'=>''
        );

        if (is_array($string)) {

          $cleaned = array();

          foreach ($string as $key => $clean) {
            $clean = strtr($clean, $mapping);
            $clean = preg_replace("/[^{$allow}_a-zA-Z0-9]/", '', $clean);
            $cleaned[$key] = preg_replace('/[_]+/', '_', $clean); // remove double underscore
          }
        } else {
          $string = strtr($string, $mapping);
          $string = preg_replace("/[^{$allow}_a-zA-Z0-9]/", '', $string);
          $cleaned = preg_replace('/[_]+/', '_', $string); // remove double underscore
        }
        return $cleaned;
}

/**
 * securityCheck()
 * Test and sanitize user input
 * from request
 * @return boolean
 **/
function securityCheck() {

  $passed = true;
  
  // we first sanitize vars
  if(isset($_REQUEST['rub']))
    $_REQUEST['rub']= strip_tags($_REQUEST['rub']);
  if(isset($_REQUEST['name']))
    $_REQUEST['name']= strip_tags($_REQUEST['name']);
  // then do tests
  if(isset($_REQUEST['id']) && preg_match('/[^0-9A-Za-z]/',$_REQUEST['id']))
    $passed= false;
  if(isset($_REQUEST['parentid']) && !is_numeric($_REQUEST['parentid']))
    $passed= false;
  if(isset($_REQUEST['parentparentid']) && !is_numeric($_REQUEST['parentparentid']))
    $passed= false;
  if(isset($_REQUEST['debut']) && !is_numeric($_REQUEST['debut']))
    $passed= false;

  if($passed == false) die('no way!');
  else return true;
}
?>