<?php
/**
 * @package linea21.core
 * @subpackage mail
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */


/**
 * absolute_url
 * http://www.howtoforge.com/forums/showthread.php?t=4
 * @param $txt
 * @param $base_url
 */
function absolute_url($txt, $base_url) {
  $needles = array('href="', 'src="', 'background="');
  $new_txt = '';
  if(substr($base_url,-1) != '/') $base_url .= '/';
  $new_base_url = $base_url;
  $base_url_parts = parse_url($base_url);

  foreach($needles as $needle){
    while($pos = strpos($txt, $needle)){
      $pos += strlen($needle);
      if(substr($txt,$pos,7) != 'http://' && substr($txt,$pos,8) != 'https://' && substr($txt,$pos,6) != 'ftp://' && substr($txt,$pos,9) != 'mailto://'){
        if(substr($txt,$pos,1) == '/') $new_base_url = $base_url_parts['scheme'].'://'.$base_url_parts['host'];
        $new_txt .= substr($txt,0,$pos).$new_base_url;
      } else {
        $new_txt .= substr($txt,0,$pos);
      }
      $txt = substr($txt,$pos);
    }
    $txt = $new_txt.$txt;
    $new_txt = '';
  }
  return $txt;
}

include_once("../class/system/class.phpmailer.php");

$mail = new phpmailer();

if(defined('MAIL_USE_SSL') && MAIL_USE_SSL== true) {
  $mail->Host = MAIL_HOST_SSL;
  $mail->Port = MAIL_PORT_SSL;
}
if (defined('MAIL_MAILER')) {
  $mail->Mailer = MAIL_MAILER;
  if(MAIL_MAILER=='sendmail') {
    if(defined('MAIL_SENDMAIL')) $mail->Sendmail = MAIL_SENDMAIL;
  }
  if(MAIL_MAILER=='smtp') {
    if(defined('MAIL_HOST')) $mail->Host = MAIL_HOST;
  }
}

if (defined('MAIL_SMTP_AUTH') && MAIL_SMTP_AUTH == true) {
  $mail->SMTPAuth = MAIL_SMTP_AUTH;
  if (defined('MAIL_SMTP_USER')) $mail->Username = MAIL_SMTP_USER;
  if (defined('MAIL_SMTP_PASS')) $mail->Password = MAIL_SMTP_PASS;
}

/**
 echo "destinataire : ".$email_dest."<br />";
 echo "sujet : ".$email_subject."<br />";
 echo "body : ".$email_html_body."<br />";
 echo "methode : ".$email_method."<br />";
 echo "host : ".$mail->Host."<br />";
 echo "port : ".$mail->Port."<br />";
 */

for($i = 0;$i < count($newsletters); $i++) {
  $newsletter_id = $newsletters[$i]['newsletter_id'];
  $email_subject = formatText($newsletters[$i]['newsletter_title'], '2HTML');

  $newsletter_body_html = formatText($newsletters[$i]['newsletter_body'], '2HTML');
  preg_replace("(<\s*(a|img)\s+[^>]*(href|src)\s*=\s*[\"'])(?!http)([^\"'>]+)[\"'>]", "$1".CURRENT_APP_URL."$4", $newsletter_body_html);
  $email_html_body=str_replace('##TITLE##', $email_subject, $template_html);
  $email_html_body=str_replace('##CHARSET##', CHARSET, $email_html_body);
  $email_html_body=str_replace('##CONTENTS##', $newsletter_body_html, $email_html_body);
  $email_html_body=str_replace('##SITENAME##', SITE_NAME, $email_html_body);
  $email_html_body=str_replace('##CSSPATH##', SITE_ROOT_URL. THEME_DIRECTORY.'/public/'.THEME_PUBLIC.'/css/', $email_html_body);
  $email_html_body=str_replace('##SITEURL##', SITE_ROOT_URL, $email_html_body);
  $email_html_body=str_replace('##SITEMAIL##', SITE_MAIL, $email_html_body);
  $email_html_body=absolute_url($email_html_body, SITE_ROOT_URL);

  $newsletter_body_txt = formatText($newsletters[$i]['newsletter_body']);
  $email_text_body=str_replace('##TITLE##', strip_tags(formatText($email_subject)), $template_txt);
  $email_text_body=str_replace('##CONTENTS##', strip_tags(formatText($newsletter_body_txt)), $email_text_body);
  $email_text_body=str_replace('##SITENAME##', SITE_NAME, $email_text_body);
  $email_text_body=str_replace('##SITEURL##', SITE_ROOT_URL, $email_text_body);
  $email_text_body=str_replace('##SITEMAIL##', SITE_MAIL, $email_text_body);
  $email_text_body=absolute_url($email_text_body, SITE_ROOT_URL);
  

  $mail->CharSet = CHARSET;
  $mail->From = MAIL_FROM;
  $mail->FromName = MAIL_FROMNAME;
  $mail->Subject = $email_subject;
  $mail->WordWrap = 75;
  $mail->Body = $email_html_body;
  $mail->AltBody = str_replace('&amp;', '&', $email_text_body);
  $mail->AddReplyTo(MAIL_REPLY, MAIL_REPLYNAME);

  for($k = 0; $k < count($emails_batch); $k++) {
    $email_id = $emails_batch[$k]['emailcol_id'];
    $email_dest = $emails_batch[$k]['emailcol_email'];

    $mail->AddAddress($email_dest);

    $r = $mail->Send();
    logfile(LOG_MAILING, array($mail->Subject, $newsletter_id, $email_dest, $mail->ErrorInfo));

    $mail->ClearAddresses();
    $mail->ClearAttachments();
  }
  $newsletter_object->SetNewsletterPublished($newsletter_id, $sql_object);
}

?>