<?php
/**
 * @package linea21.modules
 * @subpackage project
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!IsSuperAdmin()) ReloadIndex('admin');
////////////


if (isset($_GET['id']))	$id=$_GET['id'];
if (isset($_POST['id'])) $id=$_POST['id'];

$project_object = new project;

$mask_statut_P='';
$mask_statut_D='';
$mask_archive_P='';
$mask_archive_D='';
$mask_archive_AA='';
$mask_archive_PA='';

if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$project_object->ModifyProject($id, $data_table, $sql_object);

  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if($result) header("Location: ".$link_confirm);
  else  system_error();
}

// Titre de l'actu en cours de modification
$requete=SQL_getProjectName($id);
$result=$sql_object->DBSelect($requete);
if($result==0 || count($result)!=1) exit;
else $project_current_title=formatText($result[0]['project_name'],'2HTML');



// Obtention des données  de la BDD
$req_det= SQL_getoneCompleteProject($id);
$result=$sql_object->DBSelect($req_det);
if($result==0 || count($result)!=1) exit;

$form_name=formatText($result[0]['project_name'], '2FIELD');
$form_description= formatText($result[0]['project_description'], '2FIELD');
$form_body= formatText($result[0]['project_body'], '2FIELD');
$form_parent_id = ($result[0]['project_parent_id']==0) ? -1 : $result[0]['project_parent_id'];
$form_theme_id = ($result[0]['project_theme_id']==0) ? -1 : $result[0]['project_theme_id'];
$form_workshop_id = ($result[0]['project_workshop_id']==0) ? -1 : $result[0]['project_workshop_id'];
$form_scale_id= $result[0]['project_scale_id'];
$form_priority_id= $result[0]['project_priority_id'];
$form_begin_date= isNullDate($result[0]['project_begin_date_display']) ? '' : $result[0]['project_begin_date_display'];
$form_estimated_date = isNullDate($result[0]['project_estimated_date_display']) ? '' : $result[0]['project_estimated_date_display'];
$form_end_date = isNullDate($result[0]['project_end_date_display']) ? '' : $result[0]['project_end_date_display'];
$form_statut=$result[0]['project_statut'];
$current_status=$result[0]['project_statut'];
$project_owner = $result[0]['project_posted_by'];


if(isset($_POST['valider'])) {

  isset($_POST['choose_sdi']) ? $form_sdi=$_POST['choose_sdi'] : $form_sdi=array();

  $table[0]=$_POST['project_name'];
  $table[1]=$_POST['project_description'];
  $table[2]=$_POST['project_body'];
  $table[3]=$_POST['project_parent_id'];
  $table[4]=$_POST['project_scale_id'];
  $table[5]=$_POST['project_priority_id'];
  $table[6]=$_POST['project_begin_date'];
  $table[7]=$_POST['project_estimated_date'];
  $table[8]=$_POST['project_end_date'];
  $table[9]=$_POST['project_statut'];
  $table[10]=$current_status;
  $table[11]=$_POST['project_theme_id'];
  $table[12]=$_POST['project_workshop_id'];
  $table[13]=$form_sdi;

  $project_object= new project;
  $integrity=$project_object->CheckDataIntegrity($table);


  if(is_string($integrity)) $text_format='2FIELD';
  else $text_format='2HTML';
  $form_name=formatText($_POST['project_name'],$text_format);
  $form_description=formatText($_POST['project_description'], $text_format);
  $form_body=formatText($_POST['project_body'], $text_format);
  $form_begin_date=$_POST['project_begin_date'];
  $form_estimated_date=$_POST['project_estimated_date'];
  $form_end_date=$_POST['project_end_date'];

  $form_parent_id=$_POST['project_parent_id'];
  $form_theme_id=$_POST['project_theme_id'];
  $form_workshop_id=$_POST['project_workshop_id'];
  $form_scale_id=$_POST['project_scale_id'];
  $form_priority_id=$_POST['project_priority_id'];

  $form_statut=$_POST['project_statut'];

  if($_POST['project_statut']=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($_POST['project_statut']=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
  $table=urlencode(serialize($table));
}


include_once("../lib/input_helpers.php");

// select-box de thèmes
$data=$sql_object->DBSelect($req_list_theme);
$select_theme=ThemeSelectBox($data, "project_theme_id", $form_theme_id);

// select-box de workshops
$data=$sql_object->DBSelect($req_list_workshop);
$select_workshop=WorkshopSelectBox($data, "project_workshop_id", $form_workshop_id);

// select-box des projets
$data=$sql_object->DBSelect(SQL_getProjectsList(0,1000, 'public'));
$select_parent=ProjectSelectBox($data, "project_parent_id", $form_parent_id, -1, (array) $id);

// select-box des échelles
$data=$sql_object->DBSelect($req_list_scale);
$select_scale=ScaleSelectBox($data, "project_scale_id", $form_scale_id);

// select-box des priorités
$data=$sql_object->DBSelect($req_list_priority);
$select_priority=PrioritySelectBox($data, "project_priority_id", $form_priority_id);

// Indicators select box with associated indicators selected
$data_sdi = $sql_object->DBSelect(SQL_getProjectSdi($id));
$tmp_sdi = array();
if($data_sdi != 0 || count($data_sdi)!=1) {
  foreach($data_sdi as $value) {
    array_push($tmp_sdi, $value['sdii_id']);
  }
}

$data=$sql_object->DBSelect($req_list_sdi);
$select_sdi=SDIMultiSelectBox($data, "choose_sdi", $tmp_sdi);

// select-box statut
if($form_statut=='P') $mask_archive_P=' selected="selected"';
if($form_statut=='D') $mask_archive_D=' selected="selected"';
if($form_statut=='AA') $mask_archive_AA=' selected="selected"';
if($form_statut=='PA') $mask_archive_PA=' selected="selected"';
$select_statut="<select name=\"project_statut\" id=\"project_statut\">\n";
$select_statut.="<option value=\"P\"".$mask_archive_P.">".display_statut('P')."</option>\n";
$select_statut.="<option value=\"D\"".$mask_archive_D.">".display_statut('D')."</option>\n";
$select_statut.="<option value=\"AA\"".$mask_archive_AA.">".display_statut('AA')."</option>\n";
$select_statut.="<option value=\"PA\"".$mask_archive_PA.">".display_statut('PA')."</option>\n";
$select_statut.="</select>\n";

?>


<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a>
	</li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>"
		class="chemin_rub"><?php echo _t('menu','project');?></a></li>
	<li><span><?php echo formatNavTitle(_t('project','mod'). ' : '.$project_current_title); ?></span>
	</li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>

<script type="text/javascript">
    Date.format = '<?php echo DATE_FORMAT ?>';
    
	$.dpText = {
	TEXT_PREV_YEAR		:	'<?php echo _t('datePicker','TEXT_PREV_YEAR'); ?>',
	TEXT_PREV_MONTH		:	'<?php echo _t('datePicker','TEXT_PREV_MONTH'); ?>',
	TEXT_NEXT_YEAR		:	'<?php echo _t('datePicker','TEXT_NEXT_YEAR'); ?>',
	TEXT_NEXT_MONTH		:	'<?php echo _t('datePicker','TEXT_NEXT_MONTH'); ?>',
	TEXT_CLOSE			:	'<?php echo _t('datePicker','TEXT_CLOSE'); ?>',
	TEXT_CHOOSE_DATE	:	'<?php echo _t('datePicker','TEXT_CHOOSE_DATE'); ?>'
	}
	
	$(document).ready( function() 
    {
	    $("#choose_sdi").multiSelect({selectAllText: ' <?php echo _t('divers','select_all'); ?> ', oneOrMoreSelected: '*', noneSelected: ' <?php echo _t('divers','select_choice'); ?> ' });
	
		$('.date-pick').datePicker({startDate:'01/01/1990'});
		$('#project_begin_date').bind(
    		'dpClosed',
    		function(e, selectedDates)
    		{
    			var d = selectedDates[0];
    			if (d) {
    				d = new Date(d);
    				$('#project_estimated_date').dpSetStartDate(d.addDays(1).asString());
    				$('#project_end_date').dpSetStartDate(d.addDays(1).asString());
    			}
    		}
    	);
    	$('#project_estimated_date').bind(
    		'dpClosed',
    		function(e, selectedDates)
    		{
    			var d = selectedDates[0];
    			if (d) {
    				d = new Date(d);
    				$('#project_begin_date').dpSetEndDate(d.addDays(-1).asString());
    			}
    		}
    	);
    	$('#project_end_date').bind(
    		'dpClosed',
    		function(e, selectedDates)
    		{
    			var d = selectedDates[0];
    			if (d) {
    				d = new Date(d);
    				$('#project_begin_date').dpSetEndDate(d.addDays(-1).asString());
    			}
    		}
    	);
		
    });
</script>

<?php
if(!isset($integrity) || is_string($integrity)) {
  ?>
<div class="contentcontainer"><?php
include_once($dir."/menurub.php");
?>
<div id="content"><?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2($project_current_title); ?></h2>
<form id="modproject" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"
	method="post">
<p><label for="project_name"><?php echo _t('project','name'); ?> : *</label>
<input name="project_name" type="text" class="textfield" maxlength="200"
	id="project_name" value="<?php echo $form_name; ?>" /></p>
<p><label for="project_parent_id"><?php echo _t('project','parent'); ?>
: </label> <?php echo $select_parent; ?></p>
<p><label for="project_description"><?php echo _t('project','description'); ?>
: *</label> <textarea id="project_description"
	name="project_description" class="largetextfield"
	<?php echo AREA_SETTINGS; ?>><?php echo $form_description; ?></textarea>
</p>
<p><label for="project_body"><?php echo _t('project','body'); ?> : *</label>
<textarea id="project_body" name="project_body" class="largetextfield"
	<?php echo AREA_SETTINGS; ?>><?php echo $form_body; ?></textarea></p>
<p><label for="project_begin_date"><?php echo _t('project','begin_date'); ?>
: </label> <input name="project_begin_date" type="text" maxlength="10"
	id="project_begin_date" class="date-pick shorttextfield date-text"
	value="<?php echo $form_begin_date; ?>" /></p>
<p class="post-date"><label for="project_estimated_date"><?php echo _t('project','estimated_date'); ?>
: </label> <input name="project_estimated_date" type="text"
	maxlength="10" id="project_estimated_date"
	class="date-pick shorttextfield date-text"
	value="<?php echo $form_estimated_date; ?>" /></p>
<p class="post-date"><label for="project_end_date"><?php echo _t('project','end_date'); ?>
: </label> <input name="project_end_date" type="text" maxlength="10"
	id="project_end_date" class="date-pick shorttextfield date-text"
	value="<?php echo $form_end_date; ?>" /></p>
<p class="post-date"><label for="project_priority_id"><?php echo _t('project','priority'); ?>
: *</label> <?php echo $select_priority; ?></p>
<p><label for="project_theme_id"><?php echo _t('project','theme'); ?> :
</label> <?php echo $select_theme; ?></p>
<p><label for="project_workshop_id"><?php echo _t('project','workshop'); ?>
: </label> <?php echo $select_workshop; ?></p>
<p><label for="project_scale_id"><?php echo _t('project','scale'); ?> :
*</label> <?php echo $select_scale; ?></p>
<p><label for="choose_sdi"><?php echo _t('project','sdi'); ?> : *</label>
	<?php echo $select_sdi; ?></p>
<p><label for="project_statut"><?php echo _t('project','statut'); ?> : </label>
	<?php echo $select_statut; ?></p>
<div><input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
	<?php echo cancel_button('javascript:history.go(-1);'); ?> <input
	name="valider" type="submit" value="<?php echo _t('btn','valid'); ?>"
	class="button" id="valider" /></div>
</form>
</div>
	<?php include_once($dir."/help.php"); ?></div>
	<?php
	// Récapitulatif
} else	{

  if($form_theme_id != -1) {
    $requete=SQL_getonethemeName($form_theme_id);
    $result=$sql_object->DBSelect($requete);
    if($result==0 || count($result)!=1) exit;
    else $theme_denomination=formatText($result[0]['theme_name'], '2HTML');
  } else $theme_denomination=_t('divers','none');

  $requete=SQL_getonescaleDenomination($form_scale_id);
  $result=$sql_object->DBSelect($requete);
  if($result==0 || count($result)!=1) exit;
  else $scale_denomination=formatText($result[0]['scale_denomination'], '2HTML');

  $requete=SQL_getonepriorityName($form_priority_id);
  $result=$sql_object->DBSelect($requete);
  if($result==0 || count($result)!=1) exit;
  else $priority_name=formatText($result[0]['priority_name'], '2HTML');

  if($form_parent_id != -1) {
    $requete=SQL_getProjectName($form_parent_id);
    $result=$sql_object->DBSelect($requete);
    if($result==0 || count($result)!=1) exit;
    else $parent_name=formatText($result[0]['project_name'], '2HTML');
  } else $parent_name=_t('divers','none');

  if($form_workshop_id != -1) {
    $query=SQL_getWorkshopName($form_workshop_id);
    $result=$sql_object->DBSelect($query);
    if($result==0 || count($result)!=1) exit;
    else $workshop_name=formatText($result[0]['workshop_denomination'], '2HTML');
  } else $workshop_name=_t('divers','none');

  if(count($form_sdi) > 0) {
    $sdi_list='<ul style="padding:0">';
    foreach ($form_sdi as &$value) {
      $query=SQL_getSdiName($value);
      $result = $sql_object->DBSelect($query);
      if($result==0 || count($result)!=1) exit;
      else $sdi_list.= '<li>'.formatText($result[0]['sdii_name'], '2HTML').'</li>'.END_LINE;
    }
    $sdi_list.='</ul>';
  } else $sdi_list=_t('divers','none');

  ?>
<div class="contentcontainer"><?php
include_once($dir."/menurub.php");
?>
<div id="content">
<h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
<?php
echo "<dl class=\"dl3\">\n";
echo "<dt>"._t('project','name')."</dt>\n";
echo "<dd>". $form_name."</dd>\n";
echo "<dt>"._t('project','parent')."</dt>\n";
echo "<dd>". $parent_name."</dd>\n";
echo "<dt>". _t('project','description'). "</dt>\n";
echo "<dd>".empty_nc(linkin_content($form_description))."</dd>\n";
echo "<dt>"._t('project','body')." :</dt>\n";
echo "<dd>".linkin_content($form_body)."</dd>\n";
echo "<dt>"._t('project','begin_date')." :</dt>\n";
echo "<dd>".empty_nc($form_begin_date)."</dd>\n";
echo "<dt>"._t('project','estimated_date')." :</dt>\n";
echo "<dd>".empty_nc($form_estimated_date)."</dd>\n";
echo "<dt>"._t('project','end_date')." :</dt>\n";
echo "<dd>".empty_nc($form_end_date)."</dd>\n";
echo "<dt>"._t('project','priority')." :</dt>\n";
echo "<dd>".$priority_name."</dd>\n";
echo "<dt>"._t('project','theme')." :</dt>\n";
echo "<dd>".$theme_denomination."</dd>\n";
echo "<dt>"._t('project','scale')." :</dt>\n";
echo "<dd>".$scale_denomination."</dd>\n";
echo "<dt>"._t('project','workshop')." :</dt>\n";
echo "<dd>".$workshop_name."</dd>\n";
echo "<dt>"._t('project','sdi')." :</dt>\n";
echo "<dd>".$sdi_list."</dd>\n";
echo "<dt>"._t('divers','statut')."</dt>\n";
echo "<dd>". display_statut($_POST['project_statut']). "</dd>\n";
echo "</dl>\n";
?>
<form id="modscale" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"
	method="post">
<div><input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
<input name="data_table" type="hidden" value="<?php echo $table; ?>"
	id="data_table" /> <?php echo cancel_button('?rub=project&amp;todo=list'); ?>
<input name="retour" type="button"
	value="<?php echo _t('btn','preview'); ?>" class="button" id="retour"
	onclick="history.go(-1);" /> <input name="enregistrer" type="submit"
	value="<?php echo _t('btn','save'); ?>" class="button" id="valider" /></div>
</form>
</div>
<?php include_once($dir."/help.php"); ?></div>
<?php
}
?>
