<?php
/**
 * @package linea21.modules
 * @subpackage project
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
include_once('../config/define.php');
include_once('../lib/functions_auth.php');
include_once("./".SQL.".inc.php");
include_once("../class/system/class." . SQL . ".php");
$sql_entity = SQL;
$sql_object = new $sql_entity;
$sql_object->DBInitialise();
$sql_object->DBConnexion();

header('Content-type: application/xml; charset='.CHARSET);
$req_list_projects=SQL_getProjectsList(0, 999, '');
$items=$sql_object->DBSelect($req_list_projects);



$sxe = simplexml_load_string("<?xml version=\"1.0\" encoding=\"".CHARSET."\" ?><data></data>");

foreach($items as $item){

  $s_date = date_rfc2822($item['project_begin_date_display']);
  $es_date = date_rfc2822($item['project_estimated_date_display']);
  $e_date = date_rfc2822($item['project_end_date_display']);


  if($s_date != false) {

    $child = $sxe->addChild('event', formatText($item['project_description'], '2FILE'));
    $child->addAttribute('start', $s_date);


    if($e_date != false)  {
      $child->addAttribute('end', $e_date);
      $child->addAttribute('color', '#0a0');
      $child->addAttribute('durationEvent', 'true');
    } else {
      if($es_date != false) {
        $child->addAttribute('end', $es_date);
        $child->addAttribute('color', 'orange');
        $child->addAttribute('durationEvent', 'true');
      } else {
        $child->addAttribute('color', '#FC2916');
        $child->addAttribute('icon', '../templates/admin/default/images/timeline-red.png');
      }
    }
    $child->addAttribute('title', $item['complete_project_name']);
    $child->addAttribute('caption', $item['complete_project_name']);
    //$child->addAttribute('classname', 'hot_event');

    $child->addAttribute('link', '../admin/?rub=project&todo=det&id='.$item['project_id']);
  }
}

echo $sxe->asXML();

?>