<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once('../user/'.SQL.'.inc.php');

if(!function_exists('getPastEvents')) {
  function getPastEvents($nb) {
    global $sql_object;

    $data= $sql_object->DBSelect(SQLget_pastEvents($nb));

    if($data!=0)
    {
      $content= '<ul>';
      for($i=0; $i<count($data); $i++) {

        $link = array('rub'=> $GLOBALS['links'][U_L]['calendar']['linkvalue'],'id'=>$data[$i]['workcal_workshop_id'], '#' => 'cal-'.$data[$i]['workcal_id']);
        $workshop_title =  _t('name', 'workshop_module') .' : '.formatText($data[$i]['workshop_denomination'], '2ATT');
        $workshop_task= formatText($data[$i]['workcal_task'], '2HTML');

        $content.= '<li><a href="'.HrefMaker($link).'" title="'.$workshop_title.'" class="tips">'.$data[$i]['task_date'].' : '.$workshop_task.'</a></li>';
      }
      $content.= '</ul>';
    } else {
      $content= '<p>'._t('divers', 'nodata').'</p>';
    }
    return $content;
  }
}

if(!function_exists('getIncomingEvents')) {
  function getIncomingEvents($nb) {
    global $sql_object;

    $data= $sql_object->DBSelect(SQLget_incomingEvents($nb));

    if($data!=0)
    {
      $content= '<ul>';
      for($i=0; $i<count($data); $i++) {

        $link = array('rub'=> $GLOBALS['links'][U_L]['calendar']['linkvalue'],'id'=>$data[$i]['workcal_workshop_id'], '#' => 'cal-'.$data[$i]['workcal_id']);
        $workshop_title =  _t('name', 'workshop_module') .' : '.formatText($data[$i]['workshop_denomination'], '2ATT');
        $workshop_task= formatText($data[$i]['workcal_task'], '2HTML');

        $content.= '<li><a href="'.HrefMaker($link).'" title="'.$workshop_title.'" class="tips">'.$data[$i]['task_date'].' : '.$workshop_task.'</a></li>';
         
      }
      $content.= '</ul>';
    } else {
      $content= '<p>'._t('divers', 'nodata').'</p>';
    }
    return $content;
  }
}


if(!function_exists('getWorkgroupList')) {
  function getWorkgroupList($nb) {

    global $sql_object;

    $data= $sql_object->DBSelect(SQLget_WorkshopList($nb));

    if($data!=0)
    {
      $content= '<ul id="vnav">';
      for($i=0; $i<count($data); $i++) {

        $workshop_title=formatText($data[$i]['workshop_denomination'], '2HTML');
        $workshop_resume=formatText($data[$i]['workshop_resume'], '2HTML');
        $content.='<li><a href="#tabs-'.$i.'" class="selected" title="'.formatText($workshop_title, '2ATT').'">'.$workshop_title.'</a></li>'.END_LINE;

      }
      $content.='</ul>';

      for($i=0; $i<count($data); $i++) {
         
        $link = array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'],'id'=>$data[$i]['workshop_id'],'name'=>$data[$i]['workshop_denomination']);
        $workshop_title=formatText($data[$i]['workshop_denomination'], '2HTML');
        $workshop_resume=formatText($data[$i]['workshop_resume'], '2HTML');
        $content.= '<div id="tabs-'.$i.'" class="ie6bugfix">';
        $content.= '<h3>'.$workshop_title.'</h3>'.END_LINE;
        $content.= '<div>'.$workshop_resume.'</div>';
        $content.= '<p class="access"><a href="'.HrefMaker($link).'" title="'.formatText($workshop_title, '2ATT').'">'._t('access','workgroup').'</a></p>';
        $content.= '</div>';

      }
    }
    else
    {
      $content='<p class="info">'._t('divers','nodata').'</p>';
    }

    return $content;

  }
}

if(!function_exists('DisplayLastPublications')) {

  function DisplayLastPublications($nb) {
    $data=$GLOBALS['sql_object']->DBSelect(SQL_Get_LastPublications($nb));

    $content ='<div id="home_publication">'.END_LINE;
    $content.='<h2>'._t('public','last_news_h1').'</h2>'.END_LINE;

    $link_publi= array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue']);

    for($i=0; $i<count($data); $i++) {
      $publi_id=$data[$i]['publi_id'];
      $publi_title=formatText($data[$i]['publi_title'],'2HTML');
      $publi_resume=formatText($data[$i]['publi_resume'],'2HTML');
      $link_this= array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue'], 'id'=>$publi_id, 'name'=> $data[$i]['publi_title']);
       
      $content.='<div>';
      $content.='<h3>'.$publi_title.'</h3>';
      $content.='<a href="'.HrefMaker($link_this).'" title="'.formatText($GLOBALS['links'][U_L]['publication']['desc'].' : '.$publi_title, '2ATT').'">';
      $content.=$publi_resume;
      $content.='</a>';
      $content.='</div><br />';
    }
    //$content.='<a href="'.HrefMaker($link_publi).'" title="'.$GLOBALS['links'][U_L]['publication']['desc'].'">';
    //$content.='accéder à la liste des dossiers';
    //$content.='</a>';
    $content.='</div>	'.END_LINE;

    echo $content;
  }
}

if(!function_exists('DisplayEdito')) {

  function DisplayEdito() {
    $content ='<div id="home_edito">'.END_LINE;
    $content.='<h2>'._t('header', 'welcome').'</h2>'.END_LINE;
    $content.='<p>';
    $content.=_t('public','edito');
    $content.='</p>'.END_LINE;
    $content.='</div>';
    echo $content;
  }
}

if(!function_exists('DisplayGDT')) {

  function DisplayGDT() {
    $link_gdt= array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue']);

    $content ='<div id="home_top"><div id="home_gdt">'.END_LINE;
    $content.='<h2>'._t('public','workgroup_h1').'</h2>'.END_LINE;
    $content.='<p>';
    $content.='<a href="'.HrefMaker($link_gdt).'" title="'.formatText($GLOBALS['links'][U_L]['workgroup']['desc'], '2ATT').'">';
    $content.=_t('public','workgroup_edito');
    $content.='</a>';
    $content.='</p>'.END_LINE;
    $content.='</div>';
    echo $content;
  }
}

if(!function_exists('DisplayIDD')) {

  function DisplayIDD() {
    $link_idd= array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue']);
    $content ='<div id="home_idd">'.END_LINE;
    $content.='<h2>'._t('public','dashboard_h1').'</h2>'.END_LINE;
    $content.='<p>';
    $content.='<a href="'.HrefMaker($link_idd).'" title="'.formatText($GLOBALS['links'][U_L]['dashboard']['desc'], '2ATT').'">';
    $content.=_t('public','dashboard_edito');
    $content.='</a>';
    $content.='</p>'.END_LINE;
    $content.='</div></div>';
    echo $content;
  }
}


/**
 * DisplayMenu()
 * Affichage du menu
 *
 * @return void ( echo string )
 */
if(!function_exists('DisplayMenu')) {

  function DisplayMenu()
  {
    //$content .= '<a href="#contenu" class="semnone" title="'._t('header','goto_contents').'" accesskey="2">'._t('header','goto_contents').'</a>'.END_LINE;
    $content = '<ul>'.END_LINE;
    while (list($key, $value) = each ($GLOBALS['menuitems'])) {

      (ActiveItemAlias($GLOBALS['activeitem']) == $value) ? $classe = ' class="actif"' : $classe = '' ;
      $current_link = array('rub' => $GLOBALS['links'][U_L][$value]['linkvalue']);
      $content .= '<li id="menu_'.$value.'">';
      $content .= '<a href="' . HrefMaker($current_link) . '" title="' . $GLOBALS['links'][U_L][$value]['desc'] . '" accesskey="' . $GLOBALS['links'][U_L][$value]['accesskey'] . '" id="amenu_'.$value.'"'.$classe.'>' . $GLOBALS['links'][U_L][$value]['title'] . '</a>';
      $content .= '</li>' . END_LINE;
    }
    $content .= "</ul>";
    echo $content;
  }
}

/**
 * MyAccount()
 * Renvoie les liens de creation de compte ou de déconnexion
 * suivant le statut de l'utilisateur
 *
 * @return string content
 */
if(!function_exists('MyAccount')) {

  function MyAccount()
  {
    $link_account = array('rub' => $GLOBALS['links'][U_L]['user-prefs']['linkvalue']);
    $content  = '<div>';
    if (isset($_COOKIE['linea21']['whois'])) {
      $content .= '<h3>'._t('header','welcome'). ' '.$_COOKIE['linea21']['login'].',</h3>';
      $str = ucfirst(_t('divers','myprofile'));
    } else {
      $content .= '<h3>'._t('header','myaccount').'</h3>';
      $str = ucfirst(_t('divers','auth'));
    }
    $content .= '<ul id="account">' . END_LINE;
    $content .= '<li><a href="' . HrefMaker($link_account) . '" accesskey="u" title="'._t('header','myaccount_title').'">' . $str . '</a></li>';
    $link_create = array('rub' => $GLOBALS['links'][U_L]['user-registration']['linkvalue']);
    $link_logout = array('rub' => $GLOBALS['links'][U_L]['logout']['linkvalue']);
    if (isset($_COOKIE['linea21']['whois'])) $content .= '<li><a href="' . HrefMaker($link_logout) . '" accesskey="l" title="'._t('header','deconnexion_title').'">' . ucfirst(_t('header','deconnexion')) . '</a></li>';
    else $content .= '<li><a href="' . HrefMaker($link_create) . '" accesskey="c" title="'._t('divers','user_inscription_title').'">' . _t('divers','user_inscription') . '</a></li>';
    $content .= '</ul></div>' . END_LINE;
    echo $content;
  }
}

/**
 * forgotPass()
 * Formulaire envoi d'un mot de passe
 *
 * @param string $todo
 * @return void (echo string)
 */
if(!function_exists('forgotPass')) {

  function forgotPass($back = 1 )
  {
    if($back=== 1) $back=$_SERVER['HTTP_REFERER'];
    $input_hidden = $GLOBALS['links'][U_L]['forgot-password']['linkvalue'];

    $link_pass = array('rub' => $GLOBALS['links'][U_L]['forgot-password']['linkvalue']);

    if(isset($_POST['valid'])) {
      $r = loginAuth($_POST['login']);
      if(!($r)) {
        $msg = '<div class="error">'.sprintf(_t('auth', 'no_user'), $login).'</div>';
      } else {
        include_once('../class/class.user.php');
        $user = new user;
        $key = $user->generateNewPasskey($r['user_id'], $GLOBALS['sql_object']);

        if($key != false) {
          $todo_mail = 'forgot_pass';
          $user_email = $r['profile_email'];
          $link_pass = array('rub' => $GLOBALS['links'][U_L]['forgot-password']['linkvalue'], 'token' => $key);
          include_once(themePath('../user/mail_actions.php'));
          include_once('../mail/template.php');
          $msg =  '<div class="info">'.sprintf(_t('auth', 'sending_mail'), $user_email).'</div>';
        }
      }
    }

    $form = '<p>'. _t('auth','note') . '</p>' . END_LINE;
    if(isset($msg)) $form .= $msg . END_LINE;
    $form .= '<form action="index.php" method="post">' . END_LINE;
    $form .= '<div id="forgot_pass">' . END_LINE;
    $form .= '<label for="login" class="labelised">' . _t('divers','login') . ' : </label>' . END_LINE;
    $form .= '<input type="text" maxlength="20" class="shorttextfield" name="login" id="login" />' . END_LINE;
    $form .= '<br />'.END_LINE;

    $form .= '<br />'.END_LINE;
    $form .= '<input type="hidden" name="rub" id="rub" value="' . $input_hidden . '" />' . END_LINE;
    $form .= '<input type="hidden" name="referer" id="referer" value="' . $back . '" />' . END_LINE;
    $form .= '<input type="submit" class="submitbut" value="'._t('btn','valid').'" title="'._t('btn','valid').'" size="15" name="valid" id="valid" />'.END_LINE;
    $form .= '</div>' . END_LINE;
    $form .= '</form>' . END_LINE;

    return $form;
  }
}

/**
 * AuthForm()
 * Formulaire d'authentification pour login ou inscription
 *
 * @param string $todo
 * @return void (echo string)
 */
if(!function_exists('AuthForm')) {

  function AuthForm($todo = 'LOGON', $back = 1 )
  {
    if($back=== 1) $back = $_SERVER['HTTP_REFERER'];

    if ($todo == 'LOGON') {
      $input_hidden = $GLOBALS['links'][U_L]['user-prefs']['linkvalue'];
      $div_id = 'logon';
    } else {
      $input_hidden = $GLOBALS['links'][U_L]['user-registration']['linkvalue'];
      $div_id = 'subscribe';
    }
    $link_pass = array('rub' => $GLOBALS['links'][U_L]['forgot-password']['linkvalue']);
    $form = '<form action="index.php" method="post">' . END_LINE;
    $form .= '<div id="' . $div_id . '">' . END_LINE;
    $form .= '<label for="login" class="labelised">' . _t('divers','login') . ' : </label>' . END_LINE;
    $form .= '<input type="text" maxlength="20" class="shorttextfield" name="login" id="login" />' . END_LINE;
    $form .= '<br />'.END_LINE;
    if ($todo == 'LOGON') {
      $form .= '<label for="password" class="labelised">' . _t('divers','password') . ' : </label>' . END_LINE;
      $form .= '<input type="password" maxlength="20" class="shorttextfield" name="password" id="password" />' . END_LINE;
      $form .= '<p class="forgot_pass"><a href="'.HrefMaker($link_pass).'">'._t('auth', 'forgot_password').'</a></p>';
    } else {
      $form .= '<label for="email" class="labelised">' . _t('divers','email') . ' : </label>' . END_LINE;
      $form .= '<input type="text" maxlength="100" class="shorttextfield" name="email" id="email" />' . END_LINE;
    }
    $form .= '<br />'.END_LINE;
    $form .= '<input type="hidden" name="rub" id="rub" value="' . $input_hidden . '" />' . END_LINE;
    $form .= '<input type="hidden" name="referer" id="referer" value="' . $back . '" />' . END_LINE;
    $form .= '<input type="submit" class="submitbut" value="'._t('btn','valid').'" title="'._t('btn','valid').'" size="15" name="valid" id="valid" />'.END_LINE;
    $form .= '</div>' . END_LINE;
    $form .= '</form>' . END_LINE;

    return $form;
  }
}

/**
 * MyGroups()
 * Return groups user has subscribed to
 * nothing if no groups
 * @return string
 */
if(!function_exists('MyGroups')) {
  function MyGroups()
  {

    if(!isset($_COOKIE['linea21']['workshop'])) return false;

    global $sql_object;

    $link_account = array('rub' => $GLOBALS['links'][U_L]['user-prefs']['linkvalue']);

    // get and prepare user groups
    $groups = base64_decode($_COOKIE['linea21']['workshop']);
    if($groups[0]=='/') $groups = substr($groups, 1); // removing first separator
    if(!empty($groups)) {
      $groups = @explode('/',$groups);
      $data= $sql_object->DBSelect(SQL_Get_WorkshopsNames($groups));
    } else {
      $data=0;
    }

    $content  = '<div id="mygroups">'.END_LINE;
    $content .= '<h3>'._t('groups', 'mine').'</h3>'.END_LINE;
    if($data!=0)
    {
      $content .= '<ul>';
      for($i=0; $i<count($data); $i++) {

        $link = array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'],'id'=>$data[$i]['workshop_id']);
        $workshop_title =  formatText($data[$i]['workshop_denomination'], '2HTML');

        $content .= '<li><a href="'.HrefMaker($link).'" title="'.formatText($data[$i]['workshop_denomination'], '2ATT').'">'.$workshop_title.'</a></li>';
         
      }
      $content .= '</ul>';
    } else {
      return false;
    }
    $content .= '</div>';

    return $content;
  }
}
?>