<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

if(!function_exists('DisplayProjectBoard')) {
  function DisplayProjectBoard() {
    $content ='';
    if(ActiveItemKey($GLOBALS['activeitem']) == 'home') {
      $content .= '<a href="'.HrefMaker(array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'])).'" title="'.$GLOBALS['links'][U_L]['project']['title'].'">'.$GLOBALS['links'][U_L]['project']['title'].'</a>';
      $content .= '<br />';
    }
    echo $content;
  }
}

if(!function_exists('DisplayNewsletterForm')) {
  function DisplayNewsletterForm() {
    $action=$GLOBALS['links'][U_L]['subscribe-newsletter']['linkvalue'];
    $form  = '<form action="index.php" method="post">' . END_LINE;
    $form .= '<div id="newsletter_form">' . END_LINE;
    $form.= '<h3>'._t('menu_alt','newsletter').'</h3>';
    $form .= '<label for="newsletteremail">' . _t('divers','email') . ' : </label>' . END_LINE;
    $form .= '<input type="text" maxlength="200" size="19" class="shorttextfield" name="newsletteremail" id="newsletteremail" />' . END_LINE;
    $form .= '<input type="submit" value="'._t('btn','valid').'" alt="'._t('btn','valid').'" title="'._t('btn','valid').'" size="15" name="valid"  id="valid_newsletter" />'.END_LINE;
    $form .='<br />';
    $form .= '<input type="checkbox" name="del_action" id="del_action" style="float:left;margin:0em 1em 0 3.2em" />';
    $form .= '<input type="hidden" name="rub" id="rub_newsletter" value='.$GLOBALS['links'][U_L]['subscribe-newsletter']['linkvalue'].' />' . END_LINE;
    $form .= '<label for="del_action" class="checkboxlab">'._t('newsletter','unsubscribe').'</label>' . END_LINE;
    $form .= '</div>' . END_LINE;
    $form .= '</form>' . END_LINE;

    echo $form;
  }
}

if(!function_exists('DisplayBoardLastNews')) {
  function DisplayBoardLastNews($nb) {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_Get_NewsBoard($nb));

    $content = '<div id="recentnews">'.END_LINE;
    //$content.= '<p>'._t('divers','actu_left').'</p>';
    $content.= '<h3>'._t('divers','actu_left').'</h3>';
    if($data!=0)
    {
      $content.= '<ul>'.END_LINE;
      for($i=0; $i<count($data); $i++) {
        $title=formatText($data[$i]['news_title'],'2HTML');
        $link_table= array('rub'=> $GLOBALS['links'][U_L]['news']['linkvalue'],'id'=>$data[$i]['news_id'], 'name' => $data[$i]['news_title']);
        $content.='<li><a href="'.HrefMaker($link_table).'" title="'.formatText($GLOBALS['links'][U_L]['news']['desc'].' : '.$title, '2ATT').'">'.$title.'</a>';
        #$content.='<em>'._t('statut', 'published_on').' '.$data[$i]['news_published_date_display'].'</em>'.END_LINE;
        $content.='</li>'.END_LINE;
      }
      $content.= '</ul>'.END_LINE;
    }
    else
    {
      $content.=_t('divers','nodata');
    }
    $content.= '</div>'.END_LINE;

    echo $content;
  }
}

if(!function_exists('DisplayBoardLastSdi')) {
  function DisplayBoardLastSdi() {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_Get_SdiBoard());

    $content = '<div id="recentSdi">'.END_LINE;
    $content.= '<h3>'._t('divers','sdi_left').'</h3>';
    if($data!=0)
    {
      $content.= '<ul>'.END_LINE;
      $test=array();
      for($i=0; $i<count($data); $i++) {
        if (!in_array($data[$i]['sdii_id'], $test) && count($test)<3){
          $test[$i]=$data[$i]['sdii_id'];
          $title=formatText($data[$i]['sdii_name'],'2HTML');
          $link_table= array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'],'id'=>$data[$i]['sdii_id'], 'parentid'=>$data[$i]['sdiv_scale'], 'name' => $data[$i]['sdii_name'] );
          $content.='<li><a href="'.HrefMaker($link_table).'" title="'.formatText($GLOBALS['links'][U_L]['dashboard']['desc'].' : '.$title, '2ATT').'">'.$title.'</a>';
          $content.='</li>'.END_LINE;
        }
      }
      $content.= '</ul>'.END_LINE;
    }
    else
    {
      $content.=_t('divers','nodata');
    }
    $content.= '</div>'.END_LINE;

    echo $content;
  }
}


if(!function_exists('DisplaySearchForm')) {
  function DisplaySearchForm() {

    $action=$GLOBALS['links'][U_L]['search-result']['linkvalue'];
    $form ='<form action="index.php" method="get">'.END_LINE;
    $form .='<div id="searchinput">'.END_LINE;
    $form.= '<h3>'._t('menu','search').'</h3>';
    $form.='<br /><label for="search">'._t('menu','search').' </label>'.END_LINE;
    $form.='<input type="text" maxlength="100" size="15" name="search" id="search" accesskey="4" class="shorttextfield" />'.END_LINE;
    $form.= '<input type="hidden" name="rub" id="rub_search" value='.$GLOBALS['links'][U_L]['search-result']['linkvalue'].' />' . END_LINE;
    $form.='<input type="submit" value="'._t('btn','valid').'" size="15" name="valid" id="validsearch" />'.END_LINE;
    $form.='<p id="searchadv">';
    $form.='<a href="'.HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['search']['linkvalue'])).'" title="'.formatText($GLOBALS['links'][U_L]['search']['title'], '2ATT').'">';
    $form.=_t('menu','advancedsearch');
    $form.='</a>';
    $form.='</p>';
    $form.='</div>'.END_LINE;
    $form.='</form>'.END_LINE;


    echo $form;
  }
}

if(!function_exists('DisplayFooterleft')) {
  function DisplayFooterleft() {
    $content='<a href="mailto:'.SITE_MAIL.'" ';
    $content.='title="'.SITE_MAIL.'" >'._t('divers','contact').' </a> | ';
    $content.='<a href="'.HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['accessibility']['linkvalue'])).'" ';
    $content.='title="'.formatText(_t('divers','accessibility'), '2ATT').'" accesskey="0"> '._t('divers','accessibility').' </a>  | <a href="rss2.php" title="RSS">rss</a><br />';
    echo $content;
  }
}

?>