<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>


<?php
// set HTML Title
SetHTMLTitle('Carta d\'accessibilità Linea21');
setBreadcrumb(array('Carta d\'accessibilità Linea21' => false));
?>

<div id="accessibilita">
<h1>Carta d'accessibilità Linea21</h1>
<div class="h1_comment" id="h1_accessibility">Questo sito è concepito
per essere letto da tutti gli internauti, indipendentemente dai loro
handicap, dal mezzo utilizzato e dall'hardware.</div>


<h2>Access key</h2>
<p>La maggiorparte dei naviganti autorizza l'esecuzione dei link
attraverso una combinazione di tasti definita sul sito. Sotto Windows,
digitate alt + una chiave d'accesso. Sotto Macintosh, digitate ctrl +
una chiave d'accesso. <br />
Tutte le pagine di questo sito contengono questi <span xml:lang="en">accesskey</span>
:</p>
<dl>
	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['accessibility']['accesskey'] ?></kbd>
	:</dt>
	<dd>Carta d'accessibilità</dd>
	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['home']['accesskey'] ?></kbd>
	:</dt>
	<dd>Home</dd>
	<dt xml:lang="en">Access key <kbd>2</kbd> :</dt>
	<dd>Contenuto</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['search']['accesskey'] ?></kbd>
	:</dt>
	<dd>Ricerca</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['news']['accesskey'] ?></kbd>
	:</dt>
	<dd>News</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['project']['accesskey'] ?></kbd>
	:</dt>
	<dd>Progetti</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['directory']['accesskey'] ?></kbd>
	:</dt>
	<dd>Rubrica</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['workgroup']['accesskey'] ?></kbd>
	:</dt>
	<dd>Gruppi di lavoro</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['publication']['accesskey'] ?></kbd>
	:</dt>
	<dd>Cartella</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['dashboard']['accesskey'] ?></kbd>
	:</dt>
	<dd>Pannello di controllo</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['user-prefs']['accesskey'] ?></kbd>
	:</dt>
	<dd>Account utenti</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['user-registration']['accesskey'] ?></kbd>
	:</dt>
	<dd>Creazione account</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['logout']['accesskey'] ?></kbd>
	:</dt>
	<dd>Disconenssione</dd>
</dl>
<br style="clear: both;" />
<h2 style="margin-top: 1em">Rispetto degli standard</h2>
<ul>
	<li>Tutte le pagine di questo sito sono state convalidate <abbr
		title="eXtensible HyperText Markup Language">XHTML</abbr> 1.0 Strict</li>
	<li>Tutte le pagine di questo sito sono state testate con <a
		href="http://www-3.ibm.com/able/solution_offerings/hpr.html"
		title="Information" xml:lang="en" hreflang="en">Home Page Reader 3.0
	(IBM® Accessibility Tool)</a>.</li>
	<li>Tutte le pagine di questo sito rispettano i valori semantici. i
	tags H1 sono utilizzati per i titoli principali i tags H2 per i
	sottotitoli. Per esempio, in questa pagina, gli utenti del software <abbr
		title="Job Access With Speech">JAWS</abbr> possono accedere alla
	sezione seguente tramite la seguente combinazione di tasti :
	ALT+INSERT+3</li>
</ul>


<h2>Aiuto alla navigazione</h2>
<ul>
	<li>Tutte le pagine di questo sito contengono gli elementi di
	navigazione e di relazione tra esse. <br />
	<pre>
			<code>
&lt;link rel="home" title="home" href="home" /&gt;
&lt;link rel="search" title="ricerca" href="ricerca" /&gt;
&lt;link rel="help" title="Carta d'accessibilità Linea21" href="accessibilita" /&gt;
			</code>
		</pre></li>
	<li>La home page e tutte le altre pagine includono un campo di ricerca
	(access key <kbd>4</kbd>).</li>
</ul>

<h2>Link</h2>
<ul>
	<li>La maggior parte dei link hanno un attributo "titolo" che descrive
	il link in dettaglio.</li>
	<li>I link sono scritti per avere un senso fuori contesto.</li>
	<li>I linguaggi di script sono utilizzati per migliorare il confort di
	navigazione, tuttavia la loro disattivazione non comporta nessuna
	restrizione di accessibilità al contenuto e alla navigazione.</li>
</ul>

<h2>Immmagini</h2>
<ul>
	<li>Tutte le immagini decorative sono incluse sotto forma di stile <abbr
		title="Cascadind Style Sheet">CSS</abbr>.</li>
	<li>Le immagini relative al contenuto utilizzano tutti i tags
	descrittivi <acronym title="Alternative">Alt</acronym>.</li>
</ul>

<h2>Moduli</h2>
<ul>
	<li>Uno sforzo è stato fatto per rendere i moduli accessibili :
	l'utilizzo del tag 'LABEL' associa un senso ad ogni campo.</li>
</ul>

<h2>Visual design</h2>
<ul>
	<li>Questo sito utilizza i fogli di stile in cascata (<abbr
		title="Cascadind Style Sheet">CSS</abbr>) per la presentazione
	grafica. Se il vostro browser non supporta <abbr
		title="Cascadind Style Sheet">CSS</abbr>, il contenuto del sito resta
	leggibile.</li>
	<li>Questo sito utilizza esclusivamente delle dimensioni dei caratteri
	relative, compatibili con l'opzione "dimensioni del testo" specificata
	dall'utente nel visual browser. Attraverso la scorciatoia <kbd>ctrl +
	rotella del mouse</kbd>, potete cambiare la dimensione del testo.</li>
</ul>

<h2>Fogli di stile alternativi</h2>
<ul>
	<li>Questo sito può essere sfogliato con i fogli di stile alternativi
	disponibili in basso nella pagina :</li>
	<li>Sono disponibili quattro stili : bianco e nero, minimale, classico,
	e senza stile.</li>
</ul>

<h2>Avvertenze - responsabilità</h2>
<ul>
	<li>Il contenuto pubblicato su questo sito non proviene da <a
		href="<?php echo SITE_LINEA_URL; ?>">Linea21</a>, non possiamo
	garantire un'accessibilità perfetta dei dati contenuti alla radice
	dell'applicazione.</li>
	<li>Non esitate a segnalarci i punti deboli o a renderci partecipi
	delle vostre osservazioni relative all'accessibilità dell'informazione
	contenuta in questo sito : <a href="mailto:<?php echo MAIL_LINEA; ?>"><?php echo MAIL_LINEA; ?></a></li>
</ul>

<h2>Riferimenti</h2>
<ul>
	<li><a href="http://handy.univ-lyon1.fr/access/"
		title="per la Missione handicap dell'Universit&agrave; Claude Bernard Lyon I">Traduzione
	francese delle norme</a> della <abbr
		title="Web Accessibility Initiative">WAI</abbr> sull'accessibilità.</li>
	<li><a href="http://www.la-grange.net/accessibilite/index.html"
		title="Perchè devo rendere il mio sito Web più accessibile ? Come posso rendere il mio sito web più accessibile ?">Immergetevi
	nell'accessibilità</a> : traduzione francese di Karl Dubost di un testo
	molto pedagogico scritto da Mark Pilgrim.</li>
</ul>

<h2>Utility gratuite</h2>
<ul>
	<li><a href="http://validator.w3.org/" hreflang="en">W3C MarkUp
	Validation Service</a> : controllo della sintassi delle pagine <abbr
		title="HyperText Markup Language ">HTML</abbr> et <abbr
		title="eXtensible HyperText Markup Language">XHTML</abbr>.</li>
	<li><a href="http://jigsaw.w3.org/css-validator/" hreflang="en">W3C CSS
	Validation service</a> : controllo di conformità sintattica dei fogli
	di stile in cascata.</li>
	<li><a href="http://bobby.watchfire.com/bobby/html/en/index.jsp"
		title="La versione gratuita on line permette di testare una pagina alla volta"
		hreflang="en">Bobby</a> : utility di controllo on line della
	conformità della pagine in rapporto alle raccomandazioni della <abbr
		title="Web Accessibility Initiative">WAI</abbr> e del governo
	americano per ciò che riguarda l'accessibilità.</li>
	<li><a href="http://www.w3.org/People/Raggett/tidy/"
		title="Clean up your Web pages with HTML TIDY" hreflang="en"><abbr
		title="HyperText Markup Language ">HTML</abbr> Tidy</a> : un utility
	che corregge rapidamente la maggior parte degli errori di sintassi del
	linguaggio <abbr title="HyperText Markup Language ">HTML</abbr> ed
	offre qualche consiglio di accessibilità.</li>
	<li><a href="http://www.delorie.com/web/wpbcv.html" hreflang="en">Web
	Page Backward Compatibility Viewer</a> : permette di rendersi conto
	dell'aspetto di una pagina Web all'interno di un software più vecchio o
	meno potente.</li>
	<li><a href="http://lynx.isc.org/release/"
		title="Pagina della distribuzione stabile di Lynx" hreflang="en">Lynx</a>
	: un browser in modalità testo.</li>
	<li><a href="http://artax.karlin.mff.cuni.cz/~mikulas/links/"
		title="Sorgenti del programma Links" hreflang="en">Links</a> : un
	altro browser in modalità testo, per Unix e OS/2.</li>
</ul>
</div>
