<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>

<?php
if( ActiveItemKey($GLOBALS['activeitem']) =='subscribe-newsletter') {
  // set HTML Title
  SetHTMLTitle(_t('newsletter','subscribe_title'));
  setBreadcrumb(array(_t('newsletter','subscribe_title') => false));
  include_once('../newsletter/subscribe.php');
  echo '<h1>'._t('newsletter','subscribe_title').'</h1>';
  echo '<div class="h1_comment" id="h1_newsletter">';
  echo _t('divers','newsletter_public_comment').'</div>';
  if(isset($msg)) {
    echo '<div class="'.$msg['code'].'">';
    echo $msg['string'];
    echo '</div>';
  }
}

if( ActiveItemKey($GLOBALS['activeitem']) =='contact') {
  // set HTML Title
  SetHTMLTitle(_t('contact','contact_us'));
  setBreadcrumb(array(_t('contact','contact_us') => false));
  include_once('../class/system/class.form.php');

  $name='';
  $email='';
  $subject='';
  $body='';

  if(isset($_POST['name'])) {
    $passed = true;
    $name=$_POST['name'];
    $email=$_POST['email'];
    $subject=$_POST['subject'];
    $body=$_POST['body'];

    if(strlen($body)< 8) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'body'));
      $class='error';
      $passed = false;
    }
    if(strlen($subject)< 3) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'subject'));
      $class='error';
      $passed = false;
    }
    if(!validEmail($email)) {
      $msg=sprintf(_t('contact','email_error'), $email);
      $class='error';
      $passed = false;
    }
    if(strlen($email)< 3) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'email'));
      $class='error';
      $passed = false;
    }
    if(strlen($name)< 3) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'name'));
      $class='error';
      $passed = false;
    }
    if($passed == true) {
      $class = 'info';
      $msg = _t('contact', 'message_sent');
      $email_dest = SITE_MAIL;
      $email_fromname = $name;
      $email_from = $email;
      $email_subject = formatText($subject, '2HTML') . ' - '. SITE_NAME;
      $email_html_body = formatText($body, '2HTML');
      $email_text_body = stripslashes($email_html_body);
      include_once(themePath('../mail/template.php'));
    }
  }

  echo '<h2>'._t('contact','contact_us').'</h2>'.END_LINE;
  echo '<div id="contact">'.END_LINE;
  if(isset($passed)) echo '<div class="'.$class.'">'.$msg.'</div>'.END_LINE;

  if(!isset($passed) || $passed == false) {
    $form = new genForm;
    $form->startForm('index.php', '#contactform');
    $form->textInput('name', _t('contact', 'name'). ' : ', 'shorttextfield', 'labelised', 'title', 100, 30, false, $name, false);
    $form->insertBR();
    $form->textInput('email', _t('contact', 'email'). ' : ', 'shorttextfield', 'labelised', 'title', 150, 30, false, $email, false);
    $form->insertBR();
    $form->textInput('subject', _t('contact', 'subject'). ' : ', 'shorttextfield', 'labelised', 'title', 150, 30, false, $subject, false);
    $form->insertBR();
    $form->textareaInput('body',ucfirst(_t('contact', 'body')) .' : ',false,'labelised', false, $body, 60, 10);
    $form->insertBR();
    $form->submitButton(false, _t('btn', 'valid'), true, 'submitbut');
    $form->hiddenInput('rub', $_REQUEST['rub']);
    $form->closeForm();
    if(!$output = $form->getForm()) { die("error: " . $form->error); }
    else { echo $output; }
  }
  echo '</div>'.END_LINE;
}

if(ActiveItemKey($GLOBALS['activeitem']) =='css-switch') {
  include_once(themePath('../lib/styleswitcher.php'));
  if(isset($msg)) {
    echo '<div class="'.$msg['code'].'">';
    echo $msg['string'];
    echo '</div>';
  }
}
?>





