<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>

<?php
include_once(themePath('../search/display.php'));

if(ActiveItemKey($GLOBALS['activeitem'])=='search-result') {
  SetHTMLTitle(_t('search','section')); // set HTML title
  SetHTMLTitle(_t('search','result')); // set HTML title
  setBreadcrumb(array(ucfirst(_t('search','section')) => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['search']['linkvalue']))));
  setBreadcrumb(array(ucfirst(_t('search','result')) => false));
  echo '<h1>'._t('search','result').'</h1>';

  if(!isset($_REQUEST['search']) || strlen($_REQUEST['search'])<=3) {
    echo '<div class="info">';
    echo _t('search','min_length');
    echo '</div>';
  } else {
    $str=strip_tags($_REQUEST['search']);
    $searchtype=isset($_REQUEST['searchtype']) ? $_REQUEST['searchtype'] : 'one';
    echo '<h2>'._t('search','keywords') .'\''.formatText($str,'2HTML').'\'</h2>'.END_LINE;

    $start_time = getmicrotime();
    DisplayPublicResults($str, $searchtype);
    $end_time = getmicrotime();
    DisplayQueryTime($start_time, $end_time);
    logfile(LOG_KEYWORDS,array($str, 'PUBLIC', $searchtype, i2c_realip()));
  }
}

if(ActiveItemKey($GLOBALS['activeitem'])=='search') {
  SetHTMLTitle(_t('menu','advancedsearch')); // set HTML title
  setBreadcrumb(array(ucfirst(_t('menu','advancedsearch')) => false));
  echo '<h1>'._t('menu','advancedsearch').'</h1>';

  DisplayAdvancedSearchForm();
}
?>





