<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once('../class/system/class.form.php');

isset($_COOKIE['linea21']['login']) ?  $isAuthentified = true : $isAuthentified = false;

if(isset($_REQUEST['id'])) {
  $_POST['workgroup_'.$_REQUEST['id']] = true;
  $link_back = HrefMaker(array('rub'=>$GLOBALS['links'][U_L]['workgroup']['linkvalue'], 'id'=> $_REQUEST['id']));
}
$link_registration = array('rub'=> $GLOBALS['links'][U_L]['user-registration']['linkvalue']);
$link_account = array('rub'=> $GLOBALS['links'][U_L]['user-prefs']['linkvalue']);

function ischecked($id) {
  if(isset($_POST['workgroup_'.$id]))  return true;
  else return false;
}

function isWgselected($workgroups) {
  for($i=0; $i<count($workgroups); $i++) {
    $var = 'workgroup_'.$workgroups[$i]->workshop_id;
    if(isset($_POST[$var])) return true;
  }
  return false;
}

function getSelectedwg($workgroups) {
  $a = array();
  for($i=0; $i<count($workgroups); $i++) {
    $var = 'workgroup_'.$workgroups[$i]->workshop_id;
    if(isset($_POST[$var])) array_push($a, $workgroups[$i]->workshop_id);
  }

  return $a;
}
?>

<?php
// set HTML Title
SetHTMLTitle(_t('workshop','get_involve_long'));
setBreadcrumb(array(_t('workshop','get_involve') => false));

// workshops
$workgroups = $GLOBALS['sql_object']->DBSelect(SQL_Get_WorkshopsNames(), 'OBJECT');
?>

<h1><?php echo _t('workshop','get_involve_long'); ?></h1>

<div><?php

$comment='';

if(isset($_POST['comment'])) {

  $msg='';

  // sélection d'au moins un groupe
  if (!isWgselected($workgroups)) $msg.=_t('workshop','nogroup_selected').'<br />';
  else {
    $groups='';
    $data=$GLOBALS['sql_object']->DBSelect(SQL_Get_WorkshopsNames(getSelectedwg($workgroups)), 'OBJECT');

    foreach($data as $el) {
      $groups.= " - ".$el->workshop_denomination. " <i>(id: ".$el->workshop_id.")</i><br />\n";
    }
  }

  if(empty($msg)) {
    $passed = true;
    $class='confirm';
    $msg .= _t('workshop', 'confirm_request');
    if(isset($link_back)) $msg .= ' <a href="'.$link_back.'" title="'._t('workshop','workshop_back').'" >'._t('workshop','workshop_back').'</a>.'.END_LINE;
    $linkuser = 'index.php?rub=user&todo=mod&id='.$_COOKIE['linea21']['id'];

    /** include email template */
    $a['action']='workgroup_request';
    include_once(themePath('../workshop/mail_actions.php'));
    include_once(themePath('../mail/template.php'));

  } else {
    $passed = false;
    $class='error';
  }
}

if(isset($passed)) echo '<div class="'.$class.'">'.$msg.'</div>';

if(!$isAuthentified) {

  echo '<p class="warning">'._t('workshop','note_account').' ' . '<a href="'.HrefMaker($link_account).'" title="'.formatText(_t('divers','auth'), '2ATT').'" >'._t('divers','auth').'</a>.<br />'.END_LINE;
  echo '<a href="'.HrefMaker($link_registration).'">'._t('user','info_inscription2').' </a></p>';

} else {
  // affichage s'il manque un champs
  if(!isset($passed) || $passed== false) {

    $form = new genForm;
    $form->startForm('index.php', '#wg-subscription');
    $form->insertHTML('<div id="choosegdt">'._t('workshop','subscribe_to').' : </div>');

    for($i=0; $i<count($workgroups); $i++) {
      if(!CookieWorkshopid($workgroups[$i]->workshop_id)) { // we remove the workgroups user already belongs to
        $form->checkboxInput('checkbox','workgroup_'.$workgroups[$i]->workshop_id, $workgroups[$i]->workshop_id, $workgroups[$i]->workshop_denomination, ischecked($workgroups[$i]->workshop_id), 'after', 'cb', 'labelised');
      }
    }
    $form->insertBR();
    $form->textareaInput('comment',ucfirst(_t('divers', 'comment')).' ('._t('divers', 'optional').') : ',false,'labelised', false, $comment, 60, 10);
    $form->insertBR();
    $form->submitButton(false, _t('btn', 'valid'), true, 'submitbut');
    $form->hiddenInput('rub', $_REQUEST['rub']);
    if(isset($_REQUEST['id'])) $form->hiddenInput('id', $_REQUEST['id']);
    $form->closeForm();
    if(!$output = $form->getForm()) { die("error: " . $form->error); }
    else { echo $output; }

  }
}

?></div>
