<?php
/**
 * @package linea21.modules
 * @subpackage publication
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

$req_list_theme = "SELECT T.theme_id, T.theme_name, T.theme_statut, SDT.sdtheme_name, SDT.sdtheme_id FROM " . T_THEME . " AS T LEFT OUTER JOIN ". T_SD_THEME ." AS SDT ON SDT.sdtheme_id=T.theme_sd_theme WHERE T.theme_statut  <> 'E' ORDER BY sdtheme_name DESC, theme_name ASC;";
$req_list_level = "SELECT level_id, level_name FROM " . T_LEVEL. " WHERE level_statut<>'E' ORDER BY level_range DESC;";
$req_list_scale = "SELECT scale_id, scale_denomination FROM " . T_SCALE . " WHERE scale_statut='P' OR scale_statut='D' ORDER BY scale_denomination ASC;";

$req_quickbox_add = "SELECT publi_id, LEFT(publi_title, 50) as publi_title, DATE_FORMAT(publi_date_crea, '".toStringSqlDate('long')."') AS publi_date_crea_display FROM " . T_PUBLI . " WHERE publi_statut  = 'P' OR publi_statut = 'D'  ORDER BY publi_date_crea DESC LIMIT 0 , 10;";
$req_quickbox_sup = "SELECT publi_id,  LEFT(publi_title, 50) as publi_title, DATE_FORMAT(publi_last_modify, '".toStringSqlDate('long')."') AS publi_last_modify_display, DATE_FORMAT(publi_date_crea, '".toStringSqlDate()."') AS publi_date_crea_display FROM " . T_PUBLI . " WHERE publi_statut = 'E' ORDER BY publi_last_modify DESC LIMIT 0 , 10;";
$req_quickbox_mod = "SELECT publi_id, LEFT(publi_title, 50) as publi_title, DATE_FORMAT(publi_last_modify, '".toStringSqlDate('long')."') AS publi_last_modify_display, DATE_FORMAT(publi_date_crea, '".toStringSqlDate()."') AS publi_date_crea_display FROM " . T_PUBLI . " WHERE publi_statut  <> 'E' ORDER BY publi_last_modify DESC LIMIT 0 , 10;";
$req_quickbox_list = "SELECT publi_id,  LEFT(publi_title, 50) as publi_title, DATE_FORMAT(publi_published_date, '".toStringSqlDate('long')."') AS publi_published_date_display, DATE_FORMAT(publi_date_crea, '".toStringSqlDate()."') AS publi_date_crea_display FROM " . T_PUBLI . " WHERE publi_statut <> 'E' AND  publi_published_date <> '0001-01-01' ORDER BY publi_published_date DESC LIMIT 0 , 10;";


function SQL_getPublicationList($debut, $limite = SELECT_LIMIT, $statut=-1, $filter= -1, $id_filter=-1) {
  switch ($statut) {
    case 'public':
      $mask=" WHERE publi_statut = 'P'";
      $orderby="publi_published_date DESC";
      break;
    case 'draft':
      $mask=" WHERE publi_statut = 'D'";
      $orderby="publi_date_crea DESC";
      break;
    case 'archives_a':
      $mask=" WHERE publi_statut = 'AA'";
      $orderby="publi_last_modify DESC";
      break;
    case 'archives_p':
      $mask=" WHERE publi_statut = 'PA'";
      $orderby="publi_last_modify DESC";
      break;
    default:
      $mask=" WHERE publi_statut <> 'E'";
      $orderby="publi_date_crea DESC";
      break;
  }
  switch ($filter) {
    case 'THEME':
      $mask.=" AND theme_sd_theme = '".$id_filter."'";
      break;
    case 'SCALE':
      $mask.=" AND publi_scale = '".$id_filter."'";
      break;
    case 'LEVEL':
      $mask.=" AND publi_level = '".$id_filter."'";
      break;
    default:
      $mask.="";
      break;
  }
  $requete=	"SELECT U.user_login, P.publi_id, LEFT(P.publi_title, 60) AS publi_title, ".
				"P.publi_title AS complete_publi_title, P.publi_statut, ".
				"publi_resume, publi_level, publi_scale, publi_statut, SDT.sdtheme_id, SDT.sdtheme_name, ".
			  	"scale_denomination, level_name, publi_posted_by, ".
				"DATE_FORMAT(P.publi_date_crea, '".toStringSqlDate()."') AS publi_date_crea_display, ".
			  	"DATE_FORMAT(P.publi_published_date, '".toStringSqlDate()."') AS publi_published_date_display, ".
			  	"DATE_FORMAT(P.publi_last_modify, '".toStringSqlDate()."') AS publi_last_modify_display ".
				"FROM " . T_PUBLI." AS P ".
				"LEFT OUTER JOIN ".T_THEME." AS T on P.publi_theme=T.theme_id ".
				"LEFT OUTER JOIN ".T_SD_THEME." AS SDT on T.theme_sd_theme=SDT.sdtheme_id ".
				"LEFT OUTER JOIN ".T_SCALE." AS S on publi_scale=S.scale_id ".
				"LEFT OUTER JOIN ".T_LEVEL." AS L on publi_level=L.level_id ".
			 	"LEFT OUTER JOIN ".T_USER." AS U on P.publi_posted_by=U.user_id ".

  $mask." ORDER BY ".$orderby." LIMIT ".$debut." , ".$limite.";";
  #echo $requete;
  return $requete;
}

function SQL_getCountPublicationList($statut=-1, $filter=-1, $id_filter=-1) {
  switch ($statut) {
    case 'public':
      $mask=" WHERE publi_statut = 'P'";
      break;
    case 'draft':
      $mask=" WHERE publi_statut = 'D'";
      break;
    case 'archives_a':
      $mask=" WHERE publi_statut = 'AA'";
      break;
    case 'archives_p':
      $mask=" WHERE publi_statut = 'PA'";
      break;
    default:
      $mask=" WHERE publi_statut <> 'E'";
      break;
  }
  switch ($filter) {
    case 'THEME':
      $mask.=" AND theme_sd_theme = '".$id_filter."'";
      break;
    case 'SCALE':
      $mask.=" AND publi_scale = '".$id_filter."'";
      break;
    case 'LEVEL':
      $mask.=" AND publi_level = '".$id_filter."'";
      break;
    default:
      $mask.="";
      break;
  }
  $requete= "SELECT COUNT(publi_id) AS num_rows FROM " . T_PUBLI ." ";
  if($filter=='THEME') {
    $requete.=	"LEFT OUTER JOIN ".T_THEME." AS T on publi_theme=T.theme_id ".
					"LEFT OUTER JOIN ".T_SD_THEME." AS SDT on theme_sd_theme=SDT.sdtheme_id ";
  }
  $requete.=$mask.";";

  return $requete;
}

function SQL_getoneCompletePublication($publi_id) {
  $requete =	"SELECT P.publi_title, P.publi_resume, P.publi_theme, P.publi_scale, P.publi_level, P.publi_posted_by, P.publi_comment, P.publi_statut, ".
				"T.theme_name, S.scale_denomination, L.level_name, U.user_login, T.theme_sd_theme, SDT.sdtheme_name, ".
				"DATE_FORMAT(P.publi_date_crea, '".toStringSqlDate()."') AS publi_date_crea_display, ".
				"DATE_FORMAT(P.publi_last_modify, '".toStringSqlDate('long')."') AS publi_last_modify_display, ".
				"DATE_FORMAT(P.publi_published_date, '".toStringSqlDate()."') AS publi_published_date_display ".
				"FROM " . T_PUBLI . " AS  P ".
				"LEFT OUTER JOIN ".T_THEME." AS T on P.publi_theme=T.theme_id ".
				"LEFT OUTER JOIN ".T_SD_THEME." AS SDT on T.theme_sd_theme=SDT.sdtheme_id ".
				"LEFT OUTER JOIN ".T_SCALE." AS S on P.publi_scale=S.scale_id ".
				"LEFT OUTER JOIN ".T_LEVEL." AS L on P.publi_level=L.level_id ".
				"LEFT OUTER JOIN ".T_USER." AS U on P.publi_posted_by=U.user_id ".
				"WHERE publi_id='".$publi_id."' AND publi_statut<>'E';";
  #echo $requete;
  return $requete;
}

if(!function_exists('SQL_getPublicationParts')) {
  function SQL_getPublicationParts($publi_id) {
    $requete =	"SELECT PC.publicon_id, PC.publicon_title FROM " . J_PARTS ." AS JP ".
				"LEFT OUTER JOIN ".T_PUBLI_CONT." AS PC ON  JP.j_parts_id=PC.publicon_id ".
				"WHERE  JP.j_root_id='".$publi_id."' AND JP.j_type='P' AND publicon_validity='Y' ORDER BY PC.publicon_date_crea ASC;";
    return $requete;
  }
}

if(!function_exists('SQL_getPublicationTitle')) {
  function SQL_getPublicationTitle($publi_id) {
    $requete =	"SELECT publi_title, publi_posted_by FROM " . T_PUBLI . " WHERE publi_id='".$publi_id."';";
    return $requete;
  }
}

function SQL_getonethemeName($theme_id) {
  $requete ="SELECT theme_name FROM " . T_THEME . " WHERE theme_id='".$theme_id."';";
  return $requete;
}

function SQL_getonescaleDenomination($scale_id) {
  $requete="SELECT scale_denomination FROM " . T_SCALE . " WHERE scale_id='".$scale_id."';";
  return $requete;
}

function SQL_getonelevelName($level_id) {
  $requete="SELECT level_name FROM " . T_LEVEL . " WHERE level_id='".$level_id."';";
  return $requete;
}

// Copie conforme de celle qui se trouve dans workshoprep
function SQL_GetResources($ID, $type, $ressource, $sql_object)
{
  switch ($ressource) {
    case 'BIBLIO':
      $TDB_LIAISON = J_BIBLIO;
      $ACTIVE_TABLE = T_BIBLIO_RES;
      $join_active="bibliores";
      $champ2="j_biblio_id";
      break;
    case 'LINK':
      $TDB_LIAISON = J_LINK;
      $ACTIVE_TABLE = T_LINK_RES;
      $join_active="linkres";
      $champ2="j_link_id";
      break;
    case 'MULTI':
      $TDB_LIAISON = J_MULTI;
      $ACTIVE_TABLE = T_MULTI_RES;
      $join_active="multires";
      $champ2="j_multi_id";
      break;
    default:
      return false;
  }

  $requete = "SELECT * FROM " . $ACTIVE_TABLE . " LEFT OUTER JOIN ".$TDB_LIAISON." ON ".$champ2."=".$join_active."_id WHERE j_root_id='".$ID."' AND j_type='".substr($type, 0, 1)."' AND ".$join_active."_validity='Y' ORDER BY ".$join_active."_date_crea ASC;";
  //echo $requete;
  $result = $sql_object -> DBSelect ($requete);

  return $result;
}


?>
