<?php
/**
 * @package linea21.utils
 * @subpackage report_sdi
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) PDF report
 */

ob_start();
include_once('../config/define.php');
include_once('../languages/'.U_L.'/lang_common.' . CHARSET . '.php');
include_once('../languages/'.U_L.'/lang_sdi.' . CHARSET . '.php');
include_once('../languages/'.U_L.'/lang_dashboard.' . CHARSET . '.php');
include_once('../lib/functions_auth.php');
include_once('phpsql.process.php');

include_once('pdf.report.inc.php');

require('../class/system/tcpdf/idd_pdf.php');

SureRemoveDir('tmp', 1);

# bench start tag
$start_time=getmicrotime();
$pdf = new idd_pdf('P', 'mm', 'A4');
$pdf->Open();

#inclusion propriétés du document
include_once('pdf.doc_define.php');

#inclusion page de garde
include_once('pdf.firstpage.php');

for($i=0; $i<count($sdi); $i++) {
  DisplayOneSdi($i);
}

#inclusion sommaire
if($report_settings['summary']===true) include_once('pdf.summary.php');

# bench stop tag
$stop_time=getmicrotime();

$total_time=(float) $stop_time-$start_time;

#inclusion page d'infos de génération
if($report_settings['publi_infos']===true) include_once('pdf.lastpage.php');

# sortie pdf
$pdf->Output('rapport'.date("dmY_His").'.pdf', $report_settings['file']);
ob_end_flush();

SureRemoveDir('tmp', 1);
?>