<?php
/**
 * @package linea21.modules
 * @subpackage resources
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Resource' module is used by 'Publication' and 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

$complete_type=strtoupper($mod_inc);
if($type=='P') {
  $requete= SQL_getPublicationTitle($parent);
  $result=$sql_object->DBSelect($requete);
  $current_title=FormatText($result[0]['publi_title'], '2HTML');
  $publi_owner=$result[0]['publi_posted_by'];

  //////////// Check Droits utilisateur ////////////
  if (!HaveRight('publication')) ReloadIndex('admin');
  if (GetSessionElement('id')!=$publi_owner && !IsSuperAdmin()) ReloadIndex('admin');
  ///////////
}
if($type=='W') {
  $requete= SQL_getWorkshopRepTitleAndGroup($parent);
  $result=$sql_object->DBSelect($requete);
  $current_title=FormatText($result[0]['workrep_title'].' ('.$result[0]['workshop_denomination'].')', '2HTML');
  $workshop_id=$result[0]['workrep_workshop_id'];

  //////////// Check Droits utilisateur ////////////
  if (!HaveRight('workshop')) ReloadIndex('admin');
  if (!AuthUser4Workshop($workshop_id, $sql_object) && !IsSuperAdmin()) ReloadIndex('admin');
  ///////////
}
?>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a>
	</li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>"
		class="chemin_rub"><?php echo _t('menu',$mod_inc); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('resources',$mod_inc.'_type')." : ". $current_title); ?></span>
	</li>
</ul>
</div>
<!--end barre haute -->
<?php
$form_name='';
$form_description='';
$form_url='';
$mask_localisation_IN='';
$mask_localisation_OUT='checked="checked"';


$resources_object= new resources;

if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$resources_object->AddMultiRes($parent, $data_table, $complete_type, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&type=".$type."&id=".$parent;
  if($result===true) header("Location: ".$link_confirm);
  else  system_error();
}

if(isset($_POST['valider'])) {
  $table[0]=$_POST['multi_name'];
  $table[1]=$_POST['multi_description'];
  $table[2]=$_POST['multi_url'];
  $table[3]=0; // range
  $table[4]=$_POST['multi_localisation'];

  if($_POST['multi_localisation']=='OUT') {
    $display_localisation=_t('resources','multi_file_out');
    $mask_localisation_OUT='checked="checked"';
    $mask_localisation_IN='';
  } else {
    $table[2]=$resources_object->M_URI_INPUT.$table[2];
    $display_localisation=_t('resources','multi_file_in');
  }

  $integrity=$resources_object->CheckDataIntegrity($table,'MULTI');

  if(is_string($integrity)) {
    $text_format='2FIELD';
  } else {
    $text_format='2HTML';
  }
  $form_name=formatText($_POST['multi_name'], $text_format);
  $form_description=formatText($_POST['multi_description'], $text_format);
  $form_url=formatText($_POST['multi_url'], $text_format);

  $table=urlencode(serialize($table));
}


include_once(THEME_ADMIN_PATH."quickicons.php");

?>

<?php
if(!isset($integrity) || is_string($integrity)) {
  ?>
<div class="contentcontainer"><?php
include_once($dir."/menurub.php");
?>
<div id="content"><?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2($current_title); ?></h2>
<form id="addmulti" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"
	method="post">
<p><label for="multi_name"><?php echo _t('resources','multi_name'); ?> :
*</label> <input name="multi_name" type="text" class="textfield"
	id="multi_name" maxlength="200" value="<?php echo $form_name; ?>" /></p>
<p><label for="multi_description"><?php echo _t('resources','multi_description'); ?>
: *</label> <textarea id="multi_description" name="multi_description"
	class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_description; ?></textarea>
</p>
<p><label for="multi_localisation_IN"><?php echo _t('resources','multi_situ'); ?>
: *</label> <input name="multi_localisation" type="radio"
	id="multi_localisation_IN" value="IN" class="radio"
	<?php echo $mask_localisation_IN; ?> /><span class="radio"><?php echo _t('resources','multi_file_in'); ?></span>
<input name="multi_localisation" type="radio"
	id="multi_localisation_OUT" value="OUT" class="radio"
	<?php echo $mask_localisation_OUT; ?> /><span class="radio"><?php echo _t('resources','multi_file_out'); ?></span>
</p>
<p><label for="multi_url"><?php echo _t('resources','url'); ?> : *</label>
<input name="multi_url" type="text" class="textfield" id="multi_url"
	maxlength="255" value="<?php echo $form_url; ?>" /></p>
<div><input name="rub" type="hidden" value="<?php echo $rub; ?>"
	id="rub" /> <input name="todo" type="hidden"
	value="<?php echo $todo; ?>" id="todo" /> <input name="type"
	type="hidden" value="<?php echo $type; ?>" id="type" /> <input
	name="parent" type="hidden" value="<?php echo $parent; ?>" id="parent" />
	<?php echo cancel_button($cancel_link); ?> <input name="valider"
	type="submit" value="<?php echo _t('btn','valid') ?>" class="button"
	id="valider" /></div>
</form>
</div>
	<?php include_once($dir."/help.php"); ?></div>
	<?php
	// Récapitulatif
} else	{

  ?>
<div class="contentcontainer"><?php
include_once($dir."/menurub.php");
?>
<div id="content">
<h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
<?php
echo "<dl class=\"dl3\">\n";
echo "<dt>"._t('resources','multi_name')."</dt>\n";
echo "<dd>".$form_name."</dd>\n";
echo "<dt>"._t('resources','multi_description')."</dt>\n";
echo "<dd>".$form_description."</dd>\n";
echo "<dt>"._t('resources','multi_situ')."</dt>\n";
echo "<dd>".$display_localisation."</dd>\n";
echo "<dt>"._t('resources','url')."</dt>\n";
echo "<dd>".$form_url."</dd>\n";
echo "</dl>\n";
?>
<form id="addmulti" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"
	method="post">
<div><input name="rub" type="hidden" value="<?php echo $rub; ?>"
	id="rub" /> <input name="todo" type="hidden"
	value="<?php echo $todo; ?>" id="todo" /> <input name="type"
	type="hidden" value="<?php echo $type; ?>" id="type" /> <input
	name="parent" type="hidden" value="<?php echo $parent; ?>" id="parent" />
<input name="data_table" type="hidden" value="<?php echo $table; ?>"
	id="data_table" /> <input name="retour" type="button"
	value="<?php echo _t('btn','preview') ?>" class="button" id="retour"
	onclick="history.go(-1);" /> <input name="enregistrer" type="submit"
	value="<?php echo _t('btn','save') ?>" class="button" id="valider" /></div>
</form>
</div>
<?php include_once($dir."/help.php"); ?></div>
<?php
}
?>
