
--
-- Table structure for table bibliography_resources
--

DROP TABLE IF EXISTS l21_bibliography_resources;
CREATE TABLE l21_bibliography_resources (  bibliores_id SERIAL,  bibliores_author varchar(200) NOT NULL default '',  bibliores_title varchar(255) NOT NULL default '',  bibliores_sub_title varchar(255) NOT NULL default '',  bibliores_editor varchar(255) NOT NULL default '',  bibliores_date varchar(100) NOT NULL default '',  bibliores_range int NOT NULL default '0',  bibliores_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  bibliores_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  bibliores_validity char(1) NOT NULL default 'Y',  PRIMARY KEY  (bibliores_id)) ;


--
-- Table structure for table category_user
--

DROP TABLE IF EXISTS l21_category_user;
CREATE TABLE l21_category_user (  catus_id SERIAL,  catus_name varchar(100) NOT NULL default '',  catus_description varchar(255) NOT NULL default '',  catus_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  catus_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  PRIMARY KEY  (catus_id)) ;


-- --------------------------------------------------------

--
-- Table structure for table email_collector
--

DROP TABLE IF EXISTS l21_email_collector;
CREATE TABLE l21_email_collector (  emailcol_id SERIAL,  emailcol_email varchar(200) NOT NULL default '',  emailcol_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  emailcol_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  emailcol_validity char(1) NOT NULL default 'Y', PRIMARY KEY  (emailcol_id)) ;


-- --------------------------------------------------------
--
-- Table structure for table j_biblio
--

DROP TABLE IF EXISTS l21_j_biblio;
CREATE TABLE l21_j_biblio (  j_root_id int NOT NULL default '0',  j_biblio_id int NOT NULL default '0',  j_type char(1) NOT NULL default 'P') ;


-- --------------------------------------------------------
--
-- Table structure for table j_link
--

DROP TABLE IF EXISTS l21_j_link;
CREATE TABLE l21_j_link (  j_root_id int NOT NULL default '0',  j_link_id int NOT NULL default '0',  j_type char(1) NOT NULL default 'P') ;


-- --------------------------------------------------------
--
-- Table structure for table j_multi
--

DROP TABLE IF EXISTS l21_j_multi;
CREATE TABLE l21_j_multi (  j_root_id int NOT NULL default '0',  j_multi_id int NOT NULL default '0',  j_type char(1) NOT NULL default 'P') ;


-- --------------------------------------------------------
--
-- Table structure for table j_parts
--

DROP TABLE IF EXISTS l21_j_parts;
CREATE TABLE l21_j_parts ( j_root_id int NOT NULL default '0', j_parts_id int NOT NULL default '0', j_type char(1) NOT NULL default 'P' ) ;


-- --------------------------------------------------------
-- 
-- Table structure for table `j_project_sdi`
-- 

DROP TABLE IF EXISTS l21_j_project_sdi;
CREATE TABLE l21_j_project_sdi (  jps_project_id int NOT NULL default '0',  jps_sdi_id int NOT NULL default '0') ;


-- --------------------------------------------------------
--
-- Table structure for table j_work_users
--

DROP TABLE IF EXISTS l21_j_work_users;
CREATE TABLE l21_j_work_users (  jwu_id SERIAL,  jwu_workshop_id int NOT NULL default '0',  jwu_user_id int NOT NULL default '0',  jwu_user_right char(1) NOT NULL default 'U',  PRIMARY KEY  (jwu_id)) ;


-- --------------------------------------------------------
--
-- Table structure for table level
--

DROP TABLE IF EXISTS l21_level;
CREATE TABLE l21_level (  level_id SERIAL,  level_name varchar(200) NOT NULL default '',  level_description text NOT NULL default '',  level_comment text NOT NULL default '',   level_visual_identity varchar(100) NOT NULL default '',  level_range int NOT NULL default '0',  level_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  level_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  level_statut char(1) NOT NULL default 'P',  PRIMARY KEY  (level_id))  ;


-- --------------------------------------------------------

--
-- Table structure for table link_resources
--

DROP TABLE IF EXISTS l21_link_resources;
CREATE TABLE l21_link_resources (  linkres_id SERIAL,  linkres_text text NOT NULL,  linkres_mask varchar(200) NOT NULL default '',  linkres_range int NOT NULL default '0',  linkres_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  linkres_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  linkres_validity char(1) NOT NULL default 'Y', PRIMARY KEY  (linkres_id)) ;


-- --------------------------------------------------------
--
-- Table structure for table multimedia_resources
--

DROP TABLE IF EXISTS l21_multimedia_resources;
CREATE TABLE l21_multimedia_resources (  multires_id SERIAL,  multires_name varchar(200) NOT NULL default '',  multires_description text NOT NULL,  multires_media_uri varchar(255) NOT NULL default '',  multires_range int NOT NULL default '0',  multires_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  multires_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  multires_validity char(1) NOT NULL default 'Y', PRIMARY KEY  (multires_id)) ;


-- --------------------------------------------------------
--
-- Table structure for table news
--

DROP TABLE IF EXISTS l21_news;
CREATE TABLE l21_news (  news_id SERIAL,  news_title varchar(200) NOT NULL default '',  news_header text NOT NULL,  news_body text NOT NULL,  news_theme int NOT NULL default '0',  news_scale int NOT NULL default '0',  news_level int NOT NULL default '0',  news_template int NOT NULL default '0',  news_photo_uri varchar(255) NOT NULL default '',  news_range int NOT NULL default '0',  news_posted_by int NOT NULL default '0',  news_published_date timestamp NOT NULL default CURRENT_TIMESTAMP,  news_perempt_date timestamp NOT NULL default CURRENT_TIMESTAMP,  news_is_national char(1) NOT NULL default 'N', news_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  news_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  news_statut varchar(2) NOT NULL default 'D',   PRIMARY KEY  (news_id)) ;


-- --------------------------------------------------------
--
-- Table structure for table newsletter
--

DROP TABLE IF EXISTS l21_newsletter;
CREATE TABLE l21_newsletter (  newsletter_id SERIAL,  newsletter_title varchar(200) default NULL,  newsletter_body text NOT NULL,  newsletter_posted_by int NOT NULL default '0',  newsletter_published_date timestamp NOT NULL default CURRENT_TIMESTAMP,  newsletter_date_crea timestamp default CURRENT_TIMESTAMP,  newsletter_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  newsletter_statut char(1) NOT NULL default 'D',  PRIMARY KEY  (newsletter_id) ) ;


-- --------------------------------------------------------
--
-- Table structure for table profile
--

DROP TABLE IF EXISTS l21_profile;
CREATE TABLE l21_profile (  profile_id SERIAL,  profile_email varchar(200) NOT NULL default '',  profile_email_display char(1) NOT NULL default 'Y',  profile_city varchar(100) NOT NULL default '',  profile_birthdate date NOT NULL default '0001-01-01',  profile_leisures varchar(150) NOT NULL default '',  profile_job varchar(150) NOT NULL default '',   profile_avatar varchar(255) NOT NULL default '',  profile_quotation varchar(150) NOT NULL default '',  profile_signature varchar(200) NOT NULL default '',  profile_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  profile_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  PRIMARY KEY  (profile_id))  ;


-- --------------------------------------------------------

--
-- Table structure for table publication
--

DROP TABLE IF EXISTS l21_publication;
CREATE TABLE l21_publication (  publi_id SERIAL,  publi_title varchar(200) NOT NULL default '',  publi_resume text NOT NULL,  publi_theme int NOT NULL default '0',  publi_scale int NOT NULL default '0',  publi_level int NOT NULL default '0',  publi_posted_by int NOT NULL default '0',  publi_published_date timestamp NOT NULL default CURRENT_TIMESTAMP,  publi_comment text NOT NULL,  publi_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  publi_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  publi_statut varchar(2) NOT NULL default 'D',  PRIMARY KEY  (publi_id)) ;



--
-- Table structure for table publication_contents
--

DROP TABLE IF EXISTS l21_publication_contents;
CREATE TABLE l21_publication_contents (  publicon_id SERIAL,  publicon_title varchar(200) NOT NULL default '',  publicon_body text NOT NULL,  publicon_template int NOT NULL default '0',  publicon_photos_uri varchar(255) NOT NULL default '',  publicon_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  publicon_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  publicon_validity char(1) NOT NULL default 'Y',   PRIMARY KEY  (publicon_id) ) ;


-- --------------------------------------------------------
--
-- Table structure for table rights
--

DROP TABLE IF EXISTS l21_rights;
CREATE TABLE l21_rights (  rights_id SERIAL,  rights_dashboard char(1) NOT NULL default 'U',  rights_workshop char(1) NOT NULL default 'U',  rights_project char(1) NOT NULL default 'U',   rights_publication char(1) NOT NULL default 'U',   rights_news char(1) NOT NULL default 'U',  rights_yellowpages char(1) NOT NULL default 'U',   rights_theme char(1) NOT NULL default 'U',   rights_scale char(1) NOT NULL default 'U',   rights_level char(1) NOT NULL default 'U',   rights_category_user char(1) NOT NULL default 'U',   rights_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  rights_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  PRIMARY KEY  (rights_id))  ;


-- --------------------------------------------------------
--
-- Table structure for table scale
--

DROP TABLE IF EXISTS l21_scale;
CREATE TABLE l21_scale (  scale_id SERIAL,  scale_denomination varchar(200) NOT NULL default '',  scale_surface real NOT NULL default '0',  scale_inhabitantsnumber bigint NOT NULL default '0',  scale_root int NOT NULL default '0',  scale_comment text NOT NULL default '',  scale_dependencies int NOT NULL default '0',  scale_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  scale_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  scale_statut char(1) NOT NULL default 'P',   PRIMARY KEY  (scale_id))  ;


-- --------------------------------------------------------


-- --------------------------------------------------------
--
-- Table structure for table sd_theme
--

DROP TABLE IF EXISTS l21_sd_theme;
CREATE TABLE l21_sd_theme (  sdtheme_id SERIAL,  sdtheme_name varchar(150) NOT NULL default '',  sdtheme_description text NOT NULL,  sdtheme_range int NOT NULL default '0',  sdtheme_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  sdtheme_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  PRIMARY KEY  (sdtheme_id))  ;


-- --------------------------------------------------------

--
-- Table structure for table sdi_evaluation
--

DROP TABLE IF EXISTS l21_sdi_evaluation;
CREATE TABLE l21_sdi_evaluation (  sdie_id SERIAL,  sdie_scale_compare int NOT NULL default '0',  sdie_fiability int NOT NULL default '0',  sdie_accessibility int NOT NULL default '0',  sdie_lisibility int NOT NULL default '0',  sdie_relevance int NOT NULL default '0',  sdie_global_performance int NOT NULL default '0',  sdie_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  sdie_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  PRIMARY KEY  (sdie_id)) ;


-- --------------------------------------------------------
--
-- Table structure for table sdi_info
--

DROP TABLE IF EXISTS l21_sdi_info;
CREATE TABLE l21_sdi_info (  sdii_id SERIAL,  sdii_name varchar(255) NOT NULL default '',  sdii_description text NOT NULL,  sdii_comment text NOT NULL,  sdii_theme int NOT NULL default '0',  sdii_range int NOT NULL default '0',  sdii_goal text NOT NULL,  sdii_consulting text NOT NULL,  sdii_unit varchar(100) NOT NULL default '',  sdii_max_value real NOT NULL default '0',  sdii_min_value real NOT NULL default '0',  sdii_threshold_value real NOT NULL default '0',  sdii_threshold_relative char(1) NOT NULL default 'Y',   sdii_frequency int NOT NULL default '0',  sdii_provider int NOT NULL default '0',  sdii_evaluation int NOT NULL default '0',  sdii_reglementation int NOT NULL default '0',  sdii_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  sdii_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  sdii_statut char(1) NOT NULL default 'P',  PRIMARY KEY  (sdii_id) ) ;



-- --------------------------------------------------------
--
-- Table structure for table sdi_provider
--

DROP TABLE IF EXISTS l21_sdi_provider;
CREATE TABLE l21_sdi_provider (  sdip_id SERIAL,  sdip_name varchar(255) NOT NULL default '',  sdip_service varchar(255) NOT NULL default '',  sdip_description text NOT NULL default '',  sdip_incharge varchar(150) NOT NULL default '',  sdip_address text NOT NULL default '',  sdip_phone varchar(10) NOT NULL default '',  sdip_fax varchar(12) NOT NULL default '',  sdip_email varchar(200) NOT NULL default '',  sdip_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  sdip_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  PRIMARY KEY  (sdip_id)) ;


-- --------------------------------------------------------
--
-- Table structure for table sdi_reglementation
--

DROP TABLE IF EXISTS l21_sdi_reglementation;
CREATE TABLE l21_sdi_reglementation (  sdir_id SERIAL,  sdir_title varchar(255) NOT NULL default '',  sdir_body text NOT NULL,  sdir_referer_uri text NOT NULL,  sdir_mask_uri varchar(255) NOT NULL default '',  sdir_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  sdir_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  PRIMARY KEY  (sdir_id)) ;


-- --------------------------------------------------------
--
-- Table structure for table sdi_value
--

DROP TABLE IF EXISTS l21_sdi_value;
CREATE TABLE l21_sdi_value (  sdiv_id SERIAL,  sdiv_value real NOT NULL default '0',  sdiv_sdi_info int NOT NULL default '0',  sdiv_scale int NOT NULL default '0',  sdiv_date_published timestamp NOT NULL default CURRENT_TIMESTAMP,  sdiv_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  sdiv_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  sdiv_statut char(1) NOT NULL default 'P',  PRIMARY KEY  (sdiv_id)) ;



-- --------------------------------------------------------
--
-- Table structure for table theme
--

DROP TABLE IF EXISTS l21_theme;
CREATE TABLE l21_theme (  theme_id SERIAL,  theme_name varchar(200) NOT NULL default '',  theme_visual_uri varchar(255) NOT NULL default '',  theme_sd_theme int NOT NULL default '0',  theme_desc_project text NOT NULL default '',  theme_desc_dashboard text NOT NULL default '',  theme_desc_publication text NOT NULL default '',  theme_desc_news text NOT NULL default '',  theme_desc_workshop text NOT NULL default '',  theme_range_project int NOT NULL default '0',  theme_range_dashboard int NOT NULL default '0',  theme_range_publication int NOT NULL default '0',  theme_range_news int NOT NULL default '0',  theme_range_workshop int NOT NULL default '0',  theme_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  theme_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  theme_statut char(1) NOT NULL default 'P', PRIMARY KEY  (theme_id)) ;





-- --------------------------------------------------------
--
-- Table structure for table user
--

DROP TABLE IF EXISTS l21_user;
CREATE TABLE l21_user (  user_id SERIAL,  user_login varchar(20) NOT NULL default '',  user_password varchar(20) NOT NULL default '',  user_community int NOT NULL default '0',  user_category int NOT NULL default '0',  user_rights int NOT NULL default '0',  user_profile int NOT NULL default '0', user_forget_passkey varchar(50) DEFAULT NOT NULL default '', user_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  user_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  user_validity char(1) NOT NULL default 'Y',  PRIMARY KEY  (user_id)) ;



-- --------------------------------------------------------
--
-- Table structure for table workshop
--

DROP TABLE IF EXISTS l21_workshop;
CREATE TABLE l21_workshop (  workshop_id SERIAL,  workshop_denomination varchar(255) NOT NULL default '',  workshop_resume text NOT NULL default '',  workshop_theme int NOT NULL default '0',  workshop_comment text NOT NULL,  workshop_level int NOT NULL default '0',  workshop_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  workshop_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  workshop_statut varchar(2) NOT NULL default 'D', PRIMARY KEY  (workshop_id) ) ;


-- --------------------------------------------------------
--
-- Table structure for table workshop_calendar
--

DROP TABLE IF EXISTS l21_workshop_calendar;
CREATE TABLE l21_workshop_calendar (  workcal_id SERIAL,  workcal_task_date timestamp NOT NULL default CURRENT_TIMESTAMP,  workcal_task varchar(200) NOT NULL default '',  workcal_task_details text NOT NULL,  workcal_workshop_id int NOT NULL default '0',  workcal_posted_by int NOT NULL default '0',  workcal_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  workcal_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  workcal_validity char(1) NOT NULL default 'Y',   PRIMARY KEY  (workcal_id)) ;


-- --------------------------------------------------------
--
-- Table structure for table workshop_com
--

DROP TABLE IF EXISTS l21_workshop_com;
CREATE TABLE l21_workshop_com (  workcom_id SERIAL,  workcom_subject varchar(200) NOT NULL default '',  workcom_body text NOT NULL,  workcom_parent int NOT NULL default '0',  workcom_workshop_id int NOT NULL default '0',  workcom_user_id int NOT NULL default '0',  workcom_last_user_id int NOT NULL default '0',  workcom_viewed int NOT NULL default '0', workcom_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  workcom_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  workcom_statut char(1) NOT NULL default 'P',   PRIMARY KEY  (workcom_id) ) ;


-- --------------------------------------------------------
--
-- Table structure for table workshop_report
--

DROP TABLE IF EXISTS l21_workshop_report;
CREATE TABLE l21_workshop_report (  workrep_id SERIAL,  workrep_title varchar(200) NOT NULL default '',  workrep_resume text NOT NULL,  workrep_workshop_id int NOT NULL default '0',  workrep_published_date timestamp NOT NULL default CURRENT_TIMESTAMP,  workrep_comment text NOT NULL default '',  workrep_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  workrep_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP, workrep_statut varchar(2) NOT NULL default 'D',  PRIMARY KEY  (workrep_id)) ;


-- --------------------------------------------------------
--
-- Table structure for table workshop_report_contents
--

DROP TABLE IF EXISTS l21_workshop_report_contents;
CREATE TABLE l21_workshop_report_contents (  workrepcon_id SERIAL,  workrepcon_title varchar(100) NOT NULL default '',  workrepcon_body text NOT NULL,  workrepcon_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  workrepcon_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  workrepcon_validity char(1) NOT NULL default 'Y',  PRIMARY KEY  (workrepcon_id)) ;


-- --------------------------------------------------------
--
-- Table structure for table yellowpages
--

DROP TABLE IF EXISTS l21_yellowpages;
CREATE TABLE l21_yellowpages (  yellowp_id SERIAL,  yellowp_name varchar(150) NOT NULL default '',  yellowp_activity varchar(255) NOT NULL default '',  yellowp_theme int NOT NULL default '0',  yellowp_street varchar(200) NOT NULL default '',  yellowp_postal_code varchar(6) NOT NULL default '',  yellowp_city varchar(100) NOT NULL default '',  yellowp_country varchar(100) NOT NULL default '',  yellowp_phone varchar(12) NOT NULL default '',  yellowp_fax varchar(12) NOT NULL default '',  yellowp_email varchar(150) NOT NULL default '',  yellowp_website varchar(150) NOT NULL default '',  yellowp_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  yellowp_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  yellowp_statut varchar(2) NOT NULL default 'D',  PRIMARY KEY  (yellowp_id)) ;

-- 
-- Creating the **Priority** table
--
DROP TABLE IF EXISTS l21_priority;
CREATE TABLE l21_priority (  priority_id SERIAL,  priority_name varchar(255) NOT NULL,  priority_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  priority_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  PRIMARY KEY  (priority_id));



-- 
-- Creating the **Project** table
--
DROP TABLE IF EXISTS l21_project;
CREATE TABLE l21_project (  project_id SERIAL,  project_parent_id int default '0',  project_priority_id int default '0',  project_name varchar(255) NOT NULL,  project_scale_id int NOT NULL,  project_theme_id int NOT NULL,  project_description text,  project_body text NOT NULL,  project_begin_date timestamp default NULL,  project_estimated_date timestamp default NULL,  project_end_date timestamp default NULL,  project_workshop_id int NOT NULL,  project_posted_by int NOT NULL,  project_published_date timestamp NOT NULL default CURRENT_TIMESTAMP,  project_date_crea timestamp NOT NULL default CURRENT_TIMESTAMP,  project_last_modify timestamp NOT NULL default CURRENT_TIMESTAMP,  project_statut varchar(2) NOT NULL default 'D',  PRIMARY KEY  (project_id)) ;
