<?php
/**
 * @package linea21.templates
 * @subpackage admin
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @param  $rub : connu de admin/index.php
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

/**
 * displayitem()
 * affichage des items du menu. Prise en charge de leur ETAT : actif ou non
 *
 * @param string $rubactive
 * @param string $currentrub
 * @param string $accesskey
 * @return string $content
 */

function displayitem($rubactive, $currentrub, $accesskey)
{
  $content = "<li><a href=\"index.php?rub=" . $currentrub . "\" accesskey=\"" . $accesskey . "\" title=\"" . $GLOBALS['lang']['menu_alt'][$currentrub] . "\" id=\"menu_".$currentrub."\" >" . $GLOBALS['lang']['menu_alt'][$currentrub] . "</a></li>\n";
  return $content;
}

$menu_constructor_com = '';
$menu_constructor_gestion = '';
$menu_constructor_config = '';

if (MOD_NEWS === 1 && HaveRight('news')) $menu_constructor_com .= displayitem($rub, 'news', 'a');


if (MOD_PUBLICATION === 1 && HaveRight('publication')) {
  if ($rub == 'resources' || $rub == 'contents') {
    if (isset($type) && $type == 'W') $menu_constructor_com .= displayitem('workshop', 'publication', 'd');
    if (isset($type) && $type == 'P') $menu_constructor_com .= displayitem('publication', 'publication', 'd');
  } else {
    $menu_constructor_com .= displayitem($rub, 'publication', 'd');
  }
}
if (MOD_WORKSHOP === 1 && HaveRight('workshop')) {
  if ($rub == 'resources' || $rub == 'content' || $rub == 'workshoprep') {
    if (isset($type) && $type == 'W') $menu_constructor_com .= displayitem('workshop', 'workshop', 'g');
    if (isset($type) && $type == 'P') $menu_constructor_com .= displayitem('publication', 'workshop', 'g');
    if ($rub == 'workshoprep') $menu_constructor_com .= displayitem('workshop', 'workshop', 'g');
  } else {
    $menu_constructor_com .= displayitem($rub, 'workshop', 'g', $GLOBALS['lang']['menu']);
  }
}
if (MOD_NEWSLETTER === 1 && IsSuperAdmin()) $menu_constructor_com .= displayitem($rub, 'newsletter', 'r');
if (MOD_LIBRARY === 1 && IsSuperAdmin()) $menu_constructor_com .= displayitem($rub, 'library', 'l');

if (MOD_PROJECT === 1 && IsSuperAdmin()) $menu_constructor_gestion .= displayitem($rub, 'project', 'p');
if (MOD_SDI === 1 && IsSuperAdmin()) $menu_constructor_gestion .= displayitem($rub, 'sdi', 'b');
if (MOD_DASHBOARD === 1 && HaveRight('dashboard')) $menu_constructor_gestion .= displayitem($rub, 'dashboard', 'i');
if (MOD_YELLOWPAGES === 1 && HaveRight('yellowpages')) $menu_constructor_gestion .= displayitem($rub, 'yellowpages', 'y');


if (MOD_USER === 1 && IsSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'user', 'u');
if (MOD_THEME === 1 && IsSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'theme', 't');
if (MOD_SCALE === 1 && IsSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'scale', 'e');
if (MOD_LEVEL === 1 && IsSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'level', 'n');
if (MOD_SYSTEM === 1 && IsSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'system', 'n');
if (MOD_PLUGINS === 1 && IsSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'plugins', 'o');
?>
<br />

<ul class="containermenu">
	<li><a href="index.php" class="menu" id="menu_logo"></a></li>

	<li class="menu" id="menu_com"><?php echo $GLOBALS['lang']['menu_alt']['communication'];?>
	<ul class="sub_menu" id="menu_com_list">
	<?php echo $menu_constructor_com; ?>
	</ul>
	</li>
	<li class="menu" id="menu_gestion"><?php echo $GLOBALS['lang']['menu_alt']['suivi_gestion'];?>
	<ul class="sub_menu" id="menu_gestion_list">
	<?php echo $menu_constructor_gestion; ?>
	</ul>
	</li>
	<li class="menu" id="menu_config"><?php echo $GLOBALS['lang']['menu_alt']['configuration'];?>

	<ul class="sub_menu" id="menu_config_list">
	<?php echo $menu_constructor_config; ?>
	</ul>
	</li>
	<li><a href="../public/index.php" class="menu"
		id="menu_public_interface"><?php echo $GLOBALS['lang']['menu_alt']['interface_publique'];?>
	</a></li>
</ul>
<br style="clear: both" />
