<?php
/**
 * @package linea21.core
 * @subpackage user
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!IsSuperAdmin()) ReloadIndex('admin');
////////////
?>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a>
	</li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>"
		class="chemin_rub"><?php echo _t('menu','user'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('user','add')); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
$form_pseudo='';
$form_email='';
$layer_rights= "style=\"display:none;\"";
$mask_type_S='';
$mask_type_P='';
$mask_type_A='';

$mask_dashboard_1="checked=\"checked\"";
$mask_dashboard_2='';
$mask_publication_1="checked=\"checked\"";
$mask_publication_2='';
$mask_news_1="checked=\"checked\"";
$mask_news_2='';
$mask_workshop_1="checked=\"checked\"";
$mask_workshop_2='';

$q=SQL_getWorkgroupsList();
$workgroups=$sql_object->DBSelect($q);
$default_wg = array();


if(isset($_POST['enregistrer'])) {
  $data_table_user=unserialize(urldecode($_POST['data_table_user']));
  $data_table_right=unserialize(urldecode($_POST['data_table_right']));
  $data_table_workgroups=unserialize(urldecode($_POST['data_table_workgroups']));
  $user_object= new user;
  $data_table_user[3] = $user_object -> GetNewPassword();

  /** include envoi de mail */
  $todo_mail='add_user';
  include_once(themePath('../user/mail_actions.php'));
  include_once('../mail/template.php');
  /** end mail */

  $result=$user_object->AddUser($data_table_user, $data_table_right, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if(is_numeric($result)) {
    $r = $user_object -> AddWorkshops($result, $data_table_workgroups, 'U' , $sql_object);
    header("Location: ".$link_confirm);
  }
  else  system_error();
}


if(isset($_POST['valider'])) {
  $table_user[0]=$_POST['pseudo'];
  $table_user[1]=$_POST['email'];
  $table_user[2]='N';
  $user_object= new user;
  $integrity=$user_object->CheckDataIntegrity($table_user, $sql_object);

  if($_POST['user_type']=='simple_user') {
    $table_right=$user_object->InitUserRight('SIMPLE_USER');
    $mask_type_S="checked=\"checked\"";
  }
  if($_POST['user_type']=='admin_user') {
    $table_right=$user_object->InitUserRight('ADMIN_USER');
    $mask_type_A="checked=\"checked\"";
  }
  if($_POST['user_type']=='privilege_user') {
    $table_right['dashboard']=$_POST['dashboard'];
    $table_right['workshop']=$_POST['workshop'];
    $table_right['publication']=$_POST['publication'];
    $table_right['news']=$_POST['news'];
    $table_right['yellowpages']='U';
    $table_right['project']='U';
    $table_right['theme']='U';
    $table_right['scale']='U';
    $table_right['level']='U';
    $table_right['category_user']='U';
    $layer_rights= "style=\"display:block;\"";
    $mask_type_P="checked=\"checked\"";
  }

  if(isset($_POST['workgroups'])) {
    $table_workgroups=$_POST['workgroups'];
    $default_wg=$table_workgroups;
  }
  else $table_workgroups=array();

  $form_pseudo=$_POST['pseudo'];
  $form_email=$_POST['email'];
  $table_user=urlencode(serialize($table_user));
  $table_right=urlencode(serialize($table_right));
  $table_workgroups=urlencode(serialize($table_workgroups));

  if($_POST['dashboard']=='O') {
    $mask_dashboard_1='';
    $mask_dashboard_2="checked=\"checked\"";
  }
  if($_POST['publication']=='O') {
    $mask_publication_1='';
    $mask_publication_2="checked=\"checked\"";
  }
  if($_POST['news']=='O') {
    $mask_news_1='';
    $mask_news_2="checked=\"checked\"";
  }
  if($_POST['workshop']=='O') {
    $mask_workshop_1='';
    $mask_workshop_2="checked=\"checked\"";
  }
}

// preparation affichage detaillé
$rights_display='';
if(defined('MOD_SDI')) {
  $rights_display.= "<label for=\"dashboard_1\" class=\"rights\">>> "._t('menu','dashboard')." : </label><br />\n";
  $rights_display.= "<div class=\"radiomargin\">\n";
  $rights_display.= "<input type=\"radio\" id=\"dashboard_1\" class=\"radio\" name=\"dashboard\" value=\"U\" ".$mask_dashboard_1." /><span class=\"radio\">". _t('user','norights')."</span>\n";
  $rights_display.= "<input type=\"radio\" id=\"dashboard_2\" class=\"radio\" name=\"dashboard\" value=\"O\" ".$mask_dashboard_2."/><span class=\"radio\">". _t('user','redactorrights')."</span>\n";
  $rights_display.= "</div>\n";
} else $rights_display.="<input type=\"hidden\" id=\"dashboard\" name=\"dashboard\" value=\"U\" />\n";
if(defined('MOD_PUBLICATION')) {
  $rights_display.= "<label for=\"publication_1\" class=\"rights\">>> "._t('menu','publication')." : </label><br />\n";
  $rights_display.= "<div class=\"radiomargin\">\n";
  $rights_display.= "<input type=\"radio\" id=\"publication_1\" class=\"radio\" name=\"publication\" value=\"U\" ".$mask_publication_1." /><span class=\"radio\">". _t('user','norights')."</span>\n";
  $rights_display.= "<input type=\"radio\" id=\"publication_2\" class=\"radio\" name=\"publication\" value=\"O\" ".$mask_publication_2." /><span class=\"radio\">". _t('user','redactorrights')."</span>\n";
  $rights_display.= "</div>\n";
} else $rights_display.="<input type=\"hidden\" id=\"publication\" name=\"publication\" value=\"U\" />\n";
if(defined('MOD_NEWS')) {
  $rights_display.= "<label for=\"news_1\" class=\"rights\">>> "._t('menu','news')." : </label><br />\n";
  $rights_display.= "<div class=\"radiomargin\">\n";
  $rights_display.= "<input type=\"radio\" id=\"news_1\" class=\"radio\" name=\"news\" value=\"U\" ".$mask_news_1." /><span class=\"radio\">". _t('user','norights')."</span>\n";
  $rights_display.= "<input type=\"radio\" id=\"news_2\" class=\"radio\" name=\"news\" value=\"O\" ".$mask_news_2."/><span class=\"radio\">". _t('user','redactorrights')."</span>\n";
  $rights_display.= "</div>\n";
} else $rights_display.="<input type=\"hidden\" id=\"news\" name=\"news\" value=\"U\" />\n";
if(defined('MOD_WORKSHOP')) {
  $rights_display.= "<label for=\"workshop_1\" class=\"rights\">>> "._t('menu','workshop')." : </label><br />\n";
  $rights_display.= "<div class=\"radiomargin\">\n";
  $rights_display.= "<input type=\"radio\" id=\"workshop_1\" class=\"radio\" name=\"workshop\" value=\"U\" ".$mask_workshop_1." /><span class=\"radio\">". _t('user','norights')."</span>\n";
  $rights_display.= "<input type=\"radio\" id=\"workshop_2\" class=\"radio\" name=\"workshop\" value=\"O\" ".$mask_workshop_2." /><span class=\"radio\">". _t('user','animatorrights')."</span>\n";
  $rights_display.= "</div>\n";
} else $rights_display.="<input type=\"hidden\" id=\"wokshop\" name=\"workshop\" value=\"U\" />\n";

include_once(THEME_ADMIN_PATH."quickicons.php");

if(!isset($_POST['valider'])) $mask_type_S='checked="checked"';
?>

<?php
if(!isset($integrity) || is_string($integrity)) {
  ?>
<div class="contentcontainer"><?php
include_once($dir."/menurub.php");
?>
<div id="content"><?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2(_t('user','add_title')); ?></h2>
<form id="adduser" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"
	method="post">
<p><label for="simple_user"><?php echo _t('user','type'); ?> : *</label>
<input name="user_type" type="radio" id="simple_user" maxlength="150"
	value="simple_user" class="radio" onclick="ShowthemeTableRights('')"
<?php echo $mask_type_S; ?> /><span class="radio"><?php echo _t('user','type_simple'); ?></span>
<input name="user_type" type="radio" id="privilege_user" maxlength="150"
	value="privilege_user" class="radio"
	onclick="ShowthemeTableRights('rights')" <?php echo $mask_type_P;  ?> /><span
	class="radio"><?php echo _t('user','type_privilege'); ?></span> <input
	name="user_type" type="radio" id="admin_user" maxlength="150"
	value="admin_user" class="radio" onclick="ShowthemeTableRights('')"
<?php echo $mask_type_A;  ?> /><span class="radio"><?php echo _t('user','type_admin'); ?></span>
</p>
<div id="rights" <?php echo $layer_rights; ?>>
<h3><?php echo _t('user','set_rights'); ?> : <br />
</h3>
<?php echo $rights_display; ?></div>
<p><label for="pseudo"><?php echo ucfirst(_t('user','pseudo')); ?> : *</label>
<input name="pseudo" type="text" class="textfield" id="pseudo"
	maxlength="150" value="<?php echo $form_pseudo; ?>" /></p>
<p><label for="email"><?php echo ucfirst(_t('user','email')); ?> : *</label>
<input name="email" type="text" class="textfield" id="email"
	maxlength="200" value="<?php echo $form_email; ?>" /></p>
<div><input name="rub" type="hidden" value="<?php echo $rub; ?>"
	id="rub" /> <input name="todo" type="hidden"
	value="<?php echo $todo; ?>" id="todo" />
<div class="label"><?php echo ucfirst(_t('user','workgroups')); ?> :</div>
<div class="rightpanel"><?php echo workgroupsCheckbox($workgroups, 'workgroups[]', $default_wg); ?>
</div>
<?php
if(isset($table_user) && isset($table_right) && isset($table_workgroups)) {
  echo "<input name=\"data_table_user\" type=\"hidden\" value=\"".$table_user."\" id=\"data_table_user\" />\n";
  echo "<input name=\"data_table_right\" type=\"hidden\" value=\"".$table_right."\" id=\"data_table_right\" />\n";
  echo "<input name=\"data_table_workgroups\" type=\"hidden\" value=\"".$table_workgroups."\" id=\"data_table_workgroups\" />\n";
}
?> <?php echo cancel_button('javascript:history.go(-1);'); ?> <input
	name="valider" type="submit" value="<?php echo _t('btn','valid'); ?>"
	class="button" id="valider" /></div>
</form>
</div>
<?php include_once($dir."/help.php"); ?></div>
<?php
// Récapitulatif
} else	{

  $wg_display = '';
  if(isset($_POST['workgroups'])) {
    $q=SQL_Get_WorkshopsDenomination($_POST['workgroups']);
    $workgroups=$sql_object->DBSelect($q);
    foreach($workgroups as $wg) {
      $wg_display .= '- '.$wg['workshop_denomination'].'<br />'.END_LINE;
    }
  } else $wg_display .= _t('divers', 'none');


  $reca_droits='';
  if($_POST['user_type']=='simple_user') {
    $display_type=_t('user','type_simple');
  }
  if($_POST['user_type']=='admin_user') {
    $display_type=_t('user','type_admin');
  }
  if($_POST['user_type']=='privilege_user')  {
    $display_type=_t('user','type_privilege');

    $reca_droits.="<dt>"._t('user','set_rights')." : </dt>";
    $reca_droits.="<dd>&nbsp;<br /></dd>";
    if(defined('MOD_SDI'))  {
      $reca_droits.="<dt> . "._t('menu','sdi')." : </dt>";
      $reca_droits.="<dd>".GetDisplayUserRight($_POST['dashboard'], 'dashboard')."<br /></dd>";
    }
    if(defined('MOD_PUBLICATION'))  {
      $reca_droits.="<dt>  . "._t('menu','publication')." : </dt>";
      $reca_droits.="<dd>".GetDisplayUserRight($_POST['publication'])."<br /></dd>";
    }
    if(defined('MOD_WORKSHOP'))  {
      $reca_droits.="<dt>  . "._t('menu','workshop')." : </dt>";
      $reca_droits.="<dd>".GetDisplayUserRight($_POST['workshop'], 'workshop')."<br /></dd>";
    }
    if(defined('MOD_NEWS'))  {
      $reca_droits.="<dt>  . "._t('menu','news')." : </dt>";
      $reca_droits.="<dd>".GetDisplayUserRight($_POST['news'])."<br /></dd>";
    }
  }

  ?>
<div class="contentcontainer"><?php
include_once($dir."/menurub.php");
?>
<div id="content">
<h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
<dl class="dl3">
	<dt><?php echo _t('user','type') ?> :</dt>
	<dd><?php echo $display_type; ?><br />
	</dd>
	<dt><?php echo ucfirst(_t('user','pseudo')) ?> :</dt>
	<dd><?php echo $form_pseudo; ?><br />
	</dd>
	<dt><?php echo ucfirst(_t('user','email')) ?> :</dt>
	<dd><?php echo $form_email; ?><br />
	</dd>
	<?php echo $reca_droits; ?>
	<dt><?php echo ucfirst(_t('user','workgroups')) ?> :</dt>
	<dd><?php echo stripslashes($wg_display); ?></dd>
</dl>
<form id="adduser" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"
	method="post">
<div><input name="rub" type="hidden" value="<?php echo $rub; ?>"
	id="rub" /> <input name="todo" type="hidden"
	value="<?php echo $todo; ?>" id="todo" /> <input name="data_table_user"
	type="hidden" value="<?php echo $table_user; ?>" id="data_table_user" />
<input name="data_table_right" type="hidden"
	value="<?php echo $table_right; ?>" id="data_table_right" /> <input
	name="data_table_workgroups" type="hidden"
	value="<?php echo $table_workgroups; ?>" id="data_table_workgroups" />
	<?php echo cancel_button('?rub=user&todo=list'); ?> <input
	name="retour" type="button" value="<?php echo _t('btn','preview') ?>"
	class="button" id="retour" onclick="history.go(-1);" /> <input
	name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>"
	class="button" id="valider" /></div>
</form>
</div>
	<?php include_once($dir."/help.php"); ?></div>
	<?php
}
?>
