<?php
/**
 * @package linea21.core
 * @subpackage user
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!IsSuperAdmin()) ReloadIndex('admin');
////////////
$user_object= new user;
if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

$req_det= SQL_getAllUserInfo($id);
$result=$sql_object->DBSelect($req_det);
if(count($result)>1) exit();

// groupes de travail
$r=$user_object->GetUserWorkshops($id, $sql_object);
$default_wg= array();
foreach($r as $value) {
  array_push($default_wg, $value['jwu_workshop_id']);
}
$wg_display = '';
if(!empty($default_wg)) {
  $q=SQL_Get_WorkshopsDenomination($default_wg);
  $workgroups=$sql_object->DBSelect($q);
  foreach($workgroups as $wg) {
    $wg_display .= '- '.$wg['workshop_denomination'].'<br />'.END_LINE;
  }
} else $wg_display .= _t('divers', 'none');

$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_det_theme="index.php?rub=theme&amp;todo=det&amp;id=";
$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";


// formattage des données
$current_title=formatText($result[0]['user_login'], '2HTML');
$user_login=formatText($result[0]['user_login'], '2HTML');
$user_email=$result[0]['profile_email'];
$user_email=formatText('<a href="mailto:'.$user_email.'">'.$user_email.'</a>', '2HTML');
$user_groupe=formatText($result[0]['catus_name'], '2HTML');
// droits utilisateur
$rights_dashboard=$result[0]['rights_dashboard'];
$rights_publication=$result[0]['rights_publication'];
$rights_news=$result[0]['rights_news'];
$rights_workshop=$result[0]['rights_workshop'];

$user_public_email=$result[0]['profile_email_display'];
if($user_public_email=='Y') $user_public_email=_t('divers','yes');
else $user_public_email=_t('divers','no');
$user_profile_city=formatText(empty_nc($result[0]['profile_city']), '2HTML');
$user_profile_birthdate=formatText(empty_nc($result[0]['profile_birthdate']), '2HTML');
$user_profile_leisures=formatText(empty_nc($result[0]['profile_leisures']), '2HTML');
$user_profile_job=formatText(empty_nc($result[0]['profile_job']), '2HTML');
$user_profile_quotation=formatText(empty_nc($result[0]['profile_quotation']), '2HTML');
$user_profile_signature=formatText(empty_nc($result[0]['profile_signature']), '2HTML');

if(!empty($result[0]['profile_avatar'])) {
  $complete_uri='../'.$result[0]['profile_avatar'];
  $user_profile_avatar='<img src="'.$complete_uri.'" alt="'._t('user','avatar').' '.$user_login.'" />';
} else $user_profile_avatar=_t('divers','none');

$profile_last_modify_display=$result[0]['profile_last_modify_display'];
$profile_date_crea_display=$result[0]['profile_date_crea_display'];

$user_validity=display_statut(_t('statut','draft'));

$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";

//prepa affichage de droits
$reca_droits='';
$reca_droits.="<dl class=\"dl3\">\n";
$reca_droits.="<dt class=\"dl_intitule\">"._t('user','rights')." : </dt>\n";
$reca_droits.="<dd>&nbsp;<br /></dd>\n";
$reca_droits.="<dt>"._t('user','groupe')."</dt>\n";
$reca_droits.="<dd>".$user_groupe."</dd>\n";
if(defined('MOD_SDI'))  {
  $reca_droits.="<dt> . "._t('menu','dashboard')."</dt>\n";
  $reca_droits.="<dd>".GetDisplayUserRight($rights_dashboard, 'dashboard')."<br /></dd>\n";
}
if(defined('MOD_PUBLICATION'))  {
  $reca_droits.="<dt>  . "._t('menu','publication')."</dt>\n";
  $reca_droits.="<dd>".GetDisplayUserRight($rights_publication)."<br /></dd>\n";
}
if(defined('MOD_WORKSHOP'))  {
  $reca_droits.="<dt>  . "._t('menu','workshop')."</dt>\n";
  $reca_droits.="<dd>".GetDisplayUserRight($rights_workshop, 'workshop')."<br /></dd>\n";
}
if(defined('MOD_NEWS'))  {
  $reca_droits.="<dt>  . "._t('menu','news')."</dt>\n";
  $reca_droits.="<dd>".GetDisplayUserRight($rights_news)."<br /></dd>\n";
}
$reca_droits.="</dl>\n";
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a>
	</li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>"
		class="chemin_rub"><?php echo _t('menu','user');?></a></li>
	<li><span><?php echo formatnavTitle(_t('user','det'). " : " .$current_title); ?></span>
	</li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>
<div class="contentcontainer"><?php
include_once($dir."/menurub.php");
?>
<div id="content"><?php
echo "<h2>".formatTitleh2($current_title)."</h2>\n";
echo "\t<a href=\"".$link_sup.$id."\" title=\""._t('user','sup')."\" class=\"ico_sup2\"></a>\n";
echo "\t<a href=\"".$link_mod.$id."\" title=\""._t('user','mod')."\" class=\"ico_mod2\"></a>\n";
echo $reca_droits;
echo "<dl class=\"dl3\">\n";
echo "<dt class=\"dl_intitule\">"._t('user','profile')." :</dt>\n";
echo "<dd>&nbsp;</dd>\n";
echo "<dt>". _t('user','email'). "</dt>\n";
echo "<dd>".$user_email."</dd>\n";
echo "<dt>"._t('user','email_display')."</dt>\n";
echo "<dd>". $user_public_email."</dd>\n";
echo "<dt>".ucfirst(_t('user','workgroups'))."</dt>\n";
echo "<dd>". stripslashes($wg_display)."</dd>\n";
echo "<dt>"._t('user','birthdate')."</dt>\n";
echo "<dd>". $user_profile_birthdate."</dd>\n";
echo "<dt>"._t('user','city')."</dt>\n";
echo "<dd>". $user_profile_city."</dd>\n";
echo "<dt>"._t('user','leisures')."</dt>\n";
echo "<dd>". $user_profile_leisures."</dd>\n";
echo "<dt>"._t('user','job')."</dt>\n";
echo "<dd>". $user_profile_job."</dd>\n";
echo "<dt>"._t('user','avatar')."</dt>\n";
echo "<dd>". $user_profile_avatar."</dd>\n";
echo "<dt>"._t('user','quotation')."</dt>\n";
echo "<dd>". $user_profile_quotation."</dd>\n";
echo "<dt>"._t('user','signature')."</dt>\n";
echo "<dd>". $user_profile_signature."</dd>\n";
echo "<dt>"._t('divers','last_modify')."</dt>\n";
echo "<dd>". $profile_last_modify_display."</dd>\n";
echo "<dt>"._t('divers','date_crea')."</dt>\n";
echo "<dd>". $profile_date_crea_display."</dd>\n";
echo "<dt>"._t('divers','statut') ."</dt>\n";
echo "<dd>". $user_validity. "</dd>\n";
echo "</dl>\n";
?></div>
<?php include_once($dir."/help.php"); ?></div>
