<?php
/**
 * @package linea21.core
 * @subpackage user
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(themePath('../user/'.SQL.'.inc.php'));

if(!function_exists('DisplayInfoUser')) {

  function DisplayInfoUser($user_id) {

    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getAllUserInfo($user_id));

    $content = '';
    if(count($data)!=1) return false;
    else
    {
      // Récupération infos groupes de travail
      include_once('../class/class.user.php');
      $user_object= new user;
      $r=$user_object->GetUserWorkshops($user_id, $GLOBALS['sql_object']);
      $default_wg= array();
      foreach($r as $value) {
        array_push($default_wg, $value['jwu_workshop_id']);
      }
      $user_workgroups = '';
      if(!empty($default_wg)) {
        $q=SQL_Get_WorkshopsDenomination($default_wg);
        $workgroups=$GLOBALS['sql_object']->DBSelect($q);
        $user_workgroups .= '<ul>';
        foreach($workgroups as $wg) {
          $link = array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'], 'id' => $wg['workshop_id'], 'name' => $wg['workshop_denomination']);
          $user_workgroups .= '<li><a href="'.HrefMaker($link).'" title="'._t('name','workshop_module').' : '.formatText($wg['workshop_denomination'], '2ATT').'">'.formatText($wg['workshop_denomination'], '2HTML').'</a></li>'.END_LINE;
        }
        $user_workgroups .= '</ul>';
      } else $user_workgroups .= _t('divers', 'none');

      // formattage des données
      $user_login=formatText($data[0]['user_login'], '2HTML');
      $user_public_email=$data[0]['profile_email_display'];
      $user_email=$data[0]['profile_email'];
      $user_email=formatText('<a href="mailto:'.$user_email.'">'.$user_email.'</a>', '2HTML');
      $user_groupe=formatText($data[0]['catus_name'], '2HTML');

      $user_profile_city=formatText(empty_nc($data[0]['profile_city']), '2HTML');
      $user_profile_birthdate=formatText(empty_nc($data[0]['profile_birthdate']), '2HTML');
      $user_profile_leisures=formatText(empty_nc($data[0]['profile_leisures']), '2HTML');
      $user_profile_job=formatText(empty_nc($data[0]['profile_job']), '2HTML');
      $user_profile_quotation=formatText(empty_nc($data[0]['profile_quotation']), '2HTML');
      $user_profile_signature=formatText(empty_nc($data[0]['profile_signature']), '2HTML');

      if(!empty($data[0]['profile_avatar'])) {
        list($complete_uri)=GetAllPhotoUri('../'.$data[0]['profile_avatar']);
        $user_profile_avatar='<img src="'.$complete_uri.'" alt="'._t('user','avatar').' '.$user_login.'" />';
      } else $user_profile_avatar=_t('divers','none');

      $profile_last_modify_display=$data[0]['profile_last_modify_display'];
      $profile_date_crea_display=$data[0]['profile_date_crea_display'];

      $content.=GetLinkModifyUserInfo($user_id);
      $content.='<h1>'._t('user','profile').' '.$user_login.'</h1>'.END_LINE;
      $content.='<div class="h1_comment" id="h1_user">';
      $content.=_t('user','h1_public_comment');
      $content.='</div>';
      $content.='<div id="userprofil">'.END_LINE;
      $content.='<dl>'.END_LINE;
      $content.='<dt>'._t('user','type').'</dt>'.END_LINE;
      $content.='<dd>'.$user_groupe.'</dd>'.END_LINE;
      $content.='<dt>'. _t('user','email'). '</dt>'.END_LINE;
      if($user_public_email=='Y')	$content.='<dd>'.$user_email.'</dd>'.END_LINE;
      else $content.='<dd>'._t('statut','draftpdf').'</dd>'.END_LINE;
      $content.='<dt>'._t('user','birthdate').'</dt>'.END_LINE;
      $content.='<dd>'. $user_profile_birthdate.'</dd>'.END_LINE;
      $content.='<dt>'._t('user','city').'</dt>'.END_LINE;
      $content.='<dd>'. $user_profile_city.'</dd>'.END_LINE;
      $content.='<dt>'._t('user','leisures').'</dt>'.END_LINE;
      $content.='<dd>'. $user_profile_leisures.'</dd>'.END_LINE;
      $content.='<dt>'._t('user','job').'</dt>'.END_LINE;
      $content.='<dd>'. $user_profile_job.'</dd>'.END_LINE;
      $content.='<dt>'._t('user','avatar').'</dt>'.END_LINE;
      $content.='<dd>'. $user_profile_avatar.'</dd>'.END_LINE;
      $content.='<dt>'._t('user','quotation').'</dt>'.END_LINE;
      $content.='<dd>'. $user_profile_quotation.'</dd>'.END_LINE;
      $content.='<dt>'._t('user','signature').'</dt>'.END_LINE;
      $content.='<dd>'. $user_profile_signature.'</dd>'.END_LINE;
      $content.='<dt>'._t('groups','his').'</dt>'.END_LINE;
      $content.='<dd>'. $user_workgroups.'</dd>'.END_LINE;
      $content.='<dt>'._t('divers','last_modify').'</dt>'.END_LINE;
      $content.='<dd>'. $profile_last_modify_display.'</dd>'.END_LINE;
      $content.='<dt>'._t('divers','date_crea').'</dt>'.END_LINE;
      $content.='<dd>'. $profile_date_crea_display.'</dd>'.END_LINE;
      $content.='</dl>'.END_LINE;
      $content.='</div>'.END_LINE;


    }
    echo $content;
  }
}

if(!function_exists('DisplayFormProfileUser')) {

  function DisplayFormProfileUser($user_id, $submitted=-1) {

    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getAllUserInfo($user_id));
    $content = '';
    $mask_display_mail_1='';
    $mask_display_mail_2='';

    // en modification simple
    if($submitted==-1) {
      if(count($data)!=1) return false;
      else
      {
        // formattage des données
        $form_login=formatText($data[0]['user_login'], '2FIELD');
        $form_public_email=$data[0]['profile_email_display'];
        $form_email=formatText($data[0]['profile_email'], '2FIELD');
        $current_email=formatText($data[0]['profile_email'], '2FIELD');
        $form_groupe=formatText($data[0]['catus_name'], '2FIELD');
        $current_avatar=$data[0]['profile_avatar'];
         
        if($form_public_email=='Y') $mask_display_mail_1=' checked="checked"';
        else $mask_display_mail_2=' checked="checked"';
        $form_profile_city=formatText($data[0]['profile_city'], '2FIELD');
        $form_profile_birthdate = isNullDate($data[0]['profile_birthdate']) ? '--' : formatDate($data[0]['profile_birthdate'], true);
        list($form_date_y, $form_date_m, $form_date_d)=explode('-', $form_profile_birthdate);
        $form_profile_leisures=formatText($data[0]['profile_leisures'], '2FIELD');
        $form_profile_job=formatText($data[0]['profile_job'], '2FIELD');
        $form_profile_quotation=formatText($data[0]['profile_quotation'], '2FIELD');
        $form_profile_signature=formatText($data[0]['profile_signature'], '2FIELD');

        if(!empty($data[0]['profile_avatar'])) {
          list($complete_uri)=GetAllPhotoUri('../'.$data[0]['profile_avatar']);
          $user_profile_avatar='<img src="'.$complete_uri.'" alt="'._t('user','avatar').' '.$_COOKIE['linea21']['login'].'" />';
        } else $user_profile_avatar=_t('divers','none');
         
        $profile_last_modify_display=$data[0]['profile_last_modify_display'];
        $profile_date_crea_display=$data[0]['profile_date_crea_display'];
      }

      // un submit à déjà été fait, on affiche les infos entrées par l'utilisateur
    } else {
      $form_email=$_REQUEST['email'];
      $current_email=$_REQUEST['current_email'];
      $current_avatar=base64_decode($_REQUEST['current_avatar']);

      if(!empty($current_avatar)) {
        list($complete_uri)=GetAllPhotoUri('../'.$current_avatar);
        $user_profile_avatar='<img src="'.$complete_uri.'" alt="'._t('user','avatar').' '.$_COOKIE['linea21']['login'].'" />';
      } else $user_profile_avatar=_t('divers','none');
       
      if($_REQUEST['email_display']=='Y') $mask_display_mail_1=' checked="checked"';
      else $mask_display_mail_2=' checked="checked"';
      $form_date_d=$_REQUEST['date_d'];
      $form_date_m=$_REQUEST['date_m'];
      $form_date_y=$_REQUEST['date_y'];
      $form_profile_city=$_REQUEST['city'];
      $form_profile_leisures=$_REQUEST['leisures'];
      $form_profile_job=$_REQUEST['job'];
      $form_profile_quotation=$_REQUEST['quotation'];
      $form_profile_signature=$_REQUEST['signature'];
    }

    $content.='<form action="index.php" method="post" enctype="multipart/form-data">'.END_LINE;
    $content.='<div id="userprofilmodify">'.END_LINE;
    $content.='<table class="modifyuser" summary="'._t('user','p_mod_table_summary').'">'.END_LINE;
    $content.='<tr>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<label for="email">'._t('user','email').' : </label>'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<input name="email" type="text" class="textfield" id="email" maxlength="200" value="'.$form_email.'" />'.END_LINE;
    $content.='<br />';
    $content.='<div class="advertise">'.END_LINE;
    $content.=_t('user','info_mail').END_LINE;
    $content.='</div>'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='</tr>'.END_LINE;

    $content.='<tr>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<label for="email_display_Y">'._t('user','email_display').' : </label>'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<input type="radio" id="email_display_Y" class="radio" name="email_display" value="Y"'.$mask_display_mail_1.' /><span class="radio">'._t('divers','yes').'</span>'.END_LINE;
    $content.='<input type="radio" id="email_display_N" class="radio" name="email_display" value="N"'.$mask_display_mail_2.' /><span class="radio">'._t('divers','no').'</span>'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='</tr>'.END_LINE;
    $content.='<tr>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<label for="date_d">'._t('user','birthdate').' : </label>'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.= sprintf(input_date($form_date_y, $form_date_m, $form_date_d));
    $content.='</td>'.END_LINE;
    $content.='</tr>'.END_LINE;
    $content.='<tr>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<label for="city">'._t('user','city').' : </label>'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<input name="city" type="text" class="textfield" id="city" maxlength="100" value="'.$form_profile_city.'" />'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='</tr>'.END_LINE;
    $content.='<tr>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<label for="leisures">'._t('user','leisures').' :</label>'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<input name="leisures" type="text" class="textfield" id="leisures" maxlength="150" value="'.$form_profile_leisures.'" />'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='</tr>'.END_LINE;
    $content.='<tr>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<label for="job">'._t('user','job').' :</label>'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<input name="job" type="text" class="textfield" id="job" maxlength="150" value="'.$form_profile_job.'" />'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='</tr>'.END_LINE;

    $content.='<tr>'.END_LINE;
    $content.='<td class="labelised">'.END_LINE;
    $content.=_t('user','current_avatar').' : '.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.=$user_profile_avatar.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='</tr>'.END_LINE;

    $content.='<tr>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<label for="avatar">'._t('user','avatar').' :</label>'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<input name="avatar" type="file" size="47" id="avatar" class="textfield" />'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='</tr>'.END_LINE;

    $content.='<tr>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<label for="quotation">'._t('user','quotation').' :</label>'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<input name="quotation" type="text" class="textfield" id="quotation" maxlength="150" value="'.$form_profile_quotation.'" />'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='</tr>'.END_LINE;
    $content.='<tr>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<label for="signature">'._t('user','signature').' :</label>'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<input name="signature" type="text" class="textfield" id="signature" maxlength="200" value="'.$form_profile_signature.'" />'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='</tr>'.END_LINE;
    $content.='</table>'.END_LINE;

    $content.='<hr />'.END_LINE;
    $content.='<div class="advertise">'.END_LINE;
    $content.=_t('user','info_password').END_LINE;
    $content.='</div>'.END_LINE;
    $content.='<table class="modifyuser">'.END_LINE;
    $content.='<tr>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<label for="password">'._t('user','p_new_password').' : </label>'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<input name="password" type="password" class="textfield" id="password" maxlength="20" value="" />'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='</tr>'.END_LINE;
    $content.='<tr>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<label for="password2">'._t('user','p_new_password_confirm').' : </label>'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='<td>'.END_LINE;
    $content.='<input name="password2" type="password" class="textfield" id="password2" maxlength="20" value="" />'.END_LINE;
    $content.='</td>'.END_LINE;
    $content.='</tr>'.END_LINE;
    $content.='</table>'.END_LINE;

    $content.='</div>'.END_LINE;
    $content.='<div style="text-align:right;margin:1em 0">'.END_LINE;
    $content.='<input name="current_email" type="hidden" value="'.$current_email.'" id="current_email" />'.END_LINE;
    $content.='<input name="current_avatar" type="hidden" value="'.base64_encode($current_avatar).'" id="current_avatar" />'.END_LINE;
    $content.='<input name="id" type="hidden" value="'.$user_id.'" id="id" />'.END_LINE;
    $content.='<input type="hidden" maxlength="20" size="15" name="rub" id="rub" value="'.$GLOBALS['links'][U_L]['user-prefs']['linkvalue'].'" />'.END_LINE;
    $content.= '<input type="submit" value="'._t('btn','valid').'" alt="'._t('btn','valid').'" title="'._t('btn','valid').'" size="15" name="modprofile" id="modprofile" style="margin-left:30em" />'.END_LINE;
    $content.='</div>'.END_LINE;
    $content.='</form>'.END_LINE;

    echo $content;
  }
}

if(!function_exists('ModifyProfile')) {

  function ModifyProfile() {

    $link_home= array('rub'=> $GLOBALS['links'][U_L]['home']['linkvalue']);

    $id=$_COOKIE['linea21']['id'];
    $integrity=1;
    $table_user[0]= ''; // valeur login --> Non checké
    $table_user[1] =$_REQUEST['email'];
    $table_profile[0] = $_REQUEST['email'];
    $table_profile[1] = $_REQUEST['email_display'];
    $table_profile[2] = $_REQUEST['city'];
    $form_date_d = trim($_REQUEST['date_d']);
    $form_date_m = trim($_REQUEST['date_m']);
    $form_date_y = trim($_REQUEST['date_y']);
    $form_date=$form_date_d . '-' . $form_date_m . '-' . $form_date_y;

    if(!empty($form_date_d) && !empty($form_date_m) && !empty($form_date_y)) {
      $date_integrity=checkdate_validity($form_date);
    } else {
      $date_integrity=true;
    }
    if(is_string($date_integrity)) $integrity = $date_integrity;
    else {
      $table_profile[3]= $form_date;
    }

    $table_profile[4] = $_REQUEST['leisures'];
    $table_profile[5] = $_REQUEST['job'];
    $table_profile[6] = $_REQUEST['quotation'];
    $table_profile[7] = $_REQUEST['signature'];
    $table_profile[8] = base64_decode($_REQUEST['current_avatar']);


    include_once('../class/class.user.php');
    $user_object= new user;
    $data_user_integrity=$user_object->CheckDataIntegrity($table_user);
    if(is_string($data_user_integrity)) $integrity=$data_user_integrity;

    if(!empty($_REQUEST['password'])) {
      $integrity=$user_object->checkPasswordValidity($_REQUEST['password'], $_REQUEST['password2']);
    }
    if(!is_string($integrity)) {
      if(isset($_FILES['avatar']) && $_FILES['avatar']['name']!='') {
        include_once('../class/system/class.upload.php');
        $upload_object= new upload;
        $upload=$_FILES['avatar'];
        $size_integrity=$upload_object->CheckMaxFile($upload['size'], $user_object->UPLOAD_MAX_MO);
        if(is_string($size_integrity)) $integrity=$size_integrity;
        $format_integrity=$upload_object->CheckExtImage($upload['name']);
        if(is_string($format_integrity)) $integrity=$format_integrity;
        if(!is_string($integrity)) {
          $final_name=$id.".".$upload_object->GetExtension($upload ['name']);
          $table_profile[8]=$user_object->URI_INPUT.$final_name;

          $destination="../".$user_object->URI_INPUT;
          $result_upload=$upload_object->UploadFile($upload, $final_name, $destination);
        }
      }
    }


    if(!is_string($integrity)) {
      $result=$user_object->ModifyProfile($id, $table_profile, $GLOBALS['sql_object']);

      if($result == true) {
        $string =_t('user','p_confirm_mod').'.';
        $string.=' <a href="'.HrefMaker($link_home).'" title="'._t('user','p_confirm_back').'" >'._t('user','p_confirm_back').'</a>';
        $integrity = array('code'=> 'confirm', 'string' => $string);
      }
      if(($_REQUEST['email']!=$_REQUEST['current_email']) || !empty($_REQUEST['password'])) {
        if($_REQUEST['email']!=$_REQUEST['current_email']) {
          $new_pass=$user_object->GetNewPassword();
          $todo_mail='change_mail';	 // choix template pour mail
          $new_email=$_REQUEST['email']; 	// renseignement nouvel email
          $user_login=$_COOKIE['linea21']['login']; // retrieve login
        }
        if(!empty($_REQUEST['password'])) {
          $new_pass=$_REQUEST['password'];
          $todo_mail='change_pass';	 // choix template pour mail
          $user_email=$_REQUEST['email'];		// renseignement email
          $user_login=$_COOKIE['linea21']['login']; // retrieve login
        }
        $user_object->UpdateUserPassword($id, $new_pass, $GLOBALS['sql_object']);
        UpdateCookiePassword(crypt($new_pass, SALT_CRYPT));
         
        /** include envoi de mail */
        include_once(themePath('../user/mail_actions.php'));
        include_once('../mail/template.php');
      }
    } else {
      $integrity = array('code'=> 'error', 'string' => $integrity);
    }

    $return_result ='<div class="'.$integrity['code'].'">'.END_LINE;
    $return_result.=$integrity['string'].END_LINE;
    $return_result.='</div>'.END_LINE;

    echo $return_result;
    if(!isset($result)) return DisplayFormProfileUser($_COOKIE['linea21']['id'], 1);
  }
}

if(!function_exists('GetLinkModifyUserInfo')) {

  function GetLinkModifyUserInfo($user_id) {

    $content ='';
    if(isset($_COOKIE['linea21']['whois']) && $user_id==$_COOKIE['linea21']['id']) {
      $link_edit= array('rub'=> $GLOBALS['links'][U_L]['user-prefs']['linkvalue']);

      $content.='<div class="switchnav">'.END_LINE;
      $content.='<a href="'.HrefMaker($link_edit).'" title="'._t('user','p_mod').'">'._t('user','p_mod').'</a>';
      $content.='</div>'.END_LINE;
    }
    return $content;
  }
}

if(!function_exists('DisplayAuthTextInfo')) {

  function DisplayAuthTextInfo() {
    $link_account= array('rub'=> $GLOBALS['links'][U_L]['user-registration']['linkvalue']);
    $content ='<div class="info">'.END_LINE;
    $content.=_t('user','info_inscription').END_LINE;
    $content.='<a href="'.HrefMaker($link_account).'">'._t('user','info_inscription2').' </a>'.END_LINE;
    $content.='.<br />'._t('user','info_inscription3').''.END_LINE;
    $content.='</div>'.END_LINE;
    echo $content;
  }
}

if(!function_exists('DisplaySubscribeTextInfo')) {

  function DisplaySubscribeTextInfo() {
    $content ='<div class="info">'.END_LINE;
    $content.=_t('user','info_inscription5').END_LINE;
    $content.='</div>';
    echo $content;
  }
}
?>