<?php
/**
 * @package linea21.core
 * @subpackage user
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////


$req_quickbox_add = "SELECT user_id, user_login, to_char(user_last_modify, '".toStringSqlDate('long')."') AS user_last_modify_display, to_char(user_date_crea, '".toStringSqlDate()."') AS user_date_crea_display FROM " . T_USER . " WHERE user_validity <> 'N' ORDER BY user_date_crea DESC, user_login ASC LIMIT 10 OFFSET 0;";
$req_quickbox_list = "SELECT user_id, user_login, to_char(user_last_modify, '".toStringSqlDate('long')."') AS user_last_modify_display, to_char(user_date_crea, '".toStringSqlDate()."') AS user_date_crea_display FROM " . T_USER . " WHERE user_validity <> 'N' ORDER BY user_last_modify DESC, user_login ASC LIMIT 10 OFFSET 0;";
$req_quickbox_sup = "SELECT user_id, user_login, to_char(user_last_modify, '".toStringSqlDate('long')."') AS user_last_modify_display, to_char(user_date_crea, '".toStringSqlDate()."') AS user_date_crea_display FROM " . T_USER . " WHERE user_validity = 'N' ORDER BY user_last_modify DESC, user_login ASC LIMIT 10 OFFSET 0;";

$req_list_group="SELECT catus_id, catus_name FROM " . T_CAT_USER . ";";
$req_alphabetical="SELECT DISTINCT upper(substring(user_login from 1 for 1)) AS first_letter FROM ". T_USER." WHERE user_validity<>'N' ORDER BY first_letter ASC;";
$req_nb_inscrit="SELECT COUNT(user_id) AS nb_inscrit FROM ". T_USER." WHERE user_validity<>'N'";

function SQL_getUserLogin($user_id) {
  $q="SELECT user_login FROM ". T_USER." WHERE user_validity<>'N' AND user_id='".$user_id."'";
  return $q;
}

function SQL_getAllUserInfo($user_id) {
  $q="SELECT U.user_login, U.user_validity, U.user_category, R.*, P.*, to_char(profile_birthdate, '".toStringSqlDate()."') AS profile_birthdate, to_char(profile_last_modify, '".toStringSqlDate('long')."') AS profile_last_modify_display, to_char(profile_date_crea, '".toStringSqlDate()."') AS profile_date_crea_display, C.catus_id, C.catus_name FROM ". T_USER." AS U LEFT OUTER JOIN ".T_RIGHT." AS R on R.rights_id=U.user_rights LEFT OUTER JOIN ".T_PROFILE." AS P on P.profile_id=U.user_profile LEFT OUTER JOIN ".T_CAT_USER." AS C on C.catus_id=U.user_category WHERE user_validity<>'N' AND user_id='".$user_id."'";
  return $q;
}

function SQL_getlistuser($debut, $limite = SELECT_LIMIT, $filter='', $search='' ) {
  if($search!='') {
    switch ($filter) {
      case 'ALPHA':
        $mask=" AND lower(user_login) LIKE lower('\\".$search."%') ";
        break;
      case 'GROUP':
        $mask=" AND user_category='".$search."' ";
        break;
      default:
        $mask='';
        break;
    }
  } else $mask='';
  $q= "SELECT U.user_login, U.user_id, to_char(user_date_crea, '".toStringSqlDate()."') AS user_date_crea_display, C.catus_name FROM " . T_USER . " AS U LEFT OUTER JOIN ".T_CAT_USER." AS C ON U.user_category=C.catus_id WHERE user_validity<>'N'".$mask." ORDER BY user_date_crea DESC, user_login ASC OFFSET ".$debut." LIMIT ".$limite.";";
  return $q;
}

function SQLCount_getlistuser($filter='', $search='' ) {

  if($search!='') {
    switch ($filter) {
      case 'ALPHA':
        $mask=" AND lower(user_login) LIKE lower('\\".$search."%') ";
        break;
      case 'GROUP':
        $mask=" AND user_category='".$search."' ";
        break;
      default:
        $mask='';
        break;
    }
  } else $mask='';
  $q= "SELECT COUNT(user_login) AS num_rows FROM " . T_USER . " WHERE user_validity<>'N'".$mask.";";
}

function SQL_Get_WorkshopsDenomination($array) {

  $str='';
  $sep='';
  foreach($array as $v) {
    $str .= $sep. 'workshop_id='.$v;
    $sep = ' OR ';
  }
  $query = "SELECT workshop_denomination, workshop_id FROM ". T_WORK ." WHERE (". $str .") AND workshop_statut <> 'E' ORDER BY workshop_id DESC";

  return $query;
}

function SQL_getWorkgroupsList() {
  $q = "SELECT workshop_id as id, workshop_denomination as name FROM ". T_WORK ." WHERE workshop_statut = 'P' OR workshop_statut = 'D';";
  return $q;
}
?>
