<?php
/**
 * @package linea21.modules
 * @subpackage workshop
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>

<script type="text/javascript">
    $(document).ready( function()
    {
    	function UpdateList() {
    		$("#user_login").val('');
			var type = $("input[name='user_statut']:checked").val(); // we get current Type O || U
			$.ajax({url: '../workshop/_ajax_user_autocomplete.php?type=' + type, dataType: 'json',
				success: function(r){
					t.plugins['autocomplete'].setValues(r);
				}
			});
		}

    	$("input[name='user_statut']").click(function(){
    		UpdateList();
    	});
    	
    	// Autocomplete initialization
		var t = new $.TextboxList('#user_login', {unique: true, plugins: {autocomplete: {onlyFromValues: true}}});
		$.ajax({url: '../workshop/_ajax_user_autocomplete.php?type=U', dataType: 'json', success: function(r){
			t.plugins['autocomplete'].setValues(r);
		}});

    });
</script>

<?php
if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (WorkshopAuth_id(GetSessionElement('id'), $sql_object, $id)<>true && !IsSuperAdmin())
ReloadIndex('admin');
////////////

$form_user_login='';
$mask_statut_O='';
$mask_statut_U="checked=\"checked\"";

$req_det_workshop= SQL_getoneCompleteWorkshop($id);
$result_workshop=$sql_object->DBSelect($req_det_workshop);
$workshop_denomination=formatText($result_workshop[0]['workshop_denomination'], '2HTML');

$link_cancel=$rub_link."&amp;todo=det&amp;id=".$id;

$workshop_object= new workshop;

if(isset($_POST['enregistrer'])) {
  $data_login=$_POST['data_login'];
  $data_statut=$_POST['data_statut'];
  if (!IsSuperAdmin())$data_statut='U';
  //faire l'ajout de user avec AddUserWorkshop
  $result=$workshop_object->AddUserWorkshop($id, $data_login, $data_statut , $sql_object);
  echo $result;
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$id;
  if(is_numeric($result)) header("Location: ".$link_confirm);
  else  system_error();
}

if(isset($_POST['valider'])) {
  $data_login=$_POST['user_login'];
  $data_statut=$_POST['user_statut'];
  if (!IsSuperAdmin())$data_statut='U';
  $workshop_object= new workshop;
  $integrity=$workshop_object->CheckUsersIntegrity($data_login, $id, $sql_object, $data_statut);
  if(is_string($integrity)) {
    $text_format='2FIELD';
  } else {
    $text_format='2HTML';
  }

  $form_user_login=formatText(str_replace(",",", ", $_POST['user_login']), $text_format);
  if($_POST['user_statut']=='U') $mask_statut_U="checked=\"checked\""; else $mask_statut_U='';
  if($_POST['user_statut']=='O') $mask_statut_O="checked=\"checked\""; else $mask_statut_O='';
}
include_once(THEME_ADMIN_PATH."quickicons.php");
$navtitle=_t('workshop','add_new_user')." : ".$workshop_denomination;
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a>
	</li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>"
		class="chemin_rub"><?php echo _t('menu','workshop')?></a></li>
	<li><span><?php echo formatnavTitle($navtitle); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
if(!isset($integrity) || is_string($integrity)) {
  ?>
<div class="contentcontainer"><?php
include_once($dir."/menurub.php");
?>
<div id="content"><?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?> <?php afflinkbar($todo,$id, $lang); ?>
<h2><?php echo formatTitleh2(_t('workshop','name')." : ".$workshop_denomination); ?></h2>
<form id="adduserworkshop"
	action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p><label for="user_login"><?php echo _t('workshop','add_new_user_login'); ?>
* : </label> <input name="user_login" type="text" class="textfield"
	id="user_login" maxlength="150" value="<?php echo $form_user_login; ?>" />
</p>
<?php
if (IsSuperAdmin()){
  ?>
<p><label for="statut_U"><?php echo _t('workshop','add_new_user_right'); ?>
* : </label> <input name="user_statut" type="radio" id="statut_U"
	value="U" <?php echo $mask_statut_U; ?> /><span class="radio"><?php echo _t('statut','U'); ?></span>
<input name="user_statut" type="radio" id="statut_O" value="O"
  <?php echo $mask_statut_O; ?> /><span class="radio"><?php echo _t('statut','O'); ?></span>
<br />
</p>
  <?php }
  else {?> <input name="user_statut" type="hidden" value="U" id="todo" />
  <?php
  }?>
<div><input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
  <?php echo cancel_button($link_cancel); ?> <input name="rub"
	type="hidden" value="<?php echo $rub; ?>" id="rub" /> <input
	name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" /> <input
	name="valider" type="submit" value="<?php echo _t('btn','valid') ?>"
	class="button" id="valider" /></div>
</form>
</div>
  <?php include_once($dir."/help.php"); ?></div>
  <?php
  // Récapitulatif
} else	{
  ?>
<div class="contentcontainer"><?php
include_once($dir."/menurub.php");
?>
<div id="content"><?php afflinkbar($todo,$id, $lang); ?>
<h2><?php echo _t('recap','title') ?></h2>
<?php
echo "<dl class=\"dl3\">\n";
echo "<dt>"._t('workshop','add_new_user_login')." :</dt>\n";
echo "<dd>".$form_user_login."</dd>\n";
echo "<dt>"._t('workshop','add_new_user_right') ."</dt>\n";
echo "<dd>". display_statut($_POST['user_statut']). "</dd>\n";
echo "</dl>\n";
?>
<form id="addworkshop" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"
	method="post">
<div><input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
<?php echo cancel_button($link_cancel); ?> <input name="data_login"
	type="hidden" value="<?php echo $data_login; ?>" id="data_login" /> <input
	name="data_statut" type="hidden" value="<?php echo $data_statut; ?>"
	id="data_statut" /> <input name="retour" type="button"
	value="<?php echo _t('btn','preview') ?>" class="button" id="retour"
	onclick="history.go(-1);" /> <input name="enregistrer" type="submit"
	value="<?php echo _t('btn','save') ?>" class="button" id="valider" /></div>
</form>
</div>
<?php include_once($dir."/help.php"); ?></div>
<?php
}
?>
