<?php
/**
 * @package linea21.modules
 * @subpackage workshop
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(themePath('../workshop/'.SQL.'.inc.php'));

if(!function_exists('DisplayFiles')) {

  function DisplayFiles($work_id, $url) {

    echo '<h3>'._t('workshop', 'files').' : </h3>'.END_LINE;
    echo '<div id="groupfiles">'.END_LINE;
    $path = '../library/userfiles/workgroups/'.$work_id.'/';
    if(!file_exists($path)) echo '<ul><li>'._t('divers', 'no_files').'</li></ul>';
    else {
      $handle = @opendir($path) or die("Unable to open $path");
      ListDir($handle,$path, $url);
    }
    echo '</div>'.END_LINE;
    echo '<h3>'._t('workshop', 'common_files').' : </h3>'.END_LINE;
    $path = '../library/userfiles/workgroups/shared/';
    echo '<div id="sharedfiles">'.END_LINE;
    if(!file_exists($path)) echo '<ul><li>'._t('divers', 'no_files').'</li></ul>';
    else {
      $handle = @opendir($path) or die("Unable to open $path");
      ListDir($handle,$path, $url);
    }
    echo '</div>'.END_LINE;

  }

}


if(!function_exists('notifyUsers')) {

  function notifyUsers($a) {

    if($a['action'] == 'post_alert') {
      if(ALERT_NEWPOST == 0) return true;
      if(ALERT_NEWPOST == 1) $m = array('O');
      if(ALERT_NEWPOST == 2) $m = array('O', 'U');

      $wg = $a['parentid'];
      $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopDenomination($a['parentid']));
      if(count($data)==1) $wname =$data[0]['workshop_denomination'];
      $wlinkforum= array('rub'=> $GLOBALS['links'][U_L]['topic']['linkvalue'],'id'=> $a['tid'], 'parentid' => $a['parentid'], 'name' => $wname, '#' => 'msg-'.$a['id']);
      $users=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopUserList($a['parentid']), 'OBJECT');
    }

    if($a['action'] == 'topic_alert') {
      if(ALERT_NEWTOPIC == 0) return true;
      if(ALERT_NEWTOPIC == 1) $m = array('O');
      if(ALERT_NEWTOPIC == 2) $m = array('O', 'U');

      $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopDenomination($a['id']));
      if(count($data)==1) $wname =$data[0]['workshop_denomination'];
      $wlinkfiles = array('rub'=> $GLOBALS['links'][U_L]['files']['linkvalue'],'id'=> $a['id'], 'name' => $wname);
      $wlinkforum= array('rub'=> $GLOBALS['links'][U_L]['topic-list']['linkvalue'],'id'=> $a['id'], 'name' => $wname);
      $users=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopUserList($a['id']), 'OBJECT');
    }

    if($a['action'] == 'file_alert') {
      if(ALERT_NEWFILE == 0) return true;
      if(ALERT_NEWFILE == 1) $m = array('O');
      if(ALERT_NEWFILE == 2) $m = array('O', 'U');

      $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopDenomination($a['id']));
      if(count($data)==1) $wname =$data[0]['workshop_denomination'];
      $wlinkfiles = array('rub'=> $GLOBALS['links'][U_L]['files']['linkvalue'],'id'=> $a['id'], 'name' => $wname);
      $wlinkforum= array('rub'=> $GLOBALS['links'][U_L]['topic-list']['linkvalue'],'id'=> $a['id'], 'name' => $wname);
      $users=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopUserList($a['id']), 'OBJECT');
    }

    foreach($users as $user) {
      if(isset($_COOKIE['linea21']['login']) && $user->user_login != $_COOKIE['linea21']['login']) {
        if(in_array($user->jwu_user_right, $m)) {
          include(themePath('../workshop/mail_actions.php'));
          include('../mail/template.php');
        }
      }
    }
    return true;
  }

}


if(!function_exists('uploadForm')) {

  function uploadForm($id) {
    if(!CookieWorkshopid($id)) die('no way!');

    include_once('../class/system/class.upload.php');
    include_once('../class/system/class.form.php');

    if(isset($_FILES['file'])) {
      $upload = new upload;
      error_reporting(E_ALL);
      ini_set("display_errors", 1);
      $ext= $upload->GetExtension($_FILES['file']['name']);
      // extension check
      if(in_array(strtolower($ext), explode(',', MEDIA_ALLOWED_EXT))) {
        $dest = '../library/userfiles/workgroups/';
        if(isset($_POST['shared_file'])) $dest .= 'shared/';
        else $dest .= $id.'/';
        if($upload->CheckMaxFile(filesize($_FILES['file']['tmp_name']), MEDIA_ALLOWED_SIZE) === true) {
          $filename_parts = pathinfo($_FILES['file']['name']);
          $final_name = cleanString($filename_parts['filename']).'.'.$filename_parts['extension'];
          $r = $upload->UploadFile($_FILES['file'], $final_name, $dest);
          if($r === true) {
            notifyUsers(array('id' => $id, 'action' => 'file_alert', 'files' => array($final_name)));
            $confirmation = $final_name . ' : ' . _t('upload', 'confirmed');
          }
        } else {
          $err_msg = $upload->CheckMaxFile(filesize($_FILES['file']['tmp_name']), MEDIA_ALLOWED_SIZE);
        }
      } else  {
        $err_msg = sprintf(_t('upload', 'wrong_ext'), str_replace(",", ", ", MEDIA_ALLOWED_EXT));
      }
    }
//    $form = new genForm;
//    $form->startForm('../library/upload.php', '#uploadform');
//    $form->insertHTML('<p id="loader"></p>');
//    $form->hiddenInput('id', $id);
//    $form->hiddenInput('rub', $GLOBALS['links'][U_L]['files']['linkvalue']);
//    $form->fileInput('file',_t('divers', 'up_file'));
//    $form->insertHTML('<input type="file" name="fileinput" id="fileinput" multiple>');
//    $form->checkboxInput('checkbox','shared_file',true,'<i>'._t('workshop', 'share_files').'</i>', false);
//    $form->insertBR();
//    $form->submitButton(false, _t('divers', 'up'), true, 'submitbut');
//    $form->insertHTML('<button>'._t('divers', 'up_file').'</button>');
//    $form->insertHTML('<div>'._t('divers', 'up_file').'</div>');
//    $form->closeForm();

//    if(!$output = $form->getForm()) { die("error: " . $form->error); }
//    else { echo $output; }
    echo '<form id="uploadform" action="index.php" method="post" enctype="multipart/form-data">
          <div id="file_upload_container">
          	<input type="hidden" name="id" id="id" value='.$id.' />
          	<input type="hidden" name="rub" id="rub" value='.$GLOBALS['links'][U_L]['files']['linkvalue'].' />
          	<input type="file" name="file" multiple />
          	<button>'._t('divers', 'up_file').'</button>
          </div>
          <input type="checkbox" value="1" id="shared_file" name="shared_file" />
          <label for="shared_file"><i>'._t('workshop', 'share_files').'</i></label>
          </form>';
    if(isset($err_msg)) echo '<div class="error">'.$err_msg.'</div>'.END_LINE;
    if(isset($confirmation)) echo '<div class="info">'.$confirmation.'</div>'.END_LINE;
    echo '<table id="files"></table>'.END_LINE;
    
  }

}

if(!function_exists('DisplayUrlFiles')) {

  function DisplayUrlFiles($work_id, $work_name) {
    $link = array('rub'=> $GLOBALS['links'][U_L]['files']['linkvalue'],'id'=>$work_id, 'name' => $work_name);
    $content='<a href="'.HrefMaker($link).'" title="'.formatText(_t('workshop','shared_files'), '2ATT').'" id="barre_files">'._t('workshop','shared_files').'</a>'.END_LINE;
    echo $content;
  }

}

/**
 * DisplayUrlAllCalendar()
 * affichage de l'URL de détails d'un calendrier
 * @param $workshop_id
 * @return
 **/
if(!function_exists('DisplayUrlAllCalendar')) {

  function DisplayUrlAllCalendar($workshop_id) {
    $link_table= array('rub'=> $GLOBALS['links'][U_L]['calendar']['linkvalue'],'id'=>$workshop_id);
    $content='<p>'.END_LINE;
    $content.='<a href="'.HrefMaker($link_table).'" title="'.formatText(_t('workshop','cal_all'), '2ATT').'">'._t('workshop','cal_all').'</a>'.END_LINE;
    $content.='</p>'.END_LINE;
    echo $content;
  }

}

/**
 * DisplayUrlInscription()
 * affichage de l'URL d'inscription au groupe de travail
 * @param $workshop_id
 * @param $testcookie
 * @return
 **/
if(!function_exists('DisplayUrlInscription')) {

  function DisplayUrlInscription($workshop_id, $testcookie) {
    $link_table= array('rub'=> $GLOBALS['links'][U_L]['workgroup-subscription']['linkvalue'],'id'=>$workshop_id);
    $link_table2= array('rub'=> $GLOBALS['links'][U_L]['user-prefs']['linkvalue']);

    if (!isset($_COOKIE['linea21'])) {
      $content='<div class="info">'._t('divers','noauth').''.END_LINE;
      $content.='<br />'._t('divers','creaauth').' : '.END_LINE;
      $content.='<a href="'.HrefMaker($link_table2).'" title="'.formatText(_t('divers','auth'), '2ATT').'" >'._t('divers','auth').'</a>'.END_LINE;
      $content.='</div>'.END_LINE;
    }
    else{
      if ($testcookie<>true) {
        $content='<div class="info">'._t('workshop','noinscription').''.END_LINE;
        $content.='<br />'._t('workshop','creainscription2').' : '.END_LINE;
        $content.='<a href="'.HrefMaker($link_table).'" title="'.formatText(_t('workshop','creainscription'), '2ATT').'" onclick="return window.confirm(\''._t('workshop','creainscription3').'\')" >'._t('workshop','creainscription').'</a></div>'.END_LINE;
      }
    }
    echo $content;
  }

}

/**
 * DisplayUrlTopicList()
 * affichage URL pour accéder aux discussions
 * @param $work_id
 * @param $contenu
 * @return
 **/
if(!function_exists('DisplayUrlTopicList')) {

  function DisplayUrlTopicList($work_id, $work_name) {
    $link_table= array('rub'=> $GLOBALS['links'][U_L]['topic-list']['linkvalue'],'id'=>$work_id, 'name' => $work_name);
    $content='<a href="'.HrefMaker($link_table).'" title="'.formatText(_t('workshop','com_public'), '2ATT').'" id="barre_discussion" >'._t('workshop','com_public').'</a>'.END_LINE;
    echo $content;
  }

}

/**
 * DisplayUrlCalendar()
 * affichage URL pour accéder aux calendrier
 * @param $work_id
 * @param $contenu
 * @return
 **/
if(!function_exists('DisplayUrlCalendar')) {

  function DisplayUrlCalendar($work_id, $work_name) {
    $link_table= array('rub'=> $GLOBALS['links'][U_L]['calendar']['linkvalue'],'id'=>$work_id, 'name' => $work_name);
    $content='<a href="'.HrefMaker($link_table).'" title="'.formatText(_t('workshop','cal_all'), '2ATT').'" id="barre_calendar">'._t('workshop','cal_all').'</a>'.END_LINE;
    echo $content;
  }

}

/**
 * DisplayUrlListerapport()
 * affichage URL pour accéder aux rapports
 * @param $work_id
 * @param $contenu
 * @return
 **/
if(!function_exists('DisplayUrlListerapport')) {

  function DisplayUrlListerapport($work_id, $work_name) {
    $link_table= array('rub'=> $GLOBALS['links'][U_L]['report-all']['linkvalue'],'id'=>$work_id, 'name' => $work_name);
    $content='<a href="'.HrefMaker($link_table).'" title="'.formatText(_t('workshop','barre_report'), '2ATT').'" id="barre_report" >'._t('workshop','barre_report').'</a>'.END_LINE;
    echo $content;
  }

}

/**
 * DisplayUrlListeutilisateurs()
 * affichage URL pour accéder aux utilisatuers
 * @param $work_id
 * @param $contenu
 * @return
 **/
if(!function_exists('DisplayUrlListeutilisateur')) {

  function DisplayUrlListeutilisateur($work_id, $work_name) {
    $link_table= array('rub'=> $GLOBALS['links'][U_L]['user-all']['linkvalue'],'id'=>$work_id, 'name' => $work_name);
    $content='<a href="'.HrefMaker($link_table).'" title="'.formatText(_t('workshop','participant'), '2ATT').'" id="barre_user" >'._t('workshop','participant').'</a>'.END_LINE;
    echo $content;
  }

}

if(!function_exists('DisplayUrlAddTopic')) {

  function DisplayUrlAddTopic($work_id) {
    $link_table= array('rub'=> $GLOBALS['links'][U_L]['topic-add']['linkvalue'],'id'=>$work_id);
    $content='<a href="'.HrefMaker($link_table).'" title="'.formatText(_t('workshop','add_com'), '2ATT').'" class="add_topic">'._t('workshop','add_com').'</a>'.END_LINE;
    echo $content;
  }

}

/**
 * DisplayListWorkshop()
 * affichage de la liste de groupe de travail
 * @param integer $id_filter
 * @param integer $filter
 * @return
 **/
if(!function_exists('DisplayListWorkshop')) {

  function DisplayListWorkshop($id_filter=-1, $filter=-1) {

    if ($filter=="") $filter='public';
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopList($debut=-1, $limite=-1, $filter , $id_filter));

    if($data!=0)
    {
      $content= '';
      for($i=0; $i<count($data); $i++) {
        $link_table= array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'],'id'=>$data[$i]['workshop_id'],'name'=>$data[$i]['workshop_denomination']);
        $link_table2= array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'],'filter'=> $GLOBALS['filters'][U_L]['theme']['linkvalue'],'id'=>$data[$i]['sdtheme_id'], 'name'=>$data[$i]['sdtheme_name']);
        $link_table3= array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'],'filter'=> $GLOBALS['filters'][U_L]['level']['linkvalue'],'id'=>$data[$i]['workshop_level'], 'name'=>$data[$i]['level_name']);
        $workshop_title=formatText($data[$i]['workshop_denomination'], '2HTML');
        $workshop_resume=formatText($data[$i]['workshop_resume'], '2HTML');
        $workshop_sdtheme=formatText($data[$i]['sdtheme_name'], '2HTML');
        $workshop_level=formatText($data[$i]['level_name'], '2HTML');
         
        $content.='<h2><a href="'.HrefMaker($link_table).'" title="'.formatText($workshop_title, '2ATT').'">'.$workshop_title.'</a>'.END_LINE;
        $content.='</h2>'.END_LINE;
        $content.='<p>'.$workshop_resume.'</p>'.END_LINE;
        $content.='<p class="filter_info">'._t('divers','level').' : <a href="'.HrefMaker($link_table3).'" title="'.formatText($workshop_level, '2ATT').'" class="filter_info_level" >'.$workshop_level.'</a> '.END_LINE;
        $content.=' '._t('divers','themeref').': <a href="'.HrefMaker($link_table2).'" title="'.formatText($workshop_sdtheme, '2ATT').'" class="filter_info_theme">'.$workshop_sdtheme.'</a></p>'.END_LINE;
        $content.='<hr />'.END_LINE;
      }
    }
    else
    {
      $content='<p class="info">'._t('divers','nodata').'</p>';
    }

    echo $content;
  }

}

/**
 * DisplayCalendar()
 * affichage du calendrier
 * @param $workshop_id
 * @param $nb
 * @return
 **/
if(!function_exists('DisplayCalendar')) {

  function DisplayCalendar($workshop_id) {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getoneListCalWorkshop($workshop_id, "ALL"));
    $content = ''.END_LINE;
    if($data!=0)
    {
      $datenow= strtotime("now");
      $inter=1*24*3600;

      for($i=0; $i<count($data); $i++) {

        $workcal_id=$data[$i]['workcal_id'];
        $workcal_title=formatText($data[$i]['workcal_task'], '2HTML');
        $workcal_resume=formatText($data[$i]['workcal_task_details'], '2HTML');
        $workcal_author=formatText($data[$i]['user_login'], '2HTML');
        $workcal_date_publi=formatText($data[$i]['workcal_task_date_display'], '2HTML');
        $link_table= array('rub'=> $GLOBALS['links'][U_L]['user-profile']['linkvalue'],'id'=>$data[$i]['workcal_posted_by'], 'name'=>$data[$i]['workcal_task']);
         
        $datetask=$data[$i]['workcal_task_date_display'];
         
        $datetask=explode("-", $datetask);
        $jour = $datetask[0];
        $mois = $datetask[1];
        $annee = $datetask[2];
        $datetask2 = mktime (0, 0, 0, $mois, $jour, $annee);

        if (($datetask2+$inter)>$datenow) $class='in'; else $class='out';

        $content.='<div id="cal-'.$workcal_id.'" class="task_'.$class.'">'.END_LINE;
        $content.='<div class="task_meta"><p>'.$workcal_date_publi.'</p>';
        $content.='<p><a href="'.HrefMaker($link_table).'" title="'.formatText($workcal_author, '2ATT').'">'.$workcal_author.'</a></p></div>';
        $content.='<div class="task_content"><h3>'.$workcal_title.'</h3>'.END_LINE;
        $content.='<p>'.$workcal_resume.'</p></div>'.END_LINE;
        $content.='</div>'.END_LINE;
        $content.='<br style="clear:both" />'.END_LINE;
      }
    }
    else
    {
      $content.='<p class="info">'._t('divers','nodata').'</p>';
    }

    echo $content;
  }

}

/**
 * DisplayOneWorkshop()
 * affichage du détail d'un groupe de travail
 * @param $workshop_id
 * @param integer $title
 * @return
 **/
if(!function_exists('DisplayOneWorkshop')) {

  function DisplayOneWorkshop($workshop_id, $title=-1) {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getoneCompleteWorkshop($workshop_id));
    $content = ''.END_LINE;
    if($data!=0)
    {
      for($i=0; $i<count($data); $i++) {

        $link_self= array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'],'id'=>$workshop_id);
        $link_table2= array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'],'filter'=> $GLOBALS['filters'][U_L]['theme']['linkvalue'],'id'=>$data[$i]['sdtheme_id'], 'name'=>$data[$i]['sdtheme_name']);
        $link_table3= array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'],'filter'=> $GLOBALS['filters'][U_L]['level']['linkvalue'],'id'=>$data[$i]['workshop_level'], 'name'=>$data[$i]['level_name']);
        $workshop_title=formatText($data[$i]['workshop_denomination'], '2HTML');
        $workshop_resume=formatText($data[$i]['workshop_resume'], '2HTML');
        //$workshop_comment=formatText(cutText($data[$i]['workshop_comment'],150), '2HTML');
        $workshop_sdtheme=formatText($data[$i]['sdtheme_name'], '2HTML');
        $workshop_theme=formatText(cutText($data[$i]['theme_name'],50), '2HTML');
        $workshop_level=formatText($data[$i]['level_name'], '2HTML');
         
         
        if ($title<>-1) {
          $content.='<h1 class="nobottommargin">'.$workshop_title.'</h1>'.END_LINE;
        }
        else{
          $content.='<p class="permalink">'.END_LINE;
          $content.= formatted_permalink($link_self);
          $content.='</p>'.END_LINE;
          //$content.='<h2>'._t('workshop','det').'</h2>'.END_LINE;
          $content.='<p class="h1_comment_bg" id="workshop_det">'.$workshop_resume.'</p>'.END_LINE;
          //$content.='<p>'.$workshop_comment.'</p>'.END_LINE;
          $content.='<p class="filter_info">'._t('divers','level').' : <a href="'.HrefMaker($link_table3).'" title="'.formatText($workshop_level, '2ATT').'" class="filter_info_level" >'.$workshop_level.'</a> '.END_LINE;
          $content.=' '._t('divers','themeref').' : <a href="'.HrefMaker($link_table2).'" title="'.formatText($workshop_sdtheme, '2ATT').'" class="filter_info_theme" >'.$workshop_sdtheme.'</a></p> '.END_LINE;
          //._t('divers','sousthemeref').':'.$workshop_theme.'</p>'.END_LINE;
        }
      }
    }
    else
    {
      $content.='<p class="info">'._t('divers','nodata').'</p>';
    }

    echo $content;
  }

}

/**
 * DisplayUserWorkshop()
 * affichage des utilisateurs/organisateurs d'un groupe de travail
 * @param $workshop_id
 * @return
 **/
if(!function_exists('DisplayUserWorkshop')) {

  function DisplayUserWorkshop($workshop_id) {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopUserList($workshop_id));
    $content1='<p>'._t('workshop','organizer2').' : ';
    $content2='<p>'._t('workshop','user').' : ';
    $sep_u='';
    $sep_a='';
    if($data!=0)
    {
      for($i=0; $i<count($data); $i++) {

        $workcal_author=formatText($data[$i]['user_login'], '2HTML');
        $link_table= array('rub'=> $GLOBALS['links'][U_L]['user-profile']['linkvalue'],'id'=>$data[$i]['jwu_user_id'], 'name'=>$data[$i]['user_login']);
         
        if($data[$i]['jwu_user_right']<>"U") {
          $content1.= $sep_u.'<a href="'.HrefMaker($link_table).'" title="'.formatText($workcal_author, '2ATT').'">'.$workcal_author.'</a>';
          $sep_u=', ';
        }
        else {
          $content2.=$sep_a.'<a href="'.HrefMaker($link_table).'" title="'.formatText($workcal_author, '2ATT').'">'.$workcal_author.'</a>';
          $sep_a=', ';
        }

      }
      $content1.='</p>'.END_LINE;
      $content2.='</p>'.END_LINE;
      $content=$content1.$content2;
    }
    else
    {
      $content.='<p class="info">'._t('workshop','no_user').'</p>';
    }
    echo $content;
  }

}

/**
 * DisplayListReport()
 * affichage de la liste des rapports d'un groupe de travail
 * @param $workshop_id
 * @return
 **/
if(!function_exists('DisplayListReport')) {

  function DisplayListReport($workshop_id) {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopReportList($workshop_id,"P"));
    $content = ''.END_LINE;
    if($data!=0)
    {
      for($i=0; $i<count($data); $i++) {

        $link_table= array('rub'=> $GLOBALS['links'][U_L]['report']['linkvalue'],'id'=>$data[$i]['workrep_id'], 'name'=>$data[$i]['workrep_title']);
        $workrep_title=formatText($data[$i]['workrep_title'], '2HTML');
        $workrep_resume=formatText($data[$i]['workrep_resume'], '2HTML');
        $workrep_date_publi=formatText($data[$i]['workrep_published_date'], '2HTML');
        $content.='<h3><a href="'.HrefMaker($link_table).'" title="'.formatText($workrep_title, '2ATT').'">'.$workrep_title.'</a></h3>'.END_LINE;
        $content.='<p>'.$workrep_resume.'</p>'.END_LINE;
        $content.='<p class="filter_info">'._t('workshop','date_report').' : <span>'.$workrep_date_publi.'</span></p>'.END_LINE;
        $content.='<hr />'.END_LINE;
      }
    }
    else
    {
      $content.='<p class="info">'._t('workshop','no_report').'</p>';
    }
    echo $content;
  }

}

/**
 * DisplayListTopic()
 * affichage de la liste des discussions
 * @param $workshop_id
 * @param $debut
 * @return
 **/
if(!function_exists('DisplayListTopic')) {

  function DisplayListTopic($workshop_id, $debut) {

    $result_workcom_list=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkcomList($debut, SELECT_LIMIT, $workshop_id));
    $result_nb_com=$GLOBALS['sql_object'] -> DBSelect(SQL_getcountnbcom($workshop_id));
    $bdd_nb_com=$result_nb_com[0]['num_rows'];


    $table_link=array('rub' => $GLOBALS['links'][U_L]['topic-list']['linkvalue'],'id' => $workshop_id);
    echo $bdd_nb_com_display = "<p class=\"nb_sujet\">".$bdd_nb_com." "._t('workshop','nb_total_com')."</p>\n";
    if($result_workcom_list!=0) {

      $content= "<table cellspacing=\"1\" cellpadding=\"3\" class=\"table_discussion\" summary=\""._t('workshop','com')."\">".END_LINE;
      $content.= "<thead>\n";
      $content.= "<tr>\n";
      $content.= "<td>"._t('divers','statut')."</td>".END_LINE;
      $content.= "<td>"._t('workshop','com_subject')."</td>".END_LINE;
      $content.= "<td>"._t('workshop','com_author')."</td>".END_LINE;
      $content.= "<td>"._t('workshop','com_nb_rep')."</td>".END_LINE;
      $content.= "<td>"._t('workshop','com_date_last')."</td>".END_LINE;
      $content.= "</tr>".END_LINE;
      $content.= "</thead>".END_LINE;
      $content.= "<tbody>".END_LINE;


      for($i=0; $i<count($result_workcom_list); $i++) {

        $result_workcom_det=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkcom_detList($result_workcom_list[$i]['workcom_id']));
        $link_user= array('rub'=> $GLOBALS['links'][U_L]['user-profile']['linkvalue'],'id'=>$result_workcom_list[$i]['workcom_user_id'], 'name' => $result_workcom_list[$i]['user_login']);
        $link_det_com= array('rub'=> $GLOBALS['links'][U_L]['topic']['linkvalue'],'id'=>$result_workcom_list[$i]['workcom_id'], 'parentid' => $workshop_id, 'name' => $result_workcom_list[$i]['workcom_subject']);

        $workcom_title=formatText(cutText($result_workcom_list[$i]['workcom_subject'], 70, 1), '2HTML');
        $workcom_user=formatText(cutText($result_workcom_list[$i]['user_login'], 10, 1), '2HTML');


        $content.= "<tr>".END_LINE;
        if ($result_workcom_list[$i]['workcom_statut']=='C') {
          $content.= "<td><img src=\"" .THEME_PUBLIC_PATH. "images/ico_lock_dis.gif\" alt=\"\" /></td>".END_LINE;
        }
        else $content.= "<td>&nbsp;</td>\n";
        $content.= "<td style=\"width:50%\"><a href=\"".HrefMaker($link_det_com)."\" title=\"".formatText($workcom_title, '2ATT')."\" class=\"table_title\">".$workcom_title."</a></td>".END_LINE;
        $content.= "<td><a href=\"".HrefMaker($link_user)."\" title=\"".formatText($workcom_user, '2ATT')."\" class=\"table_auth\">".$workcom_user."</a></td>".END_LINE;
        if ($result_workcom_det[0]['nb_rep']=="") {
          $content.= "<td>0</td>".END_LINE;
        }
        else $content.= "<td style=\"width:11%\">".$result_workcom_det[0]['nb_rep']."</td>".END_LINE;
        if ($result_workcom_det[0]['workcom_date_crea_display']=="") {
          $content.= "<td>".$result_workcom_list[$i]['workcom_date_crea_display']."</td>".END_LINE;
        }
        else
        $content.= "<td>".$result_workcom_list[$i]['workcom_date_crea_display']."</td>".END_LINE;
        $content.= "</tr>".END_LINE;
      }

      $content.= "</tbody>".END_LINE;
      $content.= "</table>".END_LINE;
    }else {
      $content= '<p class="info">'._t('workshop','no_com').'</p>'.END_LINE;
    }
    DisplayUrlAddTopic($workshop_id);
    Display_linkin_page($table_link, $bdd_nb_com, $debut);
    echo $content;
    Display_linkin_page($table_link, $bdd_nb_com, $debut);
    DisplayUrlAddTopic($workshop_id);
  }

}

/**
 * DisplayTopic()
 * affichage d'une discussion
 * @param $workshop_id
 * @param $topic_id
 * @param $debut
 * @param $flash
 * @param $post_id
 * @return
 **/
if(!function_exists('DisplayTopic')) {

  function DisplayTopic($workshop_id, $topic_id, $debut) {

    $dataroot=$GLOBALS['sql_object'] -> DBSelect(SQL_getOnetopicWorkcom($workshop_id, $topic_id, $topic_id));
    $topic_state=$dataroot[0]['workcom_statut'];
    $result_display="";

    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getOnetopicWorkcom2($workshop_id, $topic_id, $root= -1, $debut, SELECT_LIMIT));
    $result_nb_com=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkcom_detList($topic_id));
    $bdd_nb_com=$result_nb_com[0]['nb_rep'];


    $table_link=array('rub' => $GLOBALS['links'][U_L]['topic']['linkvalue'],'id' => $topic_id, 'parentid' => $workshop_id, 'name' => $dataroot[0]['workcom_subject'] );

    $post_title=formatText($dataroot[0]['workcom_subject'], '2HTML');
    $post_body=formatText($dataroot[0]['workcom_body'], '2HTML');
    $post_user=formatText(cutText($dataroot[0]['user_login'], 10, 1), '2HTML');

     
    $content= '';
    echo "<p class=\"nb_sujet\">".$bdd_nb_com_display = $bdd_nb_com." "._t('workshop','nb_total_com_mes')."</p>".END_LINE;
    echo'<h1>'._t('workshop','com_name').' : '.$post_title.'</h1>'.END_LINE;
    echo Display_linkin_page($table_link, $bdd_nb_com, $debut);
    echo '<br />'.END_LINE;

    if ($debut==0) {

      $complete_uri='../'.$dataroot[0]['profile_avatar'];
      if($dataroot[0]['profile_avatar'] == "") $user_profile_avatar='<img src="'.THEME_PUBLIC_PATH.'/images/no_avatar.png" alt="'.formatText($dataroot[0]['user_login'], '2HTML').'" class="user_profile"/>';
      else $user_profile_avatar='<img src="'.$complete_uri.'" alt="'. formatText($dataroot[0]['user_login'], '2HTML').'" class="user_profile"/>';

      $link_user= array('rub'=> $GLOBALS['links'][U_L]['user-profile']['linkvalue'],'id'=>$dataroot[0]['workcom_user_id'], 'name' => $dataroot[0]['user_login']);
      $content.='<div class="blocksujet" id="msg-'.$topic_id.'">'.END_LINE;
      $content.='<p class="workshop_auth_sujet">'.$user_profile_avatar.'<a href="'.HrefMaker($link_user).'" title="'.formatText($post_user, '2ATT').'">'.$post_user.'</a><br />'.END_LINE;
      $content.='</p>'.END_LINE;
      $content.='<span class="workshop_date_sujet">'._t('statut', 'published_on').' '.$dataroot[0]['workcom_date_crea_display'].'</span>'.END_LINE;
      $content.='<div class="post-content">'.END_LINE;
      $content.='<h3>'.$post_title.'</h3>'.END_LINE;
      $content.='<p>'.$post_body.'</p>'.END_LINE;
      $content.='</div>'.END_LINE;
      $content.='</div>'.END_LINE;
      $last_title=$post_title;
    }

    if($data!=0)
    {

      for($i=0; $i<count($data); $i++) {
        $class = ($i & 1) ? '' : ' odd';
        $post_title=formatText($data[$i]['workcom_subject'], '2HTML');
        $post_body=formatText($data[$i]['workcom_body'], '2HTML');
        $post_user=formatText(cutText($data[$i]['user_login'], 10, 1), '2HTML');
        $post_id=$data[$i]['workcom_id'];
        $link_user= array('rub'=> $GLOBALS['links'][U_L]['user-profile']['linkvalue'],'id'=>$data[$i]['workcom_user_id'], 'name'=> $data[$i]['user_login']);
        $link_edit= array('rub'=> $GLOBALS['links'][U_L]['post-update']['linkvalue'],'parentid'=>$workshop_id, 'id'=>$data[$i]['workcom_id'], 'parentparentid'=>$topic_id, 'name'=> $data[$i]['workcom_subject']);
        $complete_uri='../'.$data[$i]['profile_avatar'];
        if($data[$i]['profile_avatar'] == "") $user_profile_avatar='<img src="'.THEME_PUBLIC_PATH.'/images/no_avatar.png" alt="'. formatText($data[$i]['user_login'], '2HTML').'" class="user_profile"/>';
        else $user_profile_avatar='<img src="'.$complete_uri.'" alt="'. formatText($data[$i]['user_login'], '2HTML').'" class="user_profile"/>';
         
        if(isset($_COOKIE['linea21']['id'])) {
          if ($data[$i]['workcom_user_id']==$_COOKIE['linea21']['id'] && $topic_state == 'P') {
            $edit='<span><a class="edit_topic" href="'.HrefMaker($link_edit).'" title="'.formatText(_t('workshop','mod_com_mes'), '2ATT').'"><span>'._t('divers','modify').'</span></a></span>'.END_LINE;
          }else $edit='';
        }
        $content.='<div class="blocksujet'.$class.'" id="msg-'.$post_id.'">'.END_LINE;
        $content.='<p class="workshop_auth_sujet">'.$user_profile_avatar.'<a href="'.HrefMaker($link_user).'" title="'.formatText($post_user, '2ATT').'">'.$post_user.'</a><br />'.END_LINE;
        $content.='</p>'.END_LINE;
        $content.='<span class="workshop_date_sujet">'._t('statut', 'published_on').' '.$data[$i]['workcom_date_crea_display'].'</span>'.END_LINE;
        $content.=$edit;
        $content.='<div class="post-content">'.END_LINE;
        $content.='<h3>'.$post_title.'</h3>'.END_LINE;
        $content.='<p>'.$post_body.'</p>'.END_LINE;
        $content.='</div>'.END_LINE;
        $content.='</div>'.END_LINE;
        $last_title=$post_title;
      }
    }
    else
    {
      $content.='<p class="info">'._t('workshop','no_com_rep').'</p>';
    }

    echo $content;
    echo Display_linkin_page($table_link, $bdd_nb_com, $debut);
    if ($topic_state=="P")  echo GetFormAddPost($workshop_id, $topic_id, '', $last_title);
    else echo $content='<p class="info">'._t('workshop','com_p_lock').'</p>';
  }

}


/**
 * AddTopic
 * Ajout d'une discussion
 * @param $workshop_id
 * @param $debut
 * @param $body
 * @param $title
 * @param $confirm
 */
if(!function_exists('AddTopic')) {

  function AddTopic($workshop_id, $debut, $body, $title, $confirm_update)
  {
    if(!$confirm_update)  echo GetFormAddTopic($workshop_id);
    else
    {
      //test new value for this post in form
      $integrity=CheckComIntegrity($title, $body);
      if($integrity  == 1)
      {
        $topic_id=AddPersistentPost($title, $body, '', $workshop_id);
        notifyUsers(array('id' => $workshop_id, 'action' => 'topic_alert', 'topic_subject' => $title, 'topic_body' => $body));
        echo '<p class="confirm">'._t('workshop','confirm_add_com').'</p>'.END_LINE;
        echo DisplayListTopic($workshop_id, $debut);
      }
      else
      {
        echo "<p class=\"error\">".$integrity."</p>";
        echo GetFormAddTopic($workshop_id, $body, $title);
      }
    }
  }

}

/**
 * AddPost
 * Ajout d'un Message
 * @param $workshop_id
 * @param $topic_id
 * @param $debut
 * @param $body
 * @param $title
 */
if(!function_exists('AddPost')) {

  function AddPost($workshop_id, $topic_id, $debut, $body, $title)
  {
    $dataroot=$GLOBALS['sql_object'] -> DBSelect(SQL_getOnetopicWorkcom($workshop_id, $topic_id, $topic_id));
    $topic_state=$dataroot[0]['workcom_statut'];
    if ($topic_state<>"P")  DisplayTopic($workshop_id, $topic_id, $debut);
    else {
      $integrity=CheckComIntegrity($title, $body);
      if($integrity  == 1)
      {
        $post_id=AddPersistentPost($title, $body, $topic_id, $workshop_id);
        notifyUsers(array('action' => 'post_alert', 'topic_subject' => $title, 'topic_body' => $body, 'tid' => $topic_id, 'parentid' => $workshop_id, 'id' => $post_id));
        echo '<p class="confirm">'._t('workshop','confirm_add_com').'</p>'.END_LINE;
        echo '<script type="text/javascript">
                  $(function() {
                  	setTimeout(\'jQuery.smoothScroll({scrollTarget: "#msg-'.$post_id.'"});\', '.SCROLL_DELAY.');
                  });
              </script>';
        footerAddJS('lib/js/jquery.smooth-scroll.min.js');
        echo DisplayTopic($workshop_id, $topic_id, $debut);
      }
      else
      {
        echo "<p class=\"error\">".$integrity."</p>";
        echo GetFormAddPost($workshop_id, $topic_id, $body, $title);
      }
    }
  }

}

/**
 * UpdatePost
 * Mise à jour d'un message
 * @param $workshop_id
 * @param $topic_id
 * @param $debut
 * @param $new_body
 * @param $new_title
 * @param $post_id
 * @param $confirm_update
 * @return void
 */
if(!function_exists('UpdatePost')) {

  function UpdatePost($workshop_id, $topic_id, $debut, $new_body, $new_title, $post_id, $confirm_update)
  {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getOnetopicWorkcom($workshop_id, $post_id, "root"));
    $old_title=formatText($data[0]['workcom_subject'], '2FIELD');
    $old_body=formatText($data[0]['workcom_body'], '2FIELD');
    $topic_state=$data[0]['workcom_statut'];

    if ($topic_state<>"P")  DisplayTopic($workshop_id, $topic_id, $debut);
    else {
      //display old value for this post in form
      if(!$confirm_update)  echo GetFormModPost($workshop_id, $topic_id, $post_id, $old_body, $old_title);
      else
      {
        //test new value for this post in form
        $integrity=CheckComIntegrity($new_title, $new_body);
        if($integrity  == 1)
        {
          $post_id=ModPersistentPost($new_title, $new_body, $post_id, $workshop_id, $topic_id);
          echo '<p class="confirm">'._t('workshop','confirm_mod_com').'</p>'.END_LINE;
          //scroll jusque $post_id
          echo DisplayTopic($workshop_id, $topic_id, $debut);
        }
        else
        {
          echo "<p class=\"error\">".$integrity."</p>";
          echo GetFormModPost($workshop_id, $topic_id, $post_id, $old_body, $old_title);
        }
      }
    }
  }

}


/**
 * GetFormAddTopic()
 * formulaire d'ajout d'un Topic
 * @param $workshop_id
 * @param $subject_body
 * @param $subject_title
 * @return
 **/
if(!function_exists('GetFormAddTopic')) {

  function GetFormAddTopic($workshop_id, $body='', $title='') {

    $form='<h2>'._t('workshop','add_com').'</h2>'.END_LINE;
    $form.='<form action="index.php" method="post">'.END_LINE;
    $form.='<div id="reponse">'.END_LINE;
    $form.='<label for="title" class="labelised">'.ucfirst(_t('workshop','com_subject')).' : </label>'.END_LINE;
    $form.='<input type="text" maxlength="100" size="40" name="title" id="title" value="'.$title.'" class="shorttextfield" /><br />'.END_LINE;
    $form.='<label for="body" class="labelised">'._t('workshop','com_body').' : </label>'.END_LINE;
    $form.='<textarea id="body" name="body" rows="10" cols="50" class="textfield">'.$body.'</textarea><br />'.END_LINE;
    $form.='<input type="hidden" value="'.$GLOBALS['links'][U_L]['topic-add']['linkvalue'].'" name="rub" id="rub" />'.END_LINE;
    $form.='<input type="hidden" value="'.$workshop_id.'" name="id" id="id" />'.END_LINE;
    $form.='<input type="hidden" value="true" name="confirm" id="confirm" />'.END_LINE;
    $form.='<br /><input type="submit" value="'._t('btn','valid').'" name="valider" id="valider" class="submitbut" />'.END_LINE;
    $form.='</div>'.END_LINE;
    $form.='</form>'.END_LINE;
    return $form;
  }

}

/**
 * GetFormModPost()
 * formulaire de modification d'un Post
 * @param $workshop_id
 * @param $topic_id
 * @param integer $post_id
 * @param $subject_body
 * @param $subject_title
 * @return
 **/
if(!function_exists('GetFormModPost')) {

  function GetFormModPost($workshop_id, $topic_id, $post_id, $body, $title) {

    $form='<h2>'._t('workshop','mod_com_mes').'</h2>'.END_LINE;
    $form.='<form action="index.php" method="post">'.END_LINE;
    $form.='<div id="reponse">'.END_LINE;
    $form.='<label for="title" class="labelised">'._t('workshop','com_subject').' : </label>'.END_LINE;
    $form.='<input type="text" maxlength="50"  name="title" id="title" value="'.$title.'" class="textfield" /><br />'.END_LINE;
    $form.='<label for="body" class="labelised">'._t('workshop','com_body').' : </label>'.END_LINE;
    $form.='<textarea id="body" name="body" rows="10" cols="50" class="textfield">'.$body.'</textarea>'.END_LINE;
    $form.='<input type="hidden" value="'.$GLOBALS['links'][U_L]['post-update']['linkvalue'].'" name="rub" id="rub" />'.END_LINE;
    $form.='<input type="hidden" value="'.$workshop_id.'" name="parentid" id="parentid" />'.END_LINE;
    $form.='<input type="hidden" value="'.$post_id.'" name="id" id="id" />'.END_LINE;
    $form.='<input type="hidden" value="true" name="confirm" id="confirm" />'.END_LINE;
    $form.='<input type="hidden" value="'.$topic_id.'" name="parentparentid" id="parentparentid" />'.END_LINE;
    $form.='<br /><input type="submit" value="'._t('btn','valid').'" name="valider" id="valider" class="submitbut" />'.END_LINE;
    $form.='</div>'.END_LINE;
    $form.='</form>'.END_LINE;
    return $form;
  }

}
/**
 * GetFormAddPost()
 * formulaire d'ajout d'un Post
 * @param $workshop_id
 * @param $topic_id
 * @param $body
 * @param $title
 * @return
 **/
if(!function_exists('GetFormAddPost')) {

  function GetFormAddPost($workshop_id, $topic_id, $body='', $title=''){

    $form='<h2>'._t('workshop','add_com_mes').'</h2>'.END_LINE;
    $form.='<form action="index.php" method="post">'.END_LINE;
    $form.='<div id="reponse">'.END_LINE;
    $form.='<label for="title" class="labelised">'._t('workshop','com_subject').' : </label>'.END_LINE;
    $form.='<input type="text" maxlength="100" size="40"  name="title" id="title" value="'.$title.'"  class="shorttextfield"  /><br />'.END_LINE;
    $form.='<label for="body" class="labelised">'._t('workshop','com_body').' : </label>'.END_LINE;
    $form.='<textarea id="body" name="body" rows="10" cols="50" class="textfield">'.$body.'</textarea><br />'.END_LINE;
    $form.='<input type="hidden" value="'.$GLOBALS['links'][U_L]['post-add']['linkvalue'].'" name="rub" id="rub" />'.END_LINE;
    $form.='<input type="hidden" value="'.$topic_id.'" name="id" id="id" />'.END_LINE;
    $form.='<input type="hidden" value="'.$workshop_id.'" name="parentid" id="parentid" />'.END_LINE;
    $form.='<input type="submit" alt="'._t('btn','valid').'" value="'._t('btn','valid').'" name="valider" id="valider" class="submitbut" />'.END_LINE;
    $form.='</div>'.END_LINE;
    $form.='</form>'.END_LINE;
    return $form;
  }

}

/**
 * CheckComIntegrity()
 * Vérification de l'intégrité des données
 * @param $title
 * @param $body
 * @param $workshop_com_object
 * @return
 **/
if(!function_exists('CheckComIntegrity')) {

  function CheckComIntegrity($title, $body){
    $integrity=1;
    if (strlen($title) < 3) $integrity=_t('workshop','com_no_subject');
    if (strlen($body) < 3) $integrity=_t('workshop','com_no_body');
    if(is_string($integrity)) return $integrity;
    else return 1;
  }

}

/**
 * AddPersistentPost()
 * Ajout dans la base d'un nouveau Post
 * @param $title
 * @param $body
 * @param $topic_id
 * @param $workshop_id
 * @return
 **/
if(!function_exists('AddPersistentPost')) {

  function AddPersistentPost($title, $body, $topic_id, $workshop_id){

    if(isset($_COOKIE['linea21']['id'])) {
      $user_id=$_COOKIE['linea21']['id'];

      include_once('../class/class.workshop_com.php');
      $workshop_com_object = new workshop_com;

      $result=CheckComIntegrity($title, $body);
      if ($result==1) {
        $table[0] = $title;
        $table[1] = $body;
        $table[2] = $topic_id;
        $table[3] = $user_id;
        $table[4] = $workshop_id;

        $result=$workshop_com_object->AddCom($table , $GLOBALS['sql_object']);
        return $result;
      }
      else return $result;
    } else return "<p class=\"error\">"._t('divers','errorauth')."</p>";
  }

}

/**
 * ModPersistentPost()
 * Modification dans la base d'un Post
 * @param $title
 * @param $body
 * @param $mes_id
 * @param $workshop_id
 * @param $topic_id
 * @return
 **/
if(!function_exists('ModPersistentPost')) {

  function ModPersistentPost($title, $body, $mes_id, $workshop_id, $topic_id){

    if(isset($_COOKIE['linea21']['id'])) {
      $user_id=$_COOKIE['linea21']['id'];
      include_once('../class/class.workshop_com.php');
      $workshop_com_object = new workshop_com;

      $result=CheckComIntegrity($title, $body);
      if ($result==1) {
        $table[0] = $title;
        $table[1] = $body;
        $result=$workshop_com_object->ModifyComUser($mes_id, $table , $user_id, $GLOBALS['sql_object']);

        if (!is_string($result)) return 1;
        else return $result;
      }
      else return $result;
    } else return "<p class=\"error\">"._t('divers','errorauth')."</p>";
  }

}
?>